/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.device.explorer.common.DeviceExplorerSettings;
import com.android.tools.idea.device.explorer.files.CoroutineContextUtilKt;
import com.android.tools.idea.device.explorer.files.DeviceExplorerFileManager;
import com.android.tools.idea.device.explorer.files.DeviceExplorerFileManagerImpl;
import com.android.tools.idea.device.explorer.files.DeviceExplorerFilesUtils;
import com.android.tools.idea.device.explorer.files.fs.DeviceFileEntry;
import com.android.tools.idea.device.explorer.files.fs.DeviceFileSystem;
import com.android.tools.idea.device.explorer.files.fs.DownloadProgress;
import com.android.tools.idea.device.explorer.files.fs.FileTransferProgress;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.PathUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001+B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J&\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J&\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0083@\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0006H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0016\u0010)\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010*R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceExplorerFileManagerImpl;", "Lcom/android/tools/idea/device/explorer/files/DeviceExplorerFileManager;", "project", "Lcom/intellij/openapi/project/Project;", "defaultDownloadPathSupplier", "Lkotlin/Function0;", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "(Lcom/intellij/openapi/project/Project;)V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "temporaryEditorFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDefaultLocalPathForDevice", "device", "Lcom/android/tools/idea/device/explorer/files/fs/DeviceFileSystem;", "getDefaultLocalPathForEntry", "entry", "Lcom/android/tools/idea/device/explorer/files/fs/DeviceFileEntry;", "downloadFileEntry", "localPath", "progress", "Lcom/android/tools/idea/device/explorer/files/fs/DownloadProgress;", "(Lcom/android/tools/idea/device/explorer/files/fs/DeviceFileEntry;Ljava/nio/file/Path;Lcom/android/tools/idea/device/explorer/files/fs/DownloadProgress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteFile", "", "virtualFile", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteVirtualFile", "downloadFile", "createFileTransferProgress", "Lcom/android/tools/idea/device/explorer/files/fs/FileTransferProgress;", "getPathForEntry", "file", "destinationPath", "mapName", "", "name", "deleteTemporaryFile", "openFile", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "MyFileEditorManagerAdapter", "intellij.android.device-explorer-files"})
@SourceDebugExtension(value={"SMAP\nDeviceExplorerFileManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceExplorerFileManagerImpl.kt\ncom/android/tools/idea/device/explorer/files/DeviceExplorerFileManagerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,214:1\n25#2:215\n*S KotlinDebug\n*F\n+ 1 DeviceExplorerFileManagerImpl.kt\ncom/android/tools/idea/device/explorer/files/DeviceExplorerFileManagerImpl\n*L\n62#1:215\n*E\n"})
public final class DeviceExplorerFileManagerImpl
implements DeviceExplorerFileManager {
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<Path> defaultDownloadPathSupplier;
    @NotNull
    private final Logger LOGGER;
    @NotNull
    private final List<VirtualFile> temporaryEditorFiles;

    @NonInjectable
    @VisibleForTesting
    public DeviceExplorerFileManagerImpl(@NotNull Project project, @NotNull Function0<? extends Path> defaultDownloadPathSupplier) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(defaultDownloadPathSupplier, (String)"defaultDownloadPathSupplier");
        this.project = project;
        this.defaultDownloadPathSupplier = defaultDownloadPathSupplier;
        DeviceExplorerFileManagerImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(DeviceExplorerFileManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOGGER = logger;
        this.temporaryEditorFiles = new ArrayList();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new MyFileEditorManagerAdapter());
    }

    private DeviceExplorerFileManagerImpl(Project project) {
        this(project, (Function0<? extends Path>)((Function0)DeviceExplorerFileManagerImpl::_init_$lambda$0));
    }

    @NotNull
    public final Path getDefaultLocalPathForDevice(@NotNull DeviceFileSystem device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Path rootPath = (Path)this.defaultDownloadPathSupplier.invoke();
        Path path = rootPath.resolve(this.mapName(device2.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Override
    @NotNull
    public Path getDefaultLocalPathForEntry(@NotNull DeviceFileEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Path devicePath = this.getDefaultLocalPathForDevice(entry.getFileSystem());
        return this.getPathForEntry(entry, devicePath);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object downloadFileEntry(@NotNull DeviceFileEntry var1_1, @NotNull Path var2_2, @NotNull DownloadProgress var3_3, @NotNull Continuation<? super VirtualFile> $completion) {
        if (!($completion instanceof downloadFileEntry.1)) ** GOTO lbl-1000
        var6_5 = $completion;
        if ((var6_5.label & -2147483648) != 0) {
            var6_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadFileEntry(null, null, null, (Continuation<? super VirtualFile>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = entry;
                $continuation.L$1 = localPath;
                $continuation.L$2 = progress;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getDiskIoThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super File>, Object>(localPath, null){
                    int label;
                    final /* synthetic */ Path $localPath;
                    {
                        this.$localPath = $localPath;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return FileUtils.mkdirs((File)this.$localPath.getParent().toFile());
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super File> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var7_7) {
                    return var7_7;
                }
                ** GOTO lbl26
            }
            case 1: {
                progress = (DownloadProgress)$continuation.L$2;
                localPath = (Path)$continuation.L$1;
                entry = (DeviceFileEntry)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = CoroutineContextUtilKt.withWriteSafeContextWithCurrentModality((Function2)new Function2<CoroutineScope, Continuation<? super VirtualFile>, Object>(localPath, this, entry, progress, null){
                    int label;
                    final /* synthetic */ Path $localPath;
                    final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
                    final /* synthetic */ DeviceFileEntry $entry;
                    final /* synthetic */ DownloadProgress $progress;
                    {
                        this.$localPath = $localPath;
                        this.this$0 = $receiver;
                        this.$entry = $entry;
                        this.$progress = $progress;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        void $result;
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)this.$localPath.toFile(), (boolean)true);
                                if (virtualFile == null) break;
                                VirtualFile virtualFile2 = virtualFile;
                                DeviceExplorerFileManagerImpl deviceExplorerFileManagerImpl = this.this$0;
                                VirtualFile it = virtualFile2;
                                boolean bl = false;
                                this.label = 1;
                                Object object3 = CoroutineUtilsKt.runWriteActionAndWait(() -> downloadFileEntry.3.invokeSuspend$lambda$1$lambda$0(deviceExplorerFileManagerImpl, it), (Continuation)this);
                                if (object3 == object2) {
                                    return object2;
                                }
                                break;
                            }
                            case 1: {
                                boolean bl = false;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                break;
                            }
                        }
                        this.label = 2;
                        Object object4 = DeviceExplorerFileManagerImpl.access$downloadFile(this.this$0, this.$entry, this.$localPath, this.$progress, (Continuation)this);
                        if (object4 != object2) return object4;
                        return object2;
                        {
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                object4 = $result;
                                return object4;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super VirtualFile> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$1$lambda$0(DeviceExplorerFileManagerImpl this$0, VirtualFile $it) {
                        DeviceExplorerFileManagerImpl.access$deleteVirtualFile(this$0, $it);
                        return Unit.INSTANCE;
                    }
                }, $continuation);
                if (v1 == var7_7) {
                    return var7_7;
                }
                ** GOTO lbl37
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object deleteFile(@NotNull VirtualFile virtualFile, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutineContextUtilKt.withWriteSafeContextWithCurrentModality((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, virtualFile, null){
            int label;
            final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ApplicationManager.getApplication().runWriteAction(() -> deleteFile.2.invokeSuspend$lambda$0(this.this$0, this.$virtualFile));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(DeviceExplorerFileManagerImpl this$0, VirtualFile $virtualFile) {
                DeviceExplorerFileManagerImpl.access$deleteVirtualFile(this$0, $virtualFile);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void deleteVirtualFile(VirtualFile virtualFile) throws IOException {
        TransactionGuard transactionGuard = TransactionGuard.getInstance();
        Intrinsics.checkNotNull((Object)transactionGuard, (String)"null cannot be cast to non-null type com.intellij.openapi.application.TransactionGuardImpl");
        ((TransactionGuardImpl)transactionGuard).assertWriteActionAllowed();
        virtualFile.delete((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @UiThread
    private final Object downloadFile(DeviceFileEntry var1_1, Path var2_2, DownloadProgress var3_3, Continuation<? super VirtualFile> $completion) {
        if (!($completion instanceof downloadFile.1)) ** GOTO lbl-1000
        var9_5 = $completion;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DeviceExplorerFileManagerImpl.access$downloadFile(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                fileTransferProgress = this.createFileTransferProgress(entry, progress);
                progress.onStarting(entry.getFullPath());
                $continuation.L$0 = entry;
                $continuation.L$1 = localPath;
                $continuation.L$2 = progress;
                $continuation.label = 1;
                v0 = entry.downloadFile(localPath, fileTransferProgress, (Continuation<? super Unit>)$continuation);
                ** if (v0 != var10_7) goto lbl23
lbl22:
                // 1 sources

                return var10_7;
lbl23:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                progress = (DownloadProgress)$continuation.L$2;
                localPath = (Path)$continuation.L$1;
                entry = (DeviceFileEntry)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                $continuation.L$0 = entry;
                $continuation.L$1 = localPath;
                $continuation.L$2 = progress;
                $continuation.label = 2;
                v1 = DeviceExplorerFilesUtils.findFile$default(DeviceExplorerFilesUtils.INSTANCE, localPath, false, (Continuation)$continuation, 2, null);
                ** if (v1 != var10_7) goto lbl39
lbl38:
                // 1 sources

                return var10_7;
lbl39:
                // 1 sources

                ** GOTO lbl48
            }
            case 2: {
                progress = (DownloadProgress)$continuation.L$2;
                localPath = (Path)$continuation.L$1;
                entry = (DeviceFileEntry)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl48:
                    // 2 sources

                    var6_9 = v1;
                    return var6_9;
                }
                catch (Throwable t) {
                    this.deleteTemporaryFile(localPath);
                    throw t;
                }
            }
            catch (Throwable var7_11) {
                throw var7_11;
            }
            {
                finally {
                    progress.onCompleted(entry.getFullPath());
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final FileTransferProgress createFileTransferProgress(DeviceFileEntry entry, DownloadProgress progress2) {
        return new FileTransferProgress(progress2, entry){
            final /* synthetic */ DownloadProgress $progress;
            final /* synthetic */ DeviceFileEntry $entry;
            {
                this.$progress = $progress;
                this.$entry = $entry;
            }

            @UiThread
            public void progress(long currentBytes, long totalBytes) {
                this.$progress.onProgress(this.$entry.getFullPath(), currentBytes, totalBytes);
            }

            @WorkerThread
            public boolean isCancelled() {
                return this.$progress.isCancelled();
            }
        };
    }

    @Override
    @NotNull
    public Path getPathForEntry(@NotNull DeviceFileEntry file, @NotNull Path destinationPath) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)destinationPath, (String)"destinationPath");
        List entryPathComponents = new ArrayList();
        for (DeviceFileEntry entry = file; entry != null; entry = entry.getParent()) {
            entryPathComponents.add(this.mapName(entry.getName()));
        }
        CollectionsKt.reverse((List)entryPathComponents);
        Path entryDestinationPath = destinationPath;
        for (String name2 : entryPathComponents) {
            Intrinsics.checkNotNullExpressionValue((Object)entryDestinationPath.resolve(name2), (String)"resolve(...)");
        }
        return entryDestinationPath;
    }

    private final String mapName(String name2) {
        String string = PathUtilRt.suggestFileName((String)name2, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"suggestFileName(...)");
        return string;
    }

    private final void deleteTemporaryFile(Path localPath) {
        try {
            Files.deleteIfExists(localPath);
        }
        catch (IOException e) {
            this.LOGGER.warn("Error deleting device file from local file system \"" + localPath + "\"", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object openFile(@NotNull Path var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof openFile.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.openFile(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = DeviceExplorerFilesUtils.INSTANCE.findFile((Path)localPath, true, (Continuation<? super VirtualFile>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                file = (VirtualFile)v0;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(file, this, null){
                    int label;
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
                    {
                        this.$file = $file;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                FileType fileType;
                                FileType fileType2;
                                ResultKt.throwOnFailure((Object)object);
                                String string = this.$file.getName();
                                VirtualFile virtualFile = this.$file;
                                String fileName = string;
                                boolean bl = false;
                                FileType it = fileType2 = virtualFile.getFileType();
                                boolean bl2 = false;
                                Object object3 = !Intrinsics.areEqual((Object)it, (Object)FileTypes.UNKNOWN) ? fileType2 : null;
                                if (object3 != null) break;
                                FileType it2 = fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
                                boolean bl3 = false;
                                object3 = !Intrinsics.areEqual((Object)it2, (Object)FileTypes.UNKNOWN) ? fileType : null;
                                if (object3 != null || (object3 = FileTypeChooser.associateFileType((String)fileName)) != null) break;
                                this.label = 1;
                                Object object4 = CoroutineContextUtilKt.cancelAndThrow(this);
                                if (object4 != object2) throw new KotlinNothingValueException();
                                return object2;
                            }
                            case 1: {
                                void $result;
                                boolean bl = false;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object4 = $result;
                                throw new KotlinNothingValueException();
                            }
                        }
                        OpenFileAction.Companion.openFile(this.$file, DeviceExplorerFileManagerImpl.access$getProject$p(this.this$0));
                        return Boxing.boxBoolean((boolean)DeviceExplorerFileManagerImpl.access$getTemporaryEditorFiles$p(this.this$0).add(this.$file));
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl29
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Path _init_$lambda$0() {
        Path path = Paths.get(DeviceExplorerSettings.Companion.getInstance().getDownloadLocation(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    public static final /* synthetic */ Object access$downloadFile(DeviceExplorerFileManagerImpl $this, DeviceFileEntry entry, Path localPath, DownloadProgress progress2, Continuation $completion) {
        return $this.downloadFile(entry, localPath, progress2, (Continuation<? super VirtualFile>)$completion);
    }

    public static final /* synthetic */ void access$deleteVirtualFile(DeviceExplorerFileManagerImpl $this, VirtualFile virtualFile) {
        $this.deleteVirtualFile(virtualFile);
    }

    public static final /* synthetic */ Project access$getProject$p(DeviceExplorerFileManagerImpl $this) {
        return $this.project;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceExplorerFileManagerImpl$MyFileEditorManagerAdapter;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "<init>", "(Lcom/android/tools/idea/device/explorer/files/DeviceExplorerFileManagerImpl;)V", "fileClosed", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.android.device-explorer-files"})
    private final class MyFileEditorManagerAdapter
    implements FileEditorManagerListener {
        public void fileClosed(@NotNull FileEditorManager source2, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (DeviceExplorerFileManagerImpl.this.temporaryEditorFiles.contains(file)) {
                DeviceExplorerFileManagerImpl.this.temporaryEditorFiles.remove(file);
                Path localPath = Paths.get(file.getPath(), new String[0]);
                Intrinsics.checkNotNull((Object)localPath);
                DeviceExplorerFileManagerImpl.this.deleteTemporaryFile(localPath);
            }
        }
    }
}

