/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debuggers.coroutine;

import com.android.ddmlib.IDevice;
import com.android.tools.deployer.Sites;
import com.android.tools.idea.debuggers.coroutine.CoroutineDebuggerAnalyticsTracker;
import com.android.tools.idea.debuggers.coroutine.CoroutineDebuggerSettings;
import com.android.tools.idea.debuggers.coroutine.FlagController;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.intellij.execution.Executor;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/debuggers/coroutine/CoroutineDebuggerLaunchTaskContributor;", "Lcom/android/tools/idea/run/AndroidLaunchTaskContributor;", "<init>", "()V", "getAmStartOptions", "", "applicationId", "configuration", "Lcom/android/tools/idea/run/AndroidRunConfigurationBase;", "device", "Lcom/android/ddmlib/IDevice;", "executor", "Lcom/intellij/execution/Executor;", "intellij.android.debuggers"})
public final class CoroutineDebuggerLaunchTaskContributor
implements AndroidLaunchTaskContributor {
    @Override
    @NotNull
    public String getAmStartOptions(@NotNull String applicationId2, @NotNull AndroidRunConfigurationBase configuration2, @NotNull IDevice device2, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        if (!FlagController.INSTANCE.isCoroutineDebuggerEnabled().booleanValue()) {
            return "";
        }
        if (!Intrinsics.areEqual((Object)"Debug", (Object)executor.getId())) {
            return "";
        }
        if (!device2.getVersion().isAtLeast(29)) {
            return "";
        }
        boolean isCoroutineDebuggerEnabledInSettings = CoroutineDebuggerSettings.INSTANCE.isCoroutineDebuggerEnabled();
        Project project = configuration2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CoroutineDebuggerAnalyticsTracker.Companion.getInstance(project).trackLaunchEvent(!isCoroutineDebuggerEnabledInSettings);
        if (!isCoroutineDebuggerEnabledInSettings) {
            return "";
        }
        String appCodeCache = Sites.appCodeCache((String)applicationId2);
        return "--attach-agent " + appCodeCache + "coroutine_debugger_agent.so";
    }
}

