/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0003&'(B3\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\n\u0010\fB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\n\u0010\rJ\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017*\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0016H\u0016J\b\u0010%\u001a\u00020 H\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0014\u001a*\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00170\u0015j\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0019\u001a\"\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0015j\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0006`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00060\u001bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher;", "Lcom/intellij/openapi/Disposable;", "Lcom/android/tools/idea/ddms/DeviceNamePropertiesProvider;", "parent", "uiCallback", "Lcom/google/common/util/concurrent/FutureCallback;", "Lcom/android/tools/idea/ddms/DeviceNameProperties;", "isDisposed", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/google/common/util/concurrent/FutureCallback;Lkotlin/jvm/functions/Function1;)V", "(Lcom/intellij/openapi/Disposable;)V", "(Lcom/intellij/openapi/Disposable;Lcom/google/common/util/concurrent/FutureCallback;)V", "edtExecutor", "Lcom/intellij/util/concurrency/EdtExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "taskExecutor", "Ljava/util/concurrent/ExecutorService;", "defaultValue", "tasksMap", "Ljava/util/HashMap;", "Lcom/android/ddmlib/IDevice;", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lkotlin/collections/HashMap;", "deviceNamePropertiesMap", "myDeviceChangeListener", "Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher$DeviceChangeListener;", "getDeviceSystemProperties", "isRetrieving", "device", "startRetriever", "", "assertThreadMatch", "callBy", "Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher$ThreadType;", "get", "dispose", "DefaultCallback", "ThreadType", "DeviceChangeListener", "intellij.android.adb"})
@StabilityInferred(parameters=0)
public final class DeviceNamePropertiesFetcher
implements Disposable,
DeviceNamePropertiesProvider {
    @NotNull
    private final Disposable parent;
    @NotNull
    private final FutureCallback<DeviceNameProperties> uiCallback;
    @NotNull
    private final Function1<Disposable, Boolean> isDisposed;
    @NotNull
    private final EdtExecutorService edtExecutor;
    @NotNull
    private final ExecutorService taskExecutor;
    @NotNull
    private final DeviceNameProperties defaultValue;
    @NotNull
    private final HashMap<IDevice, ListenableFuture<DeviceNameProperties>> tasksMap;
    @NotNull
    private final HashMap<IDevice, DeviceNameProperties> deviceNamePropertiesMap;
    @NotNull
    private final DeviceChangeListener myDeviceChangeListener;
    public static final int $stable = 8;

    @VisibleForTesting
    public DeviceNamePropertiesFetcher(@NotNull Disposable parent, @NotNull FutureCallback<DeviceNameProperties> uiCallback, @NotNull Function1<? super Disposable, Boolean> isDisposed) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(uiCallback, (String)"uiCallback");
        Intrinsics.checkNotNullParameter(isDisposed, (String)"isDisposed");
        this.parent = parent;
        this.uiCallback = uiCallback;
        this.isDisposed = isDisposed;
        EdtExecutorService edtExecutorService = EdtExecutorService.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)edtExecutorService, (String)"getInstance(...)");
        this.edtExecutor = edtExecutorService;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"DeviceNamePropertiesFetcher");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createSequentialApplicationPoolExecutor(...)");
        this.taskExecutor = executorService;
        this.defaultValue = new DeviceNameProperties(null, null, null, null);
        this.tasksMap = new HashMap();
        this.deviceNamePropertiesMap = new HashMap();
        this.myDeviceChangeListener = new DeviceChangeListener();
        Disposer.register((Disposable)this.parent, (Disposable)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
    }

    public DeviceNamePropertiesFetcher(@NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this(parent, (FutureCallback<DeviceNameProperties>)((FutureCallback)new DefaultCallback()));
    }

    public DeviceNamePropertiesFetcher(@NotNull Disposable parent, @NotNull FutureCallback<DeviceNameProperties> uiCallback) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(uiCallback, (String)"uiCallback");
        this(parent, uiCallback, (Function1<? super Disposable, Boolean>)((Function1)1.INSTANCE));
    }

    private final ListenableFuture<DeviceNameProperties> getDeviceSystemProperties(IDevice $this$getDeviceSystemProperties) {
        Object[] objectArray = new Future[4];
        Intrinsics.checkNotNullExpressionValue((Object)$this$getDeviceSystemProperties.getSystemProperty("ro.product.model"), (String)"getSystemProperty(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$getDeviceSystemProperties.getSystemProperty("ro.product.manufacturer"), (String)"getSystemProperty(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$getDeviceSystemProperties.getSystemProperty("ro.build.version.release"), (String)"getSystemProperty(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$getDeviceSystemProperties.getSystemProperty("ro.build.version.sdk"), (String)"getSystemProperty(...)");
        List futures = CollectionsKt.listOf((Object[])objectArray);
        ListenableFuture listenableFuture = FutureUtils.whenAllComplete((List)FutureUtils.listenInPoolThread((List)futures, (Executor)this.taskExecutor)).call(() -> DeviceNamePropertiesFetcher.getDeviceSystemProperties$lambda$0(futures), MoreExecutors.directExecutor());
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"call(...)");
        return listenableFuture;
    }

    private final boolean isRetrieving(IDevice device2) {
        this.assertThreadMatch(ThreadType.TASK);
        ListenableFuture<DeviceNameProperties> task2 = this.tasksMap.get(device2);
        return task2 != null && !task2.isDone();
    }

    private final void startRetriever(IDevice device2) {
        this.assertThreadMatch(ThreadType.TASK);
        ListenableFuture<DeviceNameProperties> task2 = this.getDeviceSystemProperties(device2);
        FutureUtils.addCallback(task2, (Executor)((Executor)this.edtExecutor), arg_0 -> DeviceNamePropertiesFetcher.startRetriever$lambda$1(this, device2, arg_0), arg_0 -> DeviceNamePropertiesFetcher.startRetriever$lambda$2(this, arg_0));
        ((Map)this.tasksMap).put(device2, task2);
    }

    private final void assertThreadMatch(ThreadType callBy) {
        Application application = ApplicationManager.getApplication();
        if (application != null && !application.isUnitTestMode()) {
            switch (WhenMappings.$EnumSwitchMapping$0[callBy.ordinal()]) {
                case 1: {
                    application.assertIsDispatchThread();
                    break;
                }
                case 2: {
                    boolean bl;
                    boolean bl2 = bl = !application.isDispatchThread();
                    if (!_Assertions.ENABLED || bl) break;
                    boolean bl3 = false;
                    String string = "This operation is time consuming and must not be called on EDT";
                    throw new AssertionError((Object)string);
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @Override
    @NotNull
    public DeviceNameProperties get(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.assertThreadMatch(ThreadType.EDT);
        if (((Boolean)this.isDisposed.invoke((Object)this)).booleanValue()) {
            Logger.getInstance(DeviceNamePropertiesFetcher.class).warn("DeviceNamePropertiesFetcher has been disposed");
            return this.defaultValue;
        }
        DeviceNameProperties value2 = this.deviceNamePropertiesMap.get(device2);
        this.taskExecutor.execute(() -> DeviceNamePropertiesFetcher.get$lambda$4(this, device2));
        DeviceNameProperties deviceNameProperties = value2;
        if (deviceNameProperties == null) {
            deviceNameProperties = this.defaultValue;
        }
        return deviceNameProperties;
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
    }

    private static final DeviceNameProperties getDeviceSystemProperties$lambda$0(List $futures) {
        return new DeviceNameProperties((String)((Future)$futures.get(0)).get(), (String)((Future)$futures.get(1)).get(), (String)((Future)$futures.get(2)).get(), (String)((Future)$futures.get(3)).get());
    }

    private static final Unit startRetriever$lambda$1(DeviceNamePropertiesFetcher this$0, IDevice $device, DeviceNameProperties deviceNameProperties) {
        if (!Intrinsics.areEqual((Object)this$0.deviceNamePropertiesMap.get($device), (Object)deviceNameProperties)) {
            ((Map)this$0.deviceNamePropertiesMap).put($device, deviceNameProperties);
            if (!((Boolean)this$0.isDisposed.invoke((Object)this$0)).booleanValue()) {
                this$0.uiCallback.onSuccess((Object)deviceNameProperties);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit startRetriever$lambda$2(DeviceNamePropertiesFetcher this$0, Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (!((Boolean)this$0.isDisposed.invoke((Object)this$0)).booleanValue()) {
            this$0.uiCallback.onFailure(t);
        }
        return Unit.INSTANCE;
    }

    private static final void get$lambda$4(DeviceNamePropertiesFetcher this$0, IDevice $device) {
        if (!this$0.isRetrieving($device)) {
            this$0.startRetriever($device);
        }
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher$DefaultCallback;", "Lcom/google/common/util/concurrent/FutureCallback;", "Lcom/android/tools/idea/ddms/DeviceNameProperties;", "<init>", "()V", "onSuccess", "", "properties", "onFailure", "throwable", "", "intellij.android.adb"})
    @StabilityInferred(parameters=1)
    public static final class DefaultCallback
    implements FutureCallback<DeviceNameProperties> {
        public static final int $stable;

        public void onSuccess(@Nullable DeviceNameProperties properties) {
        }

        public void onFailure(@NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            if (!(throwable instanceof CancellationException)) {
                Logger.getInstance(DeviceNamePropertiesFetcher.class).warn(throwable);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher$DeviceChangeListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDeviceChangeListener;", "<init>", "(Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher;)V", "deviceConnected", "", "device", "Lcom/android/ddmlib/IDevice;", "deviceDisconnected", "deviceChanged", "changeMask", "", "intellij.android.adb"})
    public final class DeviceChangeListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        public void deviceConnected(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        }

        public void deviceDisconnected(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            DeviceNamePropertiesFetcher.this.edtExecutor.execute(() -> DeviceChangeListener.deviceDisconnected$lambda$0(DeviceNamePropertiesFetcher.this, device2));
        }

        public void deviceChanged(@NotNull IDevice device2, int changeMask) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        }

        private static final void deviceDisconnected$lambda$0(DeviceNamePropertiesFetcher this$0, IDevice $device) {
            this$0.assertThreadMatch(ThreadType.EDT);
            this$0.deviceNamePropertiesMap.remove($device);
            this$0.tasksMap.remove($device);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/ddms/DeviceNamePropertiesFetcher$ThreadType;", "", "<init>", "(Ljava/lang/String;I)V", "EDT", "TASK", "intellij.android.adb"})
    public static final class ThreadType
    extends Enum<ThreadType> {
        public static final /* enum */ ThreadType EDT = new ThreadType();
        public static final /* enum */ ThreadType TASK = new ThreadType();
        private static final /* synthetic */ ThreadType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ThreadType[] values() {
            return (ThreadType[])$VALUES.clone();
        }

        public static ThreadType valueOf(String value2) {
            return Enum.valueOf(ThreadType.class, value2);
        }

        @NotNull
        public static EnumEntries<ThreadType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = threadTypeArray = new ThreadType[]{ThreadType.EDT, ThreadType.TASK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreadType.values().length];
            try {
                nArray[ThreadType.EDT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreadType.TASK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

