/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.psiclass;

import com.android.tools.idea.databinding.BindingLayout;
import com.android.tools.idea.databinding.BindingLayoutGroup;
import com.android.tools.idea.databinding.index.BindingLayoutType;
import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.index.VariableData;
import com.android.tools.idea.databinding.index.ViewIdData;
import com.android.tools.idea.databinding.module.LayoutBindingModuleCache;
import com.android.tools.idea.databinding.psiclass.LightBindingClassConfig;
import com.android.tools.idea.databinding.psiclass.LightBindingClassConfigKt;
import com.android.tools.idea.databinding.util.ViewBindingUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ApplicationKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010+\u001a\u00020&2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u00020\u000fH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R&\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR&\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u00061"}, d2={"Lcom/android/tools/idea/databinding/psiclass/BindingClassConfig;", "Lcom/android/tools/idea/databinding/psiclass/LightBindingClassConfig;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "group", "Lcom/android/tools/idea/databinding/BindingLayoutGroup;", "<init>", "(Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/tools/idea/databinding/BindingLayoutGroup;)V", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "targetLayout", "Lcom/android/tools/idea/databinding/BindingLayout;", "getTargetLayout", "()Lcom/android/tools/idea/databinding/BindingLayout;", "superName", "", "getSuperName", "()Ljava/lang/String;", "className", "getClassName", "qualifiedName", "getQualifiedName", "rootType", "getRootType", "variableTags", "", "Lkotlin/Pair;", "Lcom/android/tools/idea/databinding/index/VariableData;", "Lcom/intellij/psi/xml/XmlTag;", "getVariableTags", "()Ljava/util/List;", "scopedViewIds", "", "", "Lcom/android/tools/idea/databinding/index/ViewIdData;", "getScopedViewIds", "()Ljava/util/Map;", "shouldGenerateGettersAndStaticMethods", "", "settersShouldBeAbstract", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.android.databinding"})
@SourceDebugExtension(value={"SMAP\nLightBindingClassConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LightBindingClassConfig.kt\ncom/android/tools/idea/databinding/psiclass/BindingClassConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,282:1\n1734#2,3:283\n25#3:286\n25#3:287\n25#3:288\n25#3:289\n*S KotlinDebug\n*F\n+ 1 LightBindingClassConfig.kt\ncom/android/tools/idea/databinding/psiclass/BindingClassConfig\n*L\n150#1:283,3\n163#1:286\n166#1:287\n173#1:288\n183#1:289\n*E\n"})
public final class BindingClassConfig
implements LightBindingClassConfig {
    @NotNull
    private final AndroidFacet facet;
    @NotNull
    private final BindingLayoutGroup group;
    @NotNull
    private final String className;
    @NotNull
    private final String qualifiedName;

    public BindingClassConfig(@NotNull AndroidFacet facet, @NotNull BindingLayoutGroup group2) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        this.facet = facet;
        this.group = group2;
        this.className = this.group.getMainLayout().getClassName();
        this.qualifiedName = this.group.getMainLayout().getQualifiedClassName();
    }

    @Override
    @NotNull
    public AndroidFacet getFacet() {
        return this.facet;
    }

    @Override
    @NotNull
    public BindingLayout getTargetLayout() {
        return this.group.getMainLayout();
    }

    @Override
    @NotNull
    public String getSuperName() {
        String string;
        if (this.getTargetLayout().getData().getLayoutType() == BindingLayoutType.DATA_BINDING_LAYOUT) {
            string = LayoutBindingModuleCache.Companion.getInstance((AndroidFacet)this.getFacet()).getDataBindingMode().viewDataBinding;
        } else {
            Project project = this.getFacet().getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            string = ViewBindingUtil.getViewBindingClassName(project);
        }
        return string;
    }

    @Override
    @NotNull
    public String getClassName() {
        return this.className;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    @NotNull
    public String getRootType() {
        boolean bl;
        String mainTag;
        block4: {
            mainTag = this.group.getMainLayout().getData().getRootTag();
            Iterable $this$all$iv = this.group.getLayouts();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    BindingLayout it = (BindingLayout)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getData().getRootTag(), (Object)mainTag)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return mainTag;
        }
        return "View";
    }

    @Override
    @NotNull
    public List<Pair<VariableData, XmlTag>> getVariableTags() {
        Project project = this.getFacet().getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return LightBindingClassConfigKt.access$getAggregatedVariables(this.group, project);
    }

    @Override
    @NotNull
    public Map<BindingLayout, Collection<ViewIdData>> getScopedViewIds() {
        boolean $i$f$thisLogger;
        BindingClassConfig $this$thisLogger$iv;
        Project project = this.getFacet().getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BindingClassConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("scopedViewIds: called while in dumb mode");
        }
        if (!ApplicationKt.getApplication().isReadAccessAllowed()) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BindingClassConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("scopedViewIds: called without read access");
        }
        Map viewIds = new LinkedHashMap();
        for (BindingLayout layout : this.group.getLayouts()) {
            XmlFile xmlFile = layout.toXmlFile();
            if (xmlFile == null) {
                BindingClassConfig $this$thisLogger$iv2 = this;
                boolean $i$f$thisLogger2 = false;
                Logger logger = Logger.getInstance(BindingClassConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                Project project2 = this.getFacet().getModule().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                logger.info("scopedViewIds: Binding layout should always be backed by an xml file. Dumb mode: " + DumbService.Companion.isDumb(project2) + ". Qualified name: " + this.getQualifiedName() + ". Layout file: " + layout.getFile().getName());
                continue;
            }
            BindingXmlData xmlData = BindingXmlIndex.Companion.getDataForFile((PsiFile)xmlFile);
            if (xmlData == null) {
                BindingClassConfig $this$thisLogger$iv3 = this;
                boolean $i$f$thisLogger3 = false;
                Logger logger = Logger.getInstance(BindingClassConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                Project project3 = this.getFacet().getModule().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                logger.info("scopedViewIds: Every binding layout should have indexed data. Dumb mode: " + DumbService.Companion.isDumb(project3) + ". Qualified name: " + this.getQualifiedName() + ". Layout file: " + layout.getFile().getName());
                continue;
            }
            viewIds.put(layout, xmlData.getViewIds());
        }
        return viewIds;
    }

    @Override
    public boolean shouldGenerateGettersAndStaticMethods() {
        return true;
    }

    @Override
    public boolean settersShouldBeAbstract() {
        return this.group.getLayouts().size() > 1;
    }

    @NotNull
    public final AndroidFacet component1() {
        return this.facet;
    }

    private final BindingLayoutGroup component2() {
        return this.group;
    }

    @NotNull
    public final BindingClassConfig copy(@NotNull AndroidFacet facet, @NotNull BindingLayoutGroup group2) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        return new BindingClassConfig(facet, group2);
    }

    public static /* synthetic */ BindingClassConfig copy$default(BindingClassConfig bindingClassConfig, AndroidFacet androidFacet, BindingLayoutGroup bindingLayoutGroup, int n, Object object) {
        if ((n & 1) != 0) {
            androidFacet = bindingClassConfig.facet;
        }
        if ((n & 2) != 0) {
            bindingLayoutGroup = bindingClassConfig.group;
        }
        return bindingClassConfig.copy(androidFacet, bindingLayoutGroup);
    }

    @NotNull
    public String toString() {
        return "BindingClassConfig(facet=" + this.facet + ", group=" + this.group + ")";
    }

    public int hashCode() {
        int result2 = this.facet.hashCode();
        result2 = result2 * 31 + this.group.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BindingClassConfig)) {
            return false;
        }
        BindingClassConfig bindingClassConfig = (BindingClassConfig)other;
        if (!Intrinsics.areEqual((Object)this.facet, (Object)bindingClassConfig.facet)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.group, (Object)bindingClassConfig.group);
    }
}

