/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.index;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.databinding.index.BindingLayoutType;
import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.index.BindingXmlIndexKt;
import com.android.tools.idea.databinding.index.EscapingXmlReader;
import com.android.tools.idea.databinding.index.ImportData;
import com.android.tools.idea.databinding.index.VariableData;
import com.android.tools.idea.databinding.index.ViewIdData;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/databinding/index/BindingXmlIndex;", "Lcom/intellij/util/indexing/SingleEntryFileBasedIndexExtension;", "Lcom/android/tools/idea/databinding/index/BindingXmlData;", "<init>", "()V", "getValueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "getName", "Lcom/intellij/util/indexing/ID;", "", "getIndexer", "Lcom/intellij/util/indexing/SingleEntryIndexer;", "getInputFilter", "Lcom/intellij/util/indexing/DefaultFileTypeSpecificInputFilter;", "getVersion", "Entry", "Companion", "intellij.android.core"})
public final class BindingXmlIndex
extends SingleEntryFileBasedIndexExtension<BindingXmlData> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public DataExternalizer<BindingXmlData> getValueExternalizer() {
        return (DataExternalizer)new DataExternalizer<BindingXmlData>(){

            public void save(DataOutput out, BindingXmlData value2) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                if (value2 == null) {
                    return;
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.getLayoutType().ordinal());
                IOUtil.writeUTF((DataOutput)out, (String)value2.getRootTag());
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(value2.getViewBindingIgnore() ? 1 : 0));
                this.writeNullableUTF(out, value2.getCustomBindingName());
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.getImports().size());
                for (ImportData importData : value2.getImports()) {
                    IOUtil.writeUTF((DataOutput)out, (String)importData.getType());
                    this.writeNullableUTF(out, importData.getAlias());
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.getVariables().size());
                for (VariableData variable : value2.getVariables()) {
                    IOUtil.writeUTF((DataOutput)out, (String)variable.getName());
                    IOUtil.writeUTF((DataOutput)out, (String)variable.getType());
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.getViewIds().size());
                for (ViewIdData viewId : value2.getViewIds()) {
                    IOUtil.writeUTF((DataOutput)out, (String)viewId.getId());
                    IOUtil.writeUTF((DataOutput)out, (String)viewId.getViewName());
                    this.writeNullableUTF(out, viewId.getLayoutName());
                    this.writeNullableUTF(out, viewId.getTypeOverride());
                }
            }

            public BindingXmlData read(DataInput input2) {
                Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
                BindingLayoutType layoutType = BindingLayoutType.values()[DataInputOutputUtil.readINT((DataInput)input2)];
                String rootTag = IOUtil.readUTF((DataInput)input2);
                boolean viewBindingIgnore = DataInputOutputUtil.readINT((DataInput)input2) == 1;
                String customBindingName = this.readNullableUTF(input2);
                List imports = new ArrayList<E>();
                int n = DataInputOutputUtil.readINT((DataInput)input2);
                for (int i = 0; i < n; ++i) {
                    String string = IOUtil.readUTF((DataInput)input2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF(...)");
                    imports.add(new ImportData(string, this.readNullableUTF(input2)));
                }
                List variables = new ArrayList<E>();
                int n2 = DataInputOutputUtil.readINT((DataInput)input2);
                for (int i = 0; i < n2; ++i) {
                    String string = IOUtil.readUTF((DataInput)input2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF(...)");
                    String string2 = IOUtil.readUTF((DataInput)input2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readUTF(...)");
                    variables.add(new VariableData(string, string2));
                }
                List viewIds = new ArrayList<E>();
                int i = 1;
                int n3 = DataInputOutputUtil.readINT((DataInput)input2);
                if (i <= n3) {
                    while (true) {
                        String string = IOUtil.readUTF((DataInput)input2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF(...)");
                        String string3 = IOUtil.readUTF((DataInput)input2);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readUTF(...)");
                        viewIds.add(new ViewIdData(string, string3, this.readNullableUTF(input2), this.readNullableUTF(input2)));
                        if (i == n3) break;
                        ++i;
                    }
                }
                Intrinsics.checkNotNull((Object)rootTag);
                return new BindingXmlData(layoutType, rootTag, viewBindingIgnore, customBindingName, imports, variables, viewIds);
            }

            private final String readNullableUTF(DataInput input2) {
                return (String)DataInputOutputUtil.readNullable((DataInput)input2, () -> getValueExternalizer.1.readNullableUTF$lambda$0(input2));
            }

            private final void writeNullableUTF(DataOutput out, String value2) {
                DataInputOutputUtil.writeNullable((DataOutput)out, (Object)value2, arg_0 -> getValueExternalizer.1.writeNullableUTF$lambda$2(arg_0 -> getValueExternalizer.1.writeNullableUTF$lambda$1(out, arg_0), arg_0));
            }

            private static final String readNullableUTF$lambda$0(DataInput $input) {
                return IOUtil.readUTF((DataInput)$input);
            }

            private static final Unit writeNullableUTF$lambda$1(DataOutput $out, String it) {
                IOUtil.writeUTF((DataOutput)$out, (String)it);
                return Unit.INSTANCE;
            }

            private static final void writeNullableUTF$lambda$2(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        };
    }

    @NotNull
    public ID<Integer, BindingXmlData> getName() {
        return BindingXmlIndexKt.access$getBINDING_XML_INDEX_NAME$p();
    }

    @NotNull
    public SingleEntryIndexer<BindingXmlData> getIndexer() {
        return (SingleEntryIndexer)new SingleEntryIndexer<BindingXmlData>(){
            private final Regex xmlNamespaceRegex;
            {
                this.xmlNamespaceRegex = new Regex("xmlns:android\\s*=\\s*\"http://schemas.android.com/apk/res/android\"");
            }

            protected BindingXmlData computeValue(FileContent inputData) {
                CharSequence inputAsText;
                Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
                CharSequence charSequence = inputData.getContentAsText();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getContentAsText(...)");
                CharSequence charSequence2 = inputAsText = charSequence;
                if (!this.xmlNamespaceRegex.containsMatchIn(charSequence2)) {
                    return null;
                }
                Ref.ObjectRef bindingLayoutType = new Ref.ObjectRef();
                bindingLayoutType.element = BindingLayoutType.PLAIN_LAYOUT;
                Ref.ObjectRef customBindingName = new Ref.ObjectRef();
                Ref.BooleanRef viewBindingIgnore = new Ref.BooleanRef();
                Ref.ObjectRef rootTag = new Ref.ObjectRef();
                List variables = new ArrayList<E>();
                List imports = new ArrayList<E>();
                List viewIds = new ArrayList<E>();
                NanoXmlUtil.parse((Reader)new EscapingXmlReader(inputAsText), (IXMLBuilder)((IXMLBuilder)new NanoXmlBuilder((Ref.ObjectRef<BindingLayoutType>)bindingLayoutType, (Ref.ObjectRef<String>)rootTag, (Ref.ObjectRef<String>)customBindingName, viewBindingIgnore, imports, variables, viewIds){
                    private final List<getIndexer.computeValue.TagData> tags;
                    final /* synthetic */ Ref.ObjectRef<BindingLayoutType> $bindingLayoutType;
                    final /* synthetic */ Ref.ObjectRef<String> $rootTag;
                    final /* synthetic */ Ref.ObjectRef<String> $customBindingName;
                    final /* synthetic */ Ref.BooleanRef $viewBindingIgnore;
                    final /* synthetic */ List<ImportData> $imports;
                    final /* synthetic */ List<VariableData> $variables;
                    final /* synthetic */ List<ViewIdData> $viewIds;
                    {
                        this.$bindingLayoutType = $bindingLayoutType;
                        this.$rootTag = $rootTag;
                        this.$customBindingName = $customBindingName;
                        this.$viewBindingIgnore = $viewBindingIgnore;
                        this.$imports = $imports;
                        this.$variables = $variables;
                        this.$viewIds = $viewIds;
                        this.tags = new ArrayList<E>();
                    }

                    public final List<getIndexer.computeValue.TagData> getTags() {
                        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001d*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\u0005R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0007\"\u0004\b\u0010\u0010\u0005R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0007\"\u0004\b\u0013\u0010\u0005R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0007\"\u0004\b\u0016\u0010\u0005R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0007\"\u0004\b\u0019\u0010\u0005R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0007\"\u0004\b\u001c\u0010\u0005R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0007\"\u0004\b\u001f\u0010\u0005\u00a8\u0006 "}, d2={"com/android/tools/idea/databinding/index/BindingXmlIndex$getIndexer$1$computeValue$TagData", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "importType", "getImportType", "setImportType", "importAlias", "getImportAlias", "setImportAlias", "variableName", "getVariableName", "setVariableName", "variableType", "getVariableType", "setVariableType", "viewClass", "getViewClass", "setViewClass", "viewId", "getViewId", "setViewId", "viewLayout", "getViewLayout", "setViewLayout", "viewTypeOverride", "getViewTypeOverride", "setViewTypeOverride", "intellij.android.core"})
                        public final class TagData {
                            private final String name;
                            private String importType;
                            private String importAlias;
                            private String variableName;
                            private String variableType;
                            private String viewClass;
                            private String viewId;
                            private String viewLayout;
                            private String viewTypeOverride;

                            public TagData(String name2) {
                                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                                this.name = name2;
                            }

                            public final String getName() {
                                return this.name;
                            }

                            public final String getImportType() {
                                return this.importType;
                            }

                            public final void setImportType(String string) {
                                this.importType = string;
                            }

                            public final String getImportAlias() {
                                return this.importAlias;
                            }

                            public final void setImportAlias(String string) {
                                this.importAlias = string;
                            }

                            public final String getVariableName() {
                                return this.variableName;
                            }

                            public final void setVariableName(String string) {
                                this.variableName = string;
                            }

                            public final String getVariableType() {
                                return this.variableType;
                            }

                            public final void setVariableType(String string) {
                                this.variableType = string;
                            }

                            public final String getViewClass() {
                                return this.viewClass;
                            }

                            public final void setViewClass(String string) {
                                this.viewClass = string;
                            }

                            public final String getViewId() {
                                return this.viewId;
                            }

                            public final void setViewId(String string) {
                                this.viewId = string;
                            }

                            public final String getViewLayout() {
                                return this.viewLayout;
                            }

                            public final void setViewLayout(String string) {
                                this.viewLayout = string;
                            }

                            public final String getViewTypeOverride() {
                                return this.viewTypeOverride;
                            }

                            public final void setViewTypeOverride(String string) {
                                this.viewTypeOverride = string;
                            }
                        }
                        return this.tags;
                    }

                    public void startElement(String name2, String nsPrefix, String nsURI, String systemID, int lineNr) {
                        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                        Intrinsics.checkNotNullParameter((Object)systemID, (String)"systemID");
                        this.tags.add(new TagData(name2));
                        if (Intrinsics.areEqual((Object)name2, (Object)"layout")) {
                            this.$bindingLayoutType.element = BindingLayoutType.DATA_BINDING_LAYOUT;
                        }
                        if (this.tags.size() == 1) {
                            this.$rootTag.element = name2;
                        }
                    }

                    public void addAttribute(String key, String nsPrefix, String nsURI, String value2, String type) {
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                        TagData currTag = (TagData)CollectionsKt.last(this.tags);
                        switch (currTag.getName()) {
                            case "data": {
                                if (!Intrinsics.areEqual((Object)key, (Object)"class")) break;
                                this.$customBindingName.element = value2;
                                break;
                            }
                            case "import": {
                                String string = key;
                                if (Intrinsics.areEqual((Object)string, (Object)"type")) {
                                    currTag.setImportType(value2);
                                    break;
                                }
                                if (!Intrinsics.areEqual((Object)string, (Object)"alias")) break;
                                currTag.setImportAlias(value2);
                                break;
                            }
                            case "variable": {
                                String string = key;
                                if (Intrinsics.areEqual((Object)string, (Object)"name")) {
                                    currTag.setVariableName(value2);
                                    break;
                                }
                                if (!Intrinsics.areEqual((Object)string, (Object)"type")) break;
                                currTag.setVariableType(value2);
                                break;
                            }
                            default: {
                                if (Intrinsics.areEqual((Object)nsURI, (Object)"http://schemas.android.com/apk/res/android")) {
                                    if (!Intrinsics.areEqual((Object)key, (Object)"id")) break;
                                    ResourceUrl resourceUrl = ResourceUrl.parse((String)value2);
                                    currTag.setViewId(resourceUrl != null ? resourceUrl.name : null);
                                    break;
                                }
                                if (Intrinsics.areEqual((Object)nsURI, (Object)"http://schemas.android.com/tools")) {
                                    if (this.$bindingLayoutType.element != BindingLayoutType.PLAIN_LAYOUT || Intrinsics.areEqual((Object)currTag.getName(), (Object)"include") || Intrinsics.areEqual((Object)currTag.getName(), (Object)"merge") || !Intrinsics.areEqual((Object)key, (Object)"viewBindingType")) break;
                                    currTag.setViewTypeOverride(value2);
                                    break;
                                }
                                if (nsURI != null) break;
                                if (Intrinsics.areEqual((Object)currTag.getName(), (Object)"include") || Intrinsics.areEqual((Object)currTag.getName(), (Object)"merge")) {
                                    if (!Intrinsics.areEqual((Object)key, (Object)"layout")) break;
                                    currTag.setViewLayout(value2);
                                    break;
                                }
                                if (!Intrinsics.areEqual((Object)currTag.getName(), (Object)"view") || !Intrinsics.areEqual((Object)key, (Object)"class")) break;
                                currTag.setViewClass(value2);
                            }
                        }
                        if (this.tags.size() == 1 && this.$bindingLayoutType.element == BindingLayoutType.PLAIN_LAYOUT && Intrinsics.areEqual((Object)nsURI, (Object)"http://schemas.android.com/tools") && Intrinsics.areEqual((Object)key, (Object)"viewBindingIgnore")) {
                            this.$viewBindingIgnore.element = Boolean.parseBoolean(value2);
                        }
                    }

                    public void elementAttributesProcessed(String name2, String nsPrefix, String nsURI) {
                        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                        TagData currTag = (TagData)CollectionsKt.last(this.tags);
                        switch (currTag.getName()) {
                            case "import": {
                                String string = currTag.getImportType();
                                if (string != null) {
                                    String string2 = string;
                                    List<ImportData> list = this.$imports;
                                    String importType = string2;
                                    boolean bl = false;
                                    list.add(new ImportData(importType, currTag.getImportAlias()));
                                }
                                break;
                            }
                            case "variable": {
                                String string = currTag.getVariableName();
                                if (string != null) {
                                    String string3 = string;
                                    List<VariableData> list = this.$variables;
                                    String variableName = string3;
                                    boolean bl = false;
                                    String string4 = currTag.getVariableType();
                                    if (string4 != null) {
                                        String variableType = string4;
                                        boolean bl2 = false;
                                        list.add(new VariableData(variableName, variableType));
                                    }
                                }
                                break;
                            }
                            default: {
                                String string = currTag.getViewId();
                                if (string != null) {
                                    String viewName;
                                    String string5 = string;
                                    List<ViewIdData> list = this.$viewIds;
                                    String viewId = string5;
                                    boolean bl = false;
                                    String string6 = viewName = !Intrinsics.areEqual((Object)currTag.getName(), (Object)"view") ? currTag.getName() : currTag.getViewClass();
                                    if (viewName == null) break;
                                    list.add(new ViewIdData(viewId, viewName, currTag.getViewLayout(), currTag.getViewTypeOverride()));
                                }
                                break;
                            }
                            case "data": 
                        }
                    }

                    public void endElement(String s, String s1, String s2) {
                        this.tags.remove(CollectionsKt.getLastIndex(this.tags));
                    }
                }));
                BindingLayoutType bindingLayoutType2 = (BindingLayoutType)((Object)bindingLayoutType.element);
                String string = (String)rootTag.element;
                if (string == null) {
                    string = "";
                }
                return new BindingXmlData(bindingLayoutType2, string, viewBindingIgnore.element, (String)customBindingName.element, imports, variables, viewIds);
            }
        };
    }

    @NotNull
    public DefaultFileTypeSpecificInputFilter getInputFilter() {
        FileType[] fileTypeArray = new FileType[]{XmlFileType.INSTANCE};
        return new DefaultFileTypeSpecificInputFilter(fileTypeArray);
    }

    public int getVersion() {
        return 12;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/databinding/index/BindingXmlIndex$Companion;", "", "<init>", "()V", "getDataForFile", "Lcom/android/tools/idea/databinding/index/BindingXmlData;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getEntriesForLayout", "", "Lcom/android/tools/idea/databinding/index/BindingXmlIndex$Entry;", "layoutName", "", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.android.core"})
    @SourceDebugExtension(value={"SMAP\nBindingXmlIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BindingXmlIndex.kt\ncom/android/tools/idea/databinding/index/BindingXmlIndex$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,517:1\n1611#2,9:518\n1863#2:527\n1864#2:530\n1620#2:531\n1#3:528\n1#3:529\n*S KotlinDebug\n*F\n+ 1 BindingXmlIndex.kt\ncom/android/tools/idea/databinding/index/BindingXmlIndex$Companion\n*L\n85#1:518,9\n85#1:527\n85#1:530\n85#1:531\n85#1:529\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final BindingXmlData getDataForFile(VirtualFile file, Project project) {
            BindingXmlData bindingXmlData = (BindingXmlData)FileBasedIndex.getInstance().getSingleEntryIndexData(BindingXmlIndexKt.access$getBINDING_XML_INDEX_NAME$p(), file, project);
            if (bindingXmlData == null) {
                return null;
            }
            BindingXmlData data2 = bindingXmlData;
            Object object = file.getParent();
            if (object == null || (object = object.getName()) == null) {
                return null;
            }
            Object parentFolderName = object;
            if (ResourceFolderType.getFolderType((String)parentFolderName) != ResourceFolderType.LAYOUT) {
                return null;
            }
            return data2;
        }

        @Nullable
        public final BindingXmlData getDataForFile(@NotNull Project project, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.getDataForFile(file, project);
        }

        @Nullable
        public final BindingXmlData getDataForFile(@NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            Project project = psiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.getDataForFile(virtualFile, project);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Entry> getEntriesForLayout(Project project, String layoutName, GlobalSearchScope scope) {
            void $this$mapNotNullTo$iv$iv;
            Collection collection2 = FilenameIndex.getVirtualFilesByName((String)(layoutName + ".xml"), (GlobalSearchScope)scope);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getVirtualFilesByName(...)");
            Iterable $this$mapNotNull$iv = collection2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Entry entry;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                VirtualFile file = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)file);
                if (Companion.getDataForFile(file, project) != null) {
                    BindingXmlData data2;
                    boolean bl3 = false;
                    entry = new Entry(file, data2);
                } else {
                    entry = null;
                }
                if (entry == null) continue;
                Entry it$iv$iv = entry;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<Entry> getEntriesForLayout(@NotNull Module module, @NotNull String layoutName) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)layoutName, (String)"layoutName");
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            GlobalSearchScope globalSearchScope = module.getModuleContentWithDependenciesScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleContentWithDependenciesScope(...)");
            return this.getEntriesForLayout(project, layoutName, globalSearchScope);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/databinding/index/BindingXmlIndex$Entry;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "data", "Lcom/android/tools/idea/databinding/index/BindingXmlData;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/android/tools/idea/databinding/index/BindingXmlData;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getData", "()Lcom/android/tools/idea/databinding/index/BindingXmlData;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.core"})
    public static final class Entry {
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final BindingXmlData data;

        public Entry(@NotNull VirtualFile file, @NotNull BindingXmlData data2) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            this.file = file;
            this.data = data2;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final BindingXmlData getData() {
            return this.data;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.file;
        }

        @NotNull
        public final BindingXmlData component2() {
            return this.data;
        }

        @NotNull
        public final Entry copy(@NotNull VirtualFile file, @NotNull BindingXmlData data2) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return new Entry(file, data2);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, VirtualFile virtualFile, BindingXmlData bindingXmlData, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = entry.file;
            }
            if ((n & 2) != 0) {
                bindingXmlData = entry.data;
            }
            return entry.copy(virtualFile, bindingXmlData);
        }

        @NotNull
        public String toString() {
            return "Entry(file=" + this.file + ", data=" + this.data + ")";
        }

        public int hashCode() {
            int result2 = this.file.hashCode();
            result2 = result2 * 31 + this.data.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)entry.file)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.data, (Object)entry.data);
        }
    }
}

