/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.backup;

import com.android.backup.BackupMetadata;
import com.android.backup.BackupResult;
import com.android.tools.idea.actions.ActionUtils;
import com.android.tools.idea.backup.ActionHelper;
import com.android.tools.idea.backup.ActionHelperImpl;
import com.android.tools.idea.backup.BackupBundle;
import com.android.tools.idea.backup.BackupFileType;
import com.android.tools.idea.backup.BackupManager;
import com.android.tools.idea.backup.DeviceChecker;
import com.android.tools.idea.backup.DialogFactory;
import com.android.tools.idea.backup.DialogFactoryImpl;
import com.android.tools.idea.backup.RestoreFileAction;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\rH\u0082@\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u000b*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/backup/RestoreFileAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "actionHelper", "Lcom/android/tools/idea/backup/ActionHelper;", "dialogFactory", "Lcom/android/tools/idea/backup/DialogFactory;", "<init>", "(Lcom/android/tools/idea/backup/ActionHelper;Lcom/android/tools/idea/backup/DialogFactory;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getRestoreInfo", "Lcom/android/tools/idea/backup/RestoreFileAction$RestoreInfo;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "restore", "Lcom/android/tools/idea/backup/RestoreFileAction$RestoreInfo$Valid;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/android/tools/idea/backup/RestoreFileAction$RestoreInfo$Valid;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "RestoreInfo", "intellij.android.backup"})
public final class RestoreFileAction
extends AnAction {
    @NotNull
    private final ActionHelper actionHelper;
    @NotNull
    private final DialogFactory dialogFactory;

    public RestoreFileAction(@NotNull ActionHelper actionHelper, @NotNull DialogFactory dialogFactory) {
        Intrinsics.checkNotNullParameter((Object)actionHelper, (String)"actionHelper");
        Intrinsics.checkNotNullParameter((Object)dialogFactory, (String)"dialogFactory");
        this.actionHelper = actionHelper;
        this.dialogFactory = dialogFactory;
    }

    public /* synthetic */ RestoreFileAction(ActionHelper actionHelper, DialogFactory dialogFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            actionHelper = new ActionHelperImpl();
        }
        if ((n & 2) != 0) {
            dialogFactory = new DialogFactoryImpl();
        }
        this(actionHelper, dialogFactory);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        if (!((Boolean)StudioFlags.BACKUP_ENABLED.get()).booleanValue()) {
            return;
        }
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (!Intrinsics.areEqual((Object)virtualFile2.getFileType(), (Object)BackupFileType.INSTANCE)) {
            return;
        }
        boolean ok2 = DeviceChecker.Companion.checkEventDeviceType(this, e);
        if (!ok2) {
            return;
        }
        e.getPresentation().setVisible(true);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        ActionUtils.disableRichTooltip((Presentation)presentation);
        e.getPresentation().setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        BuildersKt.launch$default((CoroutineScope)CoroutineUtilsKt.getCoroutineScope((Project)project2), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, e, project2, null){
            int label;
            final /* synthetic */ RestoreFileAction this$0;
            final /* synthetic */ AnActionEvent $e;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$e = $e;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block9: {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = RestoreFileAction.access$getRestoreInfo(this.this$0, this.$e, (Continuation)this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if ((restoreInfo = (RestoreInfo)v0) instanceof RestoreInfo.Invalid) {
                                DialogFactory.showDialog$default(RestoreFileAction.access$getDialogFactory$p(this.this$0), this.$project, BackupBundle.message("restore.file.action.error.title", new Object[0]), ((RestoreInfo.Invalid)restoreInfo).getReason(), null, 8, null);
                            } else {
                                if (!(restoreInfo instanceof RestoreInfo.Valid)) break;
                                this.label = 2;
                                v1 = RestoreFileAction.access$restore(this.this$0, (RestoreInfo.Valid)restoreInfo, this.$project, (Continuation)this);
                                if (v1 == var3_2) {
                                    return var3_2;
                                }
                            }
                            break block9;
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            break block9;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object getRestoreInfo(AnActionEvent var1_1, Continuation<? super RestoreInfo> $completion) {
        if (!($completion instanceof getRestoreInfo.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ RestoreFileAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RestoreFileAction.access$getRestoreInfo(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $this$getRestoreInfo.getProject();
                if (v0 == null) {
                    throw new IllegalStateException("Missing project");
                }
                project = v0;
                v1 = this.actionHelper.getApplicationId(project);
                if (v1 == null) {
                    return new RestoreInfo.Invalid(BackupBundle.message("error.incompatible.run.config", new Object[0]));
                }
                applicationId = v1;
                v2 /* !! */  = (VirtualFile)$this$getRestoreInfo.getData(CommonDataKeys.VIRTUAL_FILE);
                if (v2 /* !! */  == null || (v2 /* !! */  = v2 /* !! */ .toNioPath()) == null) {
                    throw new IllegalStateException("Missing file");
                }
                backupFile = v2 /* !! */ ;
                backupManager = BackupManager.Companion.getInstance(project);
                $continuation.L$0 = project;
                $continuation.L$1 = applicationId;
                $continuation.L$2 = backupFile;
                $continuation.label = 1;
                v3 = backupManager.getMetadata(backupFile, (Continuation<? super BackupMetadata>)$continuation);
                if (v3 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl39
            }
            case 1: {
                backupFile = (Path)$continuation.L$2;
                applicationId = (String)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl39:
                // 2 sources

                v4 = (BackupMetadata)v3;
                fileApplicationId = v4 != null ? v4.getApplicationId() : null;
                if (fileApplicationId == null) {
                    var8_11 = new Object[]{backupFile.toString()};
                    return new RestoreInfo.Invalid(BackupBundle.message("error.invalid.file", var8_11));
                }
                if (!Intrinsics.areEqual((Object)fileApplicationId, (Object)applicationId)) {
                    var8_12 = new Object[]{fileApplicationId, applicationId};
                    return new RestoreInfo.Invalid(BackupBundle.message("error.wrong.package", var8_12));
                }
                targetCount = this.actionHelper.getDeployTargetCount(project);
                if (targetCount == 0) {
                    return new RestoreInfo.Invalid(BackupBundle.message("error.device.not.running", new Object[0]));
                }
                if (targetCount > 1) {
                    return new RestoreInfo.Invalid(BackupBundle.message("error.multiple.devices", new Object[0]));
                }
                v5 = this.actionHelper.getDeployTargetSerial(project);
                if (v5 == null) {
                    return new RestoreInfo.Invalid(BackupBundle.message("error.device.not.running", new Object[0]));
                }
                serialNumber = v5;
                return new RestoreInfo.Valid(backupFile, serialNumber);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object restore(RestoreInfo.Valid $this$restore, Project project, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BackupResult>, Object>(project, $this$restore, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ RestoreInfo.Valid $this_restore;
            {
                this.$project = $project;
                this.$this_restore = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return BackupManager.restoreModal$default(BackupManager.Companion.getInstance(this.$project), this.$this_restore.getSerialNumber(), this.$this_restore.getBackupFile(), BackupManager.Source.PROJECT_VIEW, false, 8, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BackupResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public RestoreFileAction() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ Object access$getRestoreInfo(RestoreFileAction $this, AnActionEvent $receiver, Continuation $completion) {
        return $this.getRestoreInfo($receiver, (Continuation<? super RestoreInfo>)$completion);
    }

    public static final /* synthetic */ DialogFactory access$getDialogFactory$p(RestoreFileAction $this) {
        return $this.dialogFactory;
    }

    public static final /* synthetic */ Object access$restore(RestoreFileAction $this, RestoreInfo.Valid $receiver, Project project, Continuation $completion) {
        return $this.restore($receiver, project, (Continuation<? super Unit>)$completion);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/backup/RestoreFileAction$RestoreInfo;", "", "<init>", "()V", "Valid", "Invalid", "Lcom/android/tools/idea/backup/RestoreFileAction$RestoreInfo$Invalid;", "Lcom/android/tools/idea/backup/RestoreFileAction$RestoreInfo$Valid;", "intellij.android.backup"})
    private static abstract class RestoreInfo {
        private RestoreInfo() {
        }

        public /* synthetic */ RestoreInfo(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/backup/RestoreFileAction$RestoreInfo$Invalid;", "Lcom/android/tools/idea/backup/RestoreFileAction$RestoreInfo;", "reason", "", "<init>", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "intellij.android.backup"})
        public static final class Invalid
        extends RestoreInfo {
            @NotNull
            private final String reason;

            public Invalid(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                super(null);
                this.reason = reason;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/backup/RestoreFileAction$RestoreInfo$Valid;", "Lcom/android/tools/idea/backup/RestoreFileAction$RestoreInfo;", "backupFile", "Ljava/nio/file/Path;", "serialNumber", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "getBackupFile", "()Ljava/nio/file/Path;", "getSerialNumber", "()Ljava/lang/String;", "intellij.android.backup"})
        public static final class Valid
        extends RestoreInfo {
            @NotNull
            private final Path backupFile;
            @NotNull
            private final String serialNumber;

            public Valid(@NotNull Path backupFile, @NotNull String serialNumber) {
                Intrinsics.checkNotNullParameter((Object)backupFile, (String)"backupFile");
                Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
                super(null);
                this.backupFile = backupFile;
                this.serialNumber = serialNumber;
            }

            @NotNull
            public final Path getBackupFile() {
                return this.backupFile;
            }

            @NotNull
            public final String getSerialNumber() {
                return this.serialNumber;
            }
        }
    }
}

