/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.backup;

import com.android.backup.BackupType;
import com.android.tools.idea.backup.BackupBundle;
import com.android.tools.idea.backup.BackupDialogKt;
import com.android.tools.idea.backup.BackupFileTextField;
import com.android.tools.idea.backup.BackupFileType;
import com.android.tools.idea.backup.BackupManagerImpl;
import com.android.tools.idea.backup.DialogFactory;
import com.android.tools.idea.backup.DialogFactoryImpl;
import com.android.tools.idea.backup.ManifestPatcher;
import com.android.tools.idea.backup.UtilsKt;
import com.android.tools.idea.util.PathExtensionsKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.UIBundle;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 92\u00020\u0001:\u00019B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020-H\u0014J\u000f\u0010.\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b/H\u0014J\b\u00100\u001a\u00020+H\u0014J\b\u00101\u001a\u00020+H\u0014J\b\u00102\u001a\u00020\u0005H\u0002J\u0010\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u0005H\u0002J\b\u00105\u001a\u00020\u0013H\u0002J\u0010\u00106\u001a\u00020+2\u0006\u0010'\u001a\u00020\u0013H\u0002J\b\u00107\u001a\u00020+H\u0002J\b\u00108\u001a\u00020+H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00050\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00130\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\n \u0011*\u0004\u0018\u00010\u001d0\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006:"}, d2={"Lcom/android/tools/idea/backup/BackupDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "initialApplicationId", "", "appIdToBackupEnabledMap", "", "", "dialogFactory", "Lcom/android/tools/idea/backup/DialogFactory;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/Map;Lcom/android/tools/idea/backup/DialogFactory;)V", "applicationIds", "", "applicationIdComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "kotlin.jvm.PlatformType", "typeComboBox", "Lcom/android/backup/BackupType;", "typeHelpIcon", "Ljavax/swing/JLabel;", "backupNotEnabledWarning", "Ljavax/swing/JEditorPane;", "Lorg/jetbrains/annotations/NotNull;", "fileTextField", "Lcom/android/tools/idea/backup/BackupFileTextField;", "fileSetByChooser", "properties", "Lcom/intellij/ide/util/PropertiesComponent;", "getProperties", "()Lcom/intellij/ide/util/PropertiesComponent;", "applicationId", "getApplicationId", "()Ljava/lang/String;", "backupPath", "Ljava/nio/file/Path;", "getBackupPath", "()Ljava/nio/file/Path;", "type", "getType", "()Lcom/android/backup/BackupType;", "checkBackupType", "", "createCenterPanel", "Ljavax/swing/JComponent;", "getHelpId", "Lorg/jetbrains/annotations/NonNls;", "doHelpAction", "doOKAction", "getLastUsedFile", "setLastUsedFile", "path", "getLastUsedType", "setLastUsedType", "updateOkAction", "enableBackupInManifest", "Companion", "intellij.android.backup"})
@SourceDebugExtension(value={"SMAP\nBackupDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupDialog.kt\ncom/android/tools/idea/backup/BackupDialog\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,329:1\n37#2:330\n36#2,3:331\n37#2:334\n36#2,3:335\n*S KotlinDebug\n*F\n+ 1 BackupDialog.kt\ncom/android/tools/idea/backup/BackupDialog\n*L\n66#1:330\n66#1:331,3\n71#1:334\n71#1:335,3\n*E\n"})
public final class BackupDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, Boolean> appIdToBackupEnabledMap;
    @NotNull
    private final DialogFactory dialogFactory;
    @NotNull
    private final List<String> applicationIds;
    @NotNull
    private final ComboBox<String> applicationIdComboBox;
    @NotNull
    private final ComboBox<BackupType> typeComboBox;
    @NotNull
    private final JLabel typeHelpIcon;
    @NotNull
    private final JEditorPane backupNotEnabledWarning;
    @NotNull
    private final BackupFileTextField fileTextField;
    private boolean fileSetByChooser;
    @NotNull
    private static final String DEFAULT_BACKUP_FILENAME = "application." + BackupFileType.INSTANCE.getDefaultExtension();
    @NotNull
    private static final String WARNING_DTD = "App-data won't be backed up as allowBackup property is false.<br>\nBackup may contain Restore Keys, if present for the app.<br>\n(<a href='learn-more'>Learn more</a>, <a href='enable-backup'>Enable in manifest</a>)";
    @NotNull
    private static final String WARNING_CLOUD = "App-data won't be backed up as allowBackup property is false.<br>\nRestore Keys backup is not supported via this tool for Cloud.<br>\nbackup type. (<a href='learn-more'>Learn more</a>, <a href='enable-backup'>Enable in manifest</a>)";
    @VisibleForTesting
    @NotNull
    public static final String LAST_USED_FILE_KEY = "Backup.Last.Used.File";
    @VisibleForTesting
    @NotNull
    public static final String LAST_USED_TYPE_KEY = "Backup.Last.Used.Type";

    /*
     * WARNING - void declaration
     */
    public BackupDialog(@NotNull Project project, @NotNull String initialApplicationId, @NotNull Map<String, Boolean> appIdToBackupEnabledMap2, @NotNull DialogFactory dialogFactory) {
        void $this$fileTextField_u24lambda_u246;
        void $this$backupNotEnabledWarning_u24lambda_u244;
        JEditorPane $this$typeHelpIcon_u24lambda_u242;
        Object $this$typeComboBox_u24lambda_u241;
        Object object;
        void $this$applicationIdComboBox_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)initialApplicationId, (String)"initialApplicationId");
        Intrinsics.checkNotNullParameter(appIdToBackupEnabledMap2, (String)"appIdToBackupEnabledMap");
        Intrinsics.checkNotNullParameter((Object)dialogFactory, (String)"dialogFactory");
        super(project);
        this.project = project;
        this.appIdToBackupEnabledMap = appIdToBackupEnabledMap2;
        this.dialogFactory = dialogFactory;
        this.applicationIds = CollectionsKt.toList((Iterable)this.appIdToBackupEnabledMap.keySet());
        Collection $this$toTypedArray$iv = CollectionsKt.sorted((Iterable)this.applicationIds);
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Collection $i$f$toTypedArray22 = $this$toTypedArray$iv = new ComboBox((ComboBoxModel)new DefaultComboBoxModel<String>(thisCollection$iv.toArray(new String[0])));
        BackupDialog backupDialog = this;
        boolean bl = false;
        $this$applicationIdComboBox_u24lambda_u240.setName("applicationIdComboBox");
        $this$applicationIdComboBox_u24lambda_u240.setMaximumSize(new Dimension(BackupDialog.Companion.getAPPLICATION_ID_FIELD_WIDTH(), $this$applicationIdComboBox_u24lambda_u240.getMaximumSize().height));
        backupDialog.applicationIdComboBox = $this$toTypedArray$iv;
        $this$toTypedArray$iv = (Collection)BackupType.getEntries();
        boolean $i$f$toTypedArray32 = false;
        thisCollection$iv = $this$toTypedArray$iv;
        ComboBox $i$f$toTypedArray32 = object = new ComboBox((ComboBoxModel)new DefaultComboBoxModel<BackupType>(thisCollection$iv.toArray(new BackupType[0])));
        backupDialog = this;
        boolean bl2 = false;
        $this$typeComboBox_u24lambda_u241.setName("typeComboBox");
        $this$typeComboBox_u24lambda_u241.setMaximumSize(new Dimension(BackupDialog.Companion.getTYPE_FIELD_WIDTH(), $this$typeComboBox_u24lambda_u241.getPreferredSize().height));
        backupDialog.typeComboBox = object;
        $this$typeComboBox_u24lambda_u241 = object = new JLabel(AllIcons.General.ContextHelp);
        backupDialog = this;
        boolean $i$a$-apply-BackupDialog$typeHelpIcon$22 = false;
        $this$typeHelpIcon_u24lambda_u242.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BrowserUtil.browse((String)"https://d.android.com//r/studio-ui/backup-restore/help/backup-type");
            }
        });
        backupDialog.typeHelpIcon = object;
        JEditorPane $i$a$-apply-BackupDialog$typeHelpIcon$22 = $this$typeHelpIcon_u24lambda_u242 = SwingHelper.createHtmlViewer((boolean)false, (Font)new JLabel().getFont(), null, null);
        backupDialog = this;
        boolean bl3 = false;
        $this$backupNotEnabledWarning_u24lambda_u244.setName("backupNotEnabledWarning");
        $this$backupNotEnabledWarning_u24lambda_u244.setEditable(false);
        $this$backupNotEnabledWarning_u24lambda_u244.setOpaque(false);
        $this$backupNotEnabledWarning_u24lambda_u244.putClientProperty("JEditorPane.honorDisplayProperties", true);
        $this$backupNotEnabledWarning_u24lambda_u244.addHyperlinkListener(arg_0 -> BackupDialog.backupNotEnabledWarning$lambda$4$lambda$3(this, arg_0));
        JEditorPane jEditorPane = $this$typeHelpIcon_u24lambda_u242;
        Intrinsics.checkNotNullExpressionValue((Object)jEditorPane, (String)"apply(...)");
        backupDialog.backupNotEnabledWarning = jEditorPane;
        object = BackupFileTextField.Companion.createFileSaver(this.project, (Function1<? super Path, Unit>)((Function1)arg_0 -> BackupDialog.fileTextField$lambda$5(this, arg_0)));
        $this$typeHelpIcon_u24lambda_u242 = object;
        backupDialog = this;
        boolean bl4 = false;
        $this$fileTextField_u24lambda_u246.getTextComponent().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this){
            final /* synthetic */ BackupDialog this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BackupDialog.access$updateOkAction(this.this$0);
            }
        });
        $this$fileTextField_u24lambda_u246.setName("fileTextField");
        $this$fileTextField_u24lambda_u246.setMinimumSize(new Dimension(BackupDialog.Companion.getPATH_FIELD_WIDTH(), $this$fileTextField_u24lambda_u246.getMinimumSize().height));
        backupDialog.fileTextField = object;
        this.init();
        this.setTitle("Backup App Data");
        this.applicationIdComboBox.setItem((Object)initialApplicationId);
        this.typeComboBox.setItem((Object)this.getLastUsedType());
        this.typeComboBox.setRenderer(BackupDialog::_init_$lambda$7);
        this.applicationIdComboBox.addItemListener(arg_0 -> BackupDialog._init_$lambda$8(this, arg_0));
        this.typeComboBox.addItemListener(arg_0 -> BackupDialog._init_$lambda$9(this, arg_0));
        this.checkBackupType();
        this.setResizable(false);
    }

    public /* synthetic */ BackupDialog(Project project, String string, Map map2, DialogFactory dialogFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            dialogFactory = new DialogFactoryImpl();
        }
        this(project, string, map2, dialogFactory);
    }

    private final PropertiesComponent getProperties() {
        return PropertiesComponent.getInstance((Project)this.project);
    }

    @NotNull
    public final String getApplicationId() {
        Object object = this.applicationIdComboBox.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        return (String)object;
    }

    @NotNull
    public final Path getBackupPath() {
        Path path = Path.of(this.fileTextField.getText(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path2 = PathExtensionsKt.absoluteInProject((Path)path, (Project)this.project);
        Path path3 = BackupDialogKt.access$withBackupExtension(path2);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"access$withBackupExtension(...)");
        return path3;
    }

    @NotNull
    public final BackupType getType() {
        Object object = this.typeComboBox.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        return (BackupType)object;
    }

    private final void checkBackupType() {
        boolean isBackupEnabled = !Intrinsics.areEqual((Object)this.appIdToBackupEnabledMap.get(this.getApplicationId()), (Object)true);
        this.backupNotEnabledWarning.setVisible(isBackupEnabled);
        this.backupNotEnabledWarning.setText(this.typeComboBox.getItem() == BackupType.DEVICE_TO_DEVICE ? WARNING_DTD : WARNING_CLOUD);
        this.updateOkAction();
        this.pack();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(null);
        GroupLayout layout = new GroupLayout(panel2);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        JLabel applicationIdLabel = new JLabel("Application ID:");
        JLabel typeLabel = new JLabel("Backup type:");
        JLabel fileLabel = new JLabel("Backup file:");
        this.fileTextField.setText(this.getLastUsedFile());
        GroupLayout $this$createCenterPanel_u24lambda_u2410 = layout;
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u2410.setHorizontalGroup($this$createCenterPanel_u24lambda_u2410.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup($this$createCenterPanel_u24lambda_u2410.createSequentialGroup().addComponent(applicationIdLabel).addComponent((Component)this.applicationIdComboBox)).addGroup($this$createCenterPanel_u24lambda_u2410.createSequentialGroup().addComponent(typeLabel).addComponent((Component)this.typeComboBox).addComponent(this.typeHelpIcon).addComponent(this.backupNotEnabledWarning)).addGroup($this$createCenterPanel_u24lambda_u2410.createSequentialGroup().addComponent(fileLabel).addComponent((Component)((Object)this.fileTextField))));
        $this$createCenterPanel_u24lambda_u2410.setVerticalGroup($this$createCenterPanel_u24lambda_u2410.createSequentialGroup().addGroup($this$createCenterPanel_u24lambda_u2410.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(applicationIdLabel).addComponent((Component)this.applicationIdComboBox)).addGroup($this$createCenterPanel_u24lambda_u2410.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup($this$createCenterPanel_u24lambda_u2410.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(typeLabel).addComponent((Component)this.typeComboBox).addComponent(this.typeHelpIcon)).addComponent(this.backupNotEnabledWarning)).addGroup($this$createCenterPanel_u24lambda_u2410.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(fileLabel).addComponent((Component)((Object)this.fileTextField))));
        Component[] componentArray = new Component[]{applicationIdLabel, typeLabel, fileLabel};
        $this$createCenterPanel_u24lambda_u2410.linkSize(0, componentArray);
        panel2.setLayout(layout);
        return panel2;
    }

    @Nullable
    protected String getHelpId() {
        return "help";
    }

    protected void doHelpAction() {
        BrowserUtil.browse((String)"http://d.android.com/studio/preview/features?utm_source=android-studio#test-backup-restore");
    }

    protected void doOKAction() {
        Object[] objectArray;
        int result2;
        this.setLastUsedFile(((Object)PathExtensionsKt.relativeToProject((Path)this.getBackupPath(), (Project)this.project)).toString());
        Object object = this.typeComboBox.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        this.setLastUsedType((BackupType)object);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(this.getBackupPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && !this.fileSetByChooser && (result2 = Messages.showYesNoDialog((String)UIBundle.message((String)"file.chooser.save.dialog.confirmation", (Object[])(objectArray = new Object[]{this.getBackupPath().getFileName()})), (String)UIBundle.message((String)"file.chooser.save.dialog.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) != 0) {
            return;
        }
        Path path = Path.of(this.fileTextField.getText(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path2 = BackupDialogKt.access$withBackupExtension(path);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"access$withBackupExtension(...)");
        this.fileTextField.setText(((Object)path2).toString());
        this.fileTextField.addCurrentTextToHistory();
        super.doOKAction();
    }

    private final String getLastUsedFile() {
        String string = this.getProperties().getValue(LAST_USED_FILE_KEY);
        if (string == null) {
            string = DEFAULT_BACKUP_FILENAME;
        }
        return string;
    }

    private final void setLastUsedFile(String path) {
        this.getProperties().setValue(LAST_USED_FILE_KEY, path);
    }

    private final BackupType getLastUsedType() {
        String name2 = this.getProperties().getValue(LAST_USED_TYPE_KEY);
        return name2 == null ? BackupType.DEVICE_TO_DEVICE : BackupType.valueOf((String)name2);
    }

    private final void setLastUsedType(BackupType type) {
        this.getProperties().setValue(LAST_USED_TYPE_KEY, type.name());
    }

    /*
     * Unable to fully structure code
     */
    private final void updateOkAction() {
        v0 = this.appIdToBackupEnabledMap.get(this.getApplicationId());
        isBackupEnabled = v0 != null ? v0 : false;
        try {
            path = Path.of(this.fileTextField.getText(), new String[0]);
            Intrinsics.checkNotNull((Object)path);
            if (!UtilsKt.isValid(path)) ** GOTO lbl-1000
            v1 = new LinkOption[]{};
            if (!Files.isDirectory(path, Arrays.copyOf(v1, v1.length)) && (this.typeComboBox.getItem() == BackupType.DEVICE_TO_DEVICE || isBackupEnabled)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            this.setOKActionEnabled(v2);
        }
        catch (InvalidPathException <unused var>) {
            this.setOKActionEnabled(false);
        }
    }

    private final void enableBackupInManifest() {
        boolean bl = new ManifestPatcher(this.project).enableBackup(this.getApplicationId());
        if (bl) {
            this.close(1);
            DialogFactory.showDialog$default(this.dialogFactory, this.project, BackupBundle.message("enable.backup.success.title", new Object[0]), BackupBundle.message("enable.backup.success.text", new Object[0]), null, 8, null);
        } else if (!bl) {
            DialogFactory.showDialog$default(this.dialogFactory, this.project, BackupBundle.message("enable.backup.failure.title", new Object[0]), BackupBundle.message("enable.backup.failure.text", new Object[0]), null, 8, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void backupNotEnabledWarning$lambda$4$lambda$3(BackupDialog this$0, HyperlinkEvent it) {
        if (!Intrinsics.areEqual((Object)it.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            return;
        }
        if (Intrinsics.areEqual((Object)it.getDescription(), (Object)"learn-more")) {
            BackupManagerImpl.Companion.openBackupDisabledLearnMoreLink();
        } else if (Intrinsics.areEqual((Object)it.getDescription(), (Object)"enable-backup")) {
            this$0.enableBackupInManifest();
        }
    }

    private static final Unit fileTextField$lambda$5(BackupDialog this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.fileSetByChooser = true;
        return Unit.INSTANCE;
    }

    private static final Component _init_$lambda$7(JList jList, BackupType value2, int n, boolean bl, boolean bl2) {
        return new JLabel(value2.getDisplayName());
    }

    private static final void _init_$lambda$8(BackupDialog this$0, ItemEvent it) {
        this$0.checkBackupType();
    }

    private static final void _init_$lambda$9(BackupDialog this$0, ItemEvent it) {
        this$0.checkBackupType();
    }

    public static final /* synthetic */ void access$updateOkAction(BackupDialog $this) {
        $this.updateOkAction();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\r8\u0000X\u0081T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\r8\u0000X\u0081T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/backup/BackupDialog$Companion;", "", "<init>", "()V", "APPLICATION_ID_FIELD_WIDTH", "", "getAPPLICATION_ID_FIELD_WIDTH", "()I", "TYPE_FIELD_WIDTH", "getTYPE_FIELD_WIDTH", "PATH_FIELD_WIDTH", "getPATH_FIELD_WIDTH", "DEFAULT_BACKUP_FILENAME", "", "WARNING_DTD", "WARNING_CLOUD", "LAST_USED_FILE_KEY", "LAST_USED_TYPE_KEY", "intellij.android.backup"})
    public static final class Companion {
        private Companion() {
        }

        private final int getAPPLICATION_ID_FIELD_WIDTH() {
            return JBUIScale.scale((int)300);
        }

        private final int getTYPE_FIELD_WIDTH() {
            return JBUIScale.scale((int)100);
        }

        private final int getPATH_FIELD_WIDTH() {
            return JBUIScale.scale((int)500);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

