/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Abi;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.android.tools.idea.avdmanager.EmulatorAccelerationCheck;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.ProductDetails;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class AccelAlert
extends JPanel {
    private final JBLabel myWarningMessage;
    private final HyperlinkLabel myErrorInstructionsLink = new HyperlinkLabel();
    private HyperlinkListener myErrorLinkListener;
    private SystemImageDescription myImageDescription;
    private AccelerationErrorCode myAccelerationErrorCode;
    private Logger myLogger;

    public AccelAlert() {
        this.myWarningMessage = new JBLabel(){

            public Dimension getPreferredSize() {
                View view = (View)this.getClientProperty("html");
                Container parent = this.getParent();
                if (view != null && parent != null && parent.getWidth() > 0 && parent.getWidth() != (int)view.getPreferredSpan(0)) {
                    view.setSize(parent.getWidth(), 0.0f);
                    return new Dimension((int)view.getPreferredSpan(0), (int)view.getPreferredSpan(1));
                }
                return super.getPreferredSize();
            }
        };
        this.setLayout((LayoutManager)new GridLayoutManager(2, 1));
        GridConstraints constraints = new GridConstraints();
        constraints.setAnchor(8);
        this.add((Component)this.myWarningMessage, constraints);
        constraints.setRow(1);
        this.add((Component)this.myErrorInstructionsLink, constraints);
        this.myErrorInstructionsLink.setOpaque(false);
        this.myWarningMessage.setForeground((Color)JBColor.RED);
        this.myWarningMessage.setHorizontalAlignment(2);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Recommendation"), BorderFactory.createEmptyBorder(0, 5, 3, 5)));
    }

    public void setSystemImageDescription(SystemImageDescription description2) {
        this.myImageDescription = description2;
        this.refresh(false);
    }

    @VisibleForTesting
    public static String getWarningTextForX86HostsUsingNonX86Image(@NotNull SystemImageDescription description2, ProductDetails.CpuArchitecture arch) {
        boolean isX86Host;
        Abi abi = Abi.getEnum((String)description2.getPrimaryAbiType());
        boolean bl = isX86Host = arch == ProductDetails.CpuArchitecture.X86 || arch == ProductDetails.CpuArchitecture.X86_64;
        if (isX86Host && abi != Abi.X86 && abi != Abi.X86_64) {
            return "Consider using an x86 system image on an x86 host for better emulation performance.";
        }
        return null;
    }

    private void refresh(boolean force) {
        if (this.myImageDescription == null) {
            this.setVisible(false);
            return;
        }
        ListenableFuture<AccelerationErrorCode> accelerationError = this.getAccelerationState(force);
        Futures.addCallback(accelerationError, (FutureCallback)new FutureCallback<AccelerationErrorCode>(){

            public void onSuccess(AccelerationErrorCode result2) {
                String warningText;
                AccelAlert.this.myAccelerationErrorCode = result2;
                boolean hasLink = false;
                StringBuilder warningTextBuilder = new StringBuilder();
                if (result2 != AccelerationErrorCode.ALREADY_INSTALLED) {
                    hasLink = true;
                    warningTextBuilder.append(result2.getProblem());
                    warningTextBuilder.append("<br>");
                    AccelAlert.this.myErrorInstructionsLink.setHyperlinkText(result2.getSolution().getDescription());
                    if (AccelAlert.this.myErrorLinkListener != null) {
                        AccelAlert.this.myErrorInstructionsLink.removeHyperlinkListener(AccelAlert.this.myErrorLinkListener);
                    }
                    final Runnable action2 = AccelerationErrorSolution.getActionForFix(result2, null, () -> AccelAlert.this.refresh(true), null);
                    AccelAlert.this.myErrorLinkListener = new HyperlinkAdapter(){

                        protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                            action2.run();
                        }
                    };
                    AccelAlert.this.myErrorInstructionsLink.addHyperlinkListener(AccelAlert.this.myErrorLinkListener);
                    AccelAlert.this.myErrorInstructionsLink.setToolTipText(result2.getSolution() != AccelerationErrorSolution.SolutionCode.NONE ? result2.getSolutionMessage() : null);
                }
                if (AccelAlert.this.myImageDescription != null) {
                    String nonX86ImageWarning;
                    if (AccelAlert.this.myImageDescription.getVersion().getApiLevel() < 16) {
                        if (warningTextBuilder.length() > 0) {
                            warningTextBuilder.append("<br>");
                        }
                        warningTextBuilder.append("This API Level is Deprecated<br>");
                    }
                    if ((nonX86ImageWarning = AccelAlert.getWarningTextForX86HostsUsingNonX86Image(AccelAlert.this.myImageDescription, CommonMetricsData.getOsArchitecture())) != null) {
                        if (warningTextBuilder.length() > 0) {
                            warningTextBuilder.append("<br>");
                        }
                        warningTextBuilder.append(nonX86ImageWarning).append("<br>");
                    }
                    if (!AccelAlert.this.myImageDescription.hasGoogleApis()) {
                        if (warningTextBuilder.length() > 0) {
                            warningTextBuilder.append("<br>");
                        }
                        warningTextBuilder.append("Consider using a system image with Google APIs to enable testing with Google Play Services.");
                    }
                }
                if (!(warningText = warningTextBuilder.toString()).isEmpty()) {
                    warningTextBuilder.insert(0, "<html>");
                    warningTextBuilder.append("</html>");
                    AccelAlert.this.myWarningMessage.setText(warningTextBuilder.toString().replaceAll("\n", "<br>"));
                    AccelAlert.this.setVisible(true);
                    AccelAlert.this.myErrorInstructionsLink.setVisible(hasLink);
                } else {
                    AccelAlert.this.setVisible(false);
                }
            }

            public void onFailure(Throwable t) {
                if (!(t instanceof CancellationException)) {
                    if (AccelAlert.this.myLogger == null) {
                        AccelAlert.this.myLogger = Logger.getInstance(AccelAlert.class);
                    }
                    AccelAlert.this.myLogger.warn("Check for emulation acceleration failed", t);
                }
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    public ListenableFuture<AccelerationErrorCode> getAccelerationState(boolean forceRefresh) {
        if (this.myAccelerationErrorCode == null || forceRefresh) {
            return AccelAlert.computeAccelerationState();
        }
        return Futures.immediateFuture((Object)((Object)this.myAccelerationErrorCode));
    }

    @NotNull
    private static ListenableFuture<AccelerationErrorCode> computeAccelerationState() {
        return MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE).submit(() -> EmulatorAccelerationCheck.checkAcceleration(AndroidSdks.getInstance().tryToChooseSdkHandler()));
    }
}

