/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avd;

import com.android.sdklib.ISystemImage;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.avd.Services;
import com.android.utils.ComputerArchUtilsKt;
import com.android.utils.CpuArchitecture;
import com.intellij.openapi.util.SystemInfo;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0002H\u0000\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0002H\u0002\u001a\u000e\u0010\u0007\u001a\u0004\u0018\u00010\u0006*\u00020\u0002H\u0002\u001a\u0012\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t*\u00020\u0002H\u0000\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b*\u0004\u0018\u00010\u0002H\u0000\u00a8\u0006\f"}, d2={"getServices", "Lcom/android/tools/idea/avd/Services;", "Lcom/android/sdklib/ISystemImage;", "isSupported", "", "incompatibleArchitectureWarning", "", "atdWarning", "imageWarnings", "", "allAbiTypes", "Lkotlinx/collections/immutable/PersistentList;", "intellij.android.avd"})
@SourceDebugExtension(value={"SMAP\nISystemImages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ISystemImages.kt\ncom/android/tools/idea/avd/ISystemImagesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class ISystemImagesKt {
    @NotNull
    public static final Services getServices(@NotNull ISystemImage $this$getServices) {
        Intrinsics.checkNotNullParameter((Object)$this$getServices, (String)"<this>");
        if ($this$getServices.hasPlayStore()) {
            return Services.GOOGLE_PLAY_STORE;
        }
        if ($this$getServices.hasGoogleApis()) {
            return Services.GOOGLE_APIS;
        }
        return Services.ANDROID_OPEN_SOURCE;
    }

    public static final boolean isSupported(@NotNull ISystemImage $this$isSupported) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupported, (String)"<this>");
        return ISystemImagesKt.imageWarnings($this$isSupported).isEmpty();
    }

    private static final String incompatibleArchitectureWarning(ISystemImage $this$incompatibleArchitectureWarning) {
        return switch (WhenMappings.$EnumSwitchMapping$0[ComputerArchUtilsKt.getOsArchitecture().ordinal()]) {
            case 1 -> {
                Abi var1_1 = Abi.getEnum((String)$this$incompatibleArchitectureWarning.getPrimaryAbiType());
                Object[] var2_3 = new Abi[]{Abi.X86_64, Abi.X86};
                if (CollectionsKt.listOf((Object[])var2_3).contains(var1_1)) {
                    yield null;
                }
                var2_3 = new Abi[]{Abi.ARMEABI, Abi.ARMEABI_V7A, Abi.ARM64_V8A};
                if (CollectionsKt.listOf((Object[])var2_3).contains(var1_1)) {
                    yield "ARM images will run very slowly on x86 hosts.";
                }
                yield "Compatibility with " + $this$incompatibleArchitectureWarning.getPrimaryAbiType() + " images is unknown.";
            }
            case 2, 3 -> {
                Abi var1_2 = Abi.getEnum((String)$this$incompatibleArchitectureWarning.getPrimaryAbiType());
                if (var1_2 == Abi.ARM64_V8A) {
                    yield null;
                }
                Object[] var2_4 = new Abi[]{Abi.ARMEABI, Abi.ARMEABI_V7A};
                if (CollectionsKt.listOf((Object[])var2_4).contains(var1_2)) {
                    if (SystemInfo.isMac) {
                        yield "32-bit ARM images are not supported on Apple Silicon.";
                    }
                    yield "Compatibility with " + $this$incompatibleArchitectureWarning.getPrimaryAbiType() + " images is unknown.";
                }
                var2_4 = new Abi[]{Abi.X86_64, Abi.X86};
                if (CollectionsKt.listOf((Object[])var2_4).contains(var1_2)) {
                    yield $this$incompatibleArchitectureWarning.getPrimaryAbiType() + " images are not supported on ARM hosts.";
                }
                yield "Compatibility with " + $this$incompatibleArchitectureWarning.getPrimaryAbiType() + " images is unknown.";
            }
            default -> "The Android Emulator requires a 64-bit host.";
        };
    }

    private static final String atdWarning(ISystemImage $this$atdWarning) {
        String string;
        String it = string = "Automated Test Device (ATD) images are intended for headless testing only.";
        boolean bl = false;
        return SystemImageTags.isAtd((Collection)$this$atdWarning.getTags()) ? string : null;
    }

    @NotNull
    public static final List<String> imageWarnings(@NotNull ISystemImage $this$imageWarnings) {
        Intrinsics.checkNotNullParameter((Object)$this$imageWarnings, (String)"<this>");
        Object[] objectArray = new String[]{ISystemImagesKt.incompatibleArchitectureWarning($this$imageWarnings), ISystemImagesKt.atdWarning($this$imageWarnings)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @NotNull
    public static final PersistentList<String> allAbiTypes(@Nullable ISystemImage $this$allAbiTypes) {
        PersistentList persistentList;
        ISystemImage iSystemImage = $this$allAbiTypes;
        if (iSystemImage == null) {
            persistentList = ExtensionsKt.persistentListOf();
        } else {
            List list = iSystemImage.getAbiTypes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAbiTypes(...)");
            PersistentList persistentList2 = ExtensionsKt.toPersistentList((Iterable)list);
            List list2 = $this$allAbiTypes.getTranslatedAbiTypes();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTranslatedAbiTypes(...)");
            persistentList = ExtensionsKt.plus((PersistentList)persistentList2, (Iterable)list2);
        }
        return persistentList;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CpuArchitecture.values().length];
            try {
                nArray[CpuArchitecture.X86_64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArchitecture.X86_ON_ARM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArchitecture.ARM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

