/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avd;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.avd.AvdNames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \r2\u00020\u0001:\u0001\rB!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u0004R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/avd/DeviceNameValidator;", "", "currentDisplayNames", "", "", "currentName", "<init>", "(Ljava/util/Set;Ljava/lang/String;)V", "endingNumberRegex", "Lkotlin/text/Regex;", "uniquify", "name", "validate", "Companion", "intellij.android.avd"})
@StabilityInferred(parameters=0)
public final class DeviceNameValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> currentDisplayNames;
    @Nullable
    private final String currentName;
    @NotNull
    private final Regex endingNumberRegex;
    public static final int $stable = 8;

    public DeviceNameValidator(@NotNull Set<String> currentDisplayNames, @Nullable String currentName) {
        Intrinsics.checkNotNullParameter(currentDisplayNames, (String)"currentDisplayNames");
        this.currentDisplayNames = currentDisplayNames;
        this.currentName = currentName;
        this.endingNumberRegex = new Regex("\\((\\d+)\\)$");
    }

    public /* synthetic */ DeviceNameValidator(Set set2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(set2, string);
    }

    @NotNull
    public final String uniquify(@NotNull String name2) {
        Object object;
        int suffix;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        MatchResult matchResult = Regex.find$default((Regex)this.endingNumberRegex, (CharSequence)name2, (int)0, (int)2, null);
        Object object2 = matchResult;
        int n = object2 != null && (object2 = object2.getGroupValues()) != null && (object2 = (String)object2.get(1)) != null ? Integer.parseInt((String)object2) : (suffix = 1);
        if (matchResult == null) {
            object = name2 + " ";
        } else {
            String string = name2.substring(0, matchResult.getRange().getStart());
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        }
        String baseName = object;
        Object candidate = name2;
        while (this.currentDisplayNames.contains(candidate)) {
            candidate = baseName + "(" + ++suffix + ")";
        }
        return candidate;
    }

    @Nullable
    public final String validate(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Intrinsics.areEqual((Object)name2, (Object)this.currentName) ? null : (StringsKt.isBlank((CharSequence)name2) ? "The name cannot be blank." : (!AvdNames.isValid((String)name2) ? "The AVD name can contain only the characters " + AvdNames.humanReadableAllowedCharacters() : (this.currentDisplayNames.contains(((Object)StringsKt.trim((CharSequence)name2)).toString()) ? "An AVD with this name already exists." : null)));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/avd/DeviceNameValidator$Companion;", "", "<init>", "()V", "createForAvdManager", "Lcom/android/tools/idea/avd/DeviceNameValidator;", "avdManager", "Lcom/android/sdklib/internal/avd/AvdManager;", "currentName", "", "intellij.android.avd"})
    @SourceDebugExtension(value={"SMAP\nDeviceNameValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceNameValidator.kt\ncom/android/tools/idea/avd/DeviceNameValidator$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,54:1\n11158#2:55\n11493#2,3:56\n*S KotlinDebug\n*F\n+ 1 DeviceNameValidator.kt\ncom/android/tools/idea/avd/DeviceNameValidator$Companion\n*L\n51#1:55\n51#1:56,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DeviceNameValidator createForAvdManager(@NotNull AvdManager avdManager, @Nullable String currentName) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)avdManager, (String)"avdManager");
            AvdInfo[] avdInfoArray = avdManager.getAllAvds();
            Intrinsics.checkNotNullExpressionValue((Object)avdInfoArray, (String)"getAllAvds(...)");
            Object[] $this$map$iv = avdInfoArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AvdInfo avdInfo2 = (AvdInfo)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getDisplayName());
            }
            String string = currentName;
            Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            return new DeviceNameValidator(set2, string);
        }

        public static /* synthetic */ DeviceNameValidator createForAvdManager$default(Companion companion, AvdManager avdManager, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.createForAvdManager(avdManager, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

