/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.StatefulButtonNotifier;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonPainter;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.FontUIResource;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002'(B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\u0006\u0010#\u001a\u00020!J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u00020\u001c8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/assistant/view/StatefulButton;", "Ljavax/swing/JPanel;", "action", "Lcom/android/tools/idea/assistant/datamodel/ActionData;", "listener", "Ljava/awt/event/ActionListener;", "stateManager", "Lcom/android/tools/idea/assistant/AssistActionStateManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/android/tools/idea/assistant/datamodel/ActionData;Ljava/awt/event/ActionListener;Lcom/android/tools/idea/assistant/AssistActionStateManager;Lcom/intellij/openapi/project/Project;)V", "myButton", "Lcom/android/tools/idea/assistant/view/StatefulButton$ActionButton;", "mySuccessMessage", "", "myStateManager", "actionData", "getActionData", "()Lcom/android/tools/idea/assistant/datamodel/ActionData;", "getProject", "()Lcom/intellij/openapi/project/Project;", "myMessageBusConnections", "", "Lcom/intellij/util/messages/MessageBusConnection;", "myMessage", "Lcom/android/tools/idea/assistant/view/StatefulButtonMessage;", "isLoaded", "", "()Z", "setLoaded", "(Z)V", "addNotify", "", "removeNotify", "updateButtonState", "updateUIForState", "state", "Lcom/android/tools/idea/assistant/AssistActionState;", "ActionButton", "HighlightedDarculaButtonUI", "assistant"})
@SourceDebugExtension(value={"SMAP\nStatefulButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatefulButton.kt\ncom/android/tools/idea/assistant/view/StatefulButton\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,290:1\n1863#2,2:291\n*S KotlinDebug\n*F\n+ 1 StatefulButton.kt\ncom/android/tools/idea/assistant/view/StatefulButton\n*L\n156#1:291,2\n*E\n"})
public final class StatefulButton
extends JPanel {
    @JvmField
    @VisibleForTesting
    @NotNull
    public final ActionButton myButton;
    @Nullable
    private final String mySuccessMessage;
    @Nullable
    private final AssistActionStateManager myStateManager;
    @NotNull
    private final ActionData actionData;
    @NotNull
    private final Project project;
    @NotNull
    private final Collection<MessageBusConnection> myMessageBusConnections;
    @JvmField
    @VisibleForTesting
    @Nullable
    public StatefulButtonMessage myMessage;
    private boolean isLoaded;

    public StatefulButton(@NotNull ActionData action2, @NotNull ActionListener listener2, @Nullable AssistActionStateManager stateManager, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new GridBagLayout());
        this.myMessageBusConnections = new ArrayList();
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.actionData = action2;
        this.myStateManager = stateManager;
        this.project = project;
        this.mySuccessMessage = action2.getSuccessMessage();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 18;
        c.insets = (Insets)JBUI.insets((int)7, (int)0, (int)10, (int)5);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.add((Component)buttonPanel, c);
        this.myButton = new ActionButton(action2, listener2, this);
        buttonPanel.setOpaque(false);
        buttonPanel.add(this.myButton);
        if (this.myStateManager != null) {
            this.myButton.setEnabled(false);
            AsyncProcessIcon loadingIcon = new AsyncProcessIcon("Loading");
            buttonPanel.add((Component)loadingIcon);
            BuildersKt.launch$default((CoroutineScope)CoroutineUtilsKt.getCoroutineScope((Project)project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project, action2, c, loadingIcon, null){
                int label;
                final /* synthetic */ StatefulButton this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ ActionData $action;
                final /* synthetic */ GridBagConstraints $c;
                final /* synthetic */ AsyncProcessIcon $loadingIcon;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$action = $action;
                    this.$c = $c;
                    this.$loadingIcon = $loadingIcon;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.this$0.myStateManager.init(this.$project, this.$action);
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$project, this.$action, this.$c, this.$loadingIcon, null){
                                int label;
                                final /* synthetic */ StatefulButton this$0;
                                final /* synthetic */ Project $project;
                                final /* synthetic */ ActionData $action;
                                final /* synthetic */ GridBagConstraints $c;
                                final /* synthetic */ AsyncProcessIcon $loadingIcon;
                                {
                                    this.this$0 = $receiver;
                                    this.$project = $project;
                                    this.$action = $action;
                                    this.$c = $c;
                                    this.$loadingIcon = $loadingIcon;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.this$0.myButton.setVisible(false);
                                            this.this$0.myMessage = this.this$0.myStateManager.getStateDisplay(this.$project, this.$action, this.this$0.mySuccessMessage);
                                            if (this.this$0.myMessage != null) {
                                                GridBagConstraints gridBagConstraints = this.$c;
                                                int n = gridBagConstraints.gridy;
                                                gridBagConstraints.gridy = n + 1;
                                                this.$c.fill = 2;
                                                this.this$0.add((Component)this.this$0.myMessage, this.$c);
                                                StatefulButtonMessage statefulButtonMessage = this.this$0.myMessage;
                                                Intrinsics.checkNotNull((Object)statefulButtonMessage);
                                                statefulButtonMessage.setVisible(false);
                                            }
                                            this.this$0.updateButtonState();
                                            this.$loadingIcon.setVisible(false);
                                            this.this$0.setLoaded(true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            this.updateButtonState();
            this.isLoaded = true;
        }
    }

    @NotNull
    public final ActionData getActionData() {
        return this.actionData;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @TestOnly
    public final boolean isLoaded() {
        return this.isLoaded;
    }

    public final void setLoaded(boolean bl) {
        this.isLoaded = bl;
    }

    @Override
    public void addNotify() {
        boolean bl = SwingUtilities.isEventDispatchThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.updateButtonState();
        if (this.myStateManager != null) {
            MessageBusConnection connection2 = this.project.getMessageBus().connect();
            this.myMessageBusConnections.add(connection2);
            Topic<StatefulButtonNotifier> topic = StatefulButtonNotifier.BUTTON_STATE_TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"BUTTON_STATE_TOPIC");
            connection2.subscribe(topic, () -> StatefulButton.addNotify$lambda$0(this));
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        boolean bl = SwingUtilities.isEventDispatchThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Iterable $this$forEach$iv = this.myMessageBusConnections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageBusConnection it = (MessageBusConnection)element$iv;
            boolean bl2 = false;
            it.disconnect();
        }
        this.myMessageBusConnections.clear();
        super.removeNotify();
    }

    public final void updateButtonState() {
        UIUtil.invokeLaterIfNeeded(() -> StatefulButton.updateButtonState$lambda$2(this));
    }

    private final void updateUIForState(AssistActionState state2) {
        this.myButton.setVisible(state2.isButtonVisible());
        this.myButton.setEnabled(state2.isButtonEnabled());
        if (this.myMessage != null) {
            StatefulButtonMessage statefulButtonMessage = this.myMessage;
            Intrinsics.checkNotNull((Object)statefulButtonMessage);
            statefulButtonMessage.setVisible(state2.isMessageVisible());
        }
        if (state2.isMessageVisible() && this.myStateManager != null) {
            this.remove(this.myMessage);
            this.myMessage = this.myStateManager.getStateDisplay(this.project, this.actionData, this.mySuccessMessage);
            if (this.myMessage == null) {
                return;
            }
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1.0;
            c.anchor = 18;
            c.fill = 2;
            c.insets = (Insets)JBUI.insets((int)7, (int)0, (int)10, (int)5);
            this.add((Component)this.myMessage, c);
        }
    }

    private static final void addNotify$lambda$0(StatefulButton this$0) {
        this$0.updateButtonState();
    }

    private static final void updateButtonState$lambda$2(StatefulButton this$0) {
        if (this$0.myStateManager == null) {
            this$0.myButton.setEnabled(true);
            return;
        }
        AssistActionState assistActionState = this$0.myStateManager.getState(this$0.project, this$0.actionData);
        Intrinsics.checkNotNullExpressionValue((Object)assistActionState, (String)"getState(...)");
        AssistActionState state2 = assistActionState;
        this$0.revalidate();
        this$0.repaint();
        if (this$0.myMessage != null) {
            this$0.updateUIForState(state2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0018\u001a\u00020\u0010H\u0002R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/assistant/view/StatefulButton$ActionButton;", "Ljavax/swing/JButton;", "action", "Lcom/android/tools/idea/assistant/datamodel/ActionData;", "listener", "Ljava/awt/event/ActionListener;", "wrapper", "Lcom/android/tools/idea/assistant/view/StatefulButton;", "<init>", "(Lcom/android/tools/idea/assistant/datamodel/ActionData;Ljava/awt/event/ActionListener;Lcom/android/tools/idea/assistant/view/StatefulButton;)V", "key", "", "getKey", "()Ljava/lang/String;", "myButtonWrapper", "updateState", "", "actionData", "getActionData", "()Lcom/android/tools/idea/assistant/datamodel/ActionData;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "highlight", "assistant"})
    @SourceDebugExtension(value={"SMAP\nStatefulButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatefulButton.kt\ncom/android/tools/idea/assistant/view/StatefulButton$ActionButton\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,290:1\n1#2:291\n*E\n"})
    public static final class ActionButton
    extends JButton {
        @Nullable
        private final String key;
        @NotNull
        private final StatefulButton myButtonWrapper;

        public ActionButton(@NotNull ActionData action2, @NotNull ActionListener listener2, @NotNull StatefulButton wrapper) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
            super(action2.getLabel());
            this.key = action2.getKey();
            this.myButtonWrapper = wrapper;
            this.addActionListener(listener2);
            this.setOpaque(false);
            if (action2.isHighlighted()) {
                this.highlight();
            }
        }

        @Nullable
        public final String getKey() {
            return this.key;
        }

        public final void updateState() {
            this.myButtonWrapper.updateButtonState();
        }

        @NotNull
        public final ActionData getActionData() {
            return this.myButtonWrapper.getActionData();
        }

        @NotNull
        public final Project getProject() {
            return this.myButtonWrapper.getProject();
        }

        private final void highlight() {
            block2: {
                if (!(this.getUI() instanceof DarculaButtonUI)) break block2;
                this.setUI((ButtonUI)((Object)new HighlightedDarculaButtonUI()));
                this.setBorder((Border)new DarculaButtonPainter(){

                    public Paint getBorderPaint(Component button) {
                        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
                        JBColor jBColor = JBColor.namedColor((String)"Button.default.focusedBorderColor", (Color)((Color)JBColor.namedColor((String)"Button.darcula.defaultFocusedOutlineColor", (int)8892378)));
                        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
                        return (Paint)jBColor;
                    }
                });
                Color foreground = UIManager.getColor("Button.default.foreground");
                if (foreground == null) {
                    foreground = UIManager.getColor("Button.darcula.selectedButtonForeground");
                }
                Color color = foreground;
                if (color != null) {
                    Color it = color;
                    boolean bl = false;
                    this.setForeground(it);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0005H\u0014J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/assistant/view/StatefulButton$HighlightedDarculaButtonUI;", "Lcom/intellij/ide/ui/laf/darcula/ui/DarculaButtonUI;", "<init>", "()V", "getButtonColorStart", "Ljava/awt/Color;", "getButtonColorEnd", "setupDefaultButton", "", "button", "Ljavax/swing/JComponent;", "graphics", "Ljava/awt/Graphics;", "assistant"})
    private static final class HighlightedDarculaButtonUI
    extends DarculaButtonUI {
        @NotNull
        protected Color getButtonColorStart() {
            Color color = this.getDefaultButtonColorStart();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultButtonColorStart(...)");
            return color;
        }

        @NotNull
        protected Color getButtonColorEnd() {
            Color color = this.getDefaultButtonColorEnd();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultButtonColorEnd(...)");
            return color;
        }

        protected void setupDefaultButton(@NotNull JComponent button, @NotNull Graphics graphics) {
            Intrinsics.checkNotNullParameter((Object)button, (String)"button");
            Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
            Font font = button.getFont();
            if (!SystemInfo.isMac && font instanceof FontUIResource) {
                graphics.setFont(((FontUIResource)font).deriveFont(1));
            }
        }
    }
}

