/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.apk.analyzer.dex.DexReferences;
import com.android.tools.apk.analyzer.dex.PackageTreeCreator;
import com.android.tools.apk.analyzer.dex.ProguardMappings;
import com.android.tools.apk.analyzer.dex.tree.DexClassNode;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexFieldNode;
import com.android.tools.apk.analyzer.dex.tree.DexMethodNode;
import com.android.tools.idea.apk.viewer.dex.DexFileViewer;
import com.android.tools.idea.apk.viewer.dex.DexNodeIcons;
import com.android.tools.idea.apk.viewer.dex.ShowReferencesActionKt;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardSeedsMap;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Comparator;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0017H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/apk/viewer/dex/ShowReferencesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "dexFileViewer", "Lcom/android/tools/idea/apk/viewer/dex/DexFileViewer;", "<init>", "(Lcom/intellij/ui/treeStructure/Tree;Lcom/android/tools/idea/apk/viewer/dex/DexFileViewer;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "showReferenceTree", "node", "Lcom/android/tools/apk/analyzer/dex/tree/DexElementNode;", "project", "Lcom/intellij/openapi/project/Project;", "references", "Lcom/android/tools/apk/analyzer/dex/DexReferences;", "onSelectionChanged", "Ljavax/swing/event/TreeSelectionEvent;", "getSelectedNode", "Companion", "ReferenceRenderer", "intellij.android.apkanalyzer"})
public final class ShowReferencesAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Tree tree;
    @NotNull
    private final DexFileViewer dexFileViewer;

    public ShowReferencesAction(@NotNull Tree tree, @NotNull DexFileViewer dexFileViewer) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)dexFileViewer, (String)"dexFileViewer");
        super(ProjectBundle.message((String)"find.usages.action.text", (Object[])new Object[0]), null, AllIcons.Actions.Find);
        this.tree = tree;
        this.dexFileViewer = dexFileViewer;
        this.registerCustomShortcutSet(ActionManager.getInstance().getAction("FindUsages").getShortcutSet(), (JComponent)this.tree);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        presentation2.setEnabled(false);
        if (Companion.canShowReferences(this.getSelectedNode())) {
            presentation2.setEnabled(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DexElementNode dexElementNode = this.getSelectedNode();
        if (dexElementNode == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        DexElementNode node = dexElementNode;
        ListenableFuture<DexReferences> listenableFuture = this.dexFileViewer.getDexReferences();
        if (listenableFuture == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        ListenableFuture<DexReferences> references = listenableFuture;
        Project project = AnAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Project project2 = project;
        Futures.addCallback(references, (FutureCallback)((FutureCallback)new FutureCallback<DexReferences>(this, e, node, project2){
            final /* synthetic */ ShowReferencesAction this$0;
            final /* synthetic */ AnActionEvent $e;
            final /* synthetic */ DexElementNode $node;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$e = $e;
                this.$node = $node;
                this.$project = $project;
            }

            public void onSuccess(DexReferences result2) {
                DexReferences dexReferences = result2;
                Intrinsics.checkNotNull((Object)dexReferences);
                ShowReferencesAction.access$showReferenceTree(this.this$0, this.$e, this.$node, this.$project, dexReferences);
            }

            public void onFailure(Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            }
        }), (Executor)((Executor)EdtExecutorService.getInstance()));
    }

    private final void showReferenceTree(AnActionEvent e, DexElementNode node, Project project, DexReferences references) {
        ProguardMappings proguardMappings;
        ProguardMappings proguardMappings2 = proguardMappings = this.dexFileViewer.getProguardMappings();
        ProguardMap proguardMap = proguardMappings2 != null ? proguardMappings2.map : null;
        ProguardMappings proguardMappings3 = proguardMappings;
        ProguardSeedsMap seedsMap = proguardMappings3 != null ? proguardMappings3.seeds : null;
        boolean deobfuscate = this.dexFileViewer.isDeobfuscateNames();
        ImmutableReference reference = node.getReference();
        if (reference == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Tree tree = new Tree((TreeModel)new DefaultTreeModel((TreeNode)references.getReferenceTreeFor((Reference)reference, true)));
        tree.setShowsRootHandles(true);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(references){
            final /* synthetic */ DexReferences $references;
            {
                this.$references = $references;
            }

            public void treeWillExpand(TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TreePath path = event.getPath();
                if (path.getLastPathComponent() instanceof DexElementNode) {
                    Object object = path.getLastPathComponent();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.apk.analyzer.dex.tree.DexElementNode");
                    DexElementNode lastNode = (DexElementNode)object;
                    if (!DexReferences.isAlreadyLoaded((DexElementNode)lastNode)) {
                        lastNode.removeAllChildren();
                        if (lastNode.getReference() == null) {
                            String string = "Required value was null.";
                            throw new IllegalStateException(string.toString());
                        }
                        this.$references.addReferencesForNode(lastNode, true);
                        Comparator comparator = DexReferences.NODE_COMPARATOR;
                        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"NODE_COMPARATOR");
                        lastNode.sort(comparator);
                    }
                }
            }

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            }
        });
        tree.addTreeSelectionListener(arg_0 -> ShowReferencesAction.showReferenceTree$lambda$0(this, arg_0));
        tree.setCellRenderer((TreeCellRenderer)((Object)new ReferenceRenderer(seedsMap, proguardMap, deobfuscate)));
        JBScrollPane pane = new JBScrollPane((Component)tree);
        pane.setPreferredSize(new Dimension(600, 400));
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)pane, null).setProject(project).setDimensionServiceKey(project, ShowReferencesAction.class.getName(), false).setResizable(true).setMovable(true).setTitle("References to " + node.getName()).setFocusable(true).setRequestFocus(true).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup = jBPopup;
        popup.showInBestPositionFor(e.getDataContext());
    }

    private final void onSelectionChanged(TreeSelectionEvent e) {
        Object object = e.getPath().getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.apk.analyzer.dex.tree.DexElementNode");
        DexElementNode selectedNode = (DexElementNode)object;
        ImmutableReference immutableReference = selectedNode.getReference();
        if (immutableReference == null) {
            return;
        }
        ImmutableReference ref = immutableReference;
        Object object2 = this.tree.getModel().getRoot();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.android.tools.apk.analyzer.dex.tree.DexElementNode");
        DexElementNode root = (DexElementNode)object2;
        DexElementNode dexElementNode = ShowReferencesActionKt.access$findDescendant(root, (Reference)ref);
        if (dexElementNode == null) {
            return;
        }
        DexElementNode descendant = dexElementNode;
        this.tree.setSelectionPath(ShowReferencesActionKt.access$toTreePath(descendant));
    }

    private final DexElementNode getSelectedNode() {
        TreePath treePath = this.tree.getSelectionPath();
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        return object instanceof DexElementNode ? (DexElementNode)object : null;
    }

    private static final void showReferenceTree$lambda$0(ShowReferencesAction this$0, TreeSelectionEvent it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.onSelectionChanged(it);
    }

    public static final /* synthetic */ void access$showReferenceTree(ShowReferencesAction $this, AnActionEvent e, DexElementNode node, Project project, DexReferences references) {
        $this.showReferenceTree(e, node, project, references);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/apk/viewer/dex/ShowReferencesAction$Companion;", "", "<init>", "()V", "canShowReferences", "", "node", "Lcom/android/tools/apk/analyzer/dex/tree/DexElementNode;", "intellij.android.apkanalyzer"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public final boolean canShowReferences(@Nullable DexElementNode node) {
            DexElementNode dexElementNode = node;
            if ((dexElementNode != null ? dexElementNode.getReference() : null) == null) {
                return false;
            }
            return node instanceof DexClassNode || node instanceof DexMethodNode || node instanceof DexFieldNode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ@\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\"\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u001f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/apk/viewer/dex/ShowReferencesAction$ReferenceRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "seedsMap", "Lcom/android/tools/proguard/ProguardSeedsMap;", "proguardMap", "Lcom/android/tools/proguard/ProguardMap;", "deobfuscate", "", "<init>", "(Lcom/android/tools/proguard/ProguardSeedsMap;Lcom/android/tools/proguard/ProguardMap;Z)V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "expanded", "leaf", "row", "", "hasFocus", "renderTypeReference", "ref", "Lcom/android/tools/smali/dexlib2/iface/reference/TypeReference;", "usedProguardMap", "attr", "Lcom/intellij/ui/SimpleTextAttributes;", "renderMethodReference", "Lcom/android/tools/smali/dexlib2/iface/reference/MethodReference;", "renderFieldReference", "Lcom/android/tools/smali/dexlib2/iface/reference/FieldReference;", "intellij.android.apkanalyzer"})
    private static final class ReferenceRenderer
    extends ColoredTreeCellRenderer {
        @Nullable
        private final ProguardSeedsMap seedsMap;
        @Nullable
        private final ProguardMap proguardMap;
        private final boolean deobfuscate;

        public ReferenceRenderer(@Nullable ProguardSeedsMap seedsMap, @Nullable ProguardMap proguardMap, boolean deobfuscate) {
            this.seedsMap = seedsMap;
            this.proguardMap = proguardMap;
            this.deobfuscate = deobfuscate;
        }

        public void customizeCellRenderer(@NotNull JTree tree, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            DexElementNode node = (DexElementNode)value2;
            ImmutableReference ref = node.getReference();
            boolean isSeed = node.isSeed(this.seedsMap, this.proguardMap, false);
            SimpleTextAttributes attr = new SimpleTextAttributes(isSeed ? 1 : 0, null);
            ProguardMap usedProguardMap = this.deobfuscate ? this.proguardMap : null;
            ImmutableReference immutableReference = ref;
            if (immutableReference instanceof TypeReference) {
                this.renderTypeReference((TypeReference)ref, usedProguardMap, attr);
            } else if (immutableReference instanceof MethodReference) {
                this.renderMethodReference((MethodReference)ref, usedProguardMap, attr);
            } else if (immutableReference instanceof FieldReference) {
                this.renderFieldReference((FieldReference)ref, usedProguardMap, attr);
            }
            this.setIcon(DexNodeIcons.forNode(node));
        }

        private final void renderTypeReference(TypeReference ref, ProguardMap usedProguardMap, SimpleTextAttributes attr) {
            this.append(PackageTreeCreator.decodeClassName((String)ref.getType(), (ProguardMap)usedProguardMap), attr);
        }

        private final void renderMethodReference(MethodReference ref, ProguardMap usedProguardMap, SimpleTextAttributes attr) {
            this.append(PackageTreeCreator.decodeClassName((String)ref.getDefiningClass(), (ProguardMap)usedProguardMap), attr);
            this.append(": ", attr);
            this.append(PackageTreeCreator.decodeClassName((String)ref.getReturnType(), (ProguardMap)usedProguardMap), attr);
            this.append(" ", attr);
            this.append(PackageTreeCreator.decodeMethodName((MethodReference)ref, (ProguardMap)usedProguardMap), attr);
            this.append(PackageTreeCreator.decodeMethodParams((MethodReference)ref, (ProguardMap)usedProguardMap), attr);
        }

        private final void renderFieldReference(FieldReference ref, ProguardMap usedProguardMap, SimpleTextAttributes attr) {
            this.append(PackageTreeCreator.decodeClassName((String)ref.getDefiningClass(), (ProguardMap)usedProguardMap), attr);
            this.append(": ", attr);
            this.append(PackageTreeCreator.decodeClassName((String)ref.getType(), (ProguardMap)usedProguardMap), attr);
            this.append(" ", attr);
            this.append(PackageTreeCreator.decodeFieldName((FieldReference)ref, (ProguardMap)usedProguardMap), attr);
        }
    }
}

