/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.dex;

import com.android.tools.apk.analyzer.internal.ProguardMappingFiles;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectProguardMapsDialog {
    private final Project myProject;
    @Nullable
    private final VirtualFile myApkFolder;
    private ProguardMappingFiles myMappingFiles;

    public SelectProguardMapsDialog(@NotNull Project project, @Nullable VirtualFile apkFolder) {
        this.myProject = project;
        this.myApkFolder = apkFolder;
    }

    public boolean showAndGet() throws IOException {
        FileChooserDescriptor desc = new FileChooserDescriptor(true, true, false, false, false, true);
        desc.setDescription("Please select the proguard mapping files (mapping, seeds or usage) or a folder containing these files.");
        desc.withFileFilter(file -> "txt".equals(file.getExtension()) && (file.getName().contains("mapping") || file.getName().contains("seeds") || file.getName().contains("usage")));
        VirtualFile[] files2 = FileChooser.chooseFiles((FileChooserDescriptor)desc, (Project)this.myProject, this.myApkFolder != null ? SelectProguardMapsDialog.getDefaultFolderToSelect(this.myApkFolder) : null);
        if (files2.length == 0) {
            return false;
        }
        Path[] paths = new Path[files2.length];
        for (int i = 0; i < files2.length; ++i) {
            paths[i] = VfsUtilCore.virtualToIoFile((VirtualFile)files2[i]).toPath();
        }
        this.myMappingFiles = ProguardMappingFiles.from((Path[])paths);
        return true;
    }

    @VisibleForTesting
    static VirtualFile getDefaultFolderToSelect(@NotNull VirtualFile apkFolder) {
        VirtualFile mappingFolder;
        String buildTypeName = null;
        VirtualFile folderToSelect = apkFolder;
        if (folderToSelect.getParent() != null) {
            VirtualFile parentFolder = folderToSelect.getParent();
            if ("apk".equals(parentFolder.getName())) {
                buildTypeName = folderToSelect.getName();
                if (parentFolder.getParent() != null) {
                    folderToSelect = parentFolder.getParent();
                }
            } else {
                folderToSelect = parentFolder;
            }
        }
        if ((mappingFolder = folderToSelect.findChild("mapping")) != null) {
            VirtualFile buildTypeFolder;
            folderToSelect = mappingFolder;
            if (folderToSelect.getChildren().length == 1) {
                folderToSelect = folderToSelect.getChildren()[0];
            } else if (buildTypeName != null && (buildTypeFolder = folderToSelect.findChild(buildTypeName)) != null) {
                folderToSelect = buildTypeFolder;
            }
        }
        return folderToSelect;
    }

    @NotNull
    public ProguardMappingFiles getMappingFiles() {
        return this.myMappingFiles;
    }
}

