/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.arsc;

import com.android.tools.idea.apk.viewer.arsc.ResourceTypeTableModel;
import com.google.common.collect.ImmutableList;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceFile;
import com.google.devrel.gmscore.tools.apk.arsc.PackageChunk;
import com.google.devrel.gmscore.tools.apk.arsc.ResourceTableChunk;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeSpecChunk;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.RowFilter;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.swingx.sort.RowFilters;
import org.jetbrains.annotations.NotNull;

public class ResourceTablePanel {
    private JPanel myContainer;
    private ComboBox<PackageChunk> myPackageCombo;
    private Splitter mySplitter;
    private JPanel myHeader;
    private JBList<TypeSpecChunk> myTypesList;
    private JBTable myResourceTypeTable;
    private SimpleColoredComponent myResourceTableHeader;

    public ResourceTablePanel(@NotNull BinaryResourceFile resourceFile) {
        this.setupUI();
        List chunks = resourceFile.getChunks();
        if (chunks.isEmpty()) {
            throw new IllegalArgumentException("no chunks");
        }
        Object e2 = chunks.get(0);
        if (!(e2 instanceof ResourceTableChunk)) {
            throw new IllegalArgumentException("no res table chunk");
        }
        ResourceTableChunk resourceTableChunk = (ResourceTableChunk)e2;
        Collection packages = resourceTableChunk.getPackages();
        StringPoolChunk stringPool = resourceTableChunk.getStringPool();
        this.myPackageCombo.setModel((ComboBoxModel)new CollectionComboBoxModel((List)ImmutableList.copyOf((Collection)packages)));
        this.myPackageCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"<No Resources>", PackageChunk::getPackageName));
        this.myPackageCombo.setMinimumAndPreferredWidth(JBUIScale.scale((int)250));
        this.myPackageCombo.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                PackageChunk packageChunk = (PackageChunk)this.myPackageCombo.getItem();
                this.onPackageSelected(packageChunk, stringPool);
            }
        });
        if (!packages.isEmpty()) {
            PackageChunk packageChunk = (PackageChunk)packages.stream().findFirst().get();
            this.onPackageSelected(packageChunk, stringPool);
        }
        final EditorTextField myFilter = new EditorTextField();
        this.myHeader.add((Component)myFilter);
        myFilter.setPlaceholder((CharSequence)"Enter filter text...");
        myFilter.setPreferredWidth(JBUIScale.scale((int)300));
        myFilter.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                TableRowSorter sorter = (TableRowSorter)ResourceTablePanel.this.myResourceTypeTable.getRowSorter();
                if (sorter != null) {
                    sorter.setRowFilter(new ResourceFilter(myFilter.getText()));
                }
            }
        });
    }

    private void onPackageSelected(PackageChunk packageChunk, StringPoolChunk stringPool) {
        this.myTypesList.setModel((ListModel)new CollectionListModel(packageChunk.getTypeSpecChunks()));
        this.myTypesList.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", TypeSpecChunk::getTypeName));
        this.myTypesList.addListSelectionListener(e -> {
            TypeSpecChunk selectedValue = (TypeSpecChunk)this.myTypesList.getSelectedValue();
            if (selectedValue == null) {
                this.myResourceTypeTable.setModel((TableModel)new DefaultTableModel());
                this.myResourceTableHeader.clear();
                return;
            }
            ResourceTypeTableModel model = new ResourceTypeTableModel(stringPool, packageChunk, selectedValue);
            this.myResourceTypeTable.setModel((TableModel)model);
            TableRowSorter<ResourceTypeTableModel> rowSorter = new TableRowSorter<ResourceTypeTableModel>(model);
            this.myResourceTypeTable.setRowSorter(rowSorter);
            this.myResourceTypeTable.getColumnModel().getColumn(0).setMinWidth(100);
            this.myResourceTypeTable.getColumnModel().getColumn(1).setMinWidth(250);
            int resourceCount = selectedValue.getResourceCount();
            int configCount = packageChunk.getTypeChunks(selectedValue.getId()).size();
            this.myResourceTableHeader.clear();
            this.myResourceTableHeader.append("There " + (resourceCount != 1 ? "are " : "is "));
            this.myResourceTableHeader.append(Integer.toString(resourceCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.myResourceTableHeader.append(" " + selectedValue.getTypeName() + (resourceCount != 1 ? " resources" : " resource") + " across ");
            this.myResourceTableHeader.append(Integer.toString(configCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.myResourceTableHeader.append(" configuration" + (configCount != 1 ? "s" : ""));
        });
    }

    private void createUIComponents() {
        JBLabel label2 = new JBLabel("Resource types");
        this.myTypesList = new JBList();
        JPanel resourceTypesPanel = new JPanel(new BorderLayout());
        resourceTypesPanel.setBorder((Border)JBUI.Borders.empty((int)1, (int)10, (int)0, (int)0));
        resourceTypesPanel.add((Component)label2, "North");
        resourceTypesPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myTypesList), "Center");
        this.myResourceTypeTable = new JBTable();
        this.myResourceTypeTable.setAutoResizeMode(0);
        this.myResourceTypeTable.getEmptyText().setText("No resource type selected.");
        this.myResourceTableHeader = new SimpleColoredComponent();
        JPanel resourceTablePanel = new JPanel(new BorderLayout());
        resourceTablePanel.setBorder(IdeBorderFactory.createBorder((int)2));
        resourceTablePanel.add((Component)this.myResourceTableHeader, "North");
        resourceTablePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myResourceTypeTable), "Center");
        this.mySplitter = new OnePixelSplitter(false, 0.2f);
        this.mySplitter.setFirstComponent((JComponent)resourceTypesPanel);
        this.mySplitter.setSecondComponent((JComponent)resourceTablePanel);
    }

    public JComponent getPanel() {
        return this.myContainer;
    }

    private void setupUI() {
        this.createUIComponents();
        this.myContainer = new JPanel();
        this.myContainer.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myHeader = new JPanel();
        this.myHeader.setLayout(new FlowLayout(0, 10, 0));
        this.myContainer.add((Component)this.myHeader, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Package:");
        this.myHeader.add((Component)jBLabel1);
        this.myPackageCombo = new ComboBox();
        this.myHeader.add((Component)this.myPackageCombo);
        this.myContainer.add((Component)this.mySplitter, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
    }

    public JComponent getRootComponent() {
        return this.myContainer;
    }

    private static class ResourceFilter
    extends RowFilters.GeneralFilter {
        private final String myFilter;

        protected ResourceFilter(String filter2) {
            super(new int[0]);
            this.myFilter = filter2.toLowerCase(Locale.getDefault());
        }

        protected boolean include(RowFilter.Entry<?, ?> value2, int index) {
            return value2.getStringValue(index).toLowerCase(Locale.getDefault()).contains(this.myFilter);
        }
    }
}

