/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class ContentEntryUtil {
    private ContentEntryUtil() {
    }

    @Nullable
    public static ContentEntry findParentContentEntry(@NotNull File path, @NotNull Stream<ContentEntry> contentEntries) {
        Optional<ContentEntry> optional = contentEntries.filter(contentEntry -> ContentEntryUtil.isPathInContentEntry(path, contentEntry)).findFirst();
        return optional.isPresent() ? optional.get() : null;
    }

    @VisibleForTesting
    public static boolean isPathInContentEntry(@NotNull File path, @NotNull ContentEntry contentEntry) {
        return FileUtil.isAncestor((File)ContentEntryUtil.findContentEntryPath(contentEntry), (File)path, (boolean)false);
    }

    @NotNull
    private static File findContentEntryPath(@NotNull ContentEntry contentEntry) {
        VirtualFile rootFile = contentEntry.getFile();
        if (rootFile == null) {
            String s = VfsUtilCore.urlToPath((String)contentEntry.getUrl());
            return new File(s);
        }
        return VfsUtilCore.virtualToIoFile((VirtualFile)rootFile);
    }
}

