/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.license;

import com.android.tools.idea.actions.license.LicenseTextCollector;
import com.android.tools.idea.actions.license.LicensesLocator;
import com.android.tools.idea.sdk.AndroidSdkPathStore;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBDimension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowLicensesUsedAction
extends DumbAwareAction {
    public ShowLicensesUsedAction() {
        super("_Licenses");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = ShowLicensesUsedAction.getEventProject((AnActionEvent)e);
        new Task.Backgroundable(project, "Collecting licenses", true){
            public String myLicenseText;

            public void run(@NotNull ProgressIndicator indicator) {
                Path emulatorPath;
                indicator.setIndeterminate(true);
                Path ideHome = Paths.get(PathManager.getHomePath(), new String[0]);
                LicensesLocator locator = new LicensesLocator(ideHome, SystemInfo.isMac);
                CompletableFuture<String> cf = new LicenseTextCollector(ideHome, locator.getLicenseFiles()).getLicenseText();
                CompletableFuture<String> emuCf = null;
                Path sdkPath = AndroidSdkPathStore.getInstance().getAndroidSdkPath();
                if (sdkPath != null && (emulatorPath = sdkPath.resolve("emulator")) != null) {
                    LicensesLocator emulatorLocator = new LicensesLocator(emulatorPath, false);
                    emuCf = new LicenseTextCollector(emulatorPath, emulatorLocator.getLicenseFiles()).getLicenseText();
                }
                while (!indicator.isCanceled()) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        sb.append(cf.get(100L, TimeUnit.MILLISECONDS));
                        if (emuCf != null) {
                            sb.append(emuCf.get(100L, TimeUnit.MILLISECONDS));
                        }
                        this.myLicenseText = sb.toString();
                        return;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e.getCause());
                    }
                    catch (TimeoutException timeoutException) {
                    }
                }
            }

            public void onSuccess() {
                LicenseDialog licenseDialog = new LicenseDialog(project, this.myLicenseText);
                licenseDialog.init();
                try {
                    licenseDialog.show();
                }
                catch (Exception ex) {
                    Logger.getInstance(ShowLicensesUsedAction.class).error((Throwable)ex);
                }
            }

            public void onThrowable(@NotNull Throwable error) {
                Messages.showErrorDialog((Project)project, (String)("Error collecting licenses: " + error), (String)"Show Licenses");
            }
        }.queue();
    }

    private static class LicenseDialog
    extends DialogWrapper {
        private final String myLicenseText;

        protected LicenseDialog(@Nullable Project project, @NotNull String licenseText) {
            super(project);
            this.myLicenseText = licenseText;
        }

        protected void init() {
            super.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel2 = new JPanel(new BorderLayout());
            JTextArea textArea = new JTextArea();
            textArea.setText(this.myLicenseText);
            textArea.setEditable(false);
            textArea.setCaretPosition(0);
            JBScrollPane pane = new JBScrollPane((Component)textArea);
            pane.setMinimumSize((Dimension)new JBDimension(600, 400));
            pane.setPreferredSize((Dimension)new JBDimension(600, 400));
            panel2.add((Component)pane, "Center");
            return panel2;
        }
    }
}

