/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fonts;

import com.android.ide.common.fonts.FontQueryParserError;
import com.android.ide.common.fonts.MutableFontDetail;
import com.android.ide.common.fonts.ParseResult;
import com.android.ide.common.fonts.QueryResolver;
import com.android.tools.environment.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FontFamilyParser {
    @NotNull
    public static ParseResult parseFontFamily(@NotNull InputStream xmlStream, @NotNull String fileName) {
        try {
            return FontFamilyParser.parseFontReference(xmlStream, fileName);
        }
        catch (FontQueryParserError ex) {
            return new ParseErrorResult(ex.getMessage());
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            String message = "Could not parse font xml file " + fileName;
            Logger.getInstance(FontFamilyParser.class).debug(message, ex);
            return new ParseErrorResult(message);
        }
    }

    private static ParseResult parseFontReference(@NotNull InputStream xmlStream, @NotNull String fileName) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory2 = SAXParserFactory.newInstance();
        factory2.setNamespaceAware(true);
        SAXParser parser = factory2.newSAXParser();
        FontFamilyHandler handler2 = new FontFamilyHandler(fileName);
        parser.parse(xmlStream, (DefaultHandler)handler2);
        return handler2.getResult();
    }

    static int parseInt(@Nullable String intAsString, int defaultValue) {
        if (intAsString == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(intAsString);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    static float parseFloat(@Nullable String floatAsString, float defaultValue) {
        if (floatAsString == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(floatAsString);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    static float parseFontStyle(@Nullable String fontStyle) {
        return fontStyle != null && fontStyle.startsWith("italic") ? 1.0f : 0.0f;
    }

    static class ParseErrorResult
    extends ParseResult {
        private final String myMessage;

        ParseErrorResult(@NotNull String message) {
            this.myMessage = message;
        }

        public String getMessage() {
            return this.myMessage;
        }
    }

    private static class FontFamilyHandler
    extends DefaultHandler {
        private static final String FONT_FAMILY = "font-family";
        private static final String FONT = "font";
        private static final String ATTR_AUTHORITY = "fontProviderAuthority";
        private static final String ATTR_QUERY = "fontProviderQuery";
        private static final String ATTR_FONT = "font";
        private static final String ATTR_FONT_WEIGHT = "fontWeight";
        private static final String ATTR_FONT_WIDTH = "fontWidth";
        private static final String ATTR_FONT_STYLE = "fontStyle";
        private final String myFileName;
        private ParseResult myResult;

        private FontFamilyHandler(@NotNull String fileName) {
            this.myFileName = fileName;
        }

        @NotNull
        private ParseResult getResult() {
            if (this.myResult == null) {
                this.myResult = new ParseErrorResult("The font file is empty");
            }
            return this.myResult;
        }

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String name2, @NotNull Attributes attributes) throws SAXException {
            switch (name2) {
                case "font-family": {
                    this.myResult = this.parseQuery(FontFamilyHandler.getAttributeValue(attributes, ATTR_AUTHORITY), FontFamilyHandler.getAttributeValue(attributes, ATTR_QUERY));
                    break;
                }
                case "font": {
                    String fontName = FontFamilyHandler.getAttributeValue(attributes, "font");
                    int weight = FontFamilyParser.parseInt(FontFamilyHandler.getAttributeValue(attributes, ATTR_FONT_WEIGHT), -1);
                    float width = FontFamilyParser.parseFloat(FontFamilyHandler.getAttributeValue(attributes, ATTR_FONT_WIDTH), 100.0f);
                    String fontStyle = FontFamilyHandler.getAttributeValue(attributes, ATTR_FONT_STYLE);
                    float italics = FontFamilyParser.parseFontStyle(fontStyle);
                    boolean hasExplicitStyle = fontStyle != null;
                    this.myResult = this.addFont(fontName, weight, width, italics, hasExplicitStyle);
                    break;
                }
                default: {
                    Logger.getInstance(FontFamilyParser.class).warn("Unrecognized tag: " + name2 + " in file: " + this.myFileName);
                }
            }
        }

        @Nullable
        private static String getAttributeValue(@NotNull Attributes attributes, @NotNull String attrName) {
            String value2 = attributes.getValue("http://schemas.android.com/apk/res/android", attrName);
            if (value2 != null) {
                return value2;
            }
            return attributes.getValue("http://schemas.android.com/apk/res-auto", attrName);
        }

        @Nullable
        private ParseResult parseQuery(@Nullable String authority, @Nullable String query) {
            if (this.myResult instanceof ParseErrorResult) {
                return this.myResult;
            }
            if (authority == null && query == null) {
                return this.myResult;
            }
            if (this.myResult != null) {
                return new ParseErrorResult("<font-family> must be the root element");
            }
            if (authority == null) {
                return new ParseErrorResult("The <font-family> tag must contain an fontProviderAuthority attribute");
            }
            if (query == null) {
                return new ParseErrorResult("The <font-family> tag must contain a fontProviderQuery attribute");
            }
            return QueryResolver.parseDownloadableFont((String)authority, (String)query);
        }

        private ParseResult addFont(@Nullable String fontName, int weight, float width, float italics, boolean hasExplicitStyle) {
            if (this.myResult instanceof ParseErrorResult) {
                return this.myResult;
            }
            if (this.myResult != null && !(this.myResult instanceof CompoundFontResult)) {
                return new ParseErrorResult("<font> is not allowed in a downloadable font definition");
            }
            if (fontName == null) {
                return new ParseErrorResult("The <font> tag must contain a font attribute");
            }
            CompoundFontResult result2 = (CompoundFontResult)this.myResult;
            if (result2 == null) {
                result2 = new CompoundFontResult();
            }
            result2.addFont(fontName, weight, width, italics, hasExplicitStyle);
            return result2;
        }
    }

    public static class CompoundFontResult
    extends ParseResult {
        private Map<String, MutableFontDetail> myFonts = new LinkedHashMap<String, MutableFontDetail>();

        CompoundFontResult() {
        }

        @NotNull
        public Map<String, MutableFontDetail> getFonts() {
            return this.myFonts;
        }

        private void addFont(@NotNull String fontName, int weight, float width, float italics, boolean hasExplicitStyle) {
            this.myFonts.put(fontName, new MutableFontDetail(fontName, weight, width, italics, hasExplicitStyle));
        }
    }
}

