/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.configurations;

import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.Configuration;
import com.android.tools.configurations.ConversionUtil;
import com.android.tools.configurations.DeviceSize;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\b\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\b\u001a\n\u0010\n\u001a\u00020\u0003*\u00020\b\u00a8\u0006\u000b"}, d2={"calculateDimensions", "Lcom/android/tools/configurations/DeviceSize;", "x", "", "y", "mScreenOrientation", "Lcom/android/resources/ScreenOrientation;", "deviceSizePx", "Lcom/android/tools/configurations/Configuration;", "deviceSizeDp", "dpi", "intellij.android.render-resources"})
public final class ConfigurationUtilKt {
    private static final DeviceSize calculateDimensions(int x, int y, ScreenOrientation mScreenOrientation) {
        boolean shouldSwapDimensions = x > y != (mScreenOrientation == ScreenOrientation.LANDSCAPE);
        return shouldSwapDimensions ? new DeviceSize(y, x) : new DeviceSize(x, y);
    }

    @NotNull
    public static final DeviceSize deviceSizePx(@NotNull Configuration $this$deviceSizePx) {
        Intrinsics.checkNotNullParameter((Object)$this$deviceSizePx, (String)"<this>");
        State state2 = $this$deviceSizePx.getDeviceState();
        if (state2 == null) {
            return new DeviceSize(0, 0);
        }
        State deviceState2 = state2;
        ScreenOrientation orientation = deviceState2.getOrientation();
        int x = deviceState2.getHardware().getScreen().getXDimension();
        int y = deviceState2.getHardware().getScreen().getYDimension();
        return ConfigurationUtilKt.calculateDimensions(x, y, orientation);
    }

    @NotNull
    public static final DeviceSize deviceSizeDp(@NotNull Configuration $this$deviceSizeDp) {
        Intrinsics.checkNotNullParameter((Object)$this$deviceSizeDp, (String)"<this>");
        State state2 = $this$deviceSizeDp.getDeviceState();
        if (state2 == null) {
            return new DeviceSize(0, 0);
        }
        State deviceState2 = state2;
        ScreenOrientation orientation = deviceState2.getOrientation();
        int x = ConversionUtil.INSTANCE.pxToDp(deviceState2.getHardware().getScreen().getXDimension(), ConfigurationUtilKt.dpi($this$deviceSizeDp));
        int y = ConversionUtil.INSTANCE.pxToDp(deviceState2.getHardware().getScreen().getYDimension(), ConfigurationUtilKt.dpi($this$deviceSizeDp));
        return ConfigurationUtilKt.calculateDimensions(x, y, orientation);
    }

    public static final int dpi(@NotNull Configuration $this$dpi) {
        Intrinsics.checkNotNullParameter((Object)$this$dpi, (String)"<this>");
        State state2 = $this$dpi.getDeviceState();
        return state2 != null && (state2 = state2.getHardware()) != null && (state2 = state2.getScreen()) != null && (state2 = state2.getPixelDensity()) != null ? state2.getDpiValue() : 0;
    }
}

