/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.treetable;

import com.android.tools.componenttree.treetable.TreeTableImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.ui.treeStructure.TreeBulkExpansionEvent;
import com.intellij.ui.treeStructure.TreeBulkExpansionListener;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableModelAdapter;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/componenttree/treetable/TreeTableModelAdapterImpl;", "Lcom/intellij/ui/treeStructure/treetable/TreeTableModelAdapter;", "treeTableModel", "Lcom/intellij/ui/treeStructure/treetable/TreeTableModel;", "tree", "Ljavax/swing/JTree;", "table", "Lcom/android/tools/componenttree/treetable/TreeTableImpl;", "<init>", "(Lcom/intellij/ui/treeStructure/treetable/TreeTableModel;Ljavax/swing/JTree;Lcom/android/tools/componenttree/treetable/TreeTableImpl;)V", "modificationCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "lastPathCollapsed", "Ljavax/swing/tree/TreePath;", "delayedFireTableDataChanged", "", "fireTableDataChanged", "fireActualTableDataChangeEvent", "intellij.android.layout-ui"})
public final class TreeTableModelAdapterImpl
extends TreeTableModelAdapter {
    @NotNull
    private final JTree tree;
    @NotNull
    private final TreeTableImpl table;
    @NotNull
    private final AtomicInteger modificationCount;
    @Nullable
    private TreePath lastPathCollapsed;

    public TreeTableModelAdapterImpl(@NotNull TreeTableModel treeTableModel, @NotNull JTree tree, @NotNull TreeTableImpl table2) {
        Intrinsics.checkNotNullParameter((Object)treeTableModel, (String)"treeTableModel");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        super(treeTableModel, tree, (JTable)((Object)table2));
        this.tree = tree;
        this.table = table2;
        this.modificationCount = new AtomicInteger();
        this.tree.addTreeExpansionListener((TreeExpansionListener)new TreeBulkExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                lastPathCollapsed = event.getPath();
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            }

            public void treeBulkExpansionStarted(TreeBulkExpansionEvent event) {
                super.treeBulkExpansionStarted(event);
            }

            public void treeBulkExpansionEnded(TreeBulkExpansionEvent event) {
                super.treeBulkExpansionEnded(event);
            }

            public void treeBulkCollapseStarted(TreeBulkExpansionEvent event) {
                super.treeBulkCollapseStarted(event);
            }

            public void treeBulkCollapseEnded(TreeBulkExpansionEvent event) {
                super.treeBulkCollapseEnded(event);
            }
        });
    }

    protected void delayedFireTableDataChanged() {
        long stamp = this.modificationCount.incrementAndGet();
        ActionsKt.invokeLater$default(null, () -> TreeTableModelAdapterImpl.delayedFireTableDataChanged$lambda$0(stamp, this), (int)1, null);
    }

    public void fireTableDataChanged() {
        this.delayedFireTableDataChanged();
    }

    private final void fireActualTableDataChangeEvent() {
        this.table.getTreeTableSelectionModel().update((Function0<Unit>)((Function0)() -> TreeTableModelAdapterImpl.fireActualTableDataChangeEvent$lambda$1(this)));
        if (this.lastPathCollapsed != null) {
            int row = this.tree.getRowForPath(this.lastPathCollapsed);
            int[] nArray = this.tree.getSelectionRows();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectionRows(...)");
            if (!ArraysKt.contains((int[])nArray, (int)row)) {
                this.table.getSelectionModel().addSelectionInterval(row, row);
            } else {
                this.table.getTreeTableSelectionModel().fireSelectionChanged();
            }
            this.lastPathCollapsed = null;
        }
    }

    private static final Unit delayedFireTableDataChanged$lambda$0(long $stamp, TreeTableModelAdapterImpl this$0) {
        if ($stamp == (long)this$0.modificationCount.get()) {
            this$0.fireActualTableDataChangeEvent();
        }
        return Unit.INSTANCE;
    }

    private static final Unit fireActualTableDataChangeEvent$lambda$1(TreeTableModelAdapterImpl this$0) {
        super.fireTableDataChanged();
        return Unit.INSTANCE;
    }
}

