/*
 * Decompiled with CFR 0.152.
 */
package com.android.declarative.intellij.focus.services;

import com.android.declarative.intellij.focus.DeclarativeFocusFeature;
import com.android.declarative.intellij.focus.services.FocusDeclarativeGradleReader;
import com.android.declarative.intellij.focus.services.FocusGradleSettings;
import com.android.declarative.intellij.focus.ui.ProjectFocusWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/declarative/intellij/focus/services/ProjectFocusToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "isApplicableAsync", "", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "declarative-gradle.focus-plugin"})
@SourceDebugExtension(value={"SMAP\nProjectFocusToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectFocusToolWindowFactory.kt\ncom/android/declarative/intellij/focus/services/ProjectFocusToolWindowFactory\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,58:1\n25#2:59\n31#3,2:60\n31#3,2:62\n*S KotlinDebug\n*F\n+ 1 ProjectFocusToolWindowFactory.kt\ncom/android/declarative/intellij/focus/services/ProjectFocusToolWindowFactory\n*L\n29#1:59\n32#1:60,2\n55#1:62,2\n*E\n"})
public final class ProjectFocusToolWindowFactory
implements ToolWindowFactory {
    @NotNull
    private final Logger logger;

    public ProjectFocusToolWindowFactory() {
        ProjectFocusToolWindowFactory $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ProjectFocusToolWindowFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<FocusDeclarativeGradleReader> serviceClass$iv = FocusDeclarativeGradleReader.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        FocusGradleSettings settingsService = ((FocusDeclarativeGradleReader)object).getProjectFocusSettings();
        ApplicationManager.getApplication().invokeLater(() -> ProjectFocusToolWindowFactory.createToolWindowContent$lambda$0(project, settingsService, toolWindow));
    }

    @Nullable
    public Object isApplicableAsync(@NotNull Project project, @NotNull Continuation<? super Boolean> $completion) {
        if (!DeclarativeFocusFeature.isEnabled()) {
            this.logger.debug("Focus feature is turned off in Registry");
            return Boxing.boxBoolean((boolean)false);
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<FocusDeclarativeGradleReader> serviceClass$iv = FocusDeclarativeGradleReader.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        FocusDeclarativeGradleReader settingsService = (FocusDeclarativeGradleReader)object;
        return Boxing.boxBoolean((settingsService.getProjectFocusSettings() != null ? 1 : 0) != 0);
    }

    @Deprecated(message="Use isApplicableAsync")
    public boolean isApplicable(@NotNull Project project) {
        return super.isApplicable(project);
    }

    public void init(@NotNull ToolWindow toolWindow) {
        super.init(toolWindow);
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    @Nullable
    public Object manage(@NotNull ToolWindow toolWindow, @NotNull ToolWindowManager toolWindowManager, @NotNull Continuation<? super Unit> $completion) {
        return super.manage(toolWindow, toolWindowManager, $completion);
    }

    public boolean shouldBeAvailable(@NotNull Project project) {
        return super.shouldBeAvailable(project);
    }

    @Deprecated(message="Use {@link ToolWindowEP#isDoNotActivateOnStart}")
    public boolean isDoNotActivateOnStart() {
        return super.isDoNotActivateOnStart();
    }

    @ApiStatus.Internal
    @Nullable
    public ToolWindowAnchor getAnchor() {
        return super.getAnchor();
    }

    @ApiStatus.Internal
    @Nullable
    public Icon getIcon() {
        return super.getIcon();
    }

    private static final void createToolWindowContent$lambda$0(Project $project, FocusGradleSettings $settingsService, ToolWindow $toolWindow) {
        ProjectFocusWindow projectWindowPanel = new ProjectFocusWindow($project, $settingsService, $toolWindow);
        projectWindowPanel.focusPanel.fillModulesList($settingsService);
        $toolWindow.getComponent().add(projectWindowPanel);
    }
}

