/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.output;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.output.DownloadRequestItem;
import com.android.build.output.RequestsTableModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00009\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002*\u0001\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00140\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/android/build/output/RequestsTableModel;", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/android/build/output/DownloadRequestItem;", "<init>", "()V", "cellRenderer", "com/android/build/output/RequestsTableModel$cellRenderer$1", "Lcom/android/build/output/RequestsTableModel$cellRenderer$1;", "fileNameColumn", "Lcom/intellij/util/ui/ColumnInfo;", "", "getFileNameColumn", "()Lcom/intellij/util/ui/ColumnInfo;", "timeColumn", "getTimeColumn", "sizeColumn", "getSizeColumn", "speedColumn", "getSpeedColumn", "statusColumn", "Lcom/android/build/output/RequestsTableModel$Status;", "getStatusColumn", "addOrUpdate", "", "requestItems", "", "Status", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nDownloadsInfoUIModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadsInfoUIModel.kt\ncom/android/build/output/RequestsTableModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1567#2:286\n1598#2,4:287\n1863#2,2:291\n*S KotlinDebug\n*F\n+ 1 DownloadsInfoUIModel.kt\ncom/android/build/output/RequestsTableModel\n*L\n273#1:286\n273#1:287,4\n274#1:291,2\n*E\n"})
public final class RequestsTableModel
extends ListTableModel<DownloadRequestItem> {
    @NotNull
    private final cellRenderer.1 cellRenderer = new ColoredTableCellRenderer(){

        protected void customizeCellRenderer(JTable table2, Object value2, boolean selected, boolean hasFocus, int row, int column2) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            if (value2 instanceof String) {
                this.append((String)value2);
            }
        }
    };
    @NotNull
    private final ColumnInfo<DownloadRequestItem, String> fileNameColumn = (ColumnInfo)new ColumnInfo<DownloadRequestItem, String>(this){
        final /* synthetic */ RequestsTableModel this$0;
        {
            this.this$0 = $receiver;
            super("File");
        }

        public String valueOf(DownloadRequestItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getRequestKey().getUrl();
        }

        public TableCellRenderer getRenderer(DownloadRequestItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return (TableCellRenderer)((Object)RequestsTableModel.access$getCellRenderer$p(this.this$0));
        }

        public Comparator<DownloadRequestItem> getComparator() {
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> fileNameColumn.1.getComparator$lambda$1(fileNameColumn.1::getComparator$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
            return comparator;
        }

        private static final String getComparator$lambda$0(DownloadRequestItem it) {
            return it.getRequestKey().getUrl();
        }

        private static final String getComparator$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }
    };
    @NotNull
    private final ColumnInfo<DownloadRequestItem, String> timeColumn = (ColumnInfo)new ColumnInfo<DownloadRequestItem, String>(this){
        final /* synthetic */ RequestsTableModel this$0;
        {
            this.this$0 = $receiver;
            super("Time");
        }

        public String valueOf(DownloadRequestItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            String string = StringUtil.formatDuration((long)item.getDuration());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDuration(...)");
            return string;
        }

        public TableCellRenderer getRenderer(DownloadRequestItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return (TableCellRenderer)((Object)RequestsTableModel.access$getCellRenderer$p(this.this$0));
        }

        public String getPreferredStringValue() {
            return "12 s 123 ms";
        }

        public String getMaxStringValue() {
            return this.getPreferredStringValue();
        }

        public Comparator<DownloadRequestItem> getComparator() {
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> timeColumn.1.getComparator$lambda$1(timeColumn.1::getComparator$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
            return comparator;
        }

        private static final Long getComparator$lambda$0(DownloadRequestItem it) {
            return it.getDuration();
        }

        private static final Long getComparator$lambda$1(Function1 $tmp0, Object p0) {
            return (Long)$tmp0.invoke(p0);
        }
    };
    @NotNull
    private final ColumnInfo<DownloadRequestItem, String> sizeColumn = (ColumnInfo)new ColumnInfo<DownloadRequestItem, String>(this){
        final /* synthetic */ RequestsTableModel this$0;
        {
            this.this$0 = $receiver;
            super("Size");
        }

        public String valueOf(DownloadRequestItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            String string = StringUtil.formatFileSize((long)item.getReceivedBytes());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
            return string;
        }

        public TableCellRenderer getRenderer(DownloadRequestItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return (TableCellRenderer)((Object)RequestsTableModel.access$getCellRenderer$p(this.this$0));
        }

        public String getPreferredStringValue() {
            return "123.45 MB";
        }

        public String getMaxStringValue() {
            return this.getPreferredStringValue();
        }

        public Comparator<DownloadRequestItem> getComparator() {
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> sizeColumn.1.getComparator$lambda$1(sizeColumn.1::getComparator$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
            return comparator;
        }

        private static final Long getComparator$lambda$0(DownloadRequestItem it) {
            return it.getReceivedBytes();
        }

        private static final Long getComparator$lambda$1(Function1 $tmp0, Object p0) {
            return (Long)$tmp0.invoke(p0);
        }
    };
    @NotNull
    private final ColumnInfo<DownloadRequestItem, String> speedColumn = (ColumnInfo)new ColumnInfo<DownloadRequestItem, String>(this){
        final /* synthetic */ RequestsTableModel this$0;
        {
            this.this$0 = $receiver;
            super("Avg Speed");
        }

        public String valueOf(DownloadRequestItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return BuildAttributionUIUtilKt.formatAvgDownloadSpeed(item.getReceivedBytes(), item.getDuration());
        }

        public TableCellRenderer getRenderer(DownloadRequestItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return (TableCellRenderer)((Object)RequestsTableModel.access$getCellRenderer$p(this.this$0));
        }

        public String getPreferredStringValue() {
            return "123.45 MB/s";
        }

        public String getMaxStringValue() {
            return this.getPreferredStringValue();
        }
    };
    @NotNull
    private final ColumnInfo<DownloadRequestItem, Status> statusColumn = (ColumnInfo)new ColumnInfo<DownloadRequestItem, Status>(){
        private final statusColumn.columnCellRenderer.1 columnCellRenderer;
        {
            this.columnCellRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table2, Object value2, boolean selected, boolean hasFocus, int row, int column2) {
                    Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                    if (value2 instanceof Status) {
                        this.setToolTipText(((Status)value2).getTooltip());
                        this.setIcon(((Status)value2).getIcon());
                        this.setTransparentIconBackground(true);
                        this.append(((Status)value2).getText(), SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
                        this.setTextAlign(4);
                    }
                }
            };
        }

        public final statusColumn.columnCellRenderer.1 getColumnCellRenderer() {
            return this.columnCellRenderer;
        }

        public Status valueOf(DownloadRequestItem item) {
            Status status2;
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (!item.getCompleted()) {
                AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
                status2 = new Status("Running", (Icon)animatedIcon, "");
            } else if (item.getFailed()) {
                Icon icon = StudioIcons.Common.WARNING_INLINE;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"WARNING_INLINE");
                String string = item.getFailureMessage();
                if (string == null || (string = StringsKt.replace$default((String)string, (String)"\n", (String)"<br/>", (boolean)false, (int)4, null)) == null) {
                    string = "";
                }
                status2 = new Status("Failed", icon, string);
            } else {
                Icon icon = StudioIcons.Common.SUCCESS_INLINE;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SUCCESS_INLINE");
                status2 = new Status("Finished", icon, "");
            }
            return status2;
        }

        public TableCellRenderer getRenderer(DownloadRequestItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return (TableCellRenderer)((Object)this.columnCellRenderer);
        }

        public String getPreferredStringValue() {
            return "Download Failed";
        }

        public String getMaxStringValue() {
            return this.getPreferredStringValue();
        }

        public Comparator<DownloadRequestItem> getComparator() {
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> statusColumn.1.getComparator$lambda$1(arg_0 -> statusColumn.1.getComparator$lambda$0(this, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
            return comparator;
        }

        private static final String getComparator$lambda$0(statusColumn.1 this$0, DownloadRequestItem it) {
            Intrinsics.checkNotNull((Object)it);
            return this$0.valueOf(it).getText();
        }

        private static final String getComparator$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }
    };

    public RequestsTableModel() {
        super(new ColumnInfo[0]);
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{this.statusColumn, this.fileNameColumn, this.timeColumn, this.sizeColumn, this.speedColumn};
        this.setColumnInfos(columnInfoArray);
        this.setSortable(true);
    }

    @NotNull
    public final ColumnInfo<DownloadRequestItem, String> getFileNameColumn() {
        return this.fileNameColumn;
    }

    @NotNull
    public final ColumnInfo<DownloadRequestItem, String> getTimeColumn() {
        return this.timeColumn;
    }

    @NotNull
    public final ColumnInfo<DownloadRequestItem, String> getSizeColumn() {
        return this.sizeColumn;
    }

    @NotNull
    public final ColumnInfo<DownloadRequestItem, String> getSpeedColumn() {
        return this.speedColumn;
    }

    @NotNull
    public final ColumnInfo<DownloadRequestItem, Status> getStatusColumn() {
        return this.statusColumn;
    }

    /*
     * WARNING - void declaration
     */
    public final void addOrUpdate(@NotNull List<DownloadRequestItem> requestItems) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(requestItems, (String)"requestItems");
        List list = this.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable $this$mapIndexed$iv = list;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void item;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DownloadRequestItem downloadRequestItem = (DownloadRequestItem)item$iv$iv;
            int n2 = n;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(TuplesKt.to((Object)item.getRequestKey(), (Object)((int)index)));
        }
        Map indexes = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Iterable $this$forEach$iv = requestItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadRequestItem requestItem = (DownloadRequestItem)element$iv;
            boolean bl = false;
            Integer itemIndex = (Integer)indexes.get(requestItem.getRequestKey());
            if (itemIndex == null) {
                this.addRow(requestItem);
                continue;
            }
            this.setItem(itemIndex, requestItem);
        }
    }

    public static final /* synthetic */ cellRenderer.1 access$getCellRenderer$p(RequestsTableModel $this) {
        return $this.cellRenderer;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/android/build/output/RequestsTableModel$Status;", "", "text", "", "icon", "Ljavax/swing/Icon;", "tooltip", "<init>", "(Ljava/lang/String;Ljavax/swing/Icon;Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "getIcon", "()Ljavax/swing/Icon;", "getTooltip", "toString", "intellij.android.build-attribution"})
    public static final class Status {
        @NotNull
        private final String text;
        @NotNull
        private final Icon icon;
        @NotNull
        private final String tooltip;

        public Status(@NotNull String text2, @NotNull Icon icon, @NotNull String tooltip) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
            this.text = text2;
            this.icon = icon;
            this.tooltip = tooltip;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        @NotNull
        public final String getTooltip() {
            return this.tooltip;
        }

        @NotNull
        public String toString() {
            return this.text;
        }
    }
}

