/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.view.chart;

import com.android.build.attribution.ui.view.chart.TimeDistributionTreeChart;
import com.android.build.attribution.ui.view.chart.TimeDistributionTreeChartCalculationModel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000S\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0003\u0010\u0013\u001a\u0018\u0000 %2\u00020\u0001:\u0002%&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0011\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u000e*\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\u001eH\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006'"}, d2={"Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart;", "Ljavax/swing/JComponent;", "model", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "<init>", "(Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel;Lcom/intellij/ui/treeStructure/Tree;)V", "getModel", "()Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel;", "getTree", "()Lcom/intellij/ui/treeStructure/Tree;", "treeModelListener", "Ljavax/swing/event/TreeModelListener;", "Lorg/jetbrains/annotations/NotNull;", "treeExpansionListener", "com/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$treeExpansionListener$1", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$treeExpansionListener$1;", "focusListener", "com/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$focusListener$1", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$focusListener$1;", "treeSelectionListener", "Ljavax/swing/event/TreeSelectionListener;", "refreshSelectionArea", "", "mouseListener", "com/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$mouseListener$1", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$mouseListener$1;", "makeFullWidth", "Lcom/intellij/util/ui/JBDimension;", "Ljava/awt/Dimension;", "getPreferredSize", "getMinimumSize", "getMaximumSize", "paintComponent", "g", "Ljava/awt/Graphics;", "Companion", "MyScrollPane", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nTimeDistributionTreeChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeDistributionTreeChart.kt\ncom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,453:1\n1863#2,2:454\n*S KotlinDebug\n*F\n+ 1 TimeDistributionTreeChart.kt\ncom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart\n*L\n131#1:454,2\n*E\n"})
public final class TimeDistributionTreeChart
extends JComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TimeDistributionTreeChartCalculationModel model;
    @NotNull
    private final Tree tree;
    @NotNull
    private final TreeModelListener treeModelListener;
    @NotNull
    private final treeExpansionListener.1 treeExpansionListener;
    @NotNull
    private final focusListener.1 focusListener;
    @NotNull
    private final TreeSelectionListener treeSelectionListener;
    @NotNull
    private final mouseListener.1 mouseListener;

    public TimeDistributionTreeChart(@NotNull TimeDistributionTreeChartCalculationModel model, @NotNull Tree tree) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        this.model = model;
        this.tree = tree;
        TreeModelListener treeModelListener = TreeModelAdapter.create((arg_0, arg_1) -> TimeDistributionTreeChart.treeModelListener$lambda$1((arg_0, arg_1) -> TimeDistributionTreeChart.treeModelListener$lambda$0(this, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)treeModelListener, (String)"create(...)");
        this.treeModelListener = treeModelListener;
        this.treeExpansionListener = new TreeExpansionListener(this){
            final /* synthetic */ TimeDistributionTreeChart this$0;
            {
                this.this$0 = $receiver;
            }

            public void treeExpanded(TreeExpansionEvent event) {
                this.this$0.repaint();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                this.this$0.repaint();
            }
        };
        this.focusListener = new FocusListener(this){
            final /* synthetic */ TimeDistributionTreeChart this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusLost(FocusEvent e) {
                TimeDistributionTreeChart.access$refreshSelectionArea(this.this$0);
            }

            public void focusGained(FocusEvent e) {
                TimeDistributionTreeChart.access$refreshSelectionArea(this.this$0);
            }
        };
        this.treeSelectionListener = arg_0 -> TimeDistributionTreeChart.treeSelectionListener$lambda$2(this, arg_0);
        this.mouseListener = new MouseAdapter(this){
            final /* synthetic */ TimeDistributionTreeChart this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    TimeDistributionTreeChartCalculationModel timeDistributionTreeChartCalculationModel = this.this$0.getModel();
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    TimeDistributionTreeChartCalculationModel.ChartRowItem chartRowItem = timeDistributionTreeChartCalculationModel.itemByCoordinates(point);
                    if (chartRowItem == null) break block0;
                    TimeDistributionTreeChartCalculationModel.ChartRowItem chartRowItem2 = chartRowItem;
                    TimeDistributionTreeChart timeDistributionTreeChart = this.this$0;
                    TimeDistributionTreeChartCalculationModel.ChartRowItem it = chartRowItem2;
                    boolean bl = false;
                    timeDistributionTreeChart.getTree().getSelectionModel().setSelectionPath(it.getTreePath());
                    timeDistributionTreeChart.getTree().requestFocusInWindow();
                }
            }

            public void mouseMoved(MouseEvent e) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TimeDistributionTreeChartCalculationModel.ChartRowItem chartRowItem = this.this$0.getModel().getHoveredItem();
                if (chartRowItem != null) {
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                    bl = chartRowItem.contains(point);
                } else {
                    bl = false;
                }
                if (bl) {
                    return;
                }
                TimeDistributionTreeChartCalculationModel timeDistributionTreeChartCalculationModel = this.this$0.getModel();
                TimeDistributionTreeChartCalculationModel timeDistributionTreeChartCalculationModel2 = this.this$0.getModel();
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                timeDistributionTreeChartCalculationModel.setHoveredItem(timeDistributionTreeChartCalculationModel2.itemByCoordinates(point));
                this.this$0.repaint();
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getModel().setHoveredItem(null);
                this.this$0.repaint();
            }
        };
        this.setBackground(UIUtil.getTreeBackground());
        this.tree.getModel().addTreeModelListener(this.treeModelListener);
        this.tree.addTreeExpansionListener((TreeExpansionListener)this.treeExpansionListener);
        this.tree.addFocusListener((FocusListener)this.focusListener);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
    }

    @NotNull
    public final TimeDistributionTreeChartCalculationModel getModel() {
        return this.model;
    }

    @NotNull
    public final Tree getTree() {
        return this.tree;
    }

    private final void refreshSelectionArea() {
        this.model.refreshSelectionArea(this.tree.getSelectionPath(), this.tree.isFocusOwner());
        this.repaint();
    }

    private final JBDimension makeFullWidth(Dimension $this$makeFullWidth) {
        JBDimension jBDimension = JBDimension.size((Dimension)$this$makeFullWidth).withWidth(203);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"withWidth(...)");
        return jBDimension;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension2 = this.tree.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
        return (Dimension)this.makeFullWidth(dimension2);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension2 = this.tree.getMinimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getMinimumSize(...)");
        return (Dimension)this.makeFullWidth(dimension2);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        Dimension dimension2 = this.tree.getMaximumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getMaximumSize(...)");
        return (Dimension)this.makeFullWidth(dimension2);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        Rectangle rectangle = this.getVisibleRect();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleRect(...)");
        this.model.recalculateCoordinates(rectangle);
        GraphicsUtil.setupAntialiasing((Graphics)g);
        GraphicsUtil.setupAAPainting((Graphics)g);
        this.model.getSelectionArea().draw(g);
        Iterable $this$forEach$iv = this.model.getChartItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TimeDistributionTreeChartCalculationModel.ChartRowItem it = (TimeDistributionTreeChartCalculationModel.ChartRowItem)element$iv;
            boolean bl = false;
            it.draw(g);
        }
        this.model.getMergedItemsBar().draw(g);
    }

    private static final Unit treeModelListener$lambda$0(TimeDistributionTreeChart this$0, TreeModelEvent treeModelEvent, TreeModelAdapter.EventType eventType) {
        this$0.model.refreshModel();
        this$0.repaint();
        return Unit.INSTANCE;
    }

    private static final void treeModelListener$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void treeSelectionListener$lambda$2(TimeDistributionTreeChart this$0, TreeSelectionEvent it) {
        this$0.refreshSelectionArea();
    }

    public static final /* synthetic */ void access$refreshSelectionArea(TimeDistributionTreeChart $this) {
        $this.refreshSelectionArea();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$Companion;", "", "<init>", "()V", "wrap", "Ljavax/swing/JComponent;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "intellij.android.build-attribution"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JComponent wrap(@NotNull Tree tree) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            TreeModel treeModel = tree.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"getModel(...)");
            TimeDistributionTreeChartCalculationModel model = new TimeDistributionTreeChartCalculationModel(treeModel, (Function1<? super TreePath, ? extends Rectangle>)((Function1)arg_0 -> Companion.wrap$lambda$0(tree, arg_0)));
            return (JComponent)((Object)new MyScrollPane(tree, new TimeDistributionTreeChart(model, tree)));
        }

        private static final Rectangle wrap$lambda$0(Tree $tree, TreePath treePath) {
            Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
            return $tree.getPathBounds(treePath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$MyScrollPane;", "Lcom/intellij/ui/components/JBScrollPane;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "chart", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart;", "<init>", "(Lcom/intellij/ui/treeStructure/Tree;Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart;)V", "intellij.android.build-attribution"})
    private static final class MyScrollPane
    extends JBScrollPane {
        @NotNull
        private final Tree tree;

        public MyScrollPane(@NotNull Tree tree, @NotNull TimeDistributionTreeChart chart) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
            super((Component)tree, 20, 30);
            this.tree = tree;
            this.setRowHeaderView(chart);
            this.rowHeader.setScrollMode(0);
            this.setBorder((Border)JBUI.Borders.empty());
            this.setLayout((LayoutManager)new JBScrollPane.Layout(){

                public void layoutContainer(Container parent) {
                    block2: {
                        JComponent jComponent;
                        super.layoutContainer(parent);
                        JViewport jViewport = this.viewport;
                        if (jViewport != null) {
                            jComponent = jViewport;
                            JViewport $this$layoutContainer_u24lambda_u240 = jComponent;
                            boolean bl = false;
                            $this$layoutContainer_u24lambda_u240.setLocation(0, $this$layoutContainer_u24lambda_u240.getY());
                        }
                        JViewport jViewport2 = this.rowHead;
                        if (jViewport2 != null) {
                            jComponent = jViewport2;
                            JViewport $this$layoutContainer_u24lambda_u241 = jComponent;
                            boolean bl = false;
                            $this$layoutContainer_u24lambda_u241.setLocation(this.viewport.getWidth(), $this$layoutContainer_u24lambda_u241.getY());
                        }
                        JScrollBar jScrollBar = this.getHorizontalScrollBar();
                        if (jScrollBar == null) break block2;
                        JComponent $this$layoutContainer_u24lambda_u242 = jComponent = jScrollBar;
                        boolean bl = false;
                        $this$layoutContainer_u24lambda_u242.setLocation(0, $this$layoutContainer_u24lambda_u242.getY());
                    }
                }
            });
        }
    }
}

