/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.BuildAttributionWarningsFilter;
import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.data.DownloadsSummaryUIData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/android/build/attribution/ui/model/BuildOverviewPageModel;", "", "reportUiData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "warningSuppressions", "Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "<init>", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;Lcom/android/build/attribution/BuildAttributionWarningsFilter;)V", "getReportUiData", "()Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "getWarningSuppressions", "()Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "shouldWarnAboutGC", "", "getShouldWarnAboutGC", "()Z", "shouldWarnAboutNoGCSetting", "getShouldWarnAboutNoGCSetting", "downloadsSummaryUiData", "Lcom/android/build/attribution/ui/data/DownloadsSummaryUIData;", "getDownloadsSummaryUiData", "()Lcom/android/build/attribution/ui/data/DownloadsSummaryUIData;", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nBuildOverviewPageModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildOverviewPageModel.kt\ncom/android/build/attribution/ui/model/BuildOverviewPageModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public final class BuildOverviewPageModel {
    @NotNull
    private final BuildAttributionReportUiData reportUiData;
    @NotNull
    private final BuildAttributionWarningsFilter warningSuppressions;

    public BuildOverviewPageModel(@NotNull BuildAttributionReportUiData reportUiData, @NotNull BuildAttributionWarningsFilter warningSuppressions) {
        Intrinsics.checkNotNullParameter((Object)reportUiData, (String)"reportUiData");
        Intrinsics.checkNotNullParameter((Object)warningSuppressions, (String)"warningSuppressions");
        this.reportUiData = reportUiData;
        this.warningSuppressions = warningSuppressions;
    }

    @NotNull
    public final BuildAttributionReportUiData getReportUiData() {
        return this.reportUiData;
    }

    @NotNull
    public final BuildAttributionWarningsFilter getWarningSuppressions() {
        return this.warningSuppressions;
    }

    public final boolean getShouldWarnAboutGC() {
        return this.reportUiData.getBuildSummary().getGarbageCollectionTime().getPercentage() > 10.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getShouldWarnAboutNoGCSetting() {
        if (this.warningSuppressions.getSuppressNoGCSettingWarning()) return false;
        if (!Intrinsics.areEqual((Object)this.reportUiData.getBuildSummary().isGarbageCollectorSettingSet(), (Object)false)) return false;
        Integer n = this.reportUiData.getBuildSummary().getJavaVersionUsed();
        if (n == null) return false;
        int it = ((Number)n).intValue();
        boolean bl = false;
        if (it < 9) return false;
        return true;
    }

    @Nullable
    public final DownloadsSummaryUIData getDownloadsSummaryUiData() {
        DownloadsSummaryUIData downloadsSummaryUIData;
        DownloadsAnalyzer.Result result2 = this.reportUiData.getDownloadsData();
        DownloadsAnalyzer.ActiveResult activeResult = result2 instanceof DownloadsAnalyzer.ActiveResult ? (DownloadsAnalyzer.ActiveResult)result2 : null;
        if (activeResult != null) {
            DownloadsAnalyzer.ActiveResult it = activeResult;
            boolean bl = false;
            downloadsSummaryUIData = new DownloadsSummaryUIData(it);
        } else {
            downloadsSummaryUIData = null;
        }
        return downloadsSummaryUIData;
    }
}

