/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.analyzers.AnalyzerResult;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzersProxy;
import com.android.build.attribution.analyzers.PostBuildProcessAnalyzer;
import com.android.build.attribution.data.AlwaysRunTaskData;
import com.android.build.attribution.data.PluginContainer;
import com.android.build.attribution.data.StudioProvidedInfo;
import com.android.build.attribution.data.TaskContainer;
import com.android.build.attribution.data.TaskData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001!B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014*\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/build/attribution/analyzers/AlwaysRunTasksAnalyzer;", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "Lcom/android/build/attribution/analyzers/AlwaysRunTasksAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzer;", "Lcom/android/build/attribution/analyzers/PostBuildProcessAnalyzer;", "taskContainer", "Lcom/android/build/attribution/data/TaskContainer;", "pluginContainer", "Lcom/android/build/attribution/data/PluginContainer;", "<init>", "(Lcom/android/build/attribution/data/TaskContainer;Lcom/android/build/attribution/data/PluginContainer;)V", "alwaysRunTasksSet", "Ljava/util/HashSet;", "Lcom/android/build/attribution/data/AlwaysRunTaskData;", "Lkotlin/collections/HashSet;", "receiveEvent", "", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "executionReasons", "", "", "Lorg/gradle/tooling/events/task/TaskOperationResult;", "getTask", "Lcom/android/build/attribution/data/TaskData;", "Lorg/gradle/tooling/events/task/TaskFinishEvent;", "cleanupTempState", "runPostBuildAnalysis", "analyzersResult", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "studioProvidedInfo", "Lcom/android/build/attribution/data/StudioProvidedInfo;", "calculateResult", "Result", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nAlwaysRunTasksAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlwaysRunTasksAnalyzer.kt\ncom/android/build/attribution/analyzers/AlwaysRunTasksAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1863#2,2:76\n774#2:78\n865#2,2:79\n*S KotlinDebug\n*F\n+ 1 AlwaysRunTasksAnalyzer.kt\ncom/android/build/attribution/analyzers/AlwaysRunTasksAnalyzer\n*L\n42#1:76,2\n70#1:78\n70#1:79,2\n*E\n"})
public final class AlwaysRunTasksAnalyzer
extends BaseAnalyzer<Result>
implements BuildEventsAnalyzer,
PostBuildProcessAnalyzer {
    @NotNull
    private final TaskContainer taskContainer;
    @NotNull
    private final PluginContainer pluginContainer;
    @NotNull
    private final HashSet<AlwaysRunTaskData> alwaysRunTasksSet;

    public AlwaysRunTasksAnalyzer(@NotNull TaskContainer taskContainer, @NotNull PluginContainer pluginContainer) {
        Intrinsics.checkNotNullParameter((Object)taskContainer, (String)"taskContainer");
        Intrinsics.checkNotNullParameter((Object)pluginContainer, (String)"pluginContainer");
        this.taskContainer = taskContainer;
        this.pluginContainer = pluginContainer;
        this.alwaysRunTasksSet = new HashSet();
    }

    @Override
    public void receiveEvent(@NotNull ProgressEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof TaskFinishEvent && ((TaskFinishEvent)event).getResult() instanceof TaskSuccessResult) {
            TaskOperationResult taskOperationResult = ((TaskFinishEvent)event).getResult();
            Intrinsics.checkNotNullExpressionValue((Object)taskOperationResult, (String)"getResult(...)");
            Iterable $this$forEach$iv = this.executionReasons(taskOperationResult);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String reasonMessage = (String)element$iv;
                boolean bl = false;
                if (AlwaysRunTaskData.Reason.Companion.findMatchingReason(reasonMessage) != null) {
                    AlwaysRunTaskData.Reason it;
                    boolean bl2 = false;
                    this.alwaysRunTasksSet.add(new AlwaysRunTaskData(this.getTask((TaskFinishEvent)event), it));
                }
            }
        }
    }

    private final List<String> executionReasons(TaskOperationResult $this$executionReasons) {
        List list;
        try {
            Object object = $this$executionReasons instanceof TaskSuccessResult ? (TaskSuccessResult)$this$executionReasons : null;
            if (object == null || (object = object.getExecutionReasons()) == null) {
                object = CollectionsKt.emptyList();
            }
            list = object;
        }
        catch (UnsupportedMethodException e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final TaskData getTask(TaskFinishEvent event) {
        return this.taskContainer.getTask(event, this.pluginContainer);
    }

    @Override
    public void cleanupTempState() {
        this.alwaysRunTasksSet.clear();
    }

    @Override
    public void runPostBuildAnalysis(@NotNull BuildEventsAnalyzersProxy analyzersResult, @NotNull StudioProvidedInfo studioProvidedInfo) {
        Intrinsics.checkNotNullParameter((Object)analyzersResult, (String)"analyzersResult");
        Intrinsics.checkNotNullParameter((Object)studioProvidedInfo, (String)"studioProvidedInfo");
        this.ensureResultCalculated();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Result calculateResult() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.alwaysRunTasksSet;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AlwaysRunTaskData it = (AlwaysRunTaskData)element$iv$iv;
            boolean bl = false;
            if (!this.applyIgnoredTasksFilter(it.getTaskData())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return new Result(list);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/build/attribution/analyzers/AlwaysRunTasksAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/AnalyzerResult;", "alwaysRunTasks", "", "Lcom/android/build/attribution/data/AlwaysRunTaskData;", "<init>", "(Ljava/util/List;)V", "getAlwaysRunTasks", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.android.build-attribution"})
    public static final class Result
    implements AnalyzerResult {
        @NotNull
        private final List<AlwaysRunTaskData> alwaysRunTasks;

        public Result(@NotNull List<AlwaysRunTaskData> alwaysRunTasks) {
            Intrinsics.checkNotNullParameter(alwaysRunTasks, (String)"alwaysRunTasks");
            this.alwaysRunTasks = alwaysRunTasks;
        }

        @NotNull
        public final List<AlwaysRunTaskData> getAlwaysRunTasks() {
            return this.alwaysRunTasks;
        }

        @NotNull
        public final List<AlwaysRunTaskData> component1() {
            return this.alwaysRunTasks;
        }

        @NotNull
        public final Result copy(@NotNull List<AlwaysRunTaskData> alwaysRunTasks) {
            Intrinsics.checkNotNullParameter(alwaysRunTasks, (String)"alwaysRunTasks");
            return new Result(alwaysRunTasks);
        }

        public static /* synthetic */ Result copy$default(Result result2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = result2.alwaysRunTasks;
            }
            return result2.copy(list);
        }

        @NotNull
        public String toString() {
            return "Result(alwaysRunTasks=" + this.alwaysRunTasks + ")";
        }

        public int hashCode() {
            return ((Object)this.alwaysRunTasks).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            return Intrinsics.areEqual(this.alwaysRunTasks, result2.alwaysRunTasks);
        }
    }
}

