/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClangPreprocessResult;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdSubstituteMacroOnceAction;", "Lcom/intellij/codeInsight/intention/impl/BaseIntentionAction;", "<init>", "()V", "getFamilyName", "", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "intellij.c.clangdBridge"})
@SourceDebugExtension(value={"SMAP\nClangdSubstituteMacroOnceAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdSubstituteMacroOnceAction.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdSubstituteMacroOnceAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1755#2,2:93\n1755#2,3:95\n1757#2:98\n*S KotlinDebug\n*F\n+ 1 ClangdSubstituteMacroOnceAction.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdSubstituteMacroOnceAction\n*L\n40#1:93,2\n44#1:95,3\n40#1:98\n*E\n"})
public final class ClangdSubstituteMacroOnceAction
extends BaseIntentionAction {
    public ClangdSubstituteMacroOnceAction() {
        this.setText(ClangdBundle.message((String)"intention.clangd.substitute.one.macro", (Object[])new Object[0]));
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Editor editor2 = editor;
        if (editor2 == null || (editor2 = editor2.getVirtualFile()) == null) {
            return false;
        }
        Editor virtualFile = editor2;
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
        if (document == null) {
            return false;
        }
        Document document2 = document;
        ClangLanguageService clangLanguageService = ClangLanguageServiceProvider.getIfStarted((Project)project);
        if (clangLanguageService == null) {
            return false;
        }
        ClangLanguageService service = clangLanguageService;
        TextRange textRange = ClangUtils.findIdentifierRange((CharSequence)document2.getImmutableCharSequence(), (int)editor.getCaretModel().getOffset());
        if (textRange == null) {
            return false;
        }
        TextRange srcIdentRange = textRange;
        Ref.BooleanRef caretAtMacro = new Ref.BooleanRef();
        service.gotoDefinition((VirtualFile)virtualFile, editor.getCaretModel().getOffset(), arg_0 -> ClangdSubstituteMacroOnceAction.isAvailable$lambda$1(caretAtMacro, (VirtualFile)virtualFile, document2, srcIdentRange, arg_0));
        return caretAtMacro.element;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null || editor.getVirtualFile() == null) {
            return;
        }
        ClangLanguageService clangLanguageService = ClangLanguageServiceProvider.getOrStart((Project)project);
        if (clangLanguageService == null) {
            return;
        }
        ClangLanguageService service = clangLanguageService;
        Object[] objectArray = new Object[]{project, editor, Reflection.getOrCreateKotlinClass(ClangdSubstituteMacroOnceAction.class)};
        ReadAction.nonBlocking(() -> ClangdSubstituteMacroOnceAction.invoke$lambda$3(service, editor)).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> ClangdSubstituteMacroOnceAction.invoke$lambda$7(arg_0 -> ClangdSubstituteMacroOnceAction.invoke$lambda$6(project, this, editor, arg_0), arg_0)).coalesceBy(objectArray).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    /*
     * WARNING - void declaration
     */
    private static final void isAvailable$lambda$1(Ref.BooleanRef $caretAtMacro, VirtualFile $virtualFile, Document $document, TextRange $srcIdentRange, ClangResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            boolean bl;
            boolean bl2;
            block13: {
                void $this$any$iv;
                List list = (List)it.waitForResult(100L);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                Iterable iterable = list;
                Ref.BooleanRef booleanRef = $caretAtMacro;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl3;
                        ClangSym sym = (ClangSym)element$iv;
                        boolean bl4 = false;
                        if (!sym.isMacro()) {
                            bl3 = false;
                        } else {
                            int offset;
                            boolean bl5;
                            block12: {
                                Iterable $this$any$iv2;
                                Intrinsics.checkNotNullExpressionValue((Object)LocalFileSystem.getInstance().findCachedFilesForPath(sym.startLoc.getPath()), (String)"findCachedFilesForPath(...)");
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl5 = false;
                                } else {
                                    Iterator iterator = $this$any$iv2.iterator();
                                    while (iterator.hasNext()) {
                                        Object element$iv2;
                                        Object p0 = element$iv2 = iterator.next();
                                        boolean bl6 = false;
                                        if (!$virtualFile.equals(p0)) continue;
                                        bl5 = true;
                                        break block12;
                                    }
                                    bl5 = false;
                                }
                            }
                            bl3 = !bl5 ? true : !$srcIdentRange.contains(offset = sym.startLoc.position.getOffset($document));
                        }
                        if (!bl3) continue;
                        bl2 = true;
                        break block13;
                    }
                    bl2 = false;
                }
            }
            booleanRef.element = bl = bl2;
        }
        catch (TimeoutException timeoutException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static final void invoke$lambda$3$lambda$2(Editor $editor, Ref.ObjectRef $substitution, ClangResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            CLionClangPreprocessResult cLionClangPreprocessResult = (CLionClangPreprocessResult)it.waitForResult();
            if (cLionClangPreprocessResult == null) {
                return;
            }
            CLionClangPreprocessResult preprocessed = cLionClangPreprocessResult;
            if (preprocessed.getRange().isValid()) {
                int startOffset = ClangLanguageServiceUtils.lspPos2Offset((Document)$editor.getDocument(), (Position)preprocessed.getRange().getStart().toPosition());
                int endOffset = ClangLanguageServiceUtils.lspPos2Offset((Document)$editor.getDocument(), (Position)preprocessed.getRange().getEnd().toPosition());
                $substitution.element = new Triple((Object)((Object)StringsKt.trim((CharSequence)preprocessed.getOutput())).toString(), (Object)startOffset, (Object)endOffset);
            }
        }
        catch (ExecutionException ex) {
            CidrLogService.LOG.warn((Throwable)ex);
        }
    }

    private static final Triple invoke$lambda$3(ClangLanguageService $service, Editor $editor) {
        Ref.ObjectRef substitution = new Ref.ObjectRef();
        $service.preprocessSubstitution($editor.getVirtualFile(), $editor.getCaretModel().getOffset(), 1, arg_0 -> ClangdSubstituteMacroOnceAction.invoke$lambda$3$lambda$2($editor, substitution, arg_0));
        return (Triple)substitution.element;
    }

    private static final void invoke$lambda$6$lambda$5$lambda$4(Editor $editor, Triple $it) {
        $editor.getDocument().replaceString(((Number)$it.getSecond()).intValue(), ((Number)$it.getThird()).intValue(), (CharSequence)$it.getFirst());
    }

    private static final Unit invoke$lambda$6(Project $project, ClangdSubstituteMacroOnceAction this$0, Editor $editor, Triple substitution) {
        block0: {
            Triple triple = substitution;
            if (triple == null) break block0;
            Triple it = triple;
            boolean bl = false;
            WriteCommandAction.writeCommandAction((Project)$project).withName(this$0.getText()).run(() -> ClangdSubstituteMacroOnceAction.invoke$lambda$6$lambda$5$lambda$4($editor, it));
        }
        return Unit.INSTANCE;
    }

    private static final void invoke$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

