/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridgeInterface;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorPass;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorSlowPassFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.OurClangTidyInspectionsViaClangdAnnotatorPassFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.AdvancedClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ObfuscatorImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCUnusedIncludeDirectiveInspection;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangDiagnosticIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForCallable;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForStatement;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.OCFileExtensionsSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u0012H\u0016J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0005H\u0016J\u0018\u0010-\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J&\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u001d\u00104\u001a\u0002052\u000b\u00106\u001a\u000703\u00a2\u0006\u0002\b72\u0006\u00108\u001a\u00020\tH\u0016J\b\u00109\u001a\u00020:H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u001e\u0010&\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010(0'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001e\u0010+\u001a\f\u0012\u0006\b\u0001\u0012\u00020(\u0018\u00010'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010*\u00a8\u0006;"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangdBridgeImpl;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangdBridgeInterface;", "<init>", "()V", "isClangdOnlyMode", "", "()Z", "isClangdKindSupported", "kind", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService$Kind;", "registerAnnotatorPassFactories", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "reparsingPassId", "", "clangErrorsPassId", "getFileExtensions", "", "Lcom/jetbrains/cidr/lang/settings/FileExtensionPair;", "project", "Lcom/intellij/openapi/project/Project;", "isSupported", "vf", "Lcom/intellij/openapi/vfs/VirtualFile;", "isClangdShowErrors", "filterDiagnostics", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/annotator/ClangDiagnostic;", "file", "Lcom/intellij/psi/PsiFile;", "trustworthiness", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/Trustworthiness;", "diags", "isSourceFile", "isHeaderFile", "getParameterHints", "setParameterHints", "enabled", "clazyInspection", "Ljava/lang/Class;", "Lcom/jetbrains/cidr/lang/inspections/OCInspectionBase;", "getClazyInspection", "()Ljava/lang/Class;", "unusedIncludesInspection", "getUnusedIncludesInspection", "isInProjectSourcesOrLibraries", "createSuppressActions", "Lcom/intellij/codeInspection/SuppressIntentionAction;", "range", "Lcom/intellij/openapi/util/TextRange;", "warningName", "", "createClangIdeFacade", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIdeFacade;", "descriptor", "Lorg/jetbrains/annotations/NonNls;", "forKind", "createObfuscator", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/Obfuscator;", "intellij.c.clangdBridge"})
@SourceDebugExtension(value={"SMAP\nClangdBridgeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdBridgeImpl.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/ClangdBridgeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n774#2:141\n865#2,2:142\n*S KotlinDebug\n*F\n+ 1 ClangdBridgeImpl.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/ClangdBridgeImpl\n*L\n72#1:141\n72#1:142,2\n*E\n"})
public final class ClangdBridgeImpl
implements ClangdBridgeInterface {
    public boolean isClangdOnlyMode() {
        return false;
    }

    public boolean isClangdKindSupported(@NotNull ClangLanguageService.Kind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return true;
    }

    public void registerAnnotatorPassFactories(@NotNull TextEditorHighlightingPassRegistrar registrar, int reparsingPassId, int clangErrorsPassId) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        new ClangErrorsAnnotatorSlowPassFactory(registrar, clangErrorsPassId);
        new OurClangTidyInspectionsViaClangdAnnotatorPassFactory(registrar, reparsingPassId);
    }

    @NotNull
    public List<FileExtensionPair> getFileExtensions(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getSettings(...)");
        CodeStyleSettings settings = codeStyleSettings;
        return ((OCFileExtensionsSettings)settings.getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED;
    }

    public boolean isSupported(@NotNull VirtualFile vf) {
        Intrinsics.checkNotNullParameter((Object)vf, (String)"vf");
        return LanguageUtils.Companion.getInstance().isSupportedFile(vf);
    }

    public boolean isClangdShowErrors(@NotNull Project project, @Nullable VirtualFile vf) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ClangdSettings settings = ClangdSettings.getInstance((Project)project);
        return settings != null && settings.isClangdShowErrors();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ClangDiagnostic> filterDiagnostics(@NotNull PsiFile file, @NotNull Trustworthiness trustworthiness, @NotNull List<ClangDiagnostic> diags) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)trustworthiness, (String)"trustworthiness");
        Intrinsics.checkNotNullParameter(diags, (String)"diags");
        if (trustworthiness.hasNoCompilationCommand() || trustworthiness.isCompilationCommandGuessed()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = diags;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                ClangDiagnostic diag = (ClangDiagnostic)element$iv$iv;
                boolean bl2 = false;
                if (diag.getSeverity() == HighlightSeverity.ERROR) {
                    ClangErrorsAnnotatorPass.reportSuppressed((PsiFile)file, (ClangDiagnostic)diag);
                    bl = false;
                } else {
                    bl = true;
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return diags;
    }

    public boolean isSourceFile(@NotNull VirtualFile vf) {
        Intrinsics.checkNotNullParameter((Object)vf, (String)"vf");
        return !vf.isDirectory() && OCFileTypeHelpers.sourceExtensions().contains(vf.getExtension());
    }

    public boolean isHeaderFile(@NotNull VirtualFile vf) {
        Intrinsics.checkNotNullParameter((Object)vf, (String)"vf");
        return !vf.isDirectory() && (vf.getExtension() == null || OCFileTypeHelpers.headerExtensions().contains(vf.getExtension()));
    }

    public boolean getParameterHints(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Language configLanguage = LanguageUtils.Companion.getInstance().getConfigLanguage();
        return HintUtilsKt.isParameterHintsEnabledForLanguage((Language)configLanguage) || InlayHintsSettings.Companion.instance().hintsEnabled(configLanguage);
    }

    public void setParameterHints(@NotNull Project project, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Language configLanguage = LanguageUtils.Companion.getInstance().getConfigLanguage();
        HintUtilsKt.setShowParameterHintsForLanguage((boolean)enabled, (Language)configLanguage);
        InlayHintsSettings.Companion.instance().setHintsEnabledForLanguage(configLanguage, enabled);
    }

    @NotNull
    public Class<? extends OCInspectionBase> getClazyInspection() {
        return ClazyInspection.class;
    }

    @Nullable
    public Class<? extends OCInspectionBase> getUnusedIncludesInspection() {
        return OCUnusedIncludeDirectiveInspection.class;
    }

    public boolean isInProjectSourcesOrLibraries(@NotNull Project project, @NotNull VirtualFile vf) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vf, (String)"vf");
        return OCSearchScope.isInProjectSourcesOrLibraries((Project)project, (VirtualFile)vf);
    }

    @NotNull
    public List<SuppressIntentionAction> createSuppressActions(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String warningName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)warningName, (String)"warningName");
        OCSuppressionGroup suppressionGroup = new OCSuppressionGroup("clang", warningName);
        OCFile ocFile = OCLanguageUtils.asOCFile((PsiFile)file);
        if (ocFile == null) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = new OCSuppressClangDiagnosticIntentionAction[]{new OCSuppressClangForFile((PsiFile)ocFile, range, suppressionGroup), new OCSuppressClangForCallable((PsiFile)ocFile, range, suppressionGroup), new OCSuppressClangForStatement((PsiFile)ocFile, range, suppressionGroup)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public ClangIdeFacade createClangIdeFacade(@NotNull String descriptor, @NotNull ClangLanguageService.Kind forKind) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)forKind, (String)"forKind");
        return forKind == ClangLanguageService.Kind.Indexer ? (ClangIdeFacade)new ClangIndexerIdeFacadeImpl(descriptor) : (ClangIdeFacade)new AdvancedClangIdeFacadeImpl(descriptor);
    }

    @NotNull
    public Obfuscator createObfuscator() {
        return new ObfuscatorImpl();
    }
}

