/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.taskbased.home.selections.recordings;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.android.tools.profilers.tasks.TaskSupportUtils;
import com.android.tools.profilers.tasks.taskhandlers.ProfilerTaskHandler;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0015J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010%\u001a\u00020 J\u0006\u0010&\u001a\u00020\nJ\b\u0010'\u001a\u00020\nH\u0002J\b\u0010(\u001a\u00020\nH\u0002J\b\u0010)\u001a\u00020\nH\u0002J$\u0010*\u001a\u00020\n2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u000e\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u0015J\u0016\u0010/\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0017\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u00060"}, d2={"Lcom/android/tools/profilers/taskbased/home/selections/recordings/RecordingListModel;", "Lcom/android/tools/adtui/model/AspectObserver;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "taskHandlers", "", "Lcom/android/tools/profilers/tasks/ProfilerTaskType;", "Lcom/android/tools/profilers/tasks/taskhandlers/ProfilerTaskHandler;", "resetTaskSelection", "Lkotlin/Function0;", "", "setTaskSelection", "Lkotlin/Function1;", "openProfilerTask", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;Ljava/util/Map;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "_recordingList", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/android/tools/profilers/sessions/SessionItem;", "recordingList", "Lkotlinx/coroutines/flow/StateFlow;", "getRecordingList", "()Lkotlinx/coroutines/flow/StateFlow;", "_selectedRecording", "selectedRecording", "getSelectedRecording", "onRecordingSelection", "newRecording", "isSelectedRecordingExportable", "", "exportableArtifact", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "getExportableArtifact", "()Lcom/android/tools/profilers/sessions/SessionArtifact;", "isRecordingSelected", "doDeleteSelectedRecording", "resetRecordingSelection", "updateTaskSelection", "sessionItemsUpdated", "autoOpenRecordingIfNewlyImported", "oldRecordingList", "newRecordingList", "openRecording", "recording", "setRecordingList", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nRecordingListModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordingListModel.kt\ncom/android/tools/profilers/taskbased/home/selections/recordings/RecordingListModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n774#2:122\n865#2,2:123\n808#2,11:125\n774#2:136\n865#2,2:137\n*S KotlinDebug\n*F\n+ 1 RecordingListModel.kt\ncom/android/tools/profilers/taskbased/home/selections/recordings/RecordingListModel\n*L\n79#1:122\n79#1:123,2\n87#1:125,11\n87#1:136\n87#1:137,2\n*E\n"})
public final class RecordingListModel
extends AspectObserver {
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final Map<ProfilerTaskType, ProfilerTaskHandler> taskHandlers;
    @NotNull
    private final Function0<Unit> resetTaskSelection;
    @NotNull
    private final Function1<ProfilerTaskType, Unit> setTaskSelection;
    @NotNull
    private final Function0<Unit> openProfilerTask;
    @NotNull
    private final MutableStateFlow<List<SessionItem>> _recordingList;
    @NotNull
    private final StateFlow<List<SessionItem>> recordingList;
    @NotNull
    private final MutableStateFlow<SessionItem> _selectedRecording;
    @NotNull
    private final StateFlow<SessionItem> selectedRecording;

    public RecordingListModel(@NotNull StudioProfilers profilers, @NotNull Map<ProfilerTaskType, ? extends ProfilerTaskHandler> taskHandlers, @NotNull Function0<Unit> resetTaskSelection, @NotNull Function1<? super ProfilerTaskType, Unit> setTaskSelection, @NotNull Function0<Unit> openProfilerTask) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter(taskHandlers, (String)"taskHandlers");
        Intrinsics.checkNotNullParameter(resetTaskSelection, (String)"resetTaskSelection");
        Intrinsics.checkNotNullParameter(setTaskSelection, (String)"setTaskSelection");
        Intrinsics.checkNotNullParameter(openProfilerTask, (String)"openProfilerTask");
        this.profilers = profilers;
        this.taskHandlers = taskHandlers;
        this.resetTaskSelection = resetTaskSelection;
        this.setTaskSelection = setTaskSelection;
        this.openProfilerTask = openProfilerTask;
        this._recordingList = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.recordingList = FlowKt.asStateFlow(this._recordingList);
        this._selectedRecording = StateFlowKt.MutableStateFlow(null);
        this.selectedRecording = FlowKt.asStateFlow(this._selectedRecording);
        this.profilers.getSessionsManager().addDependency(this).onChange((Enum)SessionAspect.SESSIONS, () -> RecordingListModel._init_$lambda$1(this));
    }

    public /* synthetic */ RecordingListModel(StudioProfilers studioProfilers, Map map, Function0 function0, Function1 function1, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = RecordingListModel::_init_$lambda$0;
        }
        this(studioProfilers, map, (Function0<Unit>)function0, (Function1<? super ProfilerTaskType, Unit>)function1, (Function0<Unit>)function02);
    }

    @NotNull
    public final StudioProfilers getProfilers() {
        return this.profilers;
    }

    @NotNull
    public final StateFlow<List<SessionItem>> getRecordingList() {
        return this.recordingList;
    }

    @NotNull
    public final StateFlow<SessionItem> getSelectedRecording() {
        return this.selectedRecording;
    }

    public final void onRecordingSelection(@Nullable SessionItem newRecording) {
        Object object = newRecording;
        if (object == null || (object = object.getTaskType()) == null) {
            object = ProfilerTaskType.UNSPECIFIED;
        }
        Object recordingTaskType = object;
        this.setTaskSelection.invoke(recordingTaskType);
        this._selectedRecording.setValue((Object)newRecording);
        this.updateTaskSelection();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSelectedRecordingExportable() {
        SessionItem it = (SessionItem)this._selectedRecording.getValue();
        boolean bl = false;
        if (it == null) return false;
        if (!it.containsExactlyOneArtifact()) return false;
        SessionArtifact sessionArtifact = (SessionArtifact)CollectionsKt.firstOrNull(it.getChildArtifacts());
        if (sessionArtifact == null) return false;
        boolean bl2 = sessionArtifact.getCanExport();
        if (!bl2) return false;
        return true;
    }

    @Nullable
    public final SessionArtifact<?> getExportableArtifact() {
        SessionArtifact sessionArtifact;
        if (this.isSelectedRecordingExportable()) {
            Object object = this.selectedRecording.getValue();
            Intrinsics.checkNotNull((Object)object);
            sessionArtifact = (SessionArtifact)CollectionsKt.first(((SessionItem)object).getChildArtifacts());
        } else {
            sessionArtifact = null;
        }
        return sessionArtifact;
    }

    public final boolean isRecordingSelected() {
        return this._selectedRecording.getValue() != null;
    }

    public final void doDeleteSelectedRecording() {
        boolean bl = this.isRecordingSelected();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Object object = this._selectedRecording.getValue();
        Intrinsics.checkNotNull((Object)object);
        ((SessionItem)object).deleteSession();
        this.resetTaskSelection.invoke();
        this.resetRecordingSelection();
    }

    private final void resetRecordingSelection() {
        this._selectedRecording.setValue(null);
    }

    /*
     * Unable to fully structure code
     */
    private final void updateTaskSelection() {
        $this$filter$iv = CollectionsKt.toList((Iterable)this.taskHandlers.entrySet());
        $i$f$filter = false;
        var4_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            $i$a$-filter-RecordingListModel$updateTaskSelection$supportedTasks$1 = false;
            if (this._selectedRecording.getValue() == null) ** GOTO lbl-1000
            v0 = (ProfilerTaskType)it.getKey();
            v1 = (ProfilerTaskHandler)it.getValue();
            v2 = this._selectedRecording.getValue();
            Intrinsics.checkNotNull((Object)v2);
            if (TaskSupportUtils.INSTANCE.isTaskSupportedByRecording(v0, v1, (SessionItem)v2)) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        supportedTasks = (List)destination$iv$iv;
        if (supportedTasks.size() == 1) {
            this.setTaskSelection.invoke(((Map.Entry)CollectionsKt.first((List)supportedTasks)).getKey());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sessionItemsUpdated() {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        List<SessionArtifact> list = this.profilers.getSessionsManager().getSessionArtifacts();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSessionArtifacts(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SessionItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SessionItem it = (SessionItem)element$iv$iv;
            boolean bl = false;
            if (!(!it.isOngoing() && it.getTaskType() != ProfilerTaskType.UNSPECIFIED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sessionItems = (List)destination$iv$iv;
        List newRecordingList = new ArrayList();
        newRecordingList.addAll(sessionItems);
        List oldRecordingList = CollectionsKt.toList((Iterable)((Iterable)this._recordingList.getValue()));
        this._recordingList.setValue((Object)newRecordingList);
        this.autoOpenRecordingIfNewlyImported(oldRecordingList, newRecordingList);
    }

    private final void autoOpenRecordingIfNewlyImported(List<SessionItem> oldRecordingList, List<SessionItem> newRecordingList) {
        Set difference = SetsKt.minus((Set)CollectionsKt.toSet((Iterable)newRecordingList), (Iterable)CollectionsKt.toSet((Iterable)oldRecordingList));
        if (newRecordingList.size() > oldRecordingList.size() && difference.size() == 1 && ((SessionItem)CollectionsKt.first((Iterable)difference)).isImported()) {
            this.openRecording((SessionItem)CollectionsKt.first((Iterable)difference));
        }
    }

    public final void openRecording(@NotNull SessionItem recording) {
        Intrinsics.checkNotNullParameter((Object)recording, (String)"recording");
        this.onRecordingSelection(recording);
        this.openProfilerTask.invoke();
    }

    @VisibleForTesting
    public final void setRecordingList(@NotNull List<SessionItem> recordingList) {
        Intrinsics.checkNotNullParameter(recordingList, (String)"recordingList");
        this._recordingList.setValue(recordingList);
    }

    private static final Unit _init_$lambda$0(ProfilerTaskType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(RecordingListModel this$0) {
        this$0.sessionItemsUpdated();
    }
}

