/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.inspectors.common.api.stacktrace.ThreadId;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.BaseMemoryProfilerStage;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.JniReferenceInstanceObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationCaptureObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationInstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.openapi.diagnostic.Logger;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006*\u000225\u0018\u0000 \u008e\u00012\u00020\u0001:\u0004\u008e\u0001\u008f\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u00107\u001a\u00020\u0005H\u0016J\b\u00108\u001a\u000200H\u0016J\n\u00109\u001a\u0004\u0018\u00010:H\u0016J\u0010\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020=H\u0016J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?H\u0016J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020B0?H\u0016J\n\u0010C\u001a\u0004\u0018\u000100H\u0016J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0010\u0010E\u001a\u00020$2\u0006\u0010F\u001a\u00020GH\u0016J,\u0010H\u001a&\u0012\f\u0012\n K*\u0004\u0018\u00010J0J K*\u0012\u0012\f\u0012\n K*\u0004\u0018\u00010J0J\u0018\u00010I0IH\u0016J\b\u0010L\u001a\u00020\u0007H\u0016J\b\u0010M\u001a\u00020\u0007H\u0016J\b\u0010N\u001a\u00020\u0012H\u0016J\u001c\u0010O\u001a\u00020P2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0016J\u0018\u0010S\u001a\n K*\u0004\u0018\u00010\u001c0\u001c2\u0006\u0010T\u001a\u00020\u0007H\u0016J\b\u0010U\u001a\u00020PH\u0016J\b\u0010V\u001a\u00020PH\u0016J\b\u0010W\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020X2\u0006\u0010Z\u001a\u00020\u0007H\u0002J\u0018\u0010[\u001a\u00020X2\u0006\u0010+\u001a\u00020,2\u0006\u0010\\\u001a\u00020RH\u0002J\f\u0010]\u001a\u00020\u0015*\u00020^H\u0002J\u000e\u0010_\u001a\u0004\u0018\u00010`*\u00020aH\u0002J\u001e\u0010b\u001a\u00020X2\u0006\u0010c\u001a\u00020\u00072\f\u0010d\u001a\b\u0012\u0004\u0012\u00020J0#H\u0002J\u001e\u0010e\u001a\u00020X2\u0006\u0010c\u001a\u00020\u00072\f\u0010d\u001a\b\u0012\u0004\u0012\u00020J0#H\u0002J\\\u0010f\u001a\u00020X\"\u0004\b\u0000\u0010g2\u0006\u0010c\u001a\u00020\u00072\f\u0010d\u001a\b\u0012\u0004\u0012\u00020J0#2\u0010\u0010h\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002Hg0i2$\u0010j\u001a \u0012\u0004\u0012\u0002Hg\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020m\u0012\u0004\u0012\u00020J0l\u0012\u0004\u0012\u00020X0kH\u0002J<\u0010n\u001a\u00020X2\u0006\u0010o\u001a\u00020\u00072\u0006\u0010Z\u001a\u00020\u00072\f\u0010p\u001a\b\u0012\u0004\u0012\u00020J0#2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020J0#2\u0006\u0010r\u001a\u00020PH\u0002J<\u0010s\u001a\u00020X2\u0006\u0010o\u001a\u00020\u00072\u0006\u0010Z\u001a\u00020\u00072\f\u0010p\u001a\b\u0012\u0004\u0012\u00020J0#2\f\u0010q\u001a\b\u0012\u0004\u0012\u00020J0#2\u0006\u0010r\u001a\u00020PH\u0002JD\u0010t\u001a\u00020X\"\u0004\b\u0000\u0010g2\u0006\u0010o\u001a\u00020\u00072\u0006\u0010Z\u001a\u00020\u00072\u0010\u0010h\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002Hg0i2\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u0002Hg\u0012\u0004\u0012\u00020X0uH\u0002J\u0014\u0010v\u001a\u00020X*\u00020`2\u0006\u0010w\u001a\u00020aH\u0002J\u0010\u0010x\u001a\u00020\u001e2\u0006\u0010y\u001a\u00020GH\u0002J\u0010\u0010z\u001a\u00020{2\b\u0010|\u001a\u0004\u0018\u00010}J\u0012\u0010~\u001a\u0004\u0018\u00010!2\u0006\u0010\u007f\u001a\u00020\u0007H\u0002J)\u0010\u0080\u0001\u001a\u0012\u0012\u000e\u0012\f K*\u0005\u0018\u00010\u0081\u00010\u0081\u00010?2\u0006\u0010o\u001a\u00020\u00072\u0006\u0010Z\u001a\u00020\u0007H\u0002JG\u0010\u0082\u0001\u001a\t\u0012\u0005\u0012\u0003H\u0083\u00010?\"\u0005\b\u0000\u0010\u0083\u00012\u0006\u0010o\u001a\u00020\u00072\u0006\u0010Z\u001a\u00020\u00072\u0007\u0010w\u001a\u00030\u0084\u00012\u0015\u0010\u0085\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u0086\u0001\u0012\u0005\u0012\u0003H\u0083\u00010uH\u0002J3\u0010\u0087\u0001\u001a\t\u0012\u0005\u0012\u0003H\u0083\u00010?\"\u0005\b\u0000\u0010\u0083\u0001*\u00030\u0088\u00012\u0015\u0010\u0085\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u0086\u0001\u0012\u0005\u0012\u0003H\u0083\u00010uH\u0002J-\u0010\u0089\u0001\u001a\f K*\u0005\u0018\u00010\u008a\u00010\u008a\u00012\b\u0010\u008b\u0001\u001a\u00030\u0084\u00012\u0006\u0010o\u001a\u00020\u00072\u0006\u0010Z\u001a\u00020\u0007H\u0002J1\u0010\u008c\u0001\u001a\u00020X\"\u0005\b\u0000\u0010\u0083\u0001*\t\u0012\u0005\u0012\u0003H\u0083\u00010?2\u0014\u0010\u008d\u0001\u001a\u000f\u0012\u0005\u0012\u0003H\u0083\u0001\u0012\u0004\u0012\u00020\u00070uH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u0004\u0018\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0002\b\u0003\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00103R\u0010\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00106\u00a8\u0006\u0090\u0001"}, d2={"Lcom/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject;", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "client", "Lcom/android/tools/profilers/ProfilerClient;", "session", "Lcom/android/tools/profiler/proto/Common$Session;", "captureStartTime", "", "loadService", "Ljava/util/concurrent/ExecutorService;", "stage", "Lcom/android/tools/profilers/memory/BaseMemoryProfilerStage;", "<init>", "(Lcom/android/tools/profilers/ProfilerClient;Lcom/android/tools/profiler/proto/Common$Session;JLjava/util/concurrent/ExecutorService;Lcom/android/tools/profilers/memory/BaseMemoryProfilerStage;)V", "executorService", "getExecutorService$annotations", "()V", "classDb", "Lcom/android/tools/profilers/memory/adapters/ClassDb;", "instanceMap", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/android/tools/profilers/memory/adapters/LiveAllocationInstanceObject;", "callstackMap", "Lcom/android/tools/profiler/proto/Memory$AllocationStack;", "nativeFrameMap", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lcom/android/tools/profiler/proto/Memory$NativeCallStack$NativeFrame;", "methodIdMap", "Lcom/android/tools/profiler/proto/Memory$AllocationStack$StackFrame;", "threadIdMap", "Lcom/android/tools/inspectors/common/api/stacktrace/ThreadId;", "jniMemoryRegionMap", "Ljava/util/TreeMap;", "Lcom/android/tools/profiler/proto/Memory$MemoryMap$MemoryRegion;", "heapSets", "", "Lcom/android/tools/profilers/memory/adapters/classifiers/HeapSet;", "aspectObserver", "Lcom/android/tools/adtui/model/AspectObserver;", "contextEndTimeNs", "previousQueryStartTimeNs", "previousQueryEndTimeNs", "lastSeenTimestampNs", "queryRange", "Lcom/android/tools/adtui/model/Range;", "currentTask", "Ljava/util/concurrent/Future;", "infoMessage", "", "allocationEventAdapter", "com/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject$allocationEventAdapter$1", "Lcom/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject$allocationEventAdapter$1;", "jniReferenceEventAdapter", "com/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject$jniReferenceEventAdapter$1", "Lcom/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject$jniReferenceEventAdapter$1;", "getSession", "getName", "getExportableExtension", "", "saveToFile", "outputStream", "Ljava/io/OutputStream;", "getClassifierAttributes", "", "Lcom/android/tools/profilers/memory/adapters/CaptureObject$ClassifierAttribute;", "getInstanceAttributes", "Lcom/android/tools/profilers/memory/adapters/CaptureObject$InstanceAttribute;", "getInfoMessage", "getHeapSets", "getHeapSet", "heapId", "", "getInstances", "Ljava/util/stream/Stream;", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "kotlin.jvm.PlatformType", "getStartTimeNs", "getEndTimeNs", "getClassDatabase", "load", "", "queryJoiner", "Ljava/util/concurrent/Executor;", "getStackFrame", "methodId", "isDoneLoading", "isError", "unload", "", "updateAllocationContexts", "endTimeNs", "loadTimeRange", "joiner", "getOrCreateInstanceObject", "Lcom/android/tools/profiler/proto/Memory$AllocationEvent$Allocation;", "getOrCreateJniRefObject", "Lcom/android/tools/profilers/memory/adapters/JniReferenceInstanceObject;", "Lcom/android/tools/profiler/proto/Memory$JNIGlobalReferenceEvent;", "queryJavaInstanceSnapshot", "snapshotTimeNs", "snapshotList", "queryJniReferencesSnapshot", "querySnapshot", "E", "eventAdapter", "Lcom/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject$EventAdapter;", "handleEvent", "Lkotlin/Function2;", "", "", "queryJavaInstanceDelta", "startTimeNs", "allocationList", "deallocationList", "resetInstance", "queryJniReferencesDelta", "queryDelta", "Lkotlin/Function1;", "setAllocEvent", "event", "lookupThreadId", "threadId", "resolveNativeBacktrace", "Lcom/android/tools/profiler/proto/Memory$NativeCallStack;", "backtrace", "Lcom/android/tools/profiler/proto/Memory$NativeBacktrace;", "getRegionByAddress", "address", "getAllocationContexts", "Lcom/android/tools/profiler/proto/Memory$BatchAllocationContexts;", "getEvents", "T", "Lcom/android/tools/profiler/proto/Common$Event$Kind;", "extract", "Lcom/android/tools/profiler/proto/Common$Event;", "getResultList", "Lcom/android/tools/profiler/proto/Transport$GetEventGroupsResponse;", "buildEventGroupRequest", "Lcom/android/tools/profiler/proto/Transport$GetEventGroupsRequest;", "kind", "updateSeenTimestamp", "timestamp", "Companion", "EventAdapter", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nLiveAllocationCaptureObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveAllocationCaptureObject.kt\ncom/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,549:1\n1863#2,2:550\n1863#2,2:552\n1863#2,2:554\n1863#2,2:556\n1863#2,2:558\n1557#2:561\n1628#2,3:562\n1863#2,2:567\n1863#2,2:569\n1863#2,2:571\n1863#2,2:573\n1863#2,2:575\n1863#2,2:577\n1863#2,2:579\n1#3:560\n13402#4,2:565\n*S KotlinDebug\n*F\n+ 1 LiveAllocationCaptureObject.kt\ncom/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject\n*L\n165#1:550,2\n166#1:552,2\n167#1:554,2\n168#1:556,2\n175#1:558,2\n513#1:561\n513#1:562,3\n281#1:567,2\n283#1:569,2\n284#1:571,2\n285#1:573,2\n286#1:575,2\n287#1:577,2\n288#1:579,2\n218#1:565,2\n*E\n"})
public final class LiveAllocationCaptureObject
implements CaptureObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfilerClient client;
    @NotNull
    private final Common.Session session;
    private final long captureStartTime;
    @NotNull
    private final BaseMemoryProfilerStage stage;
    @JvmField
    @Nullable
    public final ExecutorService executorService;
    @NotNull
    private final ClassDb classDb;
    @NotNull
    private final Int2ObjectOpenHashMap<LiveAllocationInstanceObject> instanceMap;
    @NotNull
    private final Int2ObjectOpenHashMap<Memory.AllocationStack> callstackMap;
    @NotNull
    private final Long2ObjectOpenHashMap<Memory.NativeCallStack.NativeFrame> nativeFrameMap;
    @NotNull
    private final Long2ObjectOpenHashMap<Memory.AllocationStack.StackFrame> methodIdMap;
    @NotNull
    private final Int2ObjectOpenHashMap<ThreadId> threadIdMap;
    @NotNull
    private final TreeMap<Long, Memory.MemoryMap.MemoryRegion> jniMemoryRegionMap;
    @NotNull
    private final List<HeapSet> heapSets;
    @NotNull
    private final AspectObserver aspectObserver;
    private long contextEndTimeNs;
    private long previousQueryStartTimeNs;
    private long previousQueryEndTimeNs;
    private long lastSeenTimestampNs;
    @Nullable
    private Range queryRange;
    @Nullable
    private Future<?> currentTask;
    @Nullable
    private String infoMessage;
    @NotNull
    private final allocationEventAdapter.1 allocationEventAdapter;
    @NotNull
    private final jniReferenceEventAdapter.1 jniReferenceEventAdapter;
    private static final long QUERY_BUFFER_NS = TimeUnit.SECONDS.toNanos(5L);
    @NotNull
    public static final String SAMPLING_INFO_MESSAGE = "Selected region does not have full tracking. Data may be inaccurate.";

    /*
     * WARNING - void declaration
     */
    public LiveAllocationCaptureObject(@NotNull ProfilerClient client, @NotNull Common.Session session, long captureStartTime, @Nullable ExecutorService loadService, @NotNull BaseMemoryProfilerStage stage) {
        void it;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        this.client = client;
        this.session = session;
        this.captureStartTime = captureStartTime;
        this.stage = stage;
        ExecutorService executorService = loadService;
        if (executorService == null) {
            executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("profiler-live-allocation").build());
        }
        this.executorService = executorService;
        this.classDb = new ClassDb();
        this.instanceMap = new Int2ObjectOpenHashMap();
        this.callstackMap = new Int2ObjectOpenHashMap();
        this.nativeFrameMap = new Long2ObjectOpenHashMap();
        this.methodIdMap = new Long2ObjectOpenHashMap();
        this.threadIdMap = new Int2ObjectOpenHashMap();
        this.jniMemoryRegionMap = new TreeMap();
        Object object = new HeapSet[]{new HeapSet(this, "default", 0), new HeapSet(this, "image", 1), new HeapSet(this, "zygote", 2), new HeapSet(this, "app", 3)};
        Object object2 = object = CollectionsKt.mutableListOf((Object[])object);
        LiveAllocationCaptureObject liveAllocationCaptureObject = this;
        boolean bl = false;
        it.add(new HeapSet(this, "JNI", 4));
        liveAllocationCaptureObject.heapSets = object;
        this.aspectObserver = new AspectObserver();
        this.contextEndTimeNs = Long.MIN_VALUE;
        this.previousQueryStartTimeNs = Long.MIN_VALUE;
        this.previousQueryEndTimeNs = Long.MIN_VALUE;
        this.lastSeenTimestampNs = Long.MIN_VALUE;
        this.allocationEventAdapter = new EventAdapter<Memory.BatchAllocationEvents, Memory.AllocationEvent>(this){
            final /* synthetic */ LiveAllocationCaptureObject this$0;
            {
                this.this$0 = $receiver;
            }

            public long getTimestamp(Memory.AllocationEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return event.getTimestamp();
            }

            public List<Memory.AllocationEvent> getEventList(Memory.BatchAllocationEvents batch) {
                Intrinsics.checkNotNullParameter((Object)batch, (String)"batch");
                return batch.getEventsList();
            }

            public List<Memory.BatchAllocationEvents> getBatchEvents(long startTimeNs, long endTimeNs) {
                List list = LiveAllocationCaptureObject.access$getEvents(this.this$0, startTimeNs, endTimeNs, Common.Event.Kind.MEMORY_ALLOC_EVENTS, allocationEventAdapter.1::getBatchEvents$lambda$0);
                LiveAllocationCaptureObject liveAllocationCaptureObject = this.this$0;
                List $this$getBatchEvents_u24lambda_u241 = list;
                boolean bl = false;
                LiveAllocationCaptureObject.access$updateSeenTimestamp(liveAllocationCaptureObject, $this$getBatchEvents_u24lambda_u241, allocationEventAdapter.getBatchEvents.2.1.INSTANCE);
                return list;
            }

            public void forEachEventStream(long startTimeNs, long endTimeNs, Function1<? super Stream<Memory.AllocationEvent>, Unit> handle) {
                EventAdapter.super.forEachEventStream(startTimeNs, endTimeNs, handle);
            }

            private static final Memory.BatchAllocationEvents getBatchEvents$lambda$0(Common.Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getMemoryAllocEvents().getEvents();
            }
        };
        this.jniReferenceEventAdapter = new EventAdapter<Memory.BatchJNIGlobalRefEvent, Memory.JNIGlobalReferenceEvent>(this){
            final /* synthetic */ LiveAllocationCaptureObject this$0;
            {
                this.this$0 = $receiver;
            }

            public long getTimestamp(Memory.JNIGlobalReferenceEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return event.getTimestamp();
            }

            public List<Memory.JNIGlobalReferenceEvent> getEventList(Memory.BatchJNIGlobalRefEvent batch) {
                Intrinsics.checkNotNullParameter((Object)batch, (String)"batch");
                return batch.getEventsList();
            }

            public List<Memory.BatchJNIGlobalRefEvent> getBatchEvents(long startTimeNs, long endTimeNs) {
                List list = LiveAllocationCaptureObject.access$getEvents(this.this$0, startTimeNs, endTimeNs, Common.Event.Kind.MEMORY_JNI_REF_EVENTS, jniReferenceEventAdapter.1::getBatchEvents$lambda$0);
                LiveAllocationCaptureObject liveAllocationCaptureObject = this.this$0;
                List $this$getBatchEvents_u24lambda_u241 = list;
                boolean bl = false;
                LiveAllocationCaptureObject.access$updateSeenTimestamp(liveAllocationCaptureObject, $this$getBatchEvents_u24lambda_u241, jniReferenceEventAdapter.getBatchEvents.2.1.INSTANCE);
                return list;
            }

            public void forEachEventStream(long startTimeNs, long endTimeNs, Function1<? super Stream<Memory.JNIGlobalReferenceEvent>, Unit> handle) {
                EventAdapter.super.forEachEventStream(startTimeNs, endTimeNs, handle);
            }

            private static final Memory.BatchJNIGlobalRefEvent getBatchEvents$lambda$0(Common.Event it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getMemoryJniRefEvents().getEvents();
            }
        };
    }

    @VisibleForTesting
    public static /* synthetic */ void getExecutorService$annotations() {
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public String getName() {
        return "Live Allocation";
    }

    @Nullable
    public Void getExportableExtension() {
        return null;
    }

    @NotNull
    public Void saveToFile(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        CaptureObject.ClassifierAttribute[] classifierAttributeArray = new CaptureObject.ClassifierAttribute[]{CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.DEALLOCATIONS, CaptureObject.ClassifierAttribute.TOTAL_COUNT, CaptureObject.ClassifierAttribute.SHALLOW_SIZE, CaptureObject.ClassifierAttribute.SHALLOW_DIFFERENCE};
        return CollectionsKt.listOf((Object[])classifierAttributeArray);
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        CaptureObject.InstanceAttribute[] instanceAttributeArray = new CaptureObject.InstanceAttribute[]{CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.ALLOCATION_TIME, CaptureObject.InstanceAttribute.DEALLOCATION_TIME, CaptureObject.InstanceAttribute.SHALLOW_SIZE};
        return CollectionsKt.listOf((Object[])instanceAttributeArray);
    }

    @Override
    @Nullable
    public String getInfoMessage() {
        return this.infoMessage;
    }

    @NotNull
    public List<HeapSet> getHeapSets() {
        return this.heapSets.get(0).getInstancesCount() > 0 ? this.heapSets : this.heapSets.subList(1, this.heapSets.size());
    }

    @Override
    @NotNull
    public HeapSet getHeapSet(int heapId) {
        return this.heapSets.get(heapId);
    }

    @Override
    public Stream<InstanceObject> getInstances() {
        return this.heapSets.stream().flatMap(arg_0 -> LiveAllocationCaptureObject.getInstances$lambda$2(LiveAllocationCaptureObject::getInstances$lambda$1, arg_0));
    }

    @Override
    public long getStartTimeNs() {
        return this.captureStartTime;
    }

    @Override
    public long getEndTimeNs() {
        return Long.MAX_VALUE;
    }

    @Override
    @NotNull
    public ClassDb getClassDatabase() {
        return this.classDb;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        boolean bl;
        boolean bl2;
        boolean it = bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl = queryRange != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl5 = bl = queryJoiner != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Range range = this.queryRange = queryRange;
        Intrinsics.checkNotNull((Object)range);
        range.addDependency(this.aspectObserver).onChange((Enum)Range.Aspect.RANGE, () -> LiveAllocationCaptureObject.load$lambda$3$loadTimeRange(this, queryJoiner));
        LiveAllocationCaptureObject.load$lambda$3$loadTimeRange(this, queryJoiner);
        return bl2;
    }

    @Override
    public Memory.AllocationStack.StackFrame getStackFrame(long methodId) {
        return (Memory.AllocationStack.StackFrame)this.methodIdMap.get(methodId);
    }

    @Override
    public boolean isDoneLoading() {
        return true;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public void unload() {
        Range range = this.queryRange;
        if (range != null) {
            range.removeDependencies(this.aspectObserver);
        }
        ExecutorService executorService = this.executorService;
        Intrinsics.checkNotNull((Object)executorService);
        executorService.shutdownNow();
    }

    private final void updateAllocationContexts(long endTimeNs) {
        if (this.contextEndTimeNs < endTimeNs) {
            for (Memory.BatchAllocationContexts contexts : this.getAllocationContexts(this.contextEndTimeNs, endTimeNs)) {
                Memory.AllocatedClass it;
                List list = contexts.getClassesList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getClassesList(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Memory.AllocatedClass)element$iv;
                    boolean bl = false;
                    this.classDb.registerClass(it.getClassId(), Type.getType((String)it.getClassName()).getClassName());
                }
                List list2 = contexts.getMethodsList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getMethodsList(...)");
                $this$forEach$iv = list2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Memory.AllocationStack.StackFrame)element$iv;
                    boolean bl = false;
                    this.methodIdMap.putIfAbsent(it.getMethodId(), (Object)it);
                }
                List list3 = contexts.getEncodedStacksList();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getEncodedStacksList(...)");
                $this$forEach$iv = list3;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Memory.AllocationStack)element$iv;
                    boolean bl = false;
                    this.callstackMap.putIfAbsent(it.getStackId(), (Object)it);
                }
                List list4 = contexts.getThreadInfosList();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getThreadInfosList(...)");
                $this$forEach$iv = list4;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Memory.ThreadInfo)element$iv;
                    boolean bl = false;
                    this.threadIdMap.putIfAbsent(it.getThreadId(), (Object)new ThreadId(it.getThreadName()));
                }
                List list5 = contexts.getMemoryMap().getRegionsList();
                Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getRegionsList(...)");
                $this$forEach$iv = list5;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Memory.MemoryMap.MemoryRegion)element$iv;
                    boolean bl = false;
                    ((Map)this.jniMemoryRegionMap).put(it.getStartAddress(), it);
                }
                this.contextEndTimeNs = Math.max(this.contextEndTimeNs, contexts.getTimestamp());
            }
        }
    }

    private final void loadTimeRange(Range queryRange, Executor joiner) {
        try {
            if (queryRange.isEmpty()) {
                return;
            }
            Future<?> future = this.currentTask;
            if (future != null) {
                future.cancel(false);
            }
            ExecutorService executorService = this.executorService;
            Intrinsics.checkNotNull((Object)executorService);
            this.currentTask = executorService.submit(() -> LiveAllocationCaptureObject.loadTimeRange$lambda$19(queryRange, this, joiner));
        }
        catch (RejectedExecutionException e) {
            LiveAllocationCaptureObject.Companion.getLogger().debug((Throwable)e);
        }
    }

    private final LiveAllocationInstanceObject getOrCreateInstanceObject(Memory.AllocationEvent.Allocation $this$getOrCreateInstanceObject) {
        LiveAllocationInstanceObject liveAllocationInstanceObject = (LiveAllocationInstanceObject)this.instanceMap.get($this$getOrCreateInstanceObject.getTag());
        if (liveAllocationInstanceObject == null) {
            LiveAllocationInstanceObject liveAllocationInstanceObject2;
            ThreadId threadId;
            Memory.AllocationStack callstack;
            ClassDb.ClassEntry entry2 = this.classDb.getEntry($this$getOrCreateInstanceObject.getClassTag());
            boolean bl = false;
            if ($this$getOrCreateInstanceObject.getStackId() != 0) {
                Object object = this.callstackMap.get($this$getOrCreateInstanceObject.getStackId());
                Intrinsics.checkNotNull((Object)object);
                v2 = (Memory.AllocationStack)object;
            } else {
                v2 = callstack = null;
            }
            if ($this$getOrCreateInstanceObject.getThreadId() != 0) {
                Object object = this.threadIdMap.get($this$getOrCreateInstanceObject.getThreadId());
                Intrinsics.checkNotNull((Object)object);
                threadId = (ThreadId)object;
            } else {
                threadId = ThreadId.INVALID_THREAD_ID;
            }
            ThreadId thread = threadId;
            Intrinsics.checkNotNull((Object)entry2);
            Intrinsics.checkNotNull((Object)thread);
            LiveAllocationInstanceObject it = liveAllocationInstanceObject2 = new LiveAllocationInstanceObject(this, entry2, thread, callstack, $this$getOrCreateInstanceObject.getSize(), $this$getOrCreateInstanceObject.getHeapId());
            boolean bl2 = false;
            this.instanceMap.put($this$getOrCreateInstanceObject.getTag(), (Object)it);
            liveAllocationInstanceObject = liveAllocationInstanceObject2;
        }
        return liveAllocationInstanceObject;
    }

    private final JniReferenceInstanceObject getOrCreateJniRefObject(Memory.JNIGlobalReferenceEvent $this$getOrCreateJniRefObject) {
        JniReferenceInstanceObject jniReferenceInstanceObject;
        LiveAllocationInstanceObject liveAllocationInstanceObject = (LiveAllocationInstanceObject)this.instanceMap.get($this$getOrCreateJniRefObject.getObjectTag());
        if (liveAllocationInstanceObject != null) {
            LiveAllocationInstanceObject referencedObject = liveAllocationInstanceObject;
            boolean bl = false;
            jniReferenceInstanceObject = referencedObject.getJniRefByValue($this$getOrCreateJniRefObject.getRefValue());
            if (jniReferenceInstanceObject == null) {
                JniReferenceInstanceObject jniReferenceInstanceObject2;
                JniReferenceInstanceObject p0 = jniReferenceInstanceObject2 = new JniReferenceInstanceObject(this, referencedObject, $this$getOrCreateJniRefObject.getObjectTag(), $this$getOrCreateJniRefObject.getRefValue());
                boolean bl2 = false;
                referencedObject.addJniRef(p0);
                jniReferenceInstanceObject = jniReferenceInstanceObject2;
            }
        } else {
            jniReferenceInstanceObject = null;
        }
        return jniReferenceInstanceObject;
    }

    private final void queryJavaInstanceSnapshot(long snapshotTimeNs, List<InstanceObject> snapshotList) {
        this.querySnapshot(snapshotTimeNs, snapshotList, this.allocationEventAdapter, (arg_0, arg_1) -> LiveAllocationCaptureObject.queryJavaInstanceSnapshot$lambda$23(this, arg_0, arg_1));
    }

    private final void queryJniReferencesSnapshot(long snapshotTimeNs, List<InstanceObject> snapshotList) {
        this.querySnapshot(snapshotTimeNs, snapshotList, this.jniReferenceEventAdapter, (arg_0, arg_1) -> LiveAllocationCaptureObject.queryJniReferencesSnapshot$lambda$26(this, arg_0, arg_1));
    }

    private final <E> void querySnapshot(long snapshotTimeNs, List<InstanceObject> snapshotList, EventAdapter<?, E> eventAdapter, Function2<? super E, ? super Map<Object, InstanceObject>, Unit> handleEvent) {
        LinkedHashMap instanceMap = new LinkedHashMap();
        eventAdapter.forEachEventStream(this.session.getStartTimestamp(), snapshotTimeNs, arg_0 -> LiveAllocationCaptureObject.querySnapshot$lambda$32(eventAdapter, snapshotTimeNs, handleEvent, instanceMap, arg_0));
        Collection collection = instanceMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        snapshotList.addAll(collection);
    }

    private final void queryJavaInstanceDelta(long startTimeNs, long endTimeNs, List<InstanceObject> allocationList, List<InstanceObject> deallocationList, boolean resetInstance) {
        this.queryDelta(startTimeNs, endTimeNs, this.allocationEventAdapter, arg_0 -> LiveAllocationCaptureObject.queryJavaInstanceDelta$lambda$34(this, resetInstance, allocationList, deallocationList, arg_0));
    }

    private final void queryJniReferencesDelta(long startTimeNs, long endTimeNs, List<InstanceObject> allocationList, List<InstanceObject> deallocationList, boolean resetInstance) {
        this.queryDelta(startTimeNs, endTimeNs, this.jniReferenceEventAdapter, arg_0 -> LiveAllocationCaptureObject.queryJniReferencesDelta$lambda$36(this, resetInstance, allocationList, deallocationList, arg_0));
    }

    private final <E> void queryDelta(long startTimeNs, long endTimeNs, EventAdapter<?, E> eventAdapter, Function1<? super E, Unit> handleEvent) {
        if (startTimeNs != endTimeNs) {
            eventAdapter.forEachEventStream(startTimeNs, endTimeNs, arg_0 -> LiveAllocationCaptureObject.queryDelta$lambda$41(eventAdapter, handleEvent, startTimeNs, endTimeNs, arg_0));
        }
    }

    private final void setAllocEvent(JniReferenceInstanceObject $this$setAllocEvent, Memory.JNIGlobalReferenceEvent event) {
        $this$setAllocEvent.setAllocThreadId(this.lookupThreadId(event.getThreadId()));
        $this$setAllocEvent.setAllocationTime(event.getTimestamp());
        if (event.hasBacktrace()) {
            $this$setAllocEvent.setAllocationBacktrace(event.getBacktrace());
        }
    }

    private final ThreadId lookupThreadId(int threadId) {
        ThreadId threadId2;
        if (threadId != 0) {
            Object object = this.threadIdMap.get(threadId);
            Intrinsics.checkNotNull((Object)object);
            threadId2 = (ThreadId)object;
        } else {
            ThreadId threadId3 = ThreadId.INVALID_THREAD_ID;
            threadId2 = threadId3;
            Intrinsics.checkNotNullExpressionValue((Object)threadId3, (String)"INVALID_THREAD_ID");
        }
        return threadId2;
    }

    @NotNull
    public final Memory.NativeCallStack resolveNativeBacktrace(@Nullable Memory.NativeBacktrace backtrace) {
        Memory.NativeCallStack nativeCallStack;
        if (backtrace == null || backtrace.getAddressesCount() == 0) {
            Memory.NativeCallStack nativeCallStack2 = Memory.NativeCallStack.getDefaultInstance();
            nativeCallStack = nativeCallStack2;
            Intrinsics.checkNotNullExpressionValue((Object)nativeCallStack2, (String)"getDefaultInstance(...)");
        } else {
            Memory.NativeCallStack.Builder builder = Memory.NativeCallStack.newBuilder();
            boolean bl = false;
            for (Long address : backtrace.getAddressesList()) {
                Intrinsics.checkNotNull((Object)address);
                if (!this.nativeFrameMap.containsKey(address.longValue())) {
                    Memory.NativeCallStack.NativeFrame symbolizedFrame;
                    Pair pair;
                    if (this.getRegionByAddress(address) != null) {
                        Memory.MemoryMap.MemoryRegion it;
                        boolean bl2 = false;
                        pair = new Pair((Object)it.getName(), (Object)(it.getFileOffset() + (address - it.getStartAddress())));
                    } else {
                        pair = new Pair((Object)"", (Object)0L);
                    }
                    Pair pair2 = pair;
                    String module = (String)pair2.component1();
                    long offset = ((Number)pair2.component2()).longValue();
                    Memory.NativeCallStack.NativeFrame unsymbolizedFrame = Memory.NativeCallStack.NativeFrame.newBuilder().setAddress(address.longValue()).setModuleName(module).setModuleOffset(offset).build();
                    Intrinsics.checkNotNullExpressionValue((Object)this.stage.getStudioProfilers().getIdeServices().getNativeFrameSymbolizer().symbolize(this.stage.getStudioProfilers().getSessionsManager().getSelectedSessionMetaData().getProcessAbi(), unsymbolizedFrame), (String)"symbolize(...)");
                    this.nativeFrameMap.put(address.longValue(), (Object)symbolizedFrame);
                }
                builder.addFrames((Memory.NativeCallStack.NativeFrame)this.nativeFrameMap.get(address.longValue()));
            }
            Memory.NativeCallStack nativeCallStack3 = builder.build();
            nativeCallStack = nativeCallStack3;
            Intrinsics.checkNotNullExpressionValue((Object)nativeCallStack3, (String)"let(...)");
        }
        return nativeCallStack;
    }

    private final Memory.MemoryMap.MemoryRegion getRegionByAddress(long address) {
        Object object;
        Map.Entry<Long, Memory.MemoryMap.MemoryRegion> entry2 = this.jniMemoryRegionMap.floorEntry(address);
        if (entry2 != null) {
            Map.Entry<Long, Memory.MemoryMap.MemoryRegion> entry3 = entry2;
            boolean bl = false;
            Memory.MemoryMap.MemoryRegion region = entry3.getValue();
            long l = region.getStartAddress();
            object = (address < region.getEndAddress() ? l <= address : false) ? region : null;
        } else {
            object = null;
        }
        return object;
    }

    private final List<Memory.BatchAllocationContexts> getAllocationContexts(long startTimeNs, long endTimeNs) {
        Transport.GetEventGroupsResponse getEventGroupsResponse = this.client.getTransportClient().getEventGroups(this.buildEventGroupRequest(Common.Event.Kind.MEMORY_ALLOC_CONTEXTS, startTimeNs, endTimeNs + QUERY_BUFFER_NS));
        Intrinsics.checkNotNullExpressionValue((Object)getEventGroupsResponse, (String)"getEventGroups(...)");
        return this.getResultList(getEventGroupsResponse, LiveAllocationCaptureObject::getAllocationContexts$lambda$45);
    }

    private final <T> List<T> getEvents(long startTimeNs, long endTimeNs, Common.Event.Kind event, Function1<? super Common.Event, ? extends T> extract) {
        Transport.GetEventGroupsResponse getEventGroupsResponse = this.client.getTransportClient().getEventGroups(this.buildEventGroupRequest(event, startTimeNs - QUERY_BUFFER_NS, endTimeNs + QUERY_BUFFER_NS));
        Intrinsics.checkNotNullExpressionValue((Object)getEventGroupsResponse, (String)"getEventGroups(...)");
        return this.getResultList(getEventGroupsResponse, extract);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> List<T> getResultList(Transport.GetEventGroupsResponse $this$getResultList, Function1<? super Common.Event, ? extends T> extract) {
        List list;
        if ($this$getResultList.getGroupsCount() == 1) {
            void $this$mapTo$iv$iv;
            List list2 = $this$getResultList.getGroups(0).getEventsList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEventsList(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(extract.invoke(item$iv$iv));
            }
            list = (List)destination$iv$iv;
        } else {
            boolean bl;
            List list3;
            List it = list3 = CollectionsKt.emptyList();
            boolean bl2 = false;
            boolean bl3 = bl = $this$getResultList.getGroupsCount() == 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            list = list3;
        }
        return list;
    }

    private final Transport.GetEventGroupsRequest buildEventGroupRequest(Common.Event.Kind kind, long startTimeNs, long endTimeNs) {
        return Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.session.getStreamId()).setPid(this.session.getPid()).setKind(kind).setFromTimestamp(startTimeNs).setToTimestamp(endTimeNs).build();
    }

    private final <T> void updateSeenTimestamp(List<? extends T> $this$updateSeenTimestamp, Function1<? super T, Long> timestamp) {
        $this$updateSeenTimestamp.stream().mapToLong(arg_0 -> LiveAllocationCaptureObject.updateSeenTimestamp$lambda$47(timestamp, arg_0)).max().ifPresent(arg_0 -> LiveAllocationCaptureObject.updateSeenTimestamp$lambda$48(this, arg_0));
    }

    private static final Stream getInstances$lambda$1(HeapSet it) {
        return it.getInstancesStream();
    }

    private static final Stream getInstances$lambda$2(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final void load$lambda$3$loadTimeRange(LiveAllocationCaptureObject this$0, Executor $queryJoiner) {
        Range range = this$0.queryRange;
        Intrinsics.checkNotNull((Object)range);
        Executor executor = $queryJoiner;
        Intrinsics.checkNotNull((Object)executor);
        this$0.loadTimeRange(range, executor);
    }

    private static final void loadTimeRange$lambda$19$lambda$9(LiveAllocationCaptureObject this$0) {
        this$0.stage.getCaptureSelection().getAspect().changed((Enum)CaptureSelectionAspect.CURRENT_HEAP_UPDATING);
    }

    private static final void loadTimeRange$lambda$19$queryDelta(LiveAllocationCaptureObject this$0, long start, long end, List<InstanceObject> allocs, List<InstanceObject> deallocs, boolean reset) {
        this$0.queryJavaInstanceDelta(start, end, allocs, deallocs, reset);
        this$0.queryJniReferencesDelta(start, end, allocs, deallocs, reset);
    }

    private static final <T> void loadTimeRange$lambda$19$addAllToEach(List<? extends T> $this$loadTimeRange_u24lambda_u2419_u24addAllToEach, List<T> ... outs) {
        List<T>[] $this$forEach$iv = outs;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            List<T> element$iv;
            List<T> it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.addAll((Collection)$this$loadTimeRange_u24lambda_u2419_u24addAllToEach);
        }
    }

    private static final void loadTimeRange$lambda$19$lambda$18(MemoryCaptureSelection $selection, boolean $clear, List $deltaAllocationList, List $deltaFreeList, List $resetDeltaAllocationList, List $resetDeltaFreeList, LiveAllocationCaptureObject this$0, List $snapshotList, List $resetSnapshotList, boolean $hasNonFullTrackingRegion) {
        $selection.getAspect().changed((Enum)CaptureSelectionAspect.CURRENT_HEAP_UPDATED);
        if ($clear || $deltaAllocationList.size() + $deltaFreeList.size() + $resetDeltaAllocationList.size() + $resetDeltaFreeList.size() > 0) {
            MemoryObject it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            if ($clear) {
                $this$forEach$iv = this$0.heapSets;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (HeapSet)element$iv;
                    boolean bl = false;
                    ((ClassifierSet)it).clearClassifierSets();
                }
            }
            $this$forEach$iv = $snapshotList;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (InstanceObject)element$iv;
                boolean bl = false;
                this$0.heapSets.get(it.getHeapId()).addSnapshotInstanceObject((InstanceObject)it);
            }
            $this$forEach$iv = $resetSnapshotList;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (InstanceObject)element$iv;
                boolean bl = false;
                this$0.heapSets.get(it.getHeapId()).removeSnapshotInstanceObject((InstanceObject)it);
            }
            $this$forEach$iv = $deltaAllocationList;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (InstanceObject)element$iv;
                boolean bl = false;
                this$0.heapSets.get(it.getHeapId()).addDeltaInstanceObject((InstanceObject)it);
            }
            $this$forEach$iv = $deltaFreeList;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (InstanceObject)element$iv;
                boolean bl = false;
                this$0.heapSets.get(it.getHeapId()).freeDeltaInstanceObject((InstanceObject)it);
            }
            $this$forEach$iv = $resetDeltaAllocationList;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (InstanceObject)element$iv;
                boolean bl = false;
                this$0.heapSets.get(it.getHeapId()).removeAddedDeltaInstanceObject((InstanceObject)it);
            }
            $this$forEach$iv = $resetDeltaFreeList;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (InstanceObject)element$iv;
                boolean bl = false;
                this$0.heapSets.get(it.getHeapId()).removeFreedDeltaInstanceObject((InstanceObject)it);
            }
            this$0.infoMessage = $hasNonFullTrackingRegion ? SAMPLING_INFO_MESSAGE : null;
            $selection.refreshSelectedHeap();
        }
    }

    private static final Object loadTimeRange$lambda$19(Range $queryRange, LiveAllocationCaptureObject this$0, Executor $joiner) {
        boolean clear;
        long newStartTimeNs = TimeUnit.MICROSECONDS.toNanos((long)$queryRange.getMin());
        long newEndTimeNs = TimeUnit.MICROSECONDS.toNanos((long)$queryRange.getMax());
        if (newStartTimeNs == this$0.previousQueryStartTimeNs && newEndTimeNs == this$0.previousQueryEndTimeNs) {
            return null;
        }
        StudioProfilers studioProfilers = this$0.stage.getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
        boolean hasNonFullTrackingRegion = !MemoryProfiler.Companion.hasOnlyFullAllocationTrackingWithinRegion(studioProfilers, this$0.session, TimeUnit.NANOSECONDS.toMicros(newStartTimeNs), TimeUnit.NANOSECONDS.toMicros(newEndTimeNs));
        $joiner.execute(() -> LiveAllocationCaptureObject.loadTimeRange$lambda$19$lambda$9(this$0));
        this$0.updateAllocationContexts(newEndTimeNs);
        List snapshotList = new ArrayList();
        List resetSnapshotList = new ArrayList();
        List deltaAllocationList = new ArrayList();
        List resetDeltaAllocationList = new ArrayList();
        List deltaFreeList = new ArrayList();
        List resetDeltaFreeList = new ArrayList();
        boolean bl = clear = this$0.previousQueryEndTimeNs <= newStartTimeNs || newEndTimeNs <= this$0.previousQueryStartTimeNs;
        if (clear) {
            this$0.instanceMap.clear();
            this$0.queryJavaInstanceSnapshot(newStartTimeNs, snapshotList);
            this$0.queryJniReferencesSnapshot(newStartTimeNs, snapshotList);
            LiveAllocationCaptureObject.loadTimeRange$lambda$19$queryDelta(this$0, newStartTimeNs, newEndTimeNs, deltaAllocationList, deltaFreeList, false);
        } else {
            List leftAllocations = new ArrayList();
            List leftDeallocations = new ArrayList();
            if (newStartTimeNs < this$0.previousQueryStartTimeNs) {
                LiveAllocationCaptureObject.loadTimeRange$lambda$19$queryDelta(this$0, newStartTimeNs, this$0.previousQueryStartTimeNs, leftAllocations, leftDeallocations, false);
                var17_15 = new List[]{deltaAllocationList, resetSnapshotList};
                LiveAllocationCaptureObject.loadTimeRange$lambda$19$addAllToEach(leftAllocations, var17_15);
                var17_15 = new List[]{deltaFreeList, snapshotList};
                LiveAllocationCaptureObject.loadTimeRange$lambda$19$addAllToEach(leftDeallocations, var17_15);
            } else if (newStartTimeNs > this$0.previousQueryStartTimeNs) {
                LiveAllocationCaptureObject.loadTimeRange$lambda$19$queryDelta(this$0, this$0.previousQueryStartTimeNs, newStartTimeNs, leftAllocations, leftDeallocations, true);
                var17_15 = new List[]{resetDeltaAllocationList, snapshotList};
                LiveAllocationCaptureObject.loadTimeRange$lambda$19$addAllToEach(leftAllocations, var17_15);
                var17_15 = new List[]{resetDeltaFreeList, resetSnapshotList};
                LiveAllocationCaptureObject.loadTimeRange$lambda$19$addAllToEach(leftDeallocations, var17_15);
            }
            List rightAllocations = new ArrayList();
            List rightDeallocations = new ArrayList();
            if (newEndTimeNs < this$0.previousQueryEndTimeNs) {
                LiveAllocationCaptureObject.loadTimeRange$lambda$19$queryDelta(this$0, newEndTimeNs, this$0.previousQueryEndTimeNs, rightAllocations, rightDeallocations, true);
                resetDeltaAllocationList.addAll(rightAllocations);
                resetDeltaFreeList.addAll(rightDeallocations);
            } else if (newEndTimeNs > this$0.previousQueryEndTimeNs) {
                LiveAllocationCaptureObject.loadTimeRange$lambda$19$queryDelta(this$0, this$0.previousQueryEndTimeNs, newEndTimeNs, rightAllocations, rightDeallocations, false);
                deltaAllocationList.addAll(rightAllocations);
                deltaFreeList.addAll(rightDeallocations);
            }
        }
        this$0.previousQueryStartTimeNs = newStartTimeNs;
        this$0.previousQueryEndTimeNs = Math.min(newEndTimeNs, this$0.lastSeenTimestampNs);
        MemoryCaptureSelection selection = this$0.stage.getCaptureSelection();
        $joiner.execute(() -> LiveAllocationCaptureObject.loadTimeRange$lambda$19$lambda$18(selection, clear, deltaAllocationList, deltaFreeList, resetDeltaAllocationList, resetDeltaFreeList, this$0, snapshotList, resetSnapshotList, hasNonFullTrackingRegion));
        return null;
    }

    private static final Unit queryJavaInstanceSnapshot$lambda$23(LiveAllocationCaptureObject this$0, Memory.AllocationEvent event, Map liveInstanceMap) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)liveInstanceMap, (String)"liveInstanceMap");
        Memory.AllocationEvent.EventCase eventCase = event.getEventCase();
        switch (eventCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eventCase.ordinal()]) {
            case 1: {
                Memory.AllocationEvent.Allocation allocation = event.getAllocData();
                Intrinsics.checkNotNull((Object)allocation);
                LiveAllocationInstanceObject instance = this$0.getOrCreateInstanceObject(allocation);
                instance.setAllocationTime(event.getTimestamp());
                liveInstanceMap.put(allocation.getTag(), instance);
                break;
            }
            case 2: {
                Memory.AllocationEvent.Deallocation deallocation = event.getFreeData();
                liveInstanceMap.remove(deallocation.getTag());
                this$0.instanceMap.remove(deallocation.getTag());
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit queryJniReferencesSnapshot$lambda$26(LiveAllocationCaptureObject this$0, Memory.JNIGlobalReferenceEvent event, Map instanceMap) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)instanceMap, (String)"instanceMap");
        Memory.JNIGlobalReferenceEvent.Type type = event.getEventType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                JniReferenceInstanceObject jniReferenceInstanceObject = this$0.getOrCreateJniRefObject(event);
                if (jniReferenceInstanceObject != null) {
                    JniReferenceInstanceObject refObject = jniReferenceInstanceObject;
                    boolean bl = false;
                    this$0.setAllocEvent(refObject, event);
                    instanceMap.put(refObject.getRefValue(), refObject);
                }
                break;
            }
            case 2: {
                InstanceObject instanceObject = (InstanceObject)instanceMap.remove(event.getRefValue());
                if (instanceObject != null) {
                    InstanceObject refObject = instanceObject;
                    boolean bl = false;
                    if (!this$0.instanceMap.containsKey(event.getObjectTag())) break;
                    ((LiveAllocationInstanceObject)this$0.instanceMap.get(event.getObjectTag())).removeJniRef((JniReferenceInstanceObject)refObject);
                }
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean querySnapshot$lambda$32$lambda$27(EventAdapter $eventAdapter, long $snapshotTimeNs, Object it) {
        return $eventAdapter.getTimestamp(it) < $snapshotTimeNs;
    }

    private static final boolean querySnapshot$lambda$32$lambda$28(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final long querySnapshot$lambda$32$lambda$29(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final Unit querySnapshot$lambda$32$lambda$30(Function2 $handleEvent, LinkedHashMap $instanceMap, Object it) {
        $handleEvent.invoke(it, (Object)$instanceMap);
        return Unit.INSTANCE;
    }

    private static final void querySnapshot$lambda$32$lambda$31(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit querySnapshot$lambda$32(EventAdapter $eventAdapter, long $snapshotTimeNs, Function2 $handleEvent, LinkedHashMap $instanceMap, Stream eventStream) {
        Intrinsics.checkNotNullParameter((Object)eventStream, (String)"eventStream");
        eventStream.filter(arg_0 -> LiveAllocationCaptureObject.querySnapshot$lambda$32$lambda$28(arg_0 -> LiveAllocationCaptureObject.querySnapshot$lambda$32$lambda$27($eventAdapter, $snapshotTimeNs, arg_0), arg_0)).sorted(Comparator.comparingLong(arg_0 -> LiveAllocationCaptureObject.querySnapshot$lambda$32$lambda$29((Function1)new Function1<E, Long>($eventAdapter){

            public final Long invoke(E p0) {
                return ((EventAdapter)this.receiver).getTimestamp(p0);
            }
        }, arg_0))).forEach(arg_0 -> LiveAllocationCaptureObject.querySnapshot$lambda$32$lambda$31(arg_0 -> LiveAllocationCaptureObject.querySnapshot$lambda$32$lambda$30($handleEvent, $instanceMap, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit queryJavaInstanceDelta$lambda$34(LiveAllocationCaptureObject this$0, boolean $resetInstance, List $allocationList, List $deallocationList, Memory.AllocationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Memory.AllocationEvent.EventCase eventCase = event.getEventCase();
        switch (eventCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eventCase.ordinal()]) {
            case 1: {
                Memory.AllocationEvent.Allocation allocation = event.getAllocData();
                Intrinsics.checkNotNullExpressionValue((Object)allocation, (String)"getAllocData(...)");
                LiveAllocationInstanceObject instance = this$0.getOrCreateInstanceObject(allocation);
                instance.setAllocationTime($resetInstance ? Long.MIN_VALUE : event.getTimestamp());
                $allocationList.add(instance);
                break;
            }
            case 2: {
                Memory.AllocationEvent.Deallocation deallocation = event.getFreeData();
                LiveAllocationInstanceObject liveAllocationInstanceObject = (LiveAllocationInstanceObject)this$0.instanceMap.get(deallocation.getTag());
                if (liveAllocationInstanceObject != null) {
                    LiveAllocationInstanceObject instance = liveAllocationInstanceObject;
                    boolean bl = false;
                    instance.setDeallocTime($resetInstance ? Long.MAX_VALUE : event.getTimestamp());
                    $deallocationList.add(instance);
                }
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit queryJniReferencesDelta$lambda$36(LiveAllocationCaptureObject this$0, boolean $resetInstance, List $allocationList, List $deallocationList, Memory.JNIGlobalReferenceEvent event) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            JniReferenceInstanceObject jniReferenceInstanceObject = this$0.getOrCreateJniRefObject(event);
            if (jniReferenceInstanceObject == null) break block10;
            JniReferenceInstanceObject refObject = jniReferenceInstanceObject;
            boolean bl = false;
            Memory.JNIGlobalReferenceEvent.Type type = event.getEventType();
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                case 1: {
                    if ($resetInstance) {
                        refObject.setAllocationTime(Long.MIN_VALUE);
                    } else {
                        this$0.setAllocEvent(refObject, event);
                    }
                    $allocationList.add(refObject);
                    break;
                }
                case 2: {
                    if ($resetInstance) {
                        refObject.setAllocationTime(Long.MAX_VALUE);
                    } else {
                        refObject.setDeallocTime(event.getTimestamp());
                        if (event.hasBacktrace()) {
                            refObject.setDeallocationBacktrace(event.getBacktrace());
                        }
                        refObject.setDeallocThreadId(this$0.lookupThreadId(event.getThreadId()));
                    }
                    $deallocationList.add(refObject);
                    break;
                }
                default: {
                    if (_Assertions.ENABLED) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    } else {
                        break;
                    }
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean queryDelta$lambda$41$lambda$37(EventAdapter $eventAdapter, long $startTimeNs, long $endTimeNs, Object it) {
        long l = $eventAdapter.getTimestamp(it);
        return $startTimeNs <= l ? l < $endTimeNs : false;
    }

    private static final boolean queryDelta$lambda$41$lambda$38(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final long queryDelta$lambda$41$lambda$39(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final void queryDelta$lambda$41$lambda$40(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit queryDelta$lambda$41(EventAdapter $eventAdapter, Function1 $handleEvent, long $startTimeNs, long $endTimeNs, Stream eventStream) {
        Intrinsics.checkNotNullParameter((Object)eventStream, (String)"eventStream");
        eventStream.filter(arg_0 -> LiveAllocationCaptureObject.queryDelta$lambda$41$lambda$38(arg_0 -> LiveAllocationCaptureObject.queryDelta$lambda$41$lambda$37($eventAdapter, $startTimeNs, $endTimeNs, arg_0), arg_0)).sorted(Comparator.comparingLong(arg_0 -> LiveAllocationCaptureObject.queryDelta$lambda$41$lambda$39((Function1)new Function1<E, Long>($eventAdapter){

            public final Long invoke(E p0) {
                return ((EventAdapter)this.receiver).getTimestamp(p0);
            }
        }, arg_0))).forEach(arg_0 -> LiveAllocationCaptureObject.queryDelta$lambda$41$lambda$40($handleEvent, arg_0));
        return Unit.INSTANCE;
    }

    private static final Memory.BatchAllocationContexts getAllocationContexts$lambda$45(Common.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMemoryAllocContexts().getContexts();
    }

    private static final long updateSeenTimestamp$lambda$47(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final void updateSeenTimestamp$lambda$48(LiveAllocationCaptureObject this$0, long it) {
        this$0.lastSeenTimestampNs = Math.max(this$0.lastSeenTimestampNs, it);
    }

    public static final /* synthetic */ List access$getEvents(LiveAllocationCaptureObject $this, long startTimeNs, long endTimeNs, Common.Event.Kind event, Function1 extract) {
        return $this.getEvents(startTimeNs, endTimeNs, event, extract);
    }

    public static final /* synthetic */ void access$updateSeenTimestamp(LiveAllocationCaptureObject $this, List $receiver, Function1 timestamp) {
        $this.updateSeenTimestamp($receiver, timestamp);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003\u00a8\u0006\r"}, d2={"Lcom/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "QUERY_BUFFER_NS", "", "SAMPLING_INFO_MESSAGE", "", "getSAMPLING_INFO_MESSAGE$annotations", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLogger() {
            Logger logger = Logger.getInstance(LiveAllocationCaptureObject.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return logger;
        }

        @VisibleForTesting
        public static /* synthetic */ void getSAMPLING_INFO_MESSAGE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bb\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t2\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H&J2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u0013\u0012\u0004\u0012\u00020\u00100\u0012H\u0016\u00a8\u0006\u0014\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject$EventAdapter;", "B", "E", "", "getTimestamp", "", "event", "(Ljava/lang/Object;)J", "getEventList", "", "batch", "(Ljava/lang/Object;)Ljava/util/List;", "getBatchEvents", "startTimeNs", "endTimeNs", "forEachEventStream", "", "handle", "Lkotlin/Function1;", "Ljava/util/stream/Stream;", "intellij.android.profilers"})
    @SourceDebugExtension(value={"SMAP\nLiveAllocationCaptureObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveAllocationCaptureObject.kt\ncom/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject$EventAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,549:1\n1863#2,2:550\n*S KotlinDebug\n*F\n+ 1 LiveAllocationCaptureObject.kt\ncom/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject$EventAdapter\n*L\n547#1:550,2\n*E\n"})
    private static interface EventAdapter<B, E> {
        public long getTimestamp(E var1);

        @NotNull
        public List<E> getEventList(B var1);

        @NotNull
        public List<B> getBatchEvents(long var1, long var3);

        default public void forEachEventStream(long startTimeNs, long endTimeNs, @NotNull Function1<? super Stream<E>, Unit> handle) {
            Intrinsics.checkNotNullParameter(handle, (String)"handle");
            Iterable $this$forEach$iv = this.getBatchEvents(startTimeNs, endTimeNs);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Stream stream = this.getEventList(it).stream();
                Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
                handle.invoke(stream);
            }
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            public static <B, E> void forEachEventStream(@NotNull EventAdapter<B, E> $this, long startTimeNs, long endTimeNs, @NotNull Function1<? super Stream<E>, Unit> handle) {
                Intrinsics.checkNotNullParameter(handle, (String)"handle");
                ((EventAdapter)$this).forEachEventStream(startTimeNs, endTimeNs, handle);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Memory.AllocationEvent.EventCase.values().length];
            try {
                nArray[Memory.AllocationEvent.EventCase.ALLOC_DATA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Memory.AllocationEvent.EventCase.FREE_DATA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Memory.AllocationEvent.EventCase.CLASS_DATA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Memory.AllocationEvent.EventCase.EVENT_NOT_SET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Memory.JNIGlobalReferenceEvent.Type.values().length];
            try {
                nArray[Memory.JNIGlobalReferenceEvent.Type.CREATE_GLOBAL_REF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Memory.JNIGlobalReferenceEvent.Type.DELETE_GLOBAL_REF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Memory.JNIGlobalReferenceEvent.Type.UNSPECIFIED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Memory.JNIGlobalReferenceEvent.Type.CREATE_WEAK_REF.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Memory.JNIGlobalReferenceEvent.Type.DELETE_WEAK_REF.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Memory.JNIGlobalReferenceEvent.Type.UNRECOGNIZED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

