/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.LegacyAllocationConverter;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.LegacyAllocationsInstanceObject;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LegacyAllocationCaptureObject
implements CaptureObject {
    static final int DEFAULT_HEAP_ID = 0;
    static final String DEFAULT_HEAP_NAME = "default";
    @NotNull
    private final ProfilerClient myClient;
    @NotNull
    private final ClassDb myClassDb;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final Memory.AllocationsInfo myInfo;
    @NotNull
    private final LegacyAllocationConverter myAllocationConverter;
    private long myStartTimeNs;
    private long myEndTimeNs;
    private final FeatureTracker myFeatureTracker;
    private volatile boolean myIsDoneLoading = false;
    private volatile boolean myIsLoadingError = false;
    private final HeapSet myFakeHeapSet;

    public LegacyAllocationCaptureObject(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Memory.AllocationsInfo info, @NotNull FeatureTracker featureTracker) {
        this.myClient = client;
        this.myClassDb = new ClassDb();
        this.mySession = session;
        this.myInfo = info;
        this.myAllocationConverter = new LegacyAllocationConverter();
        this.myStartTimeNs = info.getStartTime();
        this.myEndTimeNs = info.getEndTime();
        this.myFakeHeapSet = new HeapSet(this, DEFAULT_HEAP_NAME, 0);
        this.myFeatureTracker = featureTracker;
    }

    @Override
    @NotNull
    public String getName() {
        return "Recorded Allocations";
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return "alloc";
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) {
        MemoryProfiler.saveLegacyAllocationToFile(this.myClient, this.mySession, this.myInfo, outputStream, this.myFeatureTracker);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        assert (this.isDoneLoading() && !this.isError());
        return this.myFakeHeapSet.getInstancesStream();
    }

    @Override
    public long getStartTimeNs() {
        return this.myStartTimeNs;
    }

    @Override
    public long getEndTimeNs() {
        return this.myEndTimeNs;
    }

    @Override
    @NotNull
    public ClassDb getClassDatabase() {
        return this.myClassDb;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        byte[] allocationBytes;
        Transport.FileResponse response;
        if (!this.myInfo.getSuccess()) {
            this.myIsLoadingError = true;
            return false;
        }
        while ((response = this.myClient.getTransportClient().getFile(Transport.BytesRequest.newBuilder().setStreamId(this.mySession.getStreamId()).setId(Long.toString(this.myInfo.getStartTime())).build())).getFilePath().isEmpty()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.myIsLoadingError = true;
                return false;
            }
        }
        try {
            allocationBytes = Files.readAllBytes(new File(response.getFilePath()).toPath());
        }
        catch (IOException e) {
            this.myIsLoadingError = true;
            return false;
        }
        HashMap classEntryMap = new HashMap();
        HashMap callStacks = new HashMap();
        this.myAllocationConverter.parseDump(allocationBytes);
        this.myAllocationConverter.getAllocationStacks().forEach(stack -> callStacks.putIfAbsent(stack.getStackId(), stack));
        this.myAllocationConverter.getClassNames().forEach(klass -> classEntryMap.put(klass.getClassId(), this.myClassDb.registerClass(klass.getClassId(), klass.getClassName())));
        for (Memory.AllocationEvent.Allocation event : this.myAllocationConverter.getAllocationEvents()) {
            assert (classEntryMap.containsKey(event.getClassTag()));
            assert (callStacks.containsKey(event.getStackId()));
            this.myFakeHeapSet.addDeltaInstanceObject(new LegacyAllocationsInstanceObject(event, (ClassDb.ClassEntry)classEntryMap.get(event.getClassTag()), (Memory.AllocationStack)callStacks.get(event.getStackId())));
        }
        this.myIsDoneLoading = true;
        return true;
    }

    @Override
    public boolean isDoneLoading() {
        return this.myIsDoneLoading || this.myIsLoadingError;
    }

    @Override
    public boolean isError() {
        return this.myIsLoadingError;
    }

    @Override
    public void unload() {
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        return Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.SHALLOW_SIZE);
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        return Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.SHALLOW_SIZE);
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        return Collections.singletonList(this.myFakeHeapSet);
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        assert (heapId == 0);
        return this.myFakeHeapSet;
    }
}

