/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.ext.NativeRegistryPostProcessor;
import com.android.tools.perflib.heap.io.InMemoryBuffer;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.analytics.FeatureTrackerKt;
import com.android.tools.profilers.memory.BitmapDuplicationAnalyzer;
import com.android.tools.profilers.memory.ClassGrouping;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.HeapDumpInstanceObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.memory.adapters.classifiers.AllHeapSet;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.android.tools.profilers.memory.adapters.instancefilters.ActivityFragmentLeakInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.BitmapDuplicationInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.ProjectClassesInstanceFilter;
import com.android.tools.proguard.ProguardMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\u001cH\u0016J\b\u0010;\u001a\u000209H\u0016J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00130AH\u0016J\u0012\u0010B\u001a\u0004\u0018\u00010\u00132\u0006\u0010C\u001a\u00020\u0012H\u0016J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00160EH\u0016J\b\u0010F\u001a\u00020GH\u0016J\b\u0010H\u001a\u00020GH\u0016J\b\u0010I\u001a\u00020\u0018H\u0016J\b\u0010J\u001a\u00020\u0005H\u0016J\u001c\u0010K\u001a\u00020\u001c2\b\u0010L\u001a\u0004\u0018\u00010M2\b\u0010N\u001a\u0004\u0018\u00010OH\u0016J\u0010\u0010K\u001a\u00020=2\u0006\u0010P\u001a\u00020QH\u0007J \u0010R\u001a\u00020=2\u0006\u0010S\u001a\u00020\u00132\u0006\u0010T\u001a\u00020G2\u0006\u0010U\u001a\u00020\u0016H\u0002J\b\u0010V\u001a\u00020\u001cH\u0016J\b\u0010W\u001a\u00020\u001cH\u0016J\b\u0010X\u001a\u00020=H\u0016J\u000e\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0ZH\u0016J\u000e\u0010\\\u001a\b\u0012\u0004\u0012\u00020]0ZH\u0016J\u0012\u0010^\u001a\u0004\u0018\u00010\u00162\u0006\u0010_\u001a\u00020`H\u0016J\u0018\u0010a\u001a\u00020\u00162\b\u0010b\u001a\u0004\u0018\u00010\u00162\u0006\u0010c\u001a\u00020dJ\b\u0010e\u001a\u00020#H\u0016J\b\u0010f\u001a\u00020'H\u0016J\u000e\u0010g\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J\u000e\u0010h\u001a\b\u0012\u0004\u0012\u00020*0,H\u0016J \u0010i\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010k0j2\u0006\u0010l\u001a\u00020*2\u0006\u0010m\u001a\u00020OH\u0016J \u0010n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010k0j2\u0006\u0010o\u001a\u00020*2\u0006\u0010m\u001a\u00020OH\u0016J \u0010p\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010k0j2\u0006\u0010q\u001a\u00020*2\u0006\u0010m\u001a\u00020OH\u0016J\u0018\u0010r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010k0j2\u0006\u0010m\u001a\u00020OH\u0016J \u0010s\u001a\u0004\u0018\u00010k2\f\u0010t\u001a\b\u0012\u0004\u0012\u00020\u00160)2\u0006\u0010u\u001a\u00020OH\u0002J\b\u0010v\u001a\u00020\u001cH\u0016J\u0012\u0010w\u001a\u00020\u001c2\b\u0010x\u001a\u0004\u0018\u00010yH\u0016J\u0010\u0010z\u001a\n /*\u0004\u0018\u00010{0{H\u0002J\u001b\u0010|\u001a\u00070}\u00a2\u0006\u0002\b~*\u00020d2\b\b\u0002\u0010\u007f\u001a\u000209H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u00020\u00188G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020*0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\n /*\u0004\u0018\u00010.0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020\u00160)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\"\u00103\u001a\n /*\u0004\u0018\u00010.0.8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b4\u00105\u001a\u0004\b6\u00107\u00a8\u0006\u0080\u0001"}, d2={"Lcom/android/tools/profilers/memory/adapters/HeapDumpCaptureObject;", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "client", "Lcom/android/tools/profilers/ProfilerClient;", "_session", "Lcom/android/tools/profiler/proto/Common$Session;", "heapDumpInfo", "Lcom/android/tools/profiler/proto/Memory$HeapDumpInfo;", "proguardMap", "Lcom/android/tools/proguard/ProguardMap;", "featureTracker", "Lcom/android/tools/profilers/analytics/FeatureTracker;", "ideProfilerServices", "Lcom/android/tools/profilers/IdeProfilerServices;", "<init>", "(Lcom/android/tools/profilers/ProfilerClient;Lcom/android/tools/profiler/proto/Common$Session;Lcom/android/tools/profiler/proto/Memory$HeapDumpInfo;Lcom/android/tools/proguard/ProguardMap;Lcom/android/tools/profilers/analytics/FeatureTracker;Lcom/android/tools/profilers/IdeProfilerServices;)V", "_heapSets", "", "", "Lcom/android/tools/profilers/memory/adapters/classifiers/HeapSet;", "instanceIndex", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "classDb", "Lcom/android/tools/profilers/memory/adapters/ClassDb;", "getClassDb", "()Lcom/android/tools/profilers/memory/adapters/ClassDb;", "hasLoaded", "", "isLoadingError", "value", "hasNativeAllocations", "getHasNativeAllocations", "()Z", "activityFragmentLeakFilter", "Lcom/android/tools/profilers/memory/adapters/instancefilters/ActivityFragmentLeakInstanceFilter;", "bitmapDuplicationAnalyzer", "Lcom/android/tools/profilers/memory/BitmapDuplicationAnalyzer;", "bitmapDuplicationFilter", "Lcom/android/tools/profilers/memory/adapters/instancefilters/BitmapDuplicationInstanceFilter;", "supportedInstanceFilters", "", "Lcom/android/tools/profilers/memory/adapters/instancefilters/CaptureObjectInstanceFilter;", "currentInstanceFilters", "", "executorService", "Lcom/google/common/util/concurrent/ListeningExecutorService;", "kotlin.jvm.PlatformType", "allInstances", "getAllInstances", "()Ljava/util/Set;", "instanceFilterExecutor", "getInstanceFilterExecutor$annotations", "()V", "getInstanceFilterExecutor", "()Lcom/google/common/util/concurrent/ListeningExecutorService;", "getName", "", "isExportable", "getExportableExtension", "saveToFile", "", "outputStream", "Ljava/io/OutputStream;", "getHeapSets", "", "getHeapSet", "heapId", "getInstances", "Ljava/util/stream/Stream;", "getStartTimeNs", "", "getEndTimeNs", "getClassDatabase", "getSession", "load", "queryRange", "Lcom/android/tools/adtui/model/Range;", "queryJoiner", "Ljava/util/concurrent/Executor;", "buffer", "Lcom/android/tools/perflib/heap/io/InMemoryBuffer;", "addInstance", "heapSet", "id", "instObj", "isDoneLoading", "isError", "unload", "getClassifierAttributes", "", "Lcom/android/tools/profilers/memory/adapters/CaptureObject$ClassifierAttribute;", "getInstanceAttributes", "Lcom/android/tools/profilers/memory/adapters/CaptureObject$InstanceAttribute;", "findInstanceObject", "instance", "Lcom/android/tools/perflib/heap/Instance;", "createClassObjectInstance", "javaLangClass", "classObj", "Lcom/android/tools/perflib/heap/ClassObj;", "getActivityFragmentLeakFilter", "getBitmapDuplicationFilter", "getSupportedInstanceFilters", "getSelectedInstanceFilters", "addInstanceFilter", "Lcom/google/common/util/concurrent/ListenableFuture;", "Ljava/lang/Void;", "filterToAdd", "analyzeJoiner", "removeInstanceFilter", "filterToRemove", "setSingleFilter", "filter", "removeAllFilters", "refreshInstances", "instances", "executor", "canSafelyLoad", "isGroupingSupported", "grouping", "Lcom/android/tools/profilers/memory/ClassGrouping;", "doGetBytesRequest", "Lcom/android/tools/profiler/proto/Transport$FileResponse;", "makeEntry", "Lcom/android/tools/profilers/memory/adapters/ClassDb$ClassEntry;", "Lorg/jetbrains/annotations/NotNull;", "name", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nHeapDumpCaptureObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeapDumpCaptureObject.kt\ncom/android/tools/profilers/memory/adapters/HeapDumpCaptureObject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,269:1\n1#2:270\n1863#3,2:271\n1279#3,2:273\n1293#3,4:275\n1863#3,2:284\n1797#3,3:287\n1863#3,2:290\n1863#3,2:292\n1863#3,2:294\n37#4:279\n36#4,3:280\n216#5:283\n217#5:286\n*S KotlinDebug\n*F\n+ 1 HeapDumpCaptureObject.kt\ncom/android/tools/profilers/memory/adapters/HeapDumpCaptureObject\n*L\n95#1:271,2\n141#1:273,2\n141#1:275,4\n149#1:284,2\n221#1:287,3\n239#1:290,2\n241#1:292,2\n242#1:294,2\n143#1:279\n143#1:280,3\n148#1:283\n148#1:286\n*E\n"})
public class HeapDumpCaptureObject
implements CaptureObject {
    @NotNull
    private final ProfilerClient client;
    @NotNull
    private final Common.Session _session;
    @NotNull
    private final Memory.HeapDumpInfo heapDumpInfo;
    @Nullable
    private final ProguardMap proguardMap;
    @NotNull
    private final FeatureTracker featureTracker;
    @NotNull
    private final IdeProfilerServices ideProfilerServices;
    @NotNull
    private final Map<Integer, HeapSet> _heapSets;
    @NotNull
    private final Long2ObjectOpenHashMap<InstanceObject> instanceIndex;
    @NotNull
    private final ClassDb classDb;
    private volatile boolean hasLoaded;
    private volatile boolean isLoadingError;
    private boolean hasNativeAllocations;
    @NotNull
    private final ActivityFragmentLeakInstanceFilter activityFragmentLeakFilter;
    @NotNull
    private final BitmapDuplicationAnalyzer bitmapDuplicationAnalyzer;
    private BitmapDuplicationInstanceFilter bitmapDuplicationFilter;
    private Set<? extends CaptureObjectInstanceFilter> supportedInstanceFilters;
    @NotNull
    private final Set<CaptureObjectInstanceFilter> currentInstanceFilters;
    private final ListeningExecutorService executorService;

    public HeapDumpCaptureObject(@NotNull ProfilerClient client, @NotNull Common.Session _session, @NotNull Memory.HeapDumpInfo heapDumpInfo, @Nullable ProguardMap proguardMap, @NotNull FeatureTracker featureTracker, @NotNull IdeProfilerServices ideProfilerServices) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)_session, (String)"_session");
        Intrinsics.checkNotNullParameter((Object)heapDumpInfo, (String)"heapDumpInfo");
        Intrinsics.checkNotNullParameter((Object)featureTracker, (String)"featureTracker");
        Intrinsics.checkNotNullParameter((Object)ideProfilerServices, (String)"ideProfilerServices");
        this.client = client;
        this._session = _session;
        this.heapDumpInfo = heapDumpInfo;
        this.proguardMap = proguardMap;
        this.featureTracker = featureTracker;
        this.ideProfilerServices = ideProfilerServices;
        this._heapSets = new HashMap();
        this.instanceIndex = new Long2ObjectOpenHashMap(16, 0.5f);
        this.classDb = new ClassDb();
        this.activityFragmentLeakFilter = new ActivityFragmentLeakInstanceFilter(this.classDb);
        this.bitmapDuplicationAnalyzer = new BitmapDuplicationAnalyzer();
        this.currentInstanceFilters = new LinkedHashSet();
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("memory-heapdump-instancefilters").build()));
    }

    @VisibleForTesting
    @NotNull
    public final ClassDb getClassDb() {
        return this.classDb;
    }

    public final boolean getHasNativeAllocations() {
        return this.hasNativeAllocations;
    }

    private final Set<InstanceObject> getAllInstances() {
        HashSet<InstanceObject> hashSet;
        HashSet<InstanceObject> it = hashSet = new HashSet<InstanceObject>(this.instanceIndex.size());
        boolean bl = false;
        Collection collection = this.instanceIndex.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InstanceObject p0 = (InstanceObject)element$iv;
            boolean bl2 = false;
            it.add(p0);
        }
        return hashSet;
    }

    public final ListeningExecutorService getInstanceFilterExecutor() {
        return this.executorService;
    }

    @VisibleForTesting
    public static /* synthetic */ void getInstanceFilterExecutor$annotations() {
    }

    @Override
    @NotNull
    public String getName() {
        return "Heap Dump";
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    @NotNull
    public String getExportableExtension() {
        return "hprof";
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        MemoryProfiler.Companion.saveHeapDumpToFile(this.client, this._session, this.heapDumpInfo, outputStream, this.featureTracker);
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        return this.hasLoaded ? this._heapSets.values() : (Collection<HeapSet>)CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        return this._heapSets.getOrDefault(heapId, null);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        Stream<InstanceObject> stream;
        if (this.hasLoaded) {
            Object v0;
            block3: {
                Iterable iterable = this.getHeapSets();
                for (Object t : iterable) {
                    HeapSet it = (HeapSet)t;
                    boolean bl = false;
                    if (!(it instanceof AllHeapSet)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            Intrinsics.checkNotNull(v0);
            stream = ((HeapSet)v0).getInstancesStream();
        } else {
            Stream<InstanceObject> stream2 = Stream.empty();
            stream = stream2;
            Intrinsics.checkNotNullExpressionValue(stream2, (String)"empty(...)");
        }
        return stream;
    }

    @Override
    public long getStartTimeNs() {
        return this.heapDumpInfo.getStartTime();
    }

    @Override
    public long getEndTimeNs() {
        return this.heapDumpInfo.getEndTime();
    }

    @Override
    @NotNull
    public ClassDb getClassDatabase() {
        return this.classDb;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this._session;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        boolean bl;
        File file;
        Transport.FileResponse response = this.doGetBytesRequest();
        boolean bl2 = false;
        String string = response.getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilePath(...)");
        File file2 = file = ((CharSequence)string).length() == 0 ? null : new File(response.getFilePath());
        if (file == null || !file.exists() || file.length() == 0L) {
            boolean bl3;
            boolean it = bl3 = false;
            boolean bl4 = false;
            this.isLoadingError = true;
            bl = bl3;
        } else {
            boolean bl5;
            boolean it = bl5 = true;
            boolean bl6 = false;
            FeatureTrackerKt.trackLoading(this.ideProfilerServices.getFeatureTracker(), AndroidProfilerEvent.Loading.Type.HPROF, (int)(file.length() / (long)1024), (Function0<Long>)((Function0)() -> HeapDumpCaptureObject.load$lambda$6$lambda$5$lambda$3(this)), () -> HeapDumpCaptureObject.load$lambda$6$lambda$5$lambda$4(this, file));
            bl = bl5;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void load(@NotNull InMemoryBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        NativeRegistryPostProcessor nativeRegistryPostProcessor = new NativeRegistryPostProcessor();
        DataBuffer dataBuffer = (DataBuffer)buffer;
        ProguardMap proguardMap = this.proguardMap;
        if (proguardMap == null) {
            proguardMap = new ProguardMap();
        }
        Snapshot snapshot = Snapshot.Companion.createSnapshot(dataBuffer, proguardMap, CollectionsKt.listOf((Object)nativeRegistryPostProcessor));
        snapshot.computeRetainedSizes();
        this.hasNativeAllocations = nativeRegistryPostProcessor.getHasNativeAllocations();
        this.hasLoaded = true;
        InstanceObject javaLangClassObject = snapshot.getHeaps().stream().flatMap(arg_0 -> HeapDumpCaptureObject.load$lambda$10(HeapDumpCaptureObject::load$lambda$9, arg_0)).map(arg_0 -> HeapDumpCaptureObject.load$lambda$12(arg_0 -> HeapDumpCaptureObject.load$lambda$11(this, arg_0), arg_0)).findAny().orElse(null);
        Iterable $this$associateWith$iv = snapshot.getHeaps();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Heap heap = (Heap)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            HeapSet heapSet = new HeapSet(this, it.getName(), it.getId());
            map.put(t, heapSet);
        }
        Map heapSetMappings = result$iv;
        Collection $this$toTypedArray$iv = heapSetMappings.values();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        AllHeapSet superHeap = new AllHeapSet(this, thisCollection$iv.toArray(new HeapSet[0]));
        boolean bl = false;
        superHeap.clearClassifierSets();
        this._heapSets.put(superHeap.getId(), superHeap);
        Function3 addInstanceToRightHeap = (arg_0, arg_1, arg_2) -> HeapDumpCaptureObject.load$lambda$15$lambda$14(this, superHeap, arg_0, arg_1, arg_2);
        Map $this$forEach$iv = heapSetMappings;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            Map.Entry entry2 = element$iv;
            boolean bl2 = false;
            Heap heap = (Heap)entry2.getKey();
            HeapSet heapSet = (HeapSet)entry2.getValue();
            Collection collection = heap.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getClasses(...)");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ClassObj it = (ClassObj)element$iv2;
                boolean bl3 = false;
                Long l = it.getId();
                Intrinsics.checkNotNull((Object)it);
                addInstanceToRightHeap.invoke((Object)heapSet, (Object)l, (Object)this.createClassObjectInstance(javaLangClassObject, it));
            }
            heap.forEachInstance(arg_0 -> HeapDumpCaptureObject.load$lambda$18$lambda$17(this, addInstanceToRightHeap, heapSet, arg_0));
            if (Intrinsics.areEqual((Object)"default", (Object)heap.getName()) && snapshot.getHeaps().size() != 1 && heap.getInstancesCount() <= 0) continue;
            this._heapSets.put(heap.getId(), heapSet);
        }
        this.bitmapDuplicationAnalyzer.analyze((Iterable<? extends InstanceObject>)this.getAllInstances());
        this.bitmapDuplicationFilter = new BitmapDuplicationInstanceFilter(this.bitmapDuplicationAnalyzer.getDuplicateInstances());
        Object[] objectArray = new CaptureObjectInstanceFilter[3];
        objectArray[0] = this.activityFragmentLeakFilter;
        objectArray[1] = new ProjectClassesInstanceFilter(this.ideProfilerServices);
        BitmapDuplicationInstanceFilter bitmapDuplicationInstanceFilter = this.bitmapDuplicationFilter;
        if (bitmapDuplicationInstanceFilter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bitmapDuplicationFilter");
            bitmapDuplicationInstanceFilter = null;
        }
        objectArray[2] = bitmapDuplicationInstanceFilter;
        this.supportedInstanceFilters = SetsKt.setOf((Object[])objectArray);
    }

    private final void addInstance(HeapSet heapSet, long id, InstanceObject instObj) {
        boolean bl;
        boolean bl2 = bl = !this.instanceIndex.containsKey(id);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.instanceIndex.put(id, (Object)instObj);
        heapSet.addDeltaInstanceObject(instObj);
    }

    @Override
    public boolean isDoneLoading() {
        return this.hasLoaded || this.isLoadingError;
    }

    @Override
    public boolean isError() {
        return this.isLoadingError;
    }

    @Override
    public void unload() {
        this.executorService.shutdownNow();
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        List list;
        if (this.hasNativeAllocations) {
            CaptureObject.ClassifierAttribute[] classifierAttributeArray = new CaptureObject.ClassifierAttribute[]{CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.NATIVE_SIZE, CaptureObject.ClassifierAttribute.SHALLOW_SIZE, CaptureObject.ClassifierAttribute.RETAINED_SIZE};
            list = CollectionsKt.listOf((Object[])classifierAttributeArray);
        } else {
            CaptureObject.ClassifierAttribute[] classifierAttributeArray = new CaptureObject.ClassifierAttribute[]{CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOCATIONS, CaptureObject.ClassifierAttribute.SHALLOW_SIZE, CaptureObject.ClassifierAttribute.RETAINED_SIZE};
            list = CollectionsKt.listOf((Object[])classifierAttributeArray);
        }
        return list;
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        List list;
        if (this.hasNativeAllocations) {
            CaptureObject.InstanceAttribute[] instanceAttributeArray = new CaptureObject.InstanceAttribute[]{CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.DEPTH, CaptureObject.InstanceAttribute.NATIVE_SIZE, CaptureObject.InstanceAttribute.SHALLOW_SIZE, CaptureObject.InstanceAttribute.RETAINED_SIZE};
            list = CollectionsKt.listOf((Object[])instanceAttributeArray);
        } else {
            CaptureObject.InstanceAttribute[] instanceAttributeArray = new CaptureObject.InstanceAttribute[]{CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.DEPTH, CaptureObject.InstanceAttribute.SHALLOW_SIZE, CaptureObject.InstanceAttribute.RETAINED_SIZE};
            list = CollectionsKt.listOf((Object[])instanceAttributeArray);
        }
        return list;
    }

    @Nullable
    public InstanceObject findInstanceObject(@NotNull Instance instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        return this.hasLoaded ? (InstanceObject)this.instanceIndex.get(instance.getId()) : null;
    }

    @NotNull
    public final InstanceObject createClassObjectInstance(@Nullable InstanceObject javaLangClass, @NotNull ClassObj classObj) {
        Intrinsics.checkNotNullParameter((Object)classObj, (String)"classObj");
        ClassDb.ClassEntry classEntry = this.makeEntry(classObj, javaLangClass == null ? "java.lang.Class" : classObj.getClassName());
        Instance instance = (Instance)classObj;
        Object object = javaLangClass;
        if (object == null || (object = object.getClassEntry()) == null) {
            object = classEntry;
        }
        return new HeapDumpInstanceObject(this, instance, (ClassDb.ClassEntry)object, ValueObject.ValueType.CLASS);
    }

    @Override
    @NotNull
    public ActivityFragmentLeakInstanceFilter getActivityFragmentLeakFilter() {
        return this.activityFragmentLeakFilter;
    }

    @Override
    @NotNull
    public BitmapDuplicationInstanceFilter getBitmapDuplicationFilter() {
        BitmapDuplicationInstanceFilter bitmapDuplicationInstanceFilter = this.bitmapDuplicationFilter;
        if (bitmapDuplicationInstanceFilter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bitmapDuplicationFilter");
            bitmapDuplicationInstanceFilter = null;
        }
        return bitmapDuplicationInstanceFilter;
    }

    @Override
    @NotNull
    public Set<CaptureObjectInstanceFilter> getSupportedInstanceFilters() {
        Set<CaptureObjectInstanceFilter> set = this.supportedInstanceFilters;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"supportedInstanceFilters");
            set = null;
        }
        return set;
    }

    @Override
    @NotNull
    public Set<CaptureObjectInstanceFilter> getSelectedInstanceFilters() {
        return this.currentInstanceFilters;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> addInstanceFilter(@NotNull CaptureObjectInstanceFilter filterToAdd, @NotNull Executor analyzeJoiner) {
        Intrinsics.checkNotNullParameter((Object)filterToAdd, (String)"filterToAdd");
        Intrinsics.checkNotNullParameter((Object)analyzeJoiner, (String)"analyzeJoiner");
        Set<? extends CaptureObjectInstanceFilter> set = this.supportedInstanceFilters;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"supportedInstanceFilters");
            set = null;
        }
        boolean bl = set.contains(filterToAdd);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.currentInstanceFilters.add(filterToAdd);
        ListenableFuture listenableFuture = this.executorService.submit(() -> HeapDumpCaptureObject.addInstanceFilter$lambda$21(this, filterToAdd, analyzeJoiner));
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"submit(...)");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> removeInstanceFilter(@NotNull CaptureObjectInstanceFilter filterToRemove, @NotNull Executor analyzeJoiner) {
        ListenableFuture listenableFuture;
        Intrinsics.checkNotNullParameter((Object)filterToRemove, (String)"filterToRemove");
        Intrinsics.checkNotNullParameter((Object)analyzeJoiner, (String)"analyzeJoiner");
        if (!this.currentInstanceFilters.contains(filterToRemove)) {
            ListenableFutureTask<Void> listenableFutureTask = CaptureObject.Utils.makeEmptyTask();
            Intrinsics.checkNotNullExpressionValue(listenableFutureTask, (String)"makeEmptyTask(...)");
            listenableFuture = (ListenableFuture)listenableFutureTask;
        } else {
            this.currentInstanceFilters.remove(filterToRemove);
            ListenableFuture listenableFuture2 = this.executorService.submit(() -> HeapDumpCaptureObject.removeInstanceFilter$lambda$23(this, analyzeJoiner));
            Intrinsics.checkNotNull((Object)listenableFuture2);
            listenableFuture = listenableFuture2;
        }
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> setSingleFilter(@NotNull CaptureObjectInstanceFilter filter, @NotNull Executor analyzeJoiner) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)analyzeJoiner, (String)"analyzeJoiner");
        this.currentInstanceFilters.clear();
        this.currentInstanceFilters.add(filter);
        ListenableFuture listenableFuture = this.executorService.submit(() -> HeapDumpCaptureObject.setSingleFilter$lambda$24(this, filter, analyzeJoiner));
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"submit(...)");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> removeAllFilters(@NotNull Executor analyzeJoiner) {
        Intrinsics.checkNotNullParameter((Object)analyzeJoiner, (String)"analyzeJoiner");
        this.currentInstanceFilters.clear();
        ListenableFuture listenableFuture = this.executorService.submit(() -> HeapDumpCaptureObject.removeAllFilters$lambda$25(this, analyzeJoiner));
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"submit(...)");
        return listenableFuture;
    }

    private final Void refreshInstances(Set<? extends InstanceObject> instances, Executor executor) {
        executor.execute(() -> HeapDumpCaptureObject.refreshInstances$lambda$30(this, instances));
        return null;
    }

    @Override
    public boolean canSafelyLoad() {
        Transport.FileResponse response = this.doGetBytesRequest();
        String string = response.getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilePath(...)");
        return ((CharSequence)string).length() == 0 ? false : MainMemoryProfilerStage.canSafelyLoadHprof(new File(response.getFilePath()).length());
    }

    @Override
    public boolean isGroupingSupported(@Nullable ClassGrouping grouping) {
        ClassGrouping classGrouping = grouping;
        return switch (classGrouping == null ? -1 : WhenMappings.$EnumSwitchMapping$0[classGrouping.ordinal()]) {
            case 1, 2 -> true;
            default -> false;
        };
    }

    private final Transport.FileResponse doGetBytesRequest() {
        return this.client.getTransportClient().getFile(Transport.BytesRequest.newBuilder().setStreamId(this._session.getStreamId()).setId(String.valueOf(this.heapDumpInfo.getStartTime())).build());
    }

    private final ClassDb.ClassEntry makeEntry(ClassObj $this$makeEntry, String name) {
        ClassDb.ClassEntry classEntry;
        if ($this$makeEntry.getSuperClassObj() != null) {
            long l = $this$makeEntry.getId();
            ClassObj classObj = $this$makeEntry.getSuperClassObj();
            Intrinsics.checkNotNull((Object)classObj);
            classEntry = this.classDb.registerClass(l, classObj.getId(), name, $this$makeEntry.getTotalRetainedSize());
        } else {
            classEntry = this.classDb.registerClass($this$makeEntry.getId(), name, $this$makeEntry.getTotalRetainedSize());
        }
        ClassDb.ClassEntry classEntry2 = classEntry;
        Intrinsics.checkNotNull((Object)classEntry2);
        return classEntry2;
    }

    static /* synthetic */ ClassDb.ClassEntry makeEntry$default(HeapDumpCaptureObject heapDumpCaptureObject, ClassObj classObj, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeEntry");
        }
        if ((n & 1) != 0) {
            string = classObj.getClassName();
        }
        return heapDumpCaptureObject.makeEntry(classObj, string);
    }

    private static final long load$lambda$6$lambda$5$lambda$3(HeapDumpCaptureObject this$0) {
        return this$0.instanceIndex.size();
    }

    private static final Unit load$lambda$6$lambda$5$lambda$4(HeapDumpCaptureObject this$0, File $file) {
        this$0.load(new InMemoryBuffer($file));
        return Unit.INSTANCE;
    }

    private static final boolean load$lambda$9$lambda$7(ClassObj it) {
        return Intrinsics.areEqual((Object)"java.lang.Class", (Object)it.getClassName());
    }

    private static final boolean load$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Stream load$lambda$9(Heap h) {
        return h.getClasses().stream().filter(arg_0 -> HeapDumpCaptureObject.load$lambda$9$lambda$8(HeapDumpCaptureObject::load$lambda$9$lambda$7, arg_0));
    }

    private static final Stream load$lambda$10(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final InstanceObject load$lambda$11(HeapDumpCaptureObject this$0, ClassObj it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.createClassObjectInstance(null, it);
    }

    private static final InstanceObject load$lambda$12(Function1 $tmp0, Object p0) {
        return (InstanceObject)$tmp0.invoke(p0);
    }

    private static final Unit load$lambda$15$lambda$14(HeapDumpCaptureObject this$0, AllHeapSet $superHeap, HeapSet heapSet, long id, InstanceObject classInst) {
        Intrinsics.checkNotNullParameter((Object)heapSet, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)classInst, (String)"classInst");
        this$0.addInstance($superHeap, id, classInst);
        return Unit.INSTANCE;
    }

    private static final Boolean load$lambda$18$lambda$17(HeapDumpCaptureObject this$0, Function3 $addInstanceToRightHeap, HeapSet $heapSet, Instance instance) {
        boolean bl;
        ClassObj classObj = instance.getClassObj();
        Intrinsics.checkNotNull((Object)classObj);
        boolean bl2 = bl = !Intrinsics.areEqual((Object)"java.lang.Class", (Object)classObj.getClassName());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ClassObj classObj2 = instance.getClassObj();
        Intrinsics.checkNotNull((Object)classObj2);
        ClassDb.ClassEntry classEntry = HeapDumpCaptureObject.makeEntry$default(this$0, classObj2, null, 1, null);
        Long l = instance.getId();
        Intrinsics.checkNotNull((Object)instance);
        $addInstanceToRightHeap.invoke((Object)$heapSet, (Object)l, (Object)new HeapDumpInstanceObject(this$0, instance, classEntry, null));
        return true;
    }

    private static final Stream addInstanceFilter$lambda$21$lambda$19(HeapSet it) {
        return it.getInstancesStream();
    }

    private static final Stream addInstanceFilter$lambda$21$lambda$20(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Void addInstanceFilter$lambda$21(HeapDumpCaptureObject this$0, CaptureObjectInstanceFilter $filterToAdd, Executor $analyzeJoiner) {
        Set currentInstances = this$0._heapSets.values().stream().flatMap(arg_0 -> HeapDumpCaptureObject.addInstanceFilter$lambda$21$lambda$20(HeapDumpCaptureObject::addInstanceFilter$lambda$21$lambda$19, arg_0)).collect(Collectors.toSet());
        Intrinsics.checkNotNull(currentInstances);
        return this$0.refreshInstances((Set<? extends InstanceObject>)$filterToAdd.filter(currentInstances), $analyzeJoiner);
    }

    /*
     * WARNING - void declaration
     */
    private static final Void removeInstanceFilter$lambda$23(HeapDumpCaptureObject this$0, Executor $analyzeJoiner) {
        void $this$fold$iv;
        void initial$iv;
        Iterable iterable = this$0.currentInstanceFilters;
        Set<InstanceObject> set = this$0.getAllInstances();
        HeapDumpCaptureObject heapDumpCaptureObject = this$0;
        boolean $i$f$fold = false;
        Set accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void filter;
            CaptureObjectInstanceFilter captureObjectInstanceFilter = (CaptureObjectInstanceFilter)element$iv;
            void instances = accumulator$iv;
            boolean bl = false;
            accumulator$iv = filter.filter((Set<? extends InstanceObject>)instances);
        }
        return heapDumpCaptureObject.refreshInstances(accumulator$iv, $analyzeJoiner);
    }

    private static final Void setSingleFilter$lambda$24(HeapDumpCaptureObject this$0, CaptureObjectInstanceFilter $filter, Executor $analyzeJoiner) {
        return this$0.refreshInstances((Set<? extends InstanceObject>)$filter.filter(this$0.getAllInstances()), $analyzeJoiner);
    }

    private static final Void removeAllFilters$lambda$25(HeapDumpCaptureObject this$0, Executor $analyzeJoiner) {
        return this$0.refreshInstances(this$0.getAllInstances(), $analyzeJoiner);
    }

    private static final void refreshInstances$lambda$30(HeapDumpCaptureObject this$0, Set $instances) {
        HeapSet heapSet;
        block6: {
            HeapSet it;
            Iterable $this$forEach$iv = this$0._heapSets.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (HeapSet)element$iv;
                boolean bl = false;
                it.clearClassifierSets();
            }
            Iterable iterable = this$0._heapSets.values();
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                HeapSet it2 = it = iterator.next();
                boolean bl = false;
                if (!(it2 instanceof AllHeapSet)) continue;
                heapSet = it;
                break block6;
            }
            heapSet = null;
        }
        HeapSet h = heapSet;
        if (h == null) {
            Iterable $this$forEach$iv = $instances;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InstanceObject it = (InstanceObject)element$iv;
                boolean bl = false;
                HeapSet heapSet2 = this$0._heapSets.get(it.getHeapId());
                Intrinsics.checkNotNull((Object)heapSet2);
                heapSet2.addDeltaInstanceObject(it);
            }
        } else {
            Iterable $this$forEach$iv = $instances;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InstanceObject it = (InstanceObject)element$iv;
                boolean bl = false;
                h.addDeltaInstanceObject(it);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassGrouping.values().length];
            try {
                nArray[ClassGrouping.ARRANGE_BY_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassGrouping.ARRANGE_BY_PACKAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

