/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profilers.memory.adapters.ArrayObject;
import com.android.tools.profilers.memory.adapters.BitmapDecoder;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidBitmapDataProvider
implements BitmapDecoder.BitmapDataProvider {
    private static final Logger LOG = Logger.getInstance(AndroidBitmapDataProvider.class);
    public static final String BITMAP_FQCN = "android.graphics.Bitmap";
    public static final String BITMAP_DRAWABLE_FQCN = "android.graphics.drawable.BitmapDrawable";
    private byte[] myBuffer = null;
    private boolean myIsMutable = false;
    private int myWidth = -1;
    private int myHeight = -1;

    @Nullable
    public static AndroidBitmapDataProvider createDecoder(@NotNull InstanceObject instance) {
        if ((instance = AndroidBitmapDataProvider.getBitmapClassInstance(instance)) == null) {
            return null;
        }
        Integer width = null;
        Integer height = null;
        boolean isMutable = false;
        byte[] dataBuffer = null;
        Long nativePtr = null;
        InstanceObject shadowKlassInstance = null;
        for (FieldObject field : instance.getFields()) {
            String fieldName = field.getFieldName();
            Object fieldValue = field.getValue();
            if ("shadow$_klass_".equals(fieldName) && fieldValue instanceof InstanceObject) {
                shadowKlassInstance = field.getAsInstance();
                continue;
            }
            if ("mBuffer".equals(fieldName)) {
                dataBuffer = AndroidBitmapDataProvider.getDataBufferFromMBufferField(field);
                continue;
            }
            if ("mIsMutable".equals(fieldName) && fieldValue instanceof Boolean) {
                isMutable = (Boolean)fieldValue;
                continue;
            }
            if ("mWidth".equals(fieldName) && fieldValue instanceof Integer) {
                width = (Integer)fieldValue;
                continue;
            }
            if ("mHeight".equals(fieldName) && fieldValue instanceof Integer) {
                height = (Integer)fieldValue;
                continue;
            }
            if (!"mNativePtr".equals(fieldName) || !(fieldValue instanceof Long)) continue;
            nativePtr = (Long)fieldValue;
        }
        if (dataBuffer == null && shadowKlassInstance != null && nativePtr != null) {
            dataBuffer = AndroidBitmapDataProvider.getDataBufferFromShadowKlass(shadowKlassInstance, nativePtr);
        }
        if (dataBuffer == null || width == null || height == null) {
            return null;
        }
        return new AndroidBitmapDataProvider(dataBuffer, isMutable, width, height);
    }

    private static byte[] getDataBufferFromMBufferField(@NotNull FieldObject mBufferField) {
        InstanceObject bufferInstance = mBufferField.getAsInstance();
        if (bufferInstance == null) {
            return null;
        }
        ArrayObject arrayObject = bufferInstance.getArrayObject();
        if (arrayObject == null || arrayObject.getArrayElementType() != ValueObject.ValueType.BYTE) {
            return null;
        }
        byte[] buffer = arrayObject.getAsByteArray();
        if (buffer != null && buffer.length > 0) {
            return buffer;
        }
        return null;
    }

    private static byte[] getDataBufferFromShadowKlass(@NotNull InstanceObject shadowKlassInstance, @NotNull Long nativePtr) {
        byte[] imageBuffer = AndroidBitmapDataProvider.getDumpDataFromShadowKlass(shadowKlassInstance, nativePtr);
        if (imageBuffer == null) {
            return null;
        }
        byte[] decompressedPixelData = AndroidBitmapDataProvider.decompressImage(imageBuffer);
        if (decompressedPixelData != null && decompressedPixelData.length > 0) {
            return decompressedPixelData;
        }
        LOG.debug("Decoded pixel data is null or empty after image decoding. dataBuffer not updated for native pointer: " + nativePtr);
        return null;
    }

    private static byte[] getDumpDataFromShadowKlass(@NotNull InstanceObject shadowKlassInstance, @NotNull Long nativePtr) {
        InstanceObject dumpDataInstance = AndroidBitmapDataProvider.getNestedInstanceObject(shadowKlassInstance, "dumpData");
        if (dumpDataInstance == null) {
            return null;
        }
        return AndroidBitmapDataProvider.processBuffersFromDumpData(dumpDataInstance, nativePtr);
    }

    private static byte[] processBuffersFromDumpData(@NotNull InstanceObject dumpDataInstance, @NotNull Long nativePtr) {
        InstanceObject buffersInstance = AndroidBitmapDataProvider.getNestedInstanceObject(dumpDataInstance, "buffers");
        InstanceObject nativesInstance = AndroidBitmapDataProvider.getNestedInstanceObject(dumpDataInstance, "natives");
        if (buffersInstance == null || nativesInstance == null) {
            LOG.debug("Required 'buffers' or 'natives' fields not found or are null in dumpDataInstance.");
            return null;
        }
        List<FieldObject> buffersFields = buffersInstance.getFields();
        List<FieldObject> nativesFields = nativesInstance.getFields();
        if (buffersFields.size() != nativesFields.size()) {
            LOG.warn(String.format(Locale.US, "Mismatch in size between 'buffers' (%d) and 'natives' (%d) fields. Cannot process.", buffersFields.size(), nativesFields.size()));
            return null;
        }
        InstanceObject matchingBufferInstance = null;
        for (int i = 0; i < nativesFields.size(); ++i) {
            FieldObject bufferField;
            Object nativeValue;
            FieldObject nativeField = nativesFields.get(i);
            if (nativeField == null || !((nativeValue = nativeField.getValue()) instanceof Long) || !Objects.equals(nativePtr, nativeValue) || (bufferField = buffersFields.get(i)) == null) continue;
            matchingBufferInstance = bufferField.getAsInstance();
            break;
        }
        if (matchingBufferInstance == null) {
            LOG.warn("No matching buffer found for native pointer: " + nativePtr);
            return null;
        }
        ArrayObject arrayObject = matchingBufferInstance.getArrayObject();
        if (arrayObject == null) {
            LOG.warn("Buffer instance does not contain an ArrayObject.");
            return null;
        }
        if (arrayObject.getArrayElementType() != ValueObject.ValueType.BYTE) {
            LOG.warn("ArrayObject element type is not BYTE. Found: " + arrayObject.getArrayElementType());
            return null;
        }
        return arrayObject.getAsByteArray();
    }

    public static byte[] decompressImage(byte[] compressedBytes) {
        BufferedImage bufferedImage;
        if (compressedBytes == null) {
            LOG.debug("Input image bytes are null.");
            return null;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(compressedBytes);){
            bufferedImage = ImageIO.read(bais);
        }
        catch (IOException e) {
            LOG.warn("IOException during image decompression: " + e.getMessage(), (Throwable)e);
            return null;
        }
        if (bufferedImage == null) {
            LOG.debug("Failed to read BufferedImage from PNG bytes. ImageIO.read returned null. This might indicate invalid PNG data.");
            return null;
        }
        DataBuffer buffer = bufferedImage.getRaster().getDataBuffer();
        if (buffer instanceof DataBufferByte) {
            DataBufferByte byteBuffer = (DataBufferByte)buffer;
            return byteBuffer.getData();
        }
        LOG.warn("BufferedImage data buffer is not of type DataBufferByte. Found: " + buffer.getClass().getName());
        return null;
    }

    private static InstanceObject getNestedInstanceObject(@NotNull InstanceObject parentInstance, @NotNull String fieldName) {
        return parentInstance.getFields().stream().filter(field -> fieldName.equals(field.getFieldName()) && field.getValue() instanceof InstanceObject).map(FieldObject::getAsInstance).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private AndroidBitmapDataProvider(@NotNull byte[] buffer, boolean isMutable, int width, int height) {
        this.myBuffer = buffer;
        this.myIsMutable = isMutable;
        this.myWidth = width;
        this.myHeight = height;
    }

    @Override
    @Nullable
    public BitmapDecoder.PixelFormat getBitmapConfigName() {
        int area = this.myWidth * this.myHeight;
        int pixelSize = this.myBuffer.length / area;
        if (!this.myIsMutable && this.myBuffer.length % area != 0 || this.myIsMutable && area > this.myBuffer.length) {
            return null;
        }
        return switch (pixelSize) {
            case 4 -> BitmapDecoder.PixelFormat.ARGB_8888;
            case 3 -> BitmapDecoder.PixelFormat.BGR_888;
            case 2 -> BitmapDecoder.PixelFormat.RGB_565;
            default -> BitmapDecoder.PixelFormat.ALPHA_8;
        };
    }

    @Override
    @Nullable
    public Dimension getDimension() {
        return this.myWidth < 0 || this.myHeight < 0 ? null : new Dimension(this.myWidth, this.myHeight);
    }

    @Override
    @Nullable
    public byte[] getPixelBytes(@NotNull Dimension size) {
        return this.myBuffer;
    }

    @Nullable
    public static InstanceObject getBitmapClassInstance(@NotNull InstanceObject instance) {
        String className = instance.getClassEntry().getClassName();
        if (BITMAP_FQCN.equals(className)) {
            return instance;
        }
        if (BITMAP_DRAWABLE_FQCN.equals(className)) {
            return AndroidBitmapDataProvider.getBitmapFromDrawable(instance);
        }
        return null;
    }

    @Nullable
    private static InstanceObject getBitmapFromDrawable(@NotNull InstanceObject instance) {
        InstanceObject bitmapState = AndroidBitmapDataProvider.getBitmapStateFromBitmapDrawable(instance);
        if (bitmapState == null) {
            return null;
        }
        for (FieldObject field : bitmapState.getFields()) {
            String className;
            InstanceObject value;
            if (!"mBitmap".equals(field.getFieldName()) || (value = field.getAsInstance()) == null || !BITMAP_FQCN.equals(className = value.getClassEntry().getClassName())) continue;
            return value;
        }
        return null;
    }

    @Nullable
    private static InstanceObject getBitmapStateFromBitmapDrawable(@NotNull InstanceObject bitmapDrawable) {
        for (FieldObject field : bitmapDrawable.getFields()) {
            String className;
            InstanceObject value;
            if (!"mBitmapState".equals(field.getFieldName()) || (value = field.getAsInstance()) == null || !"android.graphics.drawable.BitmapDrawable$BitmapState".equals(className = value.getClassEntry().getClassName())) continue;
            return value;
        }
        return null;
    }
}

