/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.LiveDataModel;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.MemoryStageLegends;
import com.android.tools.profilers.memory.MemoryUsageTooltip;
import com.android.tools.profilers.memory.adapters.MemoryDataProvider;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class LiveMemoryFootprintModel
extends LiveDataModel {
    private final List<Updatable> myUpdatables;
    private final StudioProfilers myProfilers;
    private final MemoryUsageTooltip myMemoryUsageTooltip;
    private final MemoryDataProvider myMemoryDataProvider;

    public LiveMemoryFootprintModel(@NotNull StudioProfilers profilers) {
        super(profilers);
        this.myProfilers = profilers;
        this.myMemoryDataProvider = new MemoryDataProvider(profilers, profilers.getTimeline());
        this.myUpdatables = ImmutableList.of((Object)((Object)this.myMemoryDataProvider.getDetailedMemoryUsage()));
        this.myMemoryUsageTooltip = new MemoryUsageTooltip(this.getTooltipLegends(), this.isLiveAllocationTrackingReady());
    }

    @VisibleForTesting
    LiveMemoryFootprintModel(@NotNull StudioProfilers profilers, @NotNull MemoryDataProvider memoryDataProvider) {
        super(profilers);
        this.myProfilers = profilers;
        this.myMemoryDataProvider = memoryDataProvider;
        this.myUpdatables = ImmutableList.of((Object)((Object)this.myMemoryDataProvider.getDetailedMemoryUsage()));
        this.myMemoryUsageTooltip = new MemoryUsageTooltip(this.getTooltipLegends(), this.isLiveAllocationTrackingReady());
    }

    public MemoryDataProvider getMemoryDataProvider() {
        return this.myMemoryDataProvider;
    }

    public StudioProfilers getStudioProfilers() {
        return this.myProfilers;
    }

    public DetailedMemoryUsage getDetailedMemoryUsage() {
        return this.myMemoryDataProvider.getDetailedMemoryUsage();
    }

    public MemoryStageLegends getLegends() {
        return this.myMemoryDataProvider.getLegends();
    }

    public ClampedAxisComponentModel getMemoryAxis() {
        return this.myMemoryDataProvider.getMemoryAxis();
    }

    public ClampedAxisComponentModel getObjectAxis() {
        return this.myMemoryDataProvider.getObjectsAxis();
    }

    public Boolean isLiveAllocationTrackingReady() {
        return this.myMemoryDataProvider.isLiveAllocationTrackingReady();
    }

    public MemoryStageLegends getTooltipLegends() {
        return this.myMemoryDataProvider.getTooltipLegends();
    }

    public RangeSelectionModel getRangeSelectionModel() {
        return new RangeSelectionModel(this.getTimeline().getSelectionRange(), this.getTimeline().getViewRange());
    }

    @Override
    public void enter() {
        this.myUpdatables.forEach(updatable -> this.myProfilers.getUpdater().register(updatable));
    }

    @Override
    public String getName() {
        return "LIVE_MEMORY";
    }

    @Override
    public TooltipModel getTooltip() {
        return this.myMemoryUsageTooltip;
    }

    @Override
    public void exit() {
        this.myUpdatables.forEach(updatable -> this.myProfilers.getUpdater().unregister(updatable));
    }
}

