/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.BaseMemoryProfilerStage;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.CaptureDataSeries;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureObjectLoader;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.tasks.TaskEventTrackerUtils;
import com.android.tools.profilers.tasks.TaskFinishedState;
import com.android.tools.profilers.tasks.TaskStartFailedMetadata;
import com.android.tools.profilers.tasks.TaskStopFailedMetadata;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 I2\u00020\u0001:\u0001IB9\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010,\u001a\u00020\u000bH\u0002J\b\u0010-\u001a\u00020.H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020.00H\u0016J\b\u00101\u001a\u00020\u0017H\u0016J\n\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u00104\u001a\u00020\u000bH\u0014J&\u00105\u001a\u00020\u000b2\u0014\u00106\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020#0\"072\u0006\u00108\u001a\u000209H\u0014J\u0006\u0010:\u001a\u00020\u000bJ\u0006\u0010;\u001a\u00020\u0017J\b\u0010<\u001a\u00020\u000bH\u0016J\b\u0010=\u001a\u00020\u000bH\u0016J\b\u0010>\u001a\u00020\u000bH\u0007J\u0006\u0010@\u001a\u00020\u000bJ\u0006\u0010A\u001a\u00020\u000bJ\u0018\u0010B\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020\u00172\u0006\u0010D\u001a\u00020\u0017H\u0002J\u0006\u0010E\u001a\u00020\u000bJ\b\u0010F\u001a\u00020\u000bH\u0002J\b\u0010G\u001a\u00020HH\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0019R\u0016\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010 \u001a \u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020# \u001f*\f\u0012\u0006\b\u0001\u0012\u00020#\u0018\u00010\"0\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010$\u001a&\u0012\"\u0012 \u0012\u001c\u0012\u001a\u0012\u0006\b\u0001\u0012\u00020# \u001f*\f\u0012\u0006\b\u0001\u0012\u00020#\u0018\u00010\"0\"0!0%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0019\"\u0004\b*\u0010+R\u0011\u0010?\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0019\u00a8\u0006J"}, d2={"Lcom/android/tools/profilers/memory/AllocationStage;", "Lcom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "loader", "Lcom/android/tools/profilers/memory/CaptureObjectLoader;", "initMinUs", "", "initMaxUs", "stopTask", "Lkotlin/Function0;", "", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/profilers/memory/CaptureObjectLoader;DDLkotlin/jvm/functions/Function0;)V", "getStopTask", "()Lkotlin/jvm/functions/Function0;", "value", "minTrackingTimeUs", "getMinTrackingTimeUs", "()D", "maxTrackingTimeUs", "getMaxTrackingTimeUs", "hasStartedTracking", "", "getHasStartedTracking", "()Z", "hasEndedTracking", "getHasEndedTracking", "isStatic", "lastTrackingEvent", "Lcom/android/tools/profiler/proto/Common$Event;", "kotlin.jvm.PlatformType", "allocationDurationData", "Lcom/android/tools/adtui/model/DurationDataModel;", "Lcom/android/tools/profilers/memory/CaptureDurationData;", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "captureSeries", "", "getCaptureSeries", "()Ljava/util/List;", "hasAgentError", "getHasAgentError", "setHasAgentError", "(Z)V", "setupTrackingEventListener", "getParentStage", "Lcom/android/tools/profilers/memory/MainMemoryProfilerStage;", "getHomeStageClass", "Ljava/lang/Class;", "isInteractingWithTimeline", "getConfirmExitMessage", "", "selectCaptureFromSelectionRange", "onCaptureToSelect", "captureToSelect", "Lcom/android/tools/adtui/model/SeriesData;", "loadJoiner", "Ljava/util/concurrent/Executor;", "selectAll", "isAlmostAllSelected", "enter", "exit", "startLiveDataTimeline", "isAgentAttached", "stopTrackingDueToUnattachableAgent", "startTracking", "trackAllocations", "enable", "endSession", "stopTracking", "onNewData", "getStageType", "Lcom/google/wireless/android/sdk/stats/AndroidProfilerEvent$Stage;", "Companion", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nAllocationStage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllocationStage.kt\ncom/android/tools/profilers/memory/AllocationStage\n+ 2 BaseStreamingMemoryProfilerStage.kt\ncom/android/tools/profilers/memory/BaseStreamingMemoryProfilerStage\n*L\n1#1,285:1\n265#2,4:286\n*S KotlinDebug\n*F\n+ 1 AllocationStage.kt\ncom/android/tools/profilers/memory/AllocationStage\n*L\n50#1:286,4\n*E\n"})
public final class AllocationStage
extends BaseStreamingMemoryProfilerStage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Unit> stopTask;
    private double minTrackingTimeUs;
    private double maxTrackingTimeUs;
    private Common.Event lastTrackingEvent;
    @NotNull
    private final DurationDataModel<CaptureDurationData<? extends CaptureObject>> allocationDurationData;
    private boolean hasAgentError;

    /*
     * WARNING - void declaration
     */
    private AllocationStage(StudioProfilers profilers, CaptureObjectLoader loader, double initMinUs, double initMaxUs, Function0<Unit> stopTask2) {
        super(profilers, loader);
        void p3;
        void p2;
        void p1;
        void p0;
        this.stopTask = stopTask2;
        this.minTrackingTimeUs = initMinUs;
        this.maxTrackingTimeUs = initMaxUs;
        this.lastTrackingEvent = Common.Event.getDefaultInstance();
        BaseStreamingMemoryProfilerStage this_$iv = this;
        boolean $i$f$makeModel = false;
        BaseStreamingMemoryProfilerStage this_$iv$iv = this_$iv;
        boolean $i$f$applyDataSeriesConstructor = false;
        ProfilerClient profilerClient = this_$iv$iv.getStudioProfilers().getClient();
        Intrinsics.checkNotNullExpressionValue((Object)profilerClient, (String)"getClient(...)");
        BaseMemoryProfilerStage baseMemoryProfilerStage = this_$iv$iv;
        FeatureTracker featureTracker = this_$iv$iv.getStudioProfilers().getIdeServices().getFeatureTracker();
        Common.Session session = BaseStreamingMemoryProfilerStage.access$getSessionData(this_$iv$iv);
        ProfilerClient profilerClient2 = profilerClient;
        BaseStreamingMemoryProfilerStage baseStreamingMemoryProfilerStage = this_$iv;
        AllocationStage allocationStage = this;
        boolean bl = false;
        DataSeries<CaptureDurationData<? extends CaptureObject>> dataSeries = CaptureDataSeries.ofAllocationInfos((ProfilerClient)p0, (Common.Session)p1, (FeatureTracker)p2, (BaseMemoryProfilerStage)p3);
        allocationStage.allocationDurationData = BaseStreamingMemoryProfilerStage.access$makeModel(baseStreamingMemoryProfilerStage, dataSeries);
    }

    /* synthetic */ AllocationStage(StudioProfilers studioProfilers, CaptureObjectLoader captureObjectLoader, double d, double d2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            function0 = AllocationStage::_init_$lambda$0;
        }
        this(studioProfilers, captureObjectLoader, d, d2, (Function0<Unit>)function0);
    }

    @NotNull
    public final Function0<Unit> getStopTask() {
        return this.stopTask;
    }

    public final double getMinTrackingTimeUs() {
        return this.minTrackingTimeUs;
    }

    public final double getMaxTrackingTimeUs() {
        return this.maxTrackingTimeUs;
    }

    public final boolean getHasStartedTracking() {
        return this.minTrackingTimeUs > Double.NEGATIVE_INFINITY;
    }

    public final boolean getHasEndedTracking() {
        return this.maxTrackingTimeUs < Double.POSITIVE_INFINITY;
    }

    public final boolean isStatic() {
        return this.getHasStartedTracking() && this.getHasEndedTracking();
    }

    @Override
    @NotNull
    public List<DurationDataModel<CaptureDurationData<? extends CaptureObject>>> getCaptureSeries() {
        return CollectionsKt.listOf(this.allocationDurationData);
    }

    public final boolean getHasAgentError() {
        return this.hasAgentError;
    }

    public final void setHasAgentError(boolean bl) {
        this.hasAgentError = bl;
    }

    private final void setupTrackingEventListener() {
        if (this.getStudioProfilers().getSessionsManager().isSessionAlive() && this.isLiveAllocationTrackingSupported()) {
            long currentRangeMax = TimeUnit.MICROSECONDS.toNanos((long)this.getStudioProfilers().getTimeline().getDataRange().getMax());
            TransportEventListener listener = new TransportEventListener(Common.Event.Kind.MEMORY_ALLOC_TRACKING, this.getStudioProfilers().getIdeServices().getMainExecutor(), AllocationStage::setupTrackingEventListener$lambda$1, () -> AllocationStage.setupTrackingEventListener$lambda$2(this), () -> AllocationStage.setupTrackingEventListener$lambda$3(this), null, () -> AllocationStage.setupTrackingEventListener$lambda$4(currentRangeMax), null, arg_0 -> AllocationStage.setupTrackingEventListener$lambda$5(this, arg_0), 128, null);
            this.getStudioProfilers().getTransportPoller().registerListener(listener);
        }
    }

    @NotNull
    public MainMemoryProfilerStage getParentStage() {
        return new MainMemoryProfilerStage(this.getStudioProfilers(), this.getLoader());
    }

    @Override
    @NotNull
    public Class<MainMemoryProfilerStage> getHomeStageClass() {
        return MainMemoryProfilerStage.class;
    }

    @Override
    public boolean isInteractingWithTimeline() {
        return false;
    }

    @Override
    @Nullable
    public String getConfirmExitMessage() {
        return this.getHasEndedTracking() ? null : "Going back will end allocation recording. Proceed?";
    }

    @Override
    protected void selectCaptureFromSelectionRange() {
        if (this.getUpdateCaptureOnSelection()) {
            this.setUpdateCaptureOnSelection(false);
            Range range = this.getTimeline().getSelectionRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSelectionRange(...)");
            this.doSelectCaptureDuration(this.getIntersectingCaptureDuration(range), SwingUtilities::invokeLater);
            this.setUpdateCaptureOnSelection(true);
        }
    }

    @Override
    protected void onCaptureToSelect(@NotNull SeriesData<CaptureDurationData<? extends CaptureObject>> captureToSelect, @NotNull Executor loadJoiner) {
        Intrinsics.checkNotNullParameter(captureToSelect, (String)"captureToSelect");
        Intrinsics.checkNotNullParameter((Object)loadJoiner, (String)"loadJoiner");
        this.doSelectCaptureDuration((CaptureDurationData)((Object)captureToSelect.value), loadJoiner);
    }

    public final void selectAll() {
        this.getTimeline().getSelectionRange().set(this.minTrackingTimeUs, Math.min(this.maxTrackingTimeUs, this.getTimeline().getDataRange().getMax()));
    }

    public final boolean isAlmostAllSelected() {
        return AllocationStage.isAlmostAllSelected$almostEqual(this.getTimeline().getSelectionRange().getMin(), this.minTrackingTimeUs) && AllocationStage.isAlmostAllSelected$almostEqual(this.getTimeline().getSelectionRange().getMax(), Math.min(this.maxTrackingTimeUs, this.getTimeline().getDataRange().getMax()));
    }

    @Override
    public void enter() {
        this.logEnterStage();
        super.enter();
        if (this.isStatic()) {
            this.getTimeline().getViewRange().set(this.minTrackingTimeUs, this.maxTrackingTimeUs);
            this.getTimeline().getSelectionRange().set(this.minTrackingTimeUs, this.maxTrackingTimeUs);
            if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
                StudioProfilers studioProfilers = this.getStudioProfilers();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
                TaskEventTrackerUtils.trackTaskFinished(studioProfilers, false, TaskFinishedState.COMPLETED);
            }
        } else {
            this.startTracking();
        }
    }

    @Override
    public void exit() {
        block0: {
            super.exit();
            this.stopTracking();
            this.getTimeline().getSelectionRange().removeDependencies((AspectObserver)this);
            CaptureObject captureObject = this.getCaptureSelection().getSelectedCapture();
            if (captureObject == null) break block0;
            captureObject.unload();
        }
    }

    @VisibleForTesting
    public final void startLiveDataTimeline() {
        boolean bl;
        boolean bl2 = bl = this.getLiveAllocationSamplingMode() != BaseStreamingMemoryProfilerStage.LiveAllocationSamplingMode.NONE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = !this.lastTrackingEvent.getIsEnded();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.minTrackingTimeUs = TimeUnit.NANOSECONDS.toMicros(this.lastTrackingEvent.getTimestamp() + (long)1000);
        this.getTimeline().getSelectionRange().set(this.minTrackingTimeUs, this.minTrackingTimeUs);
        this.getTimeline().getViewRange().set(this.minTrackingTimeUs, this.minTrackingTimeUs);
        this.getTimeline().getDataRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::onNewData);
    }

    public final boolean isAgentAttached() {
        return this.getStudioProfilers().isAgentAttached();
    }

    public final void stopTrackingDueToUnattachableAgent() {
        this.stopTracking();
        this.hasAgentError = true;
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
            StudioProfilers studioProfilers = this.getStudioProfilers();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
            Memory.TrackStatus trackStatus = Memory.TrackStatus.newBuilder().setStatus(Memory.TrackStatus.Status.AGENT_UNATTACHABLE).build();
            TaskEventTrackerUtils.trackStartTaskFailed(studioProfilers, this.getStudioProfilers().getSessionsManager().isSessionAlive(), new TaskStartFailedMetadata(null, trackStatus, null));
        }
        this.getAspect().changed((Enum)MemoryProfilerAspect.LIVE_ALLOCATION_STATUS);
    }

    public final void startTracking() {
        Range range;
        if (Common.AgentData.Status.UNATTACHABLE == this.getStudioProfilers().getAgentData().getStatus()) {
            this.stopTrackingDueToUnattachableAgent();
            return;
        }
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled() && !this.isAgentAttached()) {
            return;
        }
        this.getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.LIVE_ALLOCATION_STATUS, () -> AllocationStage.startTracking$lambda$6(this));
        this.setupTrackingEventListener();
        this.trackAllocations(true, false);
        Range $this$startTracking_u24lambda_u248 = range = this.getTimeline().getSelectionRange();
        boolean bl = false;
        $this$startTracking_u24lambda_u248.addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> AllocationStage.startTracking$lambda$8$lambda$7(this, $this$startTracking_u24lambda_u248));
    }

    private final void trackAllocations(boolean enable, boolean endSession) {
        StudioProfilers studioProfilers = this.getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
        MemoryProfiler.Companion.trackAllocations(studioProfilers, this.getSessionData(), enable, endSession, arg_0 -> AllocationStage.trackAllocations$lambda$9(enable, this, arg_0));
    }

    public final void stopTracking() {
        this.getLogger().info("PROFILER: Java/Kotlin Allocations capture stop attempted");
        if (!this.getHasEndedTracking()) {
            this.getAspect().removeDependencies((AspectObserver)this);
            this.getTimeline().getDataRange().removeDependencies((AspectObserver)this);
            this.maxTrackingTimeUs = this.getTimeline().getDataRange().getMax();
        }
        this.trackAllocations(false, true);
    }

    private final void onNewData() {
        boolean bl;
        StreamingTimeline $this$onNewData_u24lambda_u2410 = this.getTimeline();
        boolean bl2 = false;
        boolean bl3 = bl = !this.getHasEndedTracking();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        double dataMax = $this$onNewData_u24lambda_u2410.getDataRange().getMax();
        if (dataMax >= $this$onNewData_u24lambda_u2410.getViewRange().getMax()) {
            double initialSessionLengthUs = TimeUnit.SECONDS.toMicros(15L);
            double length = Math.max((double)2 * (dataMax - this.minTrackingTimeUs), initialSessionLengthUs);
            $this$onNewData_u24lambda_u2410.getViewRange().set(this.minTrackingTimeUs, this.minTrackingTimeUs + length);
        } else if (Random.Default.nextBoolean()) {
            Range range = $this$onNewData_u24lambda_u2410.getViewRange();
            double d = range.getMax();
            range.setMax(d + 1.0);
        } else {
            Range range = $this$onNewData_u24lambda_u2410.getViewRange();
            double d = range.getMax();
            range.setMax(d + -1.0);
        }
        if ($this$onNewData_u24lambda_u2410.getSelectionRange().getMin() == this.minTrackingTimeUs || $this$onNewData_u24lambda_u2410.getSelectionRange().isEmpty()) {
            $this$onNewData_u24lambda_u2410.getSelectionRange().set(this.minTrackingTimeUs, dataMax);
        }
    }

    @Override
    @NotNull
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.MEMORY_JVM_RECORDING_STAGE;
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final boolean setupTrackingEventListener$lambda$1(Common.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final long setupTrackingEventListener$lambda$2(AllocationStage this$0) {
        return this$0.getSessionData().getStreamId();
    }

    private static final int setupTrackingEventListener$lambda$3(AllocationStage this$0) {
        return this$0.getSessionData().getPid();
    }

    private static final long setupTrackingEventListener$lambda$4(long $currentRangeMax) {
        return $currentRangeMax;
    }

    private static final boolean setupTrackingEventListener$lambda$5(AllocationStage this$0, Common.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.lastTrackingEvent = it;
        this$0.getAspect().changed((Enum)MemoryProfilerAspect.LIVE_ALLOCATION_STATUS);
        return true;
    }

    private static final boolean isAlmostAllSelected$almostEqual(double $this$isAlmostAllSelected_u24almostEqual, double that) {
        return Math.abs($this$isAlmostAllSelected_u24almostEqual - that) <= 0.001;
    }

    private static final void startTracking$lambda$6(AllocationStage this$0) {
        if (this$0.getHasStartedTracking()) {
            this$0.getAspect().removeDependencies((AspectObserver)this$0);
        } else {
            this$0.startLiveDataTimeline();
        }
    }

    private static final void startTracking$lambda$8$lambda$7(AllocationStage this$0, Range $this_apply) {
        double rightBound = Math.min(this$0.getTimeline().getDataRange().getMax(), this$0.maxTrackingTimeUs);
        if (!$this_apply.isEmpty() && $this_apply.getMin() > rightBound) {
            this$0.selectAll();
        } else if ($this_apply.getMax() > rightBound) {
            $this_apply.setMax(rightBound);
        }
    }

    private static final void trackAllocations$lambda$9(boolean $enable, AllocationStage this$0, Memory.TrackStatus status) {
        Memory.TrackStatus trackStatus = status;
        Object object = trackStatus != null ? trackStatus.getStatus() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1: {
                if ($enable) {
                    this$0.getLogger().info("PROFILER: Java/Kotlin Allocations capture start succeeded");
                    break;
                }
                if (this$0.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
                    StudioProfilers studioProfilers = this$0.getStudioProfilers();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
                    TaskEventTrackerUtils.trackTaskFinished(studioProfilers, true, TaskFinishedState.COMPLETED);
                }
                this$0.getLogger().info("PROFILER: Java/Kotlin Allocations capture stop succeeded");
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            default: {
                boolean isTaskBasedUxEnabled = this$0.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled();
                if ($enable) {
                    if (isTaskBasedUxEnabled) {
                        StudioProfilers studioProfilers = this$0.getStudioProfilers();
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
                        TaskEventTrackerUtils.trackStartTaskFailed(studioProfilers, this$0.getStudioProfilers().getSessionsManager().isSessionAlive(), new TaskStartFailedMetadata(null, status, null));
                    }
                    this$0.getLogger().info("PROFILER: Java/Kotlin Allocations capture start failed");
                    break;
                }
                if (isTaskBasedUxEnabled) {
                    StudioProfilers studioProfilers = this$0.getStudioProfilers();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
                    TaskEventTrackerUtils.trackStopTaskFailed(studioProfilers, this$0.getStudioProfilers().getSessionsManager().isSessionAlive(), new TaskStopFailedMetadata(null, status, null));
                }
                this$0.getLogger().info("PROFILER: Java/Kotlin Allocations capture stop failed");
            }
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AllocationStage makeLiveStage(@NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader) {
        return Companion.makeLiveStage(profilers, loader);
    }

    @JvmStatic
    @NotNull
    public static final AllocationStage makeLiveStage(@NotNull StudioProfilers profilers, @NotNull Runnable stopTask2) {
        return Companion.makeLiveStage(profilers, stopTask2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AllocationStage makeStaticStage(@NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader, double minTrackingTimeUs, double maxTrackingTimeUs) {
        return Companion.makeStaticStage(profilers, loader, minTrackingTimeUs, maxTrackingTimeUs);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AllocationStage makeLiveStage(@NotNull StudioProfilers profilers) {
        return Companion.makeLiveStage(profilers);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AllocationStage makeStaticStage(@NotNull StudioProfilers profilers, double minTrackingTimeUs, double maxTrackingTimeUs) {
        return Companion.makeStaticStage(profilers, minTrackingTimeUs, maxTrackingTimeUs);
    }

    public /* synthetic */ AllocationStage(StudioProfilers profilers, CaptureObjectLoader loader, double initMinUs, double initMaxUs, Function0 stopTask2, DefaultConstructorMarker $constructor_marker) {
        this(profilers, loader, initMinUs, initMaxUs, (Function0<Unit>)stopTask2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007J*\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/profilers/memory/AllocationStage$Companion;", "", "<init>", "()V", "makeLiveStage", "Lcom/android/tools/profilers/memory/AllocationStage;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "loader", "Lcom/android/tools/profilers/memory/CaptureObjectLoader;", "stopTask", "Ljava/lang/Runnable;", "makeStaticStage", "minTrackingTimeUs", "", "maxTrackingTimeUs", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AllocationStage makeLiveStage(@NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            return new AllocationStage(profilers, loader, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null, 16, null);
        }

        public static /* synthetic */ AllocationStage makeLiveStage$default(Companion companion, StudioProfilers studioProfilers, CaptureObjectLoader captureObjectLoader, int n, Object object) {
            if ((n & 2) != 0) {
                captureObjectLoader = new CaptureObjectLoader();
            }
            return companion.makeLiveStage(studioProfilers, captureObjectLoader);
        }

        @JvmStatic
        @NotNull
        public final AllocationStage makeLiveStage(@NotNull StudioProfilers profilers, @NotNull Runnable stopTask2) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)stopTask2, (String)"stopTask");
            return new AllocationStage(profilers, new CaptureObjectLoader(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, () -> Companion.makeLiveStage$lambda$0(stopTask2), null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AllocationStage makeStaticStage(@NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader, double minTrackingTimeUs, double maxTrackingTimeUs) {
            AllocationStage allocationStage;
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            AllocationStage it = allocationStage = new AllocationStage(profilers, loader, minTrackingTimeUs, maxTrackingTimeUs, null, 16, null);
            boolean bl = false;
            double d = minTrackingTimeUs;
            if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            d = maxTrackingTimeUs;
            if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(minTrackingTimeUs <= maxTrackingTimeUs)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return allocationStage;
        }

        public static /* synthetic */ AllocationStage makeStaticStage$default(Companion companion, StudioProfilers studioProfilers, CaptureObjectLoader captureObjectLoader, double d, double d2, int n, Object object) {
            if ((n & 2) != 0) {
                captureObjectLoader = new CaptureObjectLoader();
            }
            return companion.makeStaticStage(studioProfilers, captureObjectLoader, d, d2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AllocationStage makeLiveStage(@NotNull StudioProfilers profilers) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            return com.android.tools.profilers.memory.AllocationStage$Companion.makeLiveStage$default(this, profilers, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AllocationStage makeStaticStage(@NotNull StudioProfilers profilers, double minTrackingTimeUs, double maxTrackingTimeUs) {
            Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
            return com.android.tools.profilers.memory.AllocationStage$Companion.makeStaticStage$default(this, profilers, null, minTrackingTimeUs, maxTrackingTimeUs, 2, null);
        }

        private static final Unit makeLiveStage$lambda$0(Runnable $stopTask) {
            $stopTask.run();
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Memory.TrackStatus.Status.values().length];
            try {
                nArray[Memory.TrackStatus.Status.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Memory.TrackStatus.Status.IN_PROGRESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Memory.TrackStatus.Status.NOT_ENABLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

