/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.StudioProfilersView;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class CaptureDetailsView {
    protected static final String CARD_EMPTY_INFO = "Empty content";
    protected static final String CARD_CONTENT = "Content";
    @VisibleForTesting
    static final String NO_DATA_FOR_THREAD_MESSAGE = "No data available for the selected thread.";
    @VisibleForTesting
    static final String NO_DATA_FOR_RANGE_MESSAGE = "No data available for the selected time frame.";
    @NotNull
    protected final StudioProfilersView myProfilersView;

    public CaptureDetailsView(@NotNull StudioProfilersView profilersView) {
        this.myProfilersView = profilersView;
    }

    public abstract void onRemoved();

    public abstract void onReattached();

    @NotNull
    public abstract JComponent getComponent();

    protected static void switchCardLayout(@NotNull JPanel panel, boolean isEmpty) {
        CardLayout cardLayout = (CardLayout)panel.getLayout();
        cardLayout.show(panel, isEmpty ? CARD_EMPTY_INFO : CARD_CONTENT);
    }

    @NotNull
    protected static JPanel getNoDataForThread() {
        JPanel panel = new JPanel(new BorderLayout());
        InstructionsPanel info = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(UIUtilities.getFontMetrics((JComponent)panel, (Font)ProfilerFonts.H3_FONT), NO_DATA_FOR_THREAD_MESSAGE)}).setColors(JBColor.foreground(), null).build();
        panel.add((Component)info, "Center");
        return panel;
    }

    @NotNull
    protected static JComponent getNoDataForRange() {
        JPanel panel = new JPanel(new BorderLayout());
        InstructionsPanel info = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(UIUtilities.getFontMetrics((JComponent)panel, (Font)ProfilerFonts.H3_FONT), NO_DATA_FOR_RANGE_MESSAGE)}).setColors(JBColor.foreground(), null).build();
        panel.add((Component)info, "Center");
        return panel;
    }
}

