/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.FrameTimelineSelectionOverlayPanel;
import com.android.tools.profilers.cpu.FrameTimelineSelectionOverlayPanelKt;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00009\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0005*\u0001\u0012\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J9\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel;", "", "<init>", "()V", "of", "Ljavax/swing/JComponent;", "content", "captureRange", "Lcom/android/tools/adtui/model/Range;", "selection", "Lcom/android/tools/adtui/model/MultiSelectionModel;", "grayOut", "Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$GrayOutMode;", "deadLineBar", "", "text", "", "overlay", "com/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$overlay$1", "grayOutMode", "(Lcom/android/tools/adtui/model/Range;Lcom/android/tools/adtui/model/MultiSelectionModel;Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$GrayOutMode;ZLjava/lang/String;)Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$overlay$1;", "GrayOutMode", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=1)
public final class FrameTimelineSelectionOverlayPanel {
    @NotNull
    public static final FrameTimelineSelectionOverlayPanel INSTANCE = new FrameTimelineSelectionOverlayPanel();
    public static final int $stable;

    private FrameTimelineSelectionOverlayPanel() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final JComponent of(@NotNull JComponent content, @NotNull Range captureRange, @NotNull MultiSelectionModel<?> selection, @NotNull GrayOutMode grayOut, boolean deadLineBar, @NotNull String text) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)captureRange, (String)"captureRange");
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)grayOut, (String)"grayOut");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        JPanel $this$of_u24lambda_u240 = jPanel = new JPanel(){

            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        boolean bl = false;
        $this$of_u24lambda_u240.setLayout(new OverlayLayout($this$of_u24lambda_u240));
        $this$of_u24lambda_u240.setOpaque(false);
        content.setOpaque(false);
        $this$of_u24lambda_u240.add(INSTANCE.overlay(captureRange, selection, grayOut, deadLineBar, text));
        $this$of_u24lambda_u240.add(content);
        MouseListener handler2 = new MouseListener(content){
            final /* synthetic */ JComponent $content;
            {
                this.$content = $content;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseDragged(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }
        };
        $this$of_u24lambda_u240.addMouseListener(handler2);
        $this$of_u24lambda_u240.addMouseMotionListener((MouseMotionListener)((Object)handler2));
        return jPanel;
    }

    public static /* synthetic */ JComponent of$default(JComponent jComponent, Range range, MultiSelectionModel multiSelectionModel, GrayOutMode grayOutMode, boolean bl, String string, int n, Object object) {
        if ((n & 0x20) != 0) {
            string = "";
        }
        return FrameTimelineSelectionOverlayPanel.of(jComponent, range, multiSelectionModel, grayOutMode, bl, string);
    }

    private final overlay.1 overlay(Range captureRange, MultiSelectionModel<?> selection, GrayOutMode grayOutMode, boolean deadLineBar, String text) {
        return new JComponent(selection, grayOutMode, captureRange, deadLineBar, text){
            private final AspectObserver observer;
            final /* synthetic */ MultiSelectionModel<?> $selection;
            final /* synthetic */ GrayOutMode $grayOutMode;
            final /* synthetic */ Range $captureRange;
            final /* synthetic */ boolean $deadLineBar;
            final /* synthetic */ String $text;
            {
                this.$selection = $selection;
                this.$grayOutMode = $grayOutMode;
                this.$captureRange = $captureRange;
                this.$deadLineBar = $deadLineBar;
                this.$text = $text;
                this.observer = new AspectObserver();
                $selection.addDependency(this.observer).onChange((Enum)MultiSelectionModel.Aspect.ACTIVE_SELECTION_CHANGED, this::repaint).onChange((Enum)MultiSelectionModel.Aspect.SELECTIONS_CHANGED, this::repaint);
            }

            public final AspectObserver getObserver() {
                return this.observer;
            }

            protected void paintComponent(Graphics g) {
                block8: {
                    long expectedEnd;
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    super.paintComponent(g);
                    Object object = this.$selection.getActiveSelectionKey();
                    AndroidFrameTimelineEvent androidFrameTimelineEvent = object instanceof AndroidFrameTimelineEvent ? (AndroidFrameTimelineEvent)object : null;
                    if (androidFrameTimelineEvent == null) break block8;
                    object = androidFrameTimelineEvent;
                    GrayOutMode grayOutMode = this.$grayOutMode;
                    Range range = this.$captureRange;
                    boolean bl = this.$deadLineBar;
                    String string = this.$text;
                    Object event = object;
                    boolean bl2 = false;
                    GrayOutMode grayOutMode2 = grayOutMode;
                    if (Intrinsics.areEqual((Object)grayOutMode2, (Object)GrayOutMode.All.INSTANCE)) {
                        this.grayOutPixels(g, 0, this.getWidth());
                    } else if (grayOutMode2 instanceof GrayOutMode.Outside) {
                        Range highlightedRange = (Range)((GrayOutMode.Outside)grayOutMode).getGetRangeForActiveEvent().invoke(event);
                        double start = highlightedRange.getMin();
                        double end = highlightedRange.getMax();
                        if (start > range.getMin() || end < range.getMax()) {
                            this.grayOut(g, range.getMin(), Math.max(range.getMin(), start));
                            this.grayOut(g, Math.min(range.getMax(), end), range.getMax());
                        }
                    } else if (!Intrinsics.areEqual((Object)grayOutMode2, (Object)GrayOutMode.None.INSTANCE)) {
                        throw new NoWhenBranchMatchedException();
                    }
                    if (bl && ((AndroidFrameTimelineEvent)event).isActionableJank() && (expectedEnd = ((AndroidFrameTimelineEvent)event).getExpectedEndUs()) < ((AndroidFrameTimelineEvent)event).getActualEndUs()) {
                        Graphics2D $this$paintComponent_u24lambda_u241_u24lambda_u240 = (Graphics2D)g;
                        boolean bl3 = false;
                        int x = this.valueToPixelCoord(expectedEnd);
                        $this$paintComponent_u24lambda_u241_u24lambda_u240.setColor((Color)StudioColorsKt.getMissedDeadlineJank());
                        $this$paintComponent_u24lambda_u241_u24lambda_u240.setStroke(FrameTimelineSelectionOverlayPanelKt.access$getDASHED_LINE_STROKE$p());
                        $this$paintComponent_u24lambda_u241_u24lambda_u240.drawLine(x, 0, x, this.getHeight());
                        if (((CharSequence)string).length() > 0) {
                            $this$paintComponent_u24lambda_u241_u24lambda_u240.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            Font oldFont = $this$paintComponent_u24lambda_u241_u24lambda_u240.getFont();
                            $this$paintComponent_u24lambda_u241_u24lambda_u240.setFont($this$paintComponent_u24lambda_u241_u24lambda_u240.getFont().deriveFont(10.0f));
                            $this$paintComponent_u24lambda_u241_u24lambda_u240.drawString(string, (float)x + (float)4, (float)(this.getHeight() - $this$paintComponent_u24lambda_u241_u24lambda_u240.getFontMetrics().getHeight()) * 0.5f + (float)$this$paintComponent_u24lambda_u241_u24lambda_u240.getFontMetrics().getAscent());
                            $this$paintComponent_u24lambda_u241_u24lambda_u240.setFont(oldFont);
                        }
                    }
                }
            }

            private final void grayOut(Graphics $this$grayOut, double left, double right) {
                this.grayOutPixels($this$grayOut, this.valueToPixelCoord(left), this.valueToPixelCoord(right));
            }

            private final void grayOutPixels(Graphics $this$grayOutPixels, int left, int right) {
                $this$grayOutPixels.setColor((Color)FrameTimelineSelectionOverlayPanelKt.access$getTRANSLUCENT_GRAY$p());
                $this$grayOutPixels.fillRect(left, 0, right - left, this.getHeight());
            }

            private final int valueToPixelCoord(double value) {
                return (int)((value - this.$captureRange.getMin()) / this.$captureRange.getLength() * (double)this.getWidth());
            }
        };
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final JComponent of(@NotNull JComponent content, @NotNull Range captureRange, @NotNull MultiSelectionModel<?> selection, @NotNull GrayOutMode grayOut, boolean deadLineBar) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)captureRange, (String)"captureRange");
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)grayOut, (String)"grayOut");
        return FrameTimelineSelectionOverlayPanel.of$default(content, captureRange, selection, grayOut, deadLineBar, null, 32, null);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$GrayOutMode;", "", "<init>", "()V", "All", "Outside", "None", "Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$GrayOutMode$All;", "Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$GrayOutMode$None;", "Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$GrayOutMode$Outside;", "intellij.android.profilers.ui"})
    @StabilityInferred(parameters=1)
    public static abstract class GrayOutMode {
        public static final int $stable;

        private GrayOutMode() {
        }

        public /* synthetic */ GrayOutMode(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$GrayOutMode$All;", "Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$GrayOutMode;", "<init>", "()V", "intellij.android.profilers.ui"})
        @StabilityInferred(parameters=1)
        public static final class All
        extends GrayOutMode {
            @NotNull
            public static final All INSTANCE = new All();
            public static final int $stable;

            private All() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$GrayOutMode$None;", "Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$GrayOutMode;", "<init>", "()V", "intellij.android.profilers.ui"})
        @StabilityInferred(parameters=1)
        public static final class None
        extends GrayOutMode {
            @NotNull
            public static final None INSTANCE = new None();
            public static final int $stable;

            private None() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$GrayOutMode$Outside;", "Lcom/android/tools/profilers/cpu/FrameTimelineSelectionOverlayPanel$GrayOutMode;", "getRangeForActiveEvent", "Lkotlin/Function1;", "Lcom/android/tools/profilers/cpu/systemtrace/AndroidFrameTimelineEvent;", "Lcom/android/tools/adtui/model/Range;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getGetRangeForActiveEvent", "()Lkotlin/jvm/functions/Function1;", "intellij.android.profilers.ui"})
        @StabilityInferred(parameters=1)
        public static final class Outside
        extends GrayOutMode {
            @NotNull
            private final Function1<AndroidFrameTimelineEvent, Range> getRangeForActiveEvent;
            public static final int $stable;

            public Outside(@NotNull Function1<? super AndroidFrameTimelineEvent, Range> getRangeForActiveEvent) {
                Intrinsics.checkNotNullParameter(getRangeForActiveEvent, (String)"getRangeForActiveEvent");
                super(null);
                this.getRangeForActiveEvent = getRangeForActiveEvent;
            }

            @NotNull
            public final Function1<AndroidFrameTimelineEvent, Range> getGetRangeForActiveEvent() {
                return this.getRangeForActiveEvent;
            }
        }
    }
}

