/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.cpu.CpuThreadCountDataSeries;
import com.android.tools.profilers.cpu.CpuUsage;
import org.jetbrains.annotations.NotNull;

public class DetailedCpuUsage
extends CpuUsage {
    @NotNull
    private final RangedContinuousSeries myOtherCpuSeries;
    @NotNull
    private final RangedContinuousSeries myThreadsCountSeries;
    @NotNull
    private final Range myThreadRange = new Range(0.0, 8.0);

    public DetailedCpuUsage(@NotNull StudioProfilers profilers) {
        super(profilers);
        long streamId = profilers.getSession().getStreamId();
        int pid = profilers.getSession().getPid();
        UnifiedEventDataSeries others = new UnifiedEventDataSeries(profilers.getClient().getTransportClient(), streamId, pid, Common.Event.Kind.CPU_USAGE, pid, events -> DetailedCpuUsage.extractData(events, true));
        CpuThreadCountDataSeries threads = new CpuThreadCountDataSeries(profilers.getClient().getTransportClient(), streamId, pid);
        this.myOtherCpuSeries = new RangedContinuousSeries("Others", profilers.getTimeline().getViewRange(), this.getCpuRange(), others);
        this.myThreadsCountSeries = new RangedContinuousSeries("Threads", profilers.getTimeline().getViewRange(), this.myThreadRange, (DataSeries)threads);
        this.add(this.myOtherCpuSeries);
        this.add(this.myThreadsCountSeries);
    }

    @NotNull
    public RangedContinuousSeries getOtherCpuSeries() {
        return this.myOtherCpuSeries;
    }

    @NotNull
    public RangedContinuousSeries getThreadsCountSeries() {
        return this.myThreadsCountSeries;
    }

    @NotNull
    public Range getThreadRange() {
        return this.myThreadRange;
    }

    @Override
    protected String getCpuSeriesLabel() {
        return "App";
    }
}

