/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmExternalDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "wasm.frontend"})
@SourceDebugExtension(value={"SMAP\nWasmExternalDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmExternalDeclarationChecker.kt\norg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmExternalDeclarationChecker\n+ 2 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,62:1\n37#2:63\n*S KotlinDebug\n*F\n+ 1 WasmExternalDeclarationChecker.kt\norg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmExternalDeclarationChecker\n*L\n42#1:63\n*E\n"})
public final class WasmExternalDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final WasmExternalDeclarationChecker INSTANCE = new WasmExternalDeclarationChecker();

    private WasmExternalDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!(descriptor instanceof MemberDescriptor) || !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor)) {
            return;
        }
        MemberDescriptor memberDescriptor = (MemberDescriptor)descriptor;
        if (memberDescriptor instanceof ClassDescriptor) {
            ClassKind classKind = ((ClassDescriptor)descriptor).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)classKind, "getKind(...)");
            ClassKind $this$isEnumClass$iv = classKind;
            boolean $i$f$isEnumClass = false;
            if ($this$isEnumClass$iv == ClassKind.ENUM_CLASS) {
                WasmExternalDeclarationChecker.check$reportWrongExternalDeclaration(context2, declaration, "enum class");
            }
        } else if (memberDescriptor instanceof PropertyDescriptor) {
            if (((PropertyDescriptor)descriptor).isLateInit()) {
                WasmExternalDeclarationChecker.check$reportWrongExternalDeclaration(context2, declaration, "lateinit property");
            }
        } else if (memberDescriptor instanceof FunctionDescriptor) {
            if (((FunctionDescriptor)descriptor).isTailrec()) {
                WasmExternalDeclarationChecker.check$reportWrongExternalDeclaration(context2, declaration, "tailrec function");
            }
            if (((FunctionDescriptor)descriptor).isSuspend()) {
                WasmExternalDeclarationChecker.check$reportWrongExternalDeclaration(context2, declaration, "suspend function");
            }
        }
    }

    private static final void check$reportWrongExternalDeclaration(DeclarationCheckerContext $context, KtDeclaration $declaration, String kind) {
        $context.getTrace().report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)$declaration), kind));
    }
}

