/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;

class _KDocLexer
implements FlexLexer {
    public static final int YYEOF = -1;
    public static final int YYINITIAL = 0;
    public static final int LINE_BEGINNING = 2;
    public static final int CONTENTS_BEGINNING = 4;
    public static final int TAG_BEGINNING = 6;
    public static final int TAG_TEXT_BEGINNING = 8;
    public static final int CONTENTS = 10;
    public static final int CODE_BLOCK = 12;
    public static final int CODE_BLOCK_LINE_BEGINNING = 14;
    public static final int CODE_BLOCK_CONTENTS_BEGINNING = 16;
    public static final int INDENTED_CODE_BLOCK = 18;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 6, 6};
    private static final int[] ZZ_CMAP_TOP = _KDocLexer.zzUnpackcmap_top();
    private static final int[] ZZ_CMAP_BLOCKS = _KDocLexer.zzUnpackcmap_blocks();
    private static final int[] ZZ_ACTION = _KDocLexer.zzUnpackAction();
    private static final int[] ZZ_ROWMAP = _KDocLexer.zzUnpackRowMap();
    private static final int[] ZZ_TRANS = _KDocLexer.zzUnpacktrans();
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = _KDocLexer.zzUnpackAttribute();
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private CharSequence zzBuffer = "";
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    protected int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;

    private static int[] zzUnpackcmap_top() {
        int[] result2 = new int[4352];
        int offset = 0;
        offset = _KDocLexer.zzUnpackcmap_top("\u0001\u0000\u0001\u0100\u0001\u0200\u0001\u0300\u0001\u0400\u0001\u0500\u0001\u0600\u0001\u0700\u0001\u0800\u0001\u0900\u0001\u0a00\u0001\u0b00\u0001\u0c00\u0001\u0d00\u0001\u0e00\u0001\u0f00\u0001\u1000\u0001\u0100\u0001\u1100\u0001\u1200\u0001\u1300\u0001\u0100\u0001\u1400\u0001\u1500\u0001\u1600\u0001\u1700\u0001\u1800\u0001\u1900\u0001\u1a00\u0001\u1b00\u0001\u0100\u0001\u1c00\u0001\u1d00\u0001\u1e00\n\u1f00\u0001\u2000\u0001\u2100\u0001\u2200\u0001\u1f00\u0001\u2300\u0001\u2400\u0002\u1f00\u0019\u0100\u0001\u1b00Q\u0100\u0001\u2500\u0004\u0100\u0001\u2600\u0001\u0100\u0001\u2700\u0001\u2800\u0001\u2900\u0001\u2a00\u0001\u2b00\u0001\u2c00+\u0100\u0001\u2d00\b\u2e00\u0019\u1f00\u0001\u0100\u0001\u2f00\u0001\u3000\u0001\u0100\u0001\u3100\u0001\u3200\u0001\u3300\u0001\u3400\u0001\u3500\u0001\u3600\u0001\u3700\u0001\u3800\u0001\u3900\u0001\u0100\u0001\u3a00\u0001\u3b00\u0001\u3c00\u0001\u3d00\u0001\u3e00\u0001\u3f00\u0001\u4000\u0001\u4100\u0001\u4200\u0001\u4300\u0001\u4400\u0001\u4500\u0001\u4600\u0001\u4700\u0001\u4800\u0001\u4900\u0001\u4a00\u0001\u4b00\u0001\u4c00\u0001\u4d00\u0001\u1f00\u0001\u4e00\u0001\u4f00\u0001\u5000\u0001\u5100\u0003\u0100\u0001\u5200\u0001\u5300\u0001\u5400\n\u1f00\u0004\u0100\u0001\u5500\u000f\u1f00\u0002\u0100\u0001\u5600!\u1f00\u0002\u0100\u0001\u5700\u0001\u5800\u0002\u1f00\u0001\u5900\u0001\u5a00\u0017\u0100\u0001\u5b00\u0004\u0100\u0001\u5c00\u0001\u5d00\"\u1f00\u0001\u0100\u0001\u5e00\u0001\u5f00\t\u1f00\u0001\u6000\u0017\u1f00\u0001\u6100\u0001\u6200\u0001\u6300\u0001\u6400\t\u1f00\u0001\u6500\u0001\u6600\u0005\u1f00\u0001\u6700\u0001\u6800\u0002\u1f00\u0001\u6900\u0001\u1f00\u0001\u6a00\u0011\u1f00\u00a6\u0100\u0001\u6b00\u0010\u0100\u0001\u6c00\u0001\u6d00\u0015\u0100\u0001\u6e00\u001c\u0100\u0001\u6f00\f\u1f00\u0002\u0100\u0001\u7000\u0005\u1f00\u0013\u0100\u0001\u7100\u0dec\u1f00", offset, result2);
        return result2;
    }

    private static int zzUnpackcmap_top(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j2 = offset;
        int l2 = packed.length();
        while (i2 < l2) {
            int count = packed.charAt(i2++);
            char value2 = packed.charAt(i2++);
            do {
                result2[j2++] = value2;
            } while (--count > 0);
        }
        return j2;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] result2 = new int[29184];
        int offset = 0;
        offset = _KDocLexer.zzUnpackcmap_blocks("\t\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0003\u0012\u0000\u0001\u0005\u0003\u0000\u0001\u0006\u0003\u0000\u0001\u0007\u0001\b\u0001\t\u0003\u0000\u0001\n\u0001\u000b\n\f\u0006\u0000\u0001\r\u001a\u0006\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0000\u0001\u0006\u0001\u0011\u001a\u0006\u0003\u0000\u0001\u0012\u0006\u0000\u0001\u0003\u001c\u0000\u0004\u0006\u0004\u0000\u0001\u0006\n\u0000\u0001\u0006\u0004\u0000\u0001\u0006\u0005\u0000\u0017\u0006\u0001\u0000\u001f\u0006\u0001\u0000\u01ca\u0006\u0004\u0000\f\u0006\u000e\u0000\u0005\u0006\u0007\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0081\u0000\u0005\u0006\u0001\u0000\u0002\u0006\u0002\u0000\u0004\u0006\u0001\u0000\u0001\u0006\u0006\u0000\u0001\u0006\u0001\u0000\u0003\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0014\u0006\u0001\u0000S\u0006\u0001\u0000\u008b\u0006\b\u0000\u00a6\u0006\u0001\u0000&\u0006\u0002\u0000\u0001\u0006\u0006\u0000)\u0006\u0006\u0000\u0001\u0006@\u0000\u001b\u0006\u0004\u0000\u0004\u0006\u0018\u0000\u0001\u0006\u0014\u0000+\u0006#\u0000\u0002\u0006\u0001\u0000c\u0006\u0001\u0000\u0001\u0006\u000f\u0000\u0002\u0006\u0007\u0000\u0002\u0006\n\u0000\u0003\u0006\u0002\u0000\u0001\u0006\u0010\u0000\u0001\u0006\u0001\u0000\u001e\u0006\u001d\u0000Y\u0006\u000b\u0000\u0001\u0006\u0018\u0000!\u0006\t\u0000\u0002\u0006\u0004\u0000\u0001\u0006\u0003\u0000\u0018\u0006\u0004\u0000\u0001\u0006\t\u0000\u0001\u0006\u0003\u0000\u0001\u0006\u0017\u0000\u0019\u0006\u0007\u0000\u000b\u00065\u0000\u0015\u0006\u0001\u0000\u0012\u0006<\u00006\u0006\u0003\u0000\u0001\u0006\u0012\u0000\u0001\u0006\u0007\u0000\n\u0006\u000f\u0000\u0010\u0006\u0004\u0000\b\u0006\u0002\u0000\u0002\u0006\u0002\u0000\u0016\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u0001\u0006\u0003\u0000\u0004\u0006\u0003\u0000\u0001\u0006\u0010\u0000\u0001\u0006\r\u0000\u0002\u0006\u0001\u0000\u0003\u0006\u000e\u0000\u0004\u0006\u0007\u0000\u0002\u0006\b\u0000\u0006\u0006\u0004\u0000\u0002\u0006\u0002\u0000\u0016\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u0002\u0006\u0001\u0000\u0002\u0006\u0001\u0000\u0002\u0006\u001f\u0000\u0004\u0006\u0001\u0000\u0001\u0006\u0013\u0000\u0003\u0006\u0010\u0000\t\u0006\u0001\u0000\u0003\u0006\u0001\u0000\u0016\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u0002\u0006\u0001\u0000\u0005\u0006\u0003\u0000\u0001\u0006\u0012\u0000\u0001\u0006\u000f\u0000\u0002\u0006\u000f\u0000\u0001\u0006\u0007\u0000\u0001\u0006\u000b\u0000\b\u0006\u0002\u0000\u0002\u0006\u0002\u0000\u0016\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u0002\u0006\u0001\u0000\u0005\u0006\u0003\u0000\u0001\u0006\u001e\u0000\u0002\u0006\u0001\u0000\u0003\u0006\u000f\u0000\u0001\u0006\u0011\u0000\u0001\u0006\u0001\u0000\u0006\u0006\u0003\u0000\u0003\u0006\u0001\u0000\u0004\u0006\u0003\u0000\u0002\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0002\u0006\u0003\u0000\u0003\u0006\u0003\u0000\f\u0006\u0016\u0000\u0001\u0006(\u0000\u0001\u0006\u000b\u0000\b\u0006\u0001\u0000\u0003\u0006\u0001\u0000\u0017\u0006\u0001\u0000\u0010\u0006\u0003\u0000\u0001\u0006\u001a\u0000\u0003\u0006\u0005\u0000\u0002\u0006\u001e\u0000\u0001\u0006\u0004\u0000\b\u0006\u0001\u0000\u0003\u0006\u0001\u0000\u0017\u0006\u0001\u0000\n\u0006\u0001\u0000\u0005\u0006\u0003\u0000\u0001\u0006 \u0000\u0001\u0006\u0001\u0000\u0002\u0006\u000f\u0000\u0002\u0006\u0011\u0000\t\u0006\u0001\u0000\u0003\u0006\u0001\u0000)\u0006\u0002\u0000\u0001\u0006\u0010\u0000\u0001\u0006\u0005\u0000\u0003\u0006\b\u0000\u0003\u0006\u0018\u0000\u0006\u0006\u0005\u0000\u0012\u0006\u0003\u0000\u0018\u0006\u0001\u0000\t\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0007\u0006:\u00000\u0006\u0001\u0000\u0002\u0006\u000b\u0000\b\u0006:\u0000\u0002\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0005\u0006\u0001\u0000\u0018\u0006\u0001\u0000\u0001\u0006\u0001\u0000\n\u0006\u0001\u0000\u0002\u0006\t\u0000\u0001\u0006\u0002\u0000\u0005\u0006\u0001\u0000\u0001\u0006\u0015\u0000\u0004\u0006 \u0000\u0001\u0006?\u0000\b\u0006\u0001\u0000$\u0006\u001b\u0000\u0005\u0006s\u0000+\u0006\u0014\u0000\u0001\u0006\u0010\u0000\u0006\u0006\u0004\u0000\u0004\u0006\u0003\u0000\u0001\u0006\u0003\u0000\u0002\u0006\u0007\u0000\u0003\u0006\u0004\u0000\r\u0006\f\u0000\u0001\u0006\u0011\u0000&\u0006\u0001\u0000\u0001\u0006\u0005\u0000\u0001\u0006\u0002\u0000+\u0006\u0001\u0000M\u0006\u0001\u0000\u0004\u0006\u0002\u0000\u0007\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0004\u0006\u0002\u0000)\u0006\u0001\u0000\u0004\u0006\u0002\u0000!\u0006\u0001\u0000\u0004\u0006\u0002\u0000\u0007\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0004\u0006\u0002\u0000\u000f\u0006\u0001\u00009\u0006\u0001\u0000\u0004\u0006\u0002\u0000C\u0006%\u0000\u0010\u0006\u0010\u0000V\u0006\u0002\u0000\u0006\u0006\u0003\u0000\u016c\u0006\u0002\u0000\u0011\u0006\u0001\u0000\u001a\u0006\u0005\u0000K\u0006\u0003\u0000\u000b\u0006\u0007\u0000\r\u0006\u0001\u0000\u0004\u0006\u000e\u0000\u0012\u0006\u000e\u0000\u0012\u0006\u000e\u0000\r\u0006\u0001\u0000\u0003\u0006\u000f\u00004\u0006#\u0000\u0001\u0006\u0003\u0000\u0002\u0006C\u0000Y\u0006\u0007\u0000\u0005\u0006\u0002\u0000\"\u0006\u0001\u0000\u0001\u0006\u0005\u0000F\u0006\n\u0000\u001f\u00061\u0000\u001e\u0006\u0002\u0000\u0005\u0006\u000b\u0000,\u0006\u0004\u0000\u001a\u00066\u0000\u0017\u0006\t\u00005\u0006R\u0000\u0001\u0006]\u0000/\u0006\u0011\u0000\u0007\u00067\u0000\u001e\u0006\r\u0000\u0002\u0006\n\u0000,\u0006\u001a\u0000$\u0006)\u0000\u0003\u0006\n\u0000$\u0006\u0002\u0000\t\u0006\u0007\u0000+\u0006\u0002\u0000\u0003\u0006)\u0000\u0004\u0006\u0001\u0000\u0006\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001\u0006\u0005\u0000\u00c0\u0006@\u0000\u0016\u0006\u0002\u0000\u0006\u0006\u0002\u0000&\u0006\u0002\u0000\u0006\u0006\u0002\u0000\b\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u001f\u0006\u0002\u00005\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u0001\u0006\u0003\u0000\u0003\u0006\u0001\u0000\u0007\u0006\u0003\u0000\u0004\u0006\u0002\u0000\u0006\u0006\u0004\u0000\r\u0006\u0005\u0000\u0003\u0006\u0001\u0000\u0007\u0006+\u0000\u0002\u0003\u0015\u0000\u0002\u0006\u0013\u0000\u0001\u0006\u001c\u0000\u0001\u0006\r\u0000\u0001\u0006\u0010\u0000\r\u0006\u0003\u0000 \u0006B\u0000\u0001\u0006\u0004\u0000\u0001\u0006\u0002\u0000\n\u0006\u0001\u0000\u0001\u0006\u0003\u0000\u0005\u0006\u0006\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0004\u0006\u0001\u0000\u000b\u0006\u0002\u0000\u0004\u0006\u0005\u0000\u0005\u0006\u0004\u0000\u0001\u0006\u0011\u0000)\u0006\u0177\u0000/\u0006\u0001\u0000/\u0006\u0001\u0000\u0085\u0006\u0006\u0000\u0004\u0006\u0003\u0000\u0002\u0006\f\u0000&\u0006\u0001\u0000\u0001\u0006\u0005\u0000\u0001\u0006\u0002\u00008\u0006\u0007\u0000\u0001\u0006\u0010\u0000\u0017\u0006\t\u0000\u0007\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u0007\u0006P\u0000\u0001\u0006\u00d5\u0000\u0003\u0006\u0019\u0000\t\u0006\u0007\u0000\u0005\u0006\u0002\u0000\u0005\u0006\u0004\u0000V\u0006\u0006\u0000\u0003\u0006\u0001\u0000Z\u0006\u0001\u0000\u0004\u0006\u0005\u0000+\u0006\u0001\u0000^\u0006\u0011\u0000 \u00060\u0000\u010d\u0006\u0003\u0000\u008d\u0006C\u0000.\u0006\u0002\u0000\r\u0006\u0003\u0000\u0010\u0006\n\u0000\u0002\u0006\u0014\u0000/\u0006\u0010\u0000\u001f\u0006\u0002\u0000P\u0006'\u0000\t\u0006\u0002\u0000g\u0006\u0002\u00005\u0006\u0002\u0000\t\u0006*\u0000\r\u0006\u0001\u0000\u0003\u0006\u0001\u0000\u0004\u0006\u0001\u0000\u0017\u0006\u0015\u0000\u0001\u0006\u0007\u00004\u0006\u000e\u00002\u0006>\u0000\u0006\u0006\u0003\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u000b\u0000\u001c\u0006\n\u0000\u0017\u0006\u0019\u0000\u001d\u0006\u0007\u0000/\u0006\u001c\u0000\u0001\u0006\u0010\u0000\u0005\u0006\u0001\u0000\n\u0006\n\u0000\u0005\u0006\u0001\u0000)\u0006\u0017\u0000\u0003\u0006\u0001\u0000\b\u0006\u0014\u0000\u0017\u0006\u0003\u0000\u0001\u0006\u0003\u00002\u0006\u0001\u0000\u0001\u0006\u0003\u0000\u0002\u0006\u0002\u0000\u0005\u0006\u0002\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0018\u0000\u0003\u0006\u0002\u0000\u000b\u0006\u0007\u0000\u0003\u0006\f\u0000\u0006\u0006\u0002\u0000\u0006\u0006\u0002\u0000\u0006\u0006\t\u0000\u0007\u0006\u0001\u0000\u0007\u0006\u0001\u0000+\u0006\u0001\u0000\u000e\u0006\u0006\u0000s\u0006\u001d\u0000\u00a4\u0006\f\u0000\u0017\u0006\u0004\u00001\u0006\u0004\u0000\u0100\u0003n\u0006\u0002\u0000j\u0006&\u0000\u0007\u0006\f\u0000\u0005\u0006\u0005\u0000\u0001\u0006\u0001\u0000\n\u0006\u0001\u0000\r\u0006\u0001\u0000\u0005\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0001\u0000\u0002\u0006\u0001\u0000l\u0006!\u0000k\u0006\u0012\u0000@\u0006\u0002\u00006\u0006(\u0000\r\u00066\u0000\u0002\u0006\u0018\u0000\u0003\u0006\u0019\u0000\u0001\u0006\u0006\u0000\u0005\u0006\u0001\u0000\u0087\u0006\u0007\u0000\u0001\u0006\u001c\u0000\u001a\u0006\u0004\u0000\u0001\u0006\u0001\u0000\u001a\u0006\u000b\u0000Y\u0006\u0003\u0000\u0006\u0006\u0002\u0000\u0006\u0006\u0002\u0000\u0006\u0006\u0002\u0000\u0003\u0006\u0003\u0000\u0002\u0006\u0003\u0000\u0002\u0006\u0019\u0000\f\u0006\u0001\u0000\u001a\u0006\u0001\u0000\u0013\u0006\u0001\u0000\u0002\u0006\u0001\u0000\u000f\u0006\u0002\u0000\u000e\u0006\"\u0000{\u0006E\u00005\u0006\u010b\u0000\u001d\u0006\u0003\u00001\u0006/\u0000 \u0006\r\u0000\u001e\u0006\u0005\u0000&\u0006\n\u0000\u001e\u0006\u0002\u0000$\u0006\u0004\u0000\b\u0006\u0001\u0000\u0005\u0006*\u0000\u009e\u0006\u0012\u0000$\u0006\u0004\u0000$\u0006\u0004\u0000(\u0006\b\u00004\u0006\u009c\u00007\u0006\t\u0000\u0016\u0006\n\u0000\b\u0006\u0098\u0000\u0006\u0006\u0002\u0000\u0001\u0006\u0001\u0000,\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001\u0006\u0002\u0000\u0017\u0006\n\u0000\u0017\u0006\t\u0000\u001f\u0006A\u0000\u0013\u0006\u0001\u0000\u0002\u0006\n\u0000\u0016\u0006\n\u0000\u001a\u0006F\u00008\u0006\u0006\u0000\u0002\u0006@\u0000\u0001\u0006\u000f\u0000\u0004\u0006\u0001\u0000\u0003\u0006\u0001\u0000\u001d\u0006*\u0000\u001d\u0006\u0003\u0000\u001d\u0006#\u0000\b\u0006\u0001\u0000\u001c\u0006\u001b\u00006\u0006\n\u0000\u0016\u0006\n\u0000\u0013\u0006\r\u0000\u0012\u0006n\u0000I\u00067\u00003\u0006\r\u00003\u0006\r\u0000$\u0006\u015c\u0000*\u0006\u0006\u0000\u0002\u0006N\u0000\u001d\u0006\n\u0000\u0001\u0006\b\u0000\u0016\u0006j\u0000\u0015\u0006\u001b\u0000\u0017\u0006\f\u00005\u0006K\u0000-\u0006 \u0000\u0019\u0006\u001a\u0000$\u0006\u001d\u0000\u0001\u0006\u0002\u0000\u0001\u0006\b\u0000#\u0006\u0003\u0000\u0001\u0006\f\u00000\u0006\u000e\u0000\u0004\u0006\u0015\u0000\u0001\u0006\u0001\u0000\u0001\u0006#\u0000\u0012\u0006\u0001\u0000\u0019\u0006T\u0000\u0007\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0004\u0006\u0001\u0000\u000f\u0006\u0001\u0000\n\u0006\u0007\u0000/\u0006&\u0000\b\u0006\u0002\u0000\u0002\u0006\u0002\u0000\u0016\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u0002\u0006\u0001\u0000\u0005\u0006\u0003\u0000\u0001\u0006\u0012\u0000\u0001\u0006\f\u0000\u0005\u0006\u009e\u00005\u0006\u0012\u0000\u0004\u0006\u0014\u0000\u0003\u0006\u001e\u00000\u0006\u0014\u0000\u0002\u0006\u0001\u0000\u0001\u0006\u00b8\u0000/\u0006)\u0000\u0004\u0006$\u00000\u0006\u0014\u0000\u0001\u0006;\u0000+\u0006\r\u0000\u0001\u0006G\u0000\u001b\u0006\u00e5\u0000,\u0006t\u0000@\u0006\u001f\u0000\b\u0006\u0002\u0000\u0001\u0006\u0002\u0000\b\u0006\u0001\u0000\u0002\u0006\u0001\u0000\u0018\u0006\u000f\u0000\u0001\u0006\u0001\u0000\u0001\u0006^\u0000\b\u0006\u0002\u0000'\u0006\u0010\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u001c\u0000\u0001\u0006\n\u0000(\u0006\u0007\u0000\u0001\u0006\u0015\u0000\u0001\u0006\u000b\u0000.\u0006\u0013\u0000\u0001\u0006\"\u00009\u0006\u0007\u0000\t\u0006\u0001\u0000%\u0006\u0011\u0000\u0001\u00061\u0000\u001e\u0006p\u0000\u0007\u0006\u0001\u0000\u0002\u0006\u0001\u0000&\u0006\u0015\u0000\u0001\u0006\u0019\u0000\u0006\u0006\u0001\u0000\u0002\u0006\u0001\u0000 \u0006\u000e\u0000\u0001\u0006\u0147\u0000\u0013\u0006\u00bd\u0000\u0001\u0006,\u0000\u0004\u0006\u001f\u0000\u009a\u0006f\u0000o\u0006\u0011\u0000\u00c4\u0006\u00bc\u0000/\u0006\u00d1\u0000G\u0006\u00b9\u00009\u0006\u0007\u0000\u001f\u0006q\u0000\u001e\u0006\u0012\u00000\u0006\u0010\u0000\u0004\u0006\u001f\u0000\u0015\u0006\u0005\u0000\u0013\u0006\u00b0\u0000@\u0006\u0080\u0000K\u0006\u0005\u0000\u0001\u0006B\u0000\r\u0006@\u0000\u0002\u0006\u0001\u0000\u0001\u0006\u001c\u0000\u00f8\u0006\b\u0000\u00d6\u0006*\u0000\t\u0006\u00f7\u0000\u001f\u00061\u0000\u0003\u0006\u0011\u0000\u0004\u0006\b\u0000\u018c\u0006\u0004\u0000k\u0006\u0005\u0000\r\u0006\u0003\u0000\t\u0006\u0007\u0000\n\u0006f\u0000U\u0006\u0001\u0000G\u0006\u0001\u0000\u0002\u0006\u0002\u0000\u0001\u0006\u0002\u0000\u0002\u0006\u0002\u0000\u0004\u0006\u0001\u0000\f\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0007\u0006\u0001\u0000A\u0006\u0001\u0000\u0004\u0006\u0002\u0000\b\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u001c\u0006\u0001\u0000\u0004\u0006\u0001\u0000\u0005\u0006\u0001\u0000\u0001\u0006\u0003\u0000\u0007\u0006\u0001\u0000\u0154\u0006\u0002\u0000\u0019\u0006\u0001\u0000\u0019\u0006\u0001\u0000\u001f\u0006\u0001\u0000\u0019\u0006\u0001\u0000\u001f\u0006\u0001\u0000\u0019\u0006\u0001\u0000\u001f\u0006\u0001\u0000\u0019\u0006\u0001\u0000\u001f\u0006\u0001\u0000\u0019\u0006\u0001\u0000\b\u00064\u0000-\u0006\n\u0000\u0007\u0006\u0010\u0000\u0001\u0006\u0171\u0000,\u0006\u0013\u0000\u00c6\u0006;\u0000D\u0006\u0007\u0000\u0001\u0006\u0164\u0000\u0001\u0006O\u0000\u0004\u0006\u0001\u0000\u001b\u0006\u0001\u0000\u0002\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001\u0006\u0001\u0000\n\u0006\u0001\u0000\u0004\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0006\u0000\u0001\u0006\u0004\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0003\u0006\u0001\u0000\u0002\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0001\u0000\u0001\u0006\u0002\u0000\u0004\u0006\u0001\u0000\u0007\u0006\u0001\u0000\u0004\u0006\u0001\u0000\u0004\u0006\u0001\u0000\u0001\u0006\u0001\u0000\n\u0006\u0001\u0000\u0011\u0006\u0005\u0000\u0003\u0006\u0001\u0000\u0005\u0006\u0001\u0000\u0011\u0006D\u0000\u00de\u0006\"\u00005\u0006\u000b\u0000\u00de\u0006\u0002\u0000\u0182\u0006\u000e\u0000\u0131\u0006\u001f\u0000\u001e\u0006\u00e2\u0000K\u0006\u00b5\u0000", offset, result2);
        return result2;
    }

    private static int zzUnpackcmap_blocks(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j2 = offset;
        int l2 = packed.length();
        while (i2 < l2) {
            int count = packed.charAt(i2++);
            char value2 = packed.charAt(i2++);
            do {
                result2[j2++] = value2;
            } while (--count > 0);
        }
        return j2;
    }

    private static int[] zzUnpackAction() {
        int[] result2 = new int[63];
        int offset = 0;
        offset = _KDocLexer.zzUnpackAction("\t\u0000\u0003\u0001\u0001\u0002\u0001\u0003\u0002\u0004\u0001\u0005\u0006\u0002\u0001\u0006\u0001\u0007\u0002\u0002\u0001\b\u0001\t\u0001\b\u0001\n\u0002\b\u0001\u0000\u0001\u000b\u0001\u0000\u0001\u0004\u0003\u0000\u0001\f\u0002\u0000\u0001\r\u0004\u0000\u0001\u000e\u0001\u0004\u0002\u0000\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0000\u0001\u0003\u0002\u0012\u0001\u0013\u0001\u0000\u0001\u0014\u0001\u0013", offset, result2);
        return result2;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j2 = offset;
        int l2 = packed.length();
        while (i2 < l2) {
            int count = packed.charAt(i2++);
            char value2 = packed.charAt(i2++);
            do {
                result2[j2++] = value2;
            } while (--count > 0);
        }
        return j2;
    }

    private static int[] zzUnpackRowMap() {
        int[] result2 = new int[63];
        int offset = 0;
        offset = _KDocLexer.zzUnpackRowMap("\u0000\u0000\u0000\u0013\u0000&\u00009\u0000L\u0000_\u0000r\u0000\u0085\u0000\u0098\u0000\u00ab\u0000\u00be\u0000\u00d1\u0000\u00ab\u0000\u00e4\u0000\u00f7\u0000\u010a\u0000\u011d\u0000\u0130\u0000\u0143\u0000\u0156\u0000\u0169\u0000\u00be\u0000\u017c\u0000\u018f\u0000\u01a2\u0000\u01b5\u0000\u01c8\u0000\u00ab\u0000\u01db\u0000\u00be\u0000\u01ee\u0000\u0201\u0000\u0214\u0000\u00be\u0000\u00ab\u0000\u0227\u0000\u023a\u0000\u024d\u0000\u0260\u0000\u0273\u0000\u00ab\u0000\u0286\u0000\u0299\u0000\u02ac\u0000\u02bf\u0000\u02d2\u0000\u02e5\u0000\u02f8\u0000\u00ab\u0000\u030b\u0000\u031e\u0000\u0331\u0000\u0344\u0000\u00ab\u0000\u00ab\u0000\u0357\u0000\u030b\u0000\u024d\u0000\u0273\u0000\u024d\u0000\u036a\u0000\u037d\u0000\u00ab", offset, result2);
        return result2;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j2 = offset;
        int l2 = packed.length() - 1;
        while (i2 < l2) {
            int high = packed.charAt(i2++) << 16;
            result2[j2++] = high | packed.charAt(i2++);
        }
        return j2;
    }

    private static int[] zzUnpacktrans() {
        int[] result2 = new int[912];
        int offset = 0;
        offset = _KDocLexer.zzUnpacktrans("\t\n\u0001\u000b\u0001\n\u0001\f\u0007\n\u0001\r\u0001\u000e\u0001\u000f\u0001\r\u0001\u000f\u0001\u0010\u0003\r\u0001\u0011\u0004\r\u0001\u0012\u0001\u0013\u0001\r\u0001\u0014\u0001\u0015\u0001\r\u0001\u000e\u0001\u000f\u0001\r\u0001\u000f\u0001\u0010\u0003\r\u0001\u0016\u0003\r\u0001\u0017\u0001\u0012\u0001\u0013\u0001\r\u0001\u0014\u0001\u0015\u0001\r\u0002\u0018\u0001\r\u0002\u0018\u0001\u0019\u0002\r\u0001\u0016\u0004\r\u0001\u001a\u0005\r\u0002\u0018\u0001\r\u0002\u0018\u0003\r\u0001\u0016\u0004\r\u0001\u001b\u0005\r\u0001\u000e\u0001\u000f\u0001\r\u0001\u000f\u0001\u0010\u0003\r\u0001\u0016\u0004\r\u0001\u0012\u0001\u0013\u0001\r\u0001\u0014\u0001\u0015\u0001\u001c\u0002\u001d\u0001\u001c\u0002\u001d\u0003\u001c\u0001\u001e\n\u001c\u0002\u001d\u0001\u001c\u0002\u001d\u0003\u001c\u0001\u001f\u0007\u001c\u0001 \u0001!\u0001\u001c\u0002\u001d\u0001\u001c\u0002\u001d\u0003\u001c\u0001\u001e\u0007\u001c\u0001 \u0001!\u001c\u0000\u0001\"\u0001\u0000\u0001#\u0010\u0000\u0001$\n\u0000\u0001\u000e\u0001\u000f\u0001\u0000\u0002\u000f\u000e\u0000\u0002\u000f\u0001\u0000\u0002\u000f\u000e\u0000\u0002\u000f\u0001\u0000\u0001\u000f\u0001%\u0016\u0000\u0001\u0011\u0001\u0000\u0001#\u0007\u0000\u0006&\u0001'\u0007&\u0001\u0000\u0001&\u0001(\u0002&\u000e\u0000\u0001)\u0001\u0000\u0001)\u0013\u0000\u0001*\u0013\u0000\u0001+\u0006\u0000\u0001,\r\u0000\u0002\u0018\u0001\u0000\u0002\u0018\u0013\u0000\u0001\u0019\u0003\u0000\u0001\u0019\u0001\u0000\u0001\u0019\f\u0000\u0001-\u0012\u0000\u0001.\r\u0000\u0002\u001d\u0001\u0000\u0002\u001d\u0016\u0000\u0001\u001f\u0001\u0000\u0001#\u0018\u0000\u0001/\u0013\u0000\u00010\t\u0000\u00011\n\u0000\u0002\u000f\u0001\u0000\u0001\u000f\u00012\r\u0000\u000e&\u0001\u0000\u0001&\u0001(\b&\u0001'\u0003&\u0001'\u0001&\u0001'\u0001&\u0001\u0000\u0001&\u00013\t&\u00014\u0006&\u0001\u0000\u0001&\u0001(\u0002&\u0011\u0000\u00015\u0013\u0000\u00015\u0006\u0000\u0001,\u0005\u0000\u0001,\f\u0000\u0001-\u0003\u0000\u0001-\u0001\u0000\u0001-\u0003\u0000\u00016\b\u0000\u0001.\u0003\u0000\u0001.\u0001\u0000\u0001.\u0003\u0000\u00017\u0013\u0000\u00018\u0013\u0000\u00018\u0001\u0000\u0002\u000f\u0001\u0000\u0001\u000f\u00019\r\u0000\u0007:\u00014\u0006:\u0001\u0000\u0001:\u0001;\u0002:\b4\u0001<\u00054\u0001=\u00044\u00025\u0003\u0000\u000e5\u0001\u0000\u00018\u0001>\u0001\u0000\u00028\r\u0000\b=\u0001?\n=\u0001\u0000\u0001>\u0002\u0000\u0002>\r\u0000", offset, result2);
        return result2;
    }

    private static int zzUnpacktrans(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j2 = offset;
        int l2 = packed.length();
        while (i2 < l2) {
            int count = packed.charAt(i2++);
            int value2 = packed.charAt(i2++);
            do {
                result2[j2++] = --value2;
            } while (--count > 0);
        }
        return j2;
    }

    private static int[] zzUnpackAttribute() {
        int[] result2 = new int[63];
        int offset = 0;
        offset = _KDocLexer.zzUnpackAttribute("\t\u0000\u0001\t\u0002\u0001\u0001\t\u000e\u0001\u0001\t\u0005\u0001\u0001\u0000\u0001\t\u0001\u0000\u0001\u0001\u0003\u0000\u0001\t\u0002\u0000\u0001\u0001\u0004\u0000\u0001\t\u0001\u0001\u0002\u0000\u0001\u0001\u0002\t\u0001\u0000\u0004\u0001\u0001\u0000\u0001\u0001\u0001\t", offset, result2);
        return result2;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result2) {
        int i2 = 0;
        int j2 = offset;
        int l2 = packed.length();
        while (i2 < l2) {
            int count = packed.charAt(i2++);
            char value2 = packed.charAt(i2++);
            do {
                result2[j2++] = value2;
            } while (--count > 0);
        }
        return j2;
    }

    public _KDocLexer() {
        this(null);
    }

    private boolean isLastToken() {
        return this.zzMarkedPos == this.zzBuffer.length();
    }

    private boolean yytextContainLineBreaks() {
        return CharArrayUtil.containLineBreaks(this.zzBuffer, this.zzStartRead, this.zzMarkedPos);
    }

    _KDocLexer(Reader in) {
        this.zzReader = in;
    }

    private static int zzCMap(int input) {
        int offset = input & 0xFF;
        return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
    }

    public final int getTokenStart() {
        return this.zzStartRead;
    }

    @Override
    public final int getTokenEnd() {
        return this.getTokenStart() + this.yylength();
    }

    @Override
    public void reset(CharSequence buffer, int start, int end, int initialState) {
        this.zzBuffer = buffer;
        this.zzMarkedPos = this.zzStartRead = start;
        this.zzCurrentPos = this.zzStartRead;
        this.zzAtEOF = false;
        this.zzAtBOL = true;
        this.zzEndRead = end;
        this.yybegin(initialState);
    }

    private boolean zzRefill() throws IOException {
        return true;
    }

    @Override
    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final CharSequence yytext() {
        return this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer.charAt(this.zzStartRead + pos);
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message2;
        try {
            message2 = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            message2 = ZZ_ERROR_MSG[0];
        }
        throw new Error(message2);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            return;
        }
    }

    @Override
    public IElementType advance() throws IOException {
        int zzEndReadL = this.zzEndRead;
        CharSequence zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block42: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + _KDocLexer.zzCMap(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return TokenType.BAD_CHARACTER;
                }
                case 21: {
                    continue block42;
                }
                case 2: {
                    this.yybegin(10);
                    return KDocTokens.TEXT;
                }
                case 22: {
                    continue block42;
                }
                case 3: {
                    if (this.yystate() == 4) {
                        this.yybegin(18);
                        return KDocTokens.CODE_BLOCK_TEXT;
                    }
                }
                case 23: {
                    continue block42;
                }
                case 4: {
                    if (this.yytextContainLineBreaks()) {
                        this.yybegin(2);
                        return TokenType.WHITE_SPACE;
                    }
                    this.yybegin(this.yystate() == 4 ? 4 : 10);
                    return KDocTokens.TEXT;
                }
                case 24: {
                    continue block42;
                }
                case 5: {
                    this.yybegin(4);
                    return KDocTokens.LEADING_ASTERISK;
                }
                case 25: {
                    continue block42;
                }
                case 6: {
                    if (this.yytextContainLineBreaks()) {
                        this.yybegin(2);
                    }
                    return TokenType.WHITE_SPACE;
                }
                case 26: {
                    continue block42;
                }
                case 7: {
                    this.yybegin(8);
                    return KDocTokens.MARKDOWN_LINK;
                }
                case 27: {
                    continue block42;
                }
                case 8: {
                    this.yybegin(this.yystate() == 18 ? 18 : 12);
                    return KDocTokens.CODE_BLOCK_TEXT;
                }
                case 28: {
                    continue block42;
                }
                case 9: {
                    if (this.yytextContainLineBreaks()) {
                        this.yybegin(this.yystate() == 18 ? 2 : 14);
                        return TokenType.WHITE_SPACE;
                    }
                    return KDocTokens.CODE_BLOCK_TEXT;
                }
                case 29: {
                    continue block42;
                }
                case 10: {
                    this.yybegin(16);
                    return KDocTokens.LEADING_ASTERISK;
                }
                case 30: {
                    continue block42;
                }
                case 11: {
                    if (this.isLastToken()) {
                        return KDocTokens.END;
                    }
                    return KDocTokens.TEXT;
                }
                case 31: {
                    continue block42;
                }
                case 12: {
                    this.yybegin(10);
                    return KDocTokens.MARKDOWN_ESCAPED_CHAR;
                }
                case 32: {
                    continue block42;
                }
                case 13: {
                    KDocKnownTag tag = KDocKnownTag.Companion.findByTagName(this.zzBuffer.subSequence(this.zzStartRead, this.zzMarkedPos));
                    this.yybegin(tag != null && tag.isReferenceRequired() ? 6 : 8);
                    return KDocTokens.TAG_NAME;
                }
                case 33: {
                    continue block42;
                }
                case 14: {
                    this.yybegin(4);
                    return KDocTokens.START;
                }
                case 34: {
                    continue block42;
                }
                case 15: {
                    this.yybegin(14);
                    return KDocTokens.TEXT;
                }
                case 35: {
                    continue block42;
                }
                case 16: {
                    this.yybegin(8);
                    return KDocTokens.MARKDOWN_LINK;
                }
                case 36: {
                    continue block42;
                }
                case 17: {
                    this.yybegin(10);
                    return KDocTokens.MARKDOWN_LINK;
                }
                case 37: {
                    continue block42;
                }
                case 18: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzMarkedPos, -1);
                    this.yybegin(10);
                    return KDocTokens.MARKDOWN_LINK;
                }
                case 38: {
                    continue block42;
                }
                case 19: {
                    this.yybegin(10);
                    return KDocTokens.MARKDOWN_INLINE_LINK;
                }
                case 39: {
                    continue block42;
                }
                case 20: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, 3);
                    this.yybegin(10);
                    return KDocTokens.TEXT;
                }
                case 40: {
                    continue block42;
                }
            }
            this.zzScanError(1);
        }
    }
}

