/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.NotFoundClasses;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrClassReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.error.ErrorClassDescriptor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H$J$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H$J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cJ,\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ:\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\b\u0010!\u001a\u0004\u0018\u00010\u00162\b\u0010\"\u001a\u0004\u0018\u00010\u0016H\u0002J\u001c\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0016J \u0010&\u001a\u0006\u0012\u0002\b\u00030\u001c2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010(\u001a\u00020\u001fH\u0002J\f\u0010)\u001a\u00020\u0016*\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "allowErrorTypeInAnnotations", "", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Lorg/jetbrains/kotlin/ir/util/TypeTranslator;Z)V", "extractAnnotationOffsets", "Lkotlin/Pair;", "", "annotationDescriptor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "extractAnnotationParameterOffsets", "argumentName", "Lorg/jetbrains/kotlin/name/Name;", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "generateConstantValueAsExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "endOffset", "constantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "generateAnnotationValueAsExpression", "valueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "generateConstantOrAnnotationValueAsExpression", "expectedType", "expectedArrayElementType", "generateAnnotationConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "realType", "adjustAnnotationArgumentValue", "value", "parameter", "getArrayElementType", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nConstantValueGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantValueGenerator.kt\norg/jetbrains/kotlin/ir/util/ConstantValueGenerator\n+ 2 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n32#2:234\n1625#3:235\n1869#3:236\n1870#3:239\n1626#3:240\n1#4:237\n1#4:238\n*S KotlinDebug\n*F\n+ 1 ConstantValueGenerator.kt\norg/jetbrains/kotlin/ir/util/ConstantValueGenerator\n*L\n99#1:234\n99#1:235\n99#1:236\n99#1:239\n99#1:240\n99#1:238\n*E\n"})
public abstract class ConstantValueGenerator {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final ReferenceSymbolTable symbolTable;
    @NotNull
    private final TypeTranslator typeTranslator;
    private final boolean allowErrorTypeInAnnotations;

    public ConstantValueGenerator(@NotNull ModuleDescriptor moduleDescriptor, @NotNull ReferenceSymbolTable symbolTable, @NotNull TypeTranslator typeTranslator, boolean allowErrorTypeInAnnotations) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(typeTranslator, "typeTranslator");
        this.moduleDescriptor = moduleDescriptor;
        this.symbolTable = symbolTable;
        this.typeTranslator = typeTranslator;
        this.allowErrorTypeInAnnotations = allowErrorTypeInAnnotations;
    }

    @NotNull
    protected abstract Pair<Integer, Integer> extractAnnotationOffsets(@NotNull AnnotationDescriptor var1);

    @NotNull
    protected abstract Pair<Integer, Integer> extractAnnotationParameterOffsets(@NotNull AnnotationDescriptor var1, @NotNull Name var2);

    private final IrType toIrType(KotlinType $this$toIrType) {
        return this.typeTranslator.translateType($this$toIrType);
    }

    @NotNull
    public final IrExpression generateConstantValueAsExpression(int startOffset, int endOffset, @NotNull ConstantValue<?> constantValue) {
        Intrinsics.checkNotNullParameter(constantValue, "constantValue");
        IrExpression irExpression = this.generateConstantOrAnnotationValueAsExpression(startOffset, endOffset, constantValue, null, null);
        Intrinsics.checkNotNull(irExpression);
        return irExpression;
    }

    @Nullable
    public final IrExpression generateAnnotationValueAsExpression(int startOffset, int endOffset, @NotNull ConstantValue<?> constantValue, @NotNull ValueParameterDescriptor valueParameter2) {
        Intrinsics.checkNotNullParameter(constantValue, "constantValue");
        Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
        return this.generateConstantOrAnnotationValueAsExpression(startOffset, endOffset, constantValue, valueParameter2.getType(), valueParameter2.getVarargElementType());
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateConstantOrAnnotationValueAsExpression(int startOffset, int endOffset, ConstantValue<?> constantValue, KotlinType expectedType, KotlinType expectedArrayElementType) {
        IrExpression irExpression;
        KotlinType constantValueType = constantValue.getType(this.moduleDescriptor);
        KotlinType kotlinType = expectedType;
        if (kotlinType == null) {
            kotlinType = constantValueType;
        }
        KotlinType constantKtType = kotlinType;
        IrType constantType = this.toIrType(constantKtType);
        ConstantValue<?> constantValue2 = constantValue;
        if (constantValue2 instanceof StringValue) {
            irExpression = IrConstImpl.Companion.string(startOffset, endOffset, constantType, (String)((StringValue)constantValue).getValue());
        } else if (constantValue2 instanceof IntValue) {
            irExpression = IrConstImpl.Companion.int(startOffset, endOffset, constantType, ((Number)((IntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof UIntValue) {
            irExpression = IrConstImpl.Companion.int(startOffset, endOffset, constantType, ((Number)((UIntValue)constantValue).getValue()).intValue());
        } else if (constantValue2 instanceof NullValue) {
            irExpression = IrConstImpl.Companion.constNull(startOffset, endOffset, constantType);
        } else if (constantValue2 instanceof BooleanValue) {
            irExpression = IrConstImpl.Companion.boolean(startOffset, endOffset, constantType, (Boolean)((BooleanValue)constantValue).getValue());
        } else if (constantValue2 instanceof LongValue) {
            irExpression = IrConstImpl.Companion.long(startOffset, endOffset, constantType, ((Number)((LongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof ULongValue) {
            irExpression = IrConstImpl.Companion.long(startOffset, endOffset, constantType, ((Number)((ULongValue)constantValue).getValue()).longValue());
        } else if (constantValue2 instanceof DoubleValue) {
            irExpression = IrConstImpl.Companion.double(startOffset, endOffset, constantType, ((Number)((DoubleValue)constantValue).getValue()).doubleValue());
        } else if (constantValue2 instanceof FloatValue) {
            irExpression = IrConstImpl.Companion.float(startOffset, endOffset, constantType, ((Number)((FloatValue)constantValue).getValue()).floatValue());
        } else if (constantValue2 instanceof CharValue) {
            irExpression = IrConstImpl.Companion.char(startOffset, endOffset, constantType, ((Character)((CharValue)constantValue).getValue()).charValue());
        } else if (constantValue2 instanceof ByteValue) {
            irExpression = IrConstImpl.Companion.byte(startOffset, endOffset, constantType, ((Number)((ByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof UByteValue) {
            irExpression = IrConstImpl.Companion.byte(startOffset, endOffset, constantType, ((Number)((UByteValue)constantValue).getValue()).byteValue());
        } else if (constantValue2 instanceof ShortValue) {
            irExpression = IrConstImpl.Companion.short(startOffset, endOffset, constantType, ((Number)((ShortValue)constantValue).getValue()).shortValue());
        } else if (constantValue2 instanceof UShortValue) {
            irExpression = IrConstImpl.Companion.short(startOffset, endOffset, constantType, ((Number)((UShortValue)constantValue).getValue()).shortValue());
        } else if (constantValue2 instanceof ArrayValue) {
            void $this$mapNotNullTo$iv$iv;
            void $this$memoryOptimizedMapNotNull$iv;
            KotlinType kotlinType2 = expectedArrayElementType;
            if (kotlinType2 == null) {
                kotlinType2 = this.getArrayElementType(constantValueType);
            }
            KotlinType arrayElementType = kotlinType2;
            Collection collection = (Collection)((ArrayValue)constantValue).getValue();
            IrType irType = this.toIrType(arrayElementType);
            IrType irType2 = constantType;
            int n2 = endOffset;
            int n3 = startOffset;
            boolean $i$f$memoryOptimizedMapNotNull = false;
            Iterable iterable = (Iterable)$this$memoryOptimizedMapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrExpression it$iv$iv;
                KotlinType newExpectedType;
                KotlinType kotlinType3;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                ConstantValue it = (ConstantValue)element$iv$iv;
                boolean bl2 = false;
                KotlinType it2 = kotlinType3 = arrayElementType;
                boolean bl3 = false;
                KotlinType kotlinType4 = newExpectedType = expectedType != null ? kotlinType3 : null;
                if (this.generateConstantOrAnnotationValueAsExpression(startOffset, endOffset, it, newExpectedType, null) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = CollectionsKt.compactIfPossible((List)destination$iv$iv);
            irExpression = BuildersKt.IrVarargImpl(n3, n2, irType2, irType, list);
        } else if (constantValue2 instanceof EnumValue) {
            ClassifierDescriptor enumEntryDescriptor = constantValueType.getMemberScope().getContributedClassifier(((EnumValue)constantValue).getEnumEntryName(), NoLookupLocation.FROM_BACKEND);
            if (enumEntryDescriptor == null) {
                return null;
            }
            if (!(enumEntryDescriptor instanceof ClassDescriptor)) {
                throw new AssertionError((Object)("Enum entry " + enumEntryDescriptor + " should be a ClassDescriptor"));
            }
            if (!DescriptorUtils.isEnumEntry(enumEntryDescriptor)) {
                return null;
            }
            irExpression = BuildersKt.IrGetEnumValueImpl(startOffset, endOffset, constantType, this.symbolTable.getDescriptorExtension().referenceEnumEntry((ClassDescriptor)enumEntryDescriptor));
        } else if (constantValue2 instanceof AnnotationValue) {
            irExpression = this.generateAnnotationConstructorCall((AnnotationDescriptor)((AnnotationValue)constantValue).getValue(), constantKtType);
        } else if (constantValue2 instanceof KClassValue) {
            IrClassReferenceImpl irClassReferenceImpl;
            KotlinType classifierKtType = ((KClassValue)constantValue).getArgumentType(this.moduleDescriptor);
            if (KotlinTypeKt.isError(classifierKtType)) {
                irClassReferenceImpl = null;
            } else {
                ClassifierDescriptor classifierDescriptor = classifierKtType.getConstructor().getDeclarationDescriptor();
                if (classifierDescriptor == null) {
                    throw new AssertionError((Object)("Unexpected KClassValue: " + classifierKtType));
                }
                ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
                irClassReferenceImpl = BuildersKt.IrClassReferenceImpl(startOffset, endOffset, this.toIrType(((KClassValue)constantValue).getType(this.moduleDescriptor)), IrUtilsKt.referenceClassifier(this.symbolTable, classifierDescriptor2), this.toIrType(classifierKtType));
            }
            irExpression = irClassReferenceImpl;
        } else if (constantValue2 instanceof ErrorValue) {
            irExpression = null;
        } else {
            String string2 = "Unexpected constant value: " + constantValue.getClass().getSimpleName() + ' ' + constantValue;
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
        return irExpression;
    }

    @Nullable
    public final IrConstructorCall generateAnnotationConstructorCall(@NotNull AnnotationDescriptor annotationDescriptor, @Nullable KotlinType realType) {
        KotlinType annotationType;
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter(annotationDescriptor, "annotationDescriptor");
        KotlinType kotlinType = realType;
        if (kotlinType == null) {
            kotlinType = annotationDescriptor.getType();
        }
        ClassDescriptor classDescriptor = (classifierDescriptor = (annotationType = kotlinType).getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor annotationClassDescriptor = classDescriptor;
        ClassDescriptor classDescriptor2 = annotationClassDescriptor;
        if (classDescriptor2 instanceof NotFoundClasses.MockClassDescriptor) {
            return null;
        }
        if (classDescriptor2 instanceof ErrorClassDescriptor ? !this.allowErrorTypeInAnnotations : !DescriptorUtils.isAnnotationClass(annotationClassDescriptor)) {
            return null;
        }
        ClassConstructorDescriptor classConstructorDescriptor = annotationClassDescriptor.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            Collection<ClassConstructorDescriptor> collection = annotationClassDescriptor.getConstructors();
            Intrinsics.checkNotNullExpressionValue(collection, "getConstructors(...)");
            classConstructorDescriptor = (ClassConstructorDescriptor)kotlin.collections.CollectionsKt.singleOrNull((Iterable)collection);
            if (classConstructorDescriptor == null) {
                throw new AssertionError((Object)("No constructor for annotation class " + annotationClassDescriptor));
            }
        }
        ClassConstructorDescriptor primaryConstructorDescriptor = classConstructorDescriptor;
        IrConstructorSymbol primaryConstructorSymbol = this.symbolTable.getDescriptorExtension().referenceConstructor(primaryConstructorDescriptor);
        Pair<Integer, Integer> pair = this.extractAnnotationOffsets(annotationDescriptor);
        int startOffset = ((Number)pair.component1()).intValue();
        int endOffset = ((Number)pair.component2()).intValue();
        IrType irType = this.toIrType(annotationType);
        int n2 = primaryConstructorDescriptor.getValueParameters().size();
        int n3 = primaryConstructorDescriptor.getContextReceiverParameters().size();
        boolean bl = primaryConstructorDescriptor.getDispatchReceiverParameter() != null;
        int n4 = primaryConstructorDescriptor.getExtensionReceiverParameter() != null ? 1 : 0;
        int n5 = annotationClassDescriptor.getDeclaredTypeParameters().size();
        SourceElement sourceElement = annotationDescriptor.getSource();
        IrConstructorCallImpl irCall = BuildersKt.IrConstructorCallImplWithShape$default(startOffset, endOffset, irType, primaryConstructorSymbol, n5, 0, n2, n3, bl, n4 != 0, null, sourceElement, 1024, null);
        TypeSubstitutor substitutor2 = TypeConstructorSubstitution.Companion.create(annotationType).buildSubstitutor();
        ClassConstructorDescriptor classConstructorDescriptor2 = primaryConstructorDescriptor.substitute(substitutor2);
        if (classConstructorDescriptor2 == null) {
            throw new IllegalStateException("Cannot substitute constructor".toString());
        }
        ClassConstructorDescriptor substitutedConstructor = classConstructorDescriptor2;
        List<TypeProjection> typeArguments = annotationType.getArguments();
        boolean bl2 = bl = typeArguments.size() == annotationClassDescriptor.getDeclaredTypeParameters().size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        n4 = ((Collection)typeArguments).size();
        for (int i2 = 0; i2 < n4; ++i2) {
            TypeProjection typeArgument = typeArguments.get(i2);
            List<IrType> list = irCall.getTypeArguments();
            KotlinType kotlinType2 = typeArgument.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
            list.set(i2, this.toIrType(kotlinType2));
        }
        for (ValueParameterDescriptor valueParameter2 : substitutedConstructor.getValueParameters()) {
            ConstantValue<?> argumentValue;
            int argumentIndex = valueParameter2.getIndex() + (primaryConstructorDescriptor.getDispatchReceiverParameter() != null ? 1 : 0);
            if (annotationDescriptor.getAllValueArguments().get(valueParameter2.getName()) == null) continue;
            Intrinsics.checkNotNull(valueParameter2);
            ConstantValue<?> adjustedValue = this.adjustAnnotationArgumentValue(argumentValue, valueParameter2);
            Name name2 = valueParameter2.getName();
            Intrinsics.checkNotNullExpressionValue(name2, "getName(...)");
            Pair<Integer, Integer> pair2 = this.extractAnnotationParameterOffsets(annotationDescriptor, name2);
            int parameterStartOffset = ((Number)pair2.component1()).intValue();
            int parameterEndOffset = ((Number)pair2.component2()).intValue();
            IrExpression irArgument = this.generateAnnotationValueAsExpression(parameterStartOffset, parameterEndOffset, adjustedValue, valueParameter2);
            irCall.getArguments().set(argumentIndex, irArgument);
        }
        return irCall;
    }

    public static /* synthetic */ IrConstructorCall generateAnnotationConstructorCall$default(ConstantValueGenerator constantValueGenerator, AnnotationDescriptor annotationDescriptor, KotlinType kotlinType, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generateAnnotationConstructorCall");
        }
        if ((n2 & 2) != 0) {
            kotlinType = null;
        }
        return constantValueGenerator.generateAnnotationConstructorCall(annotationDescriptor, kotlinType);
    }

    private final ConstantValue<?> adjustAnnotationArgumentValue(ConstantValue<?> value2, ValueParameterDescriptor parameter) {
        if (KotlinBuiltIns.isArrayOrPrimitiveArray(parameter.getType()) && !(value2 instanceof ArrayValue)) {
            return new ArrayValue(kotlin.collections.CollectionsKt.listOf(value2), arg_0 -> ConstantValueGenerator.adjustAnnotationArgumentValue$lambda$2(parameter, arg_0));
        }
        return value2;
    }

    private final KotlinType getArrayElementType(KotlinType $this$getArrayElementType) {
        KotlinType kotlinType = TypeUtilsKt.getBuiltIns($this$getArrayElementType).getArrayElementType($this$getArrayElementType);
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getArrayElementType(...)");
        return kotlinType;
    }

    private static final KotlinType adjustAnnotationArgumentValue$lambda$2(ValueParameterDescriptor $parameter, ModuleDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        KotlinType kotlinType = $parameter.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        return kotlinType;
    }
}

