/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.inline.CallInlinerStrategy;
import org.jetbrains.kotlin.ir.inline.InlineMode;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/inline/InlineFunctionResolver;", "", "inlineMode", "Lorg/jetbrains/kotlin/ir/inline/InlineMode;", "<init>", "(Lorg/jetbrains/kotlin/ir/inline/InlineMode;)V", "getInlineMode", "()Lorg/jetbrains/kotlin/ir/inline/InlineMode;", "callInlinerStrategy", "Lorg/jetbrains/kotlin/ir/inline/CallInlinerStrategy;", "getCallInlinerStrategy", "()Lorg/jetbrains/kotlin/ir/inline/CallInlinerStrategy;", "allowExternalInlining", "", "getAllowExternalInlining", "()Z", "needsInlining", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getFunctionDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "shouldExcludeFunctionFromInlining", "ir.inline"})
public abstract class InlineFunctionResolver {
    @NotNull
    private final InlineMode inlineMode;

    public InlineFunctionResolver(@NotNull InlineMode inlineMode) {
        Intrinsics.checkNotNullParameter((Object)inlineMode, "inlineMode");
        this.inlineMode = inlineMode;
    }

    @NotNull
    public final InlineMode getInlineMode() {
        return this.inlineMode;
    }

    @NotNull
    public CallInlinerStrategy getCallInlinerStrategy() {
        return CallInlinerStrategy.DEFAULT.INSTANCE;
    }

    public boolean getAllowExternalInlining() {
        return false;
    }

    public boolean needsInlining(@NotNull IrFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        return symbol.isBound() && symbol.getOwner().isInline() && (this.getAllowExternalInlining() || !symbol.getOwner().isExternal());
    }

    public boolean needsInlining(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return this.needsInlining((IrFunctionSymbol)expression2.getSymbol());
    }

    @Nullable
    public IrFunction getFunctionDeclaration(@NotNull IrFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        if (this.shouldExcludeFunctionFromInlining(symbol)) {
            return null;
        }
        IrFunction owner = symbol.getOwner();
        IrSimpleFunction irSimpleFunction = owner instanceof IrSimpleFunction ? (IrSimpleFunction)owner : null;
        return irSimpleFunction != null && (irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(irSimpleFunction, null, 1, null)) != null ? (IrFunction)irSimpleFunction : owner;
    }

    protected boolean shouldExcludeFunctionFromInlining(@NotNull IrFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        return !this.needsInlining(symbol) || Symbols.Companion.isTypeOfIntrinsic(symbol);
    }
}

