/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.declarations;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.CompilerVersionOfApiDeprecation;
import org.jetbrains.kotlin.DeprecatedForRemovalCompilerApi;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.MultiFieldValueClassRepresentation;
import org.jetbrains.kotlin.descriptors.ValueClassRepresentation;
import org.jetbrains.kotlin.ir.CommonIrAttributesKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\f\u001a\u00020\u0001*\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u001a%\u0010\u0000\u001a\u0002H'\"\b\b\u0000\u0010'*\u00020\u0002*\u0002H'2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007\u00a2\u0006\u0002\u0010(\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\"\u0015\u0010\u0016\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013\"\u0015\u0010\u0018\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013\"\u0015\u0010\u001a\u001a\u00020\u0005*\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\"\u0015\u0010\u001d\u001a\u00020\u0005*\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001c\"\u001d\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\"\u001d\u0010#\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010$*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006)"}, d2={"copyAttributes", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "other", "isSingleFieldValueClass", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "isMultiFieldValueClass", "addMember", "member", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "addAll", "members", "", "path", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getPath", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)Ljava/lang/String;", "name", "getName", "nameWithPackage", "getNameWithPackage", "packagePartClassName", "getPackagePartClassName", "isStaticMethodOfClass", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "isPropertyAccessor", "multiFieldValueClassRepresentation", "Lorg/jetbrains/kotlin/descriptors/MultiFieldValueClassRepresentation;", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "getMultiFieldValueClassRepresentation", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/descriptors/MultiFieldValueClassRepresentation;", "inlineClassRepresentation", "Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;", "getInlineClassRepresentation", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;", "D", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/IrElement;)Lorg/jetbrains/kotlin/ir/IrElement;", "ir.tree"})
public final class IrDeclarationsKt {
    public static final void copyAttributes(@NotNull IrElement $this$copyAttributes, @NotNull IrElement other) {
        Intrinsics.checkNotNullParameter($this$copyAttributes, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        $this$copyAttributes.setAttributeOwnerId(other.getAttributeOwnerId());
        CommonIrAttributesKt.setOriginalBeforeInline($this$copyAttributes, CommonIrAttributesKt.getOriginalBeforeInline(other));
    }

    public static final boolean isSingleFieldValueClass(@NotNull IrClass $this$isSingleFieldValueClass) {
        Intrinsics.checkNotNullParameter($this$isSingleFieldValueClass, "<this>");
        return $this$isSingleFieldValueClass.getValueClassRepresentation() instanceof InlineClassRepresentation;
    }

    public static final boolean isMultiFieldValueClass(@NotNull IrClass $this$isMultiFieldValueClass) {
        Intrinsics.checkNotNullParameter($this$isMultiFieldValueClass, "<this>");
        return $this$isMultiFieldValueClass.getValueClassRepresentation() instanceof MultiFieldValueClassRepresentation;
    }

    public static final void addMember(@NotNull IrClass $this$addMember, @NotNull IrDeclaration member) {
        Intrinsics.checkNotNullParameter($this$addMember, "<this>");
        Intrinsics.checkNotNullParameter(member, "member");
        $this$addMember.getDeclarations().add(member);
    }

    public static final void addAll(@NotNull IrClass $this$addAll, @NotNull List<? extends IrDeclaration> members) {
        Intrinsics.checkNotNullParameter($this$addAll, "<this>");
        Intrinsics.checkNotNullParameter(members, "members");
        $this$addAll.getDeclarations().addAll((Collection<IrDeclaration>)members);
    }

    @NotNull
    public static final String getPath(@NotNull IrFile $this$path) {
        Intrinsics.checkNotNullParameter($this$path, "<this>");
        return $this$path.getFileEntry().getName();
    }

    @NotNull
    public static final String getName(@NotNull IrFile $this$name) {
        Intrinsics.checkNotNullParameter($this$name, "<this>");
        String string2 = new File(IrDeclarationsKt.getPath($this$name)).getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        return string2;
    }

    @NotNull
    public static final String getNameWithPackage(@NotNull IrFile $this$nameWithPackage) {
        Intrinsics.checkNotNullParameter($this$nameWithPackage, "<this>");
        FqName fqName = $this$nameWithPackage.getPackageFqName();
        Name name2 = Name.identifier(IrDeclarationsKt.getName($this$nameWithPackage));
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        return fqName.child(name2).asString();
    }

    @NotNull
    public static final String getPackagePartClassName(@NotNull IrFile $this$packagePartClassName) {
        Intrinsics.checkNotNullParameter($this$packagePartClassName, "<this>");
        return NameUtils.getPackagePartClassNamePrefix(FilesKt.getNameWithoutExtension(new File(IrDeclarationsKt.getPath($this$packagePartClassName)))) + "Kt";
    }

    public static final boolean isStaticMethodOfClass(@NotNull IrFunction $this$isStaticMethodOfClass) {
        Intrinsics.checkNotNullParameter($this$isStaticMethodOfClass, "<this>");
        return $this$isStaticMethodOfClass instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isStaticMethodOfClass).getParent() instanceof IrClass && $this$isStaticMethodOfClass.getDispatchReceiverParameter() == null;
    }

    public static final boolean isPropertyAccessor(@NotNull IrFunction $this$isPropertyAccessor) {
        Intrinsics.checkNotNullParameter($this$isPropertyAccessor, "<this>");
        return $this$isPropertyAccessor instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isPropertyAccessor).getCorrespondingPropertySymbol() != null;
    }

    @Nullable
    public static final MultiFieldValueClassRepresentation<IrSimpleType> getMultiFieldValueClassRepresentation(@NotNull IrClass $this$multiFieldValueClassRepresentation) {
        Intrinsics.checkNotNullParameter($this$multiFieldValueClassRepresentation, "<this>");
        ValueClassRepresentation<IrSimpleType> valueClassRepresentation = $this$multiFieldValueClassRepresentation.getValueClassRepresentation();
        return valueClassRepresentation instanceof MultiFieldValueClassRepresentation ? (MultiFieldValueClassRepresentation)valueClassRepresentation : null;
    }

    @Nullable
    public static final InlineClassRepresentation<IrSimpleType> getInlineClassRepresentation(@NotNull IrClass $this$inlineClassRepresentation) {
        Intrinsics.checkNotNullParameter($this$inlineClassRepresentation, "<this>");
        ValueClassRepresentation<IrSimpleType> valueClassRepresentation = $this$inlineClassRepresentation.getValueClassRepresentation();
        return valueClassRepresentation instanceof InlineClassRepresentation ? (InlineClassRepresentation)valueClassRepresentation : null;
    }

    @DeprecatedForRemovalCompilerApi(deprecatedSince=CompilerVersionOfApiDeprecation._2_1_20)
    @NotNull
    public static final <D extends IrElement> D copyAttributes(@NotNull D $this$copyAttributes, @Nullable IrElement other) {
        D d2;
        Intrinsics.checkNotNullParameter($this$copyAttributes, "<this>");
        D $this$copyAttributes_u24lambda_u240 = d2 = $this$copyAttributes;
        boolean bl = false;
        if (other != null) {
            $this$copyAttributes_u24lambda_u240.setAttributeOwnerId(other.getAttributeOwnerId());
            CommonIrAttributesKt.setOriginalBeforeInline($this$copyAttributes_u24lambda_u240, CommonIrAttributesKt.getOriginalBeforeInline(other));
        }
        return d2;
    }
}

