/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrFunctionToJsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "<init>", "()V", "visitSimpleFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "context", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "backend.js"})
public final class IrFunctionToJsTransformer
extends BaseIrElementToJsNodeTransformer<JsFunction, JsGenerationContext> {
    @Override
    @NotNull
    public JsFunction visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull JsGenerationContext context2) {
        boolean isInterfaceDefaultImpl;
        IrClass parentClass;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrDeclarationParent irDeclarationParent = declaration.getParent();
        IrClass irClass = parentClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        boolean bl = isInterfaceDefaultImpl = irClass != null ? IrUtilsKt.isInterface(irClass) : false;
        JsName funcName = declaration.getDispatchReceiverParameter() == null || isInterfaceDefaultImpl ? (declaration.getParent() instanceof IrFunction ? context2.getNameForValueDeclaration(declaration) : context2.getNameForStaticFunction(declaration)) : context2.getNameForMemberFunction(declaration);
        return JsAstUtilsKt.translateFunction(declaration, funcName, context2);
    }

    @Override
    @NotNull
    public JsFunction visitConstructor(@NotNull IrConstructor declaration, @NotNull JsGenerationContext context2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        boolean bl = declaration.isPrimary();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        JsName funcName = context2.getNameForConstructor(declaration);
        return JsAstUtilsKt.translateFunction(declaration, funcName, context2);
    }
}

