/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "extendThrowableFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getExtendThrowableFunction", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "throwableConstructors", "", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "newThrowableFunction", "undefinedValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "extractThrowableArguments", "Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$ThrowableArguments;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "ThrowableArguments", "Transformer", "backend.js"})
public final class ThrowableLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrSimpleFunctionSymbol extendThrowableFunction;
    @NotNull
    private final List<IrConstructorSymbol> throwableConstructors;
    @NotNull
    private final IrSimpleFunctionSymbol newThrowableFunction;

    public ThrowableLowering(@NotNull JsIrBackendContext context2, @NotNull IrSimpleFunctionSymbol extendThrowableFunction) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(extendThrowableFunction, "extendThrowableFunction");
        this.context = context2;
        this.extendThrowableFunction = extendThrowableFunction;
        this.throwableConstructors = this.context.getThrowableConstructors();
        this.newThrowableFunction = this.context.getNewThrowableSymbol();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrSimpleFunctionSymbol getExtendThrowableFunction() {
        return this.extendThrowableFunction;
    }

    private final IrExpression undefinedValue() {
        return IrJsUtilsKt.getVoid(this.context);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrClass enclosingClass = IrUtilsKt.getParentClassOrNull(container);
        boolean bl = false;
        IrClass irClass = enclosingClass;
        irBody.transformChildren(new Transformer(), irClass != null ? (IrElement)irClass : (IrElement)IrUtilsKt.getFile(container));
    }

    private final ThrowableArguments extractThrowableArguments(IrFunctionAccessExpression $this$extractThrowableArguments) {
        ThrowableArguments throwableArguments;
        switch ($this$extractThrowableArguments.getArguments().size()) {
            case 0: {
                throwableArguments = new ThrowableArguments(this.undefinedValue(), this.undefinedValue());
                break;
            }
            case 2: {
                Object e2 = $this$extractThrowableArguments.getArguments().get(0);
                Intrinsics.checkNotNull(e2);
                IrExpression irExpression = (IrExpression)e2;
                Object e3 = $this$extractThrowableArguments.getArguments().get(1);
                Intrinsics.checkNotNull(e3);
                throwableArguments = new ThrowableArguments(irExpression, (IrExpression)e3);
                break;
            }
            default: {
                Object e4 = $this$extractThrowableArguments.getArguments().get(0);
                Intrinsics.checkNotNull(e4);
                IrExpression arg = (IrExpression)e4;
                IrValueParameter parameter = ((IrFunctionSymbol)$this$extractThrowableArguments.getSymbol()).getOwner().getParameters().get(0);
                if (IrTypePredicatesKt.isNullableString(parameter.getType())) {
                    throwableArguments = new ThrowableArguments(arg, this.undefinedValue());
                    break;
                }
                boolean bl = IrTypeUtilsKt.isThrowable(IrTypesKt.makeNotNull(parameter.getType()));
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                throwableArguments = new ThrowableArguments(this.undefinedValue(), arg);
            }
        }
        return throwableArguments;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$ThrowableArguments;", "", "message", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "cause", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getMessage", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getCause", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "backend.js"})
    public static final class ThrowableArguments {
        @NotNull
        private final IrExpression message;
        @NotNull
        private final IrExpression cause;

        public ThrowableArguments(@NotNull IrExpression message2, @NotNull IrExpression cause) {
            Intrinsics.checkNotNullParameter(message2, "message");
            Intrinsics.checkNotNullParameter(cause, "cause");
            this.message = message2;
            this.cause = cause;
        }

        @NotNull
        public final IrExpression getMessage() {
            return this.message;
        }

        @NotNull
        public final IrExpression getCause() {
            return this.cause;
        }

        @NotNull
        public final IrExpression component1() {
            return this.message;
        }

        @NotNull
        public final IrExpression component2() {
            return this.cause;
        }

        @NotNull
        public final ThrowableArguments copy(@NotNull IrExpression message2, @NotNull IrExpression cause) {
            Intrinsics.checkNotNullParameter(message2, "message");
            Intrinsics.checkNotNullParameter(cause, "cause");
            return new ThrowableArguments(message2, cause);
        }

        public static /* synthetic */ ThrowableArguments copy$default(ThrowableArguments throwableArguments, IrExpression irExpression, IrExpression irExpression2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irExpression = throwableArguments.message;
            }
            if ((n2 & 2) != 0) {
                irExpression2 = throwableArguments.cause;
            }
            return throwableArguments.copy(irExpression, irExpression2);
        }

        @NotNull
        public String toString() {
            return "ThrowableArguments(message=" + this.message + ", cause=" + this.cause + ')';
        }

        public int hashCode() {
            int result2 = this.message.hashCode();
            result2 = result2 * 31 + this.cause.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThrowableArguments)) {
                return false;
            }
            ThrowableArguments throwableArguments = (ThrowableArguments)other;
            if (!Intrinsics.areEqual(this.message, throwableArguments.message)) {
                return false;
            }
            return Intrinsics.areEqual(this.cause, throwableArguments.cause);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering;)V", "anyConstructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "data", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "backend.js"})
    public final class Transformer
    extends IrTransformer<IrDeclarationParent> {
        @NotNull
        private final IrConstructorSymbol anyConstructor;

        public Transformer() {
            this.anyConstructor = SequencesKt.first(IrUtilsKt.getConstructors(ThrowableLowering.this.getContext().getIrBuiltIns().getAnyClass()));
        }

        @Override
        @NotNull
        public IrStatement visitClass(@NotNull IrClass declaration, @NotNull IrDeclarationParent data) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(data, "data");
            return super.visitClass(declaration, declaration);
        }

        @Override
        @NotNull
        public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull IrDeclarationParent data) {
            IrCallImpl irCallImpl;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            expression2.transformChildren(this, data);
            if (!ThrowableLowering.this.throwableConstructors.contains(expression2.getSymbol())) {
                return expression2;
            }
            ThrowableArguments throwableArguments = ThrowableLowering.this.extractThrowableArguments(expression2);
            IrExpression messageArg = throwableArguments.component1();
            IrExpression causeArg = throwableArguments.component2();
            IrConstructorCall irConstructorCall = expression2;
            ThrowableLowering throwableLowering = ThrowableLowering.this;
            IrConstructorCall $this$visitConstructorCall_u24lambda_u241 = irConstructorCall;
            boolean bl = false;
            IrCallImpl it = irCallImpl = BuildersKt.IrCallImpl$default($this$visitConstructorCall_u24lambda_u241.getStartOffset(), $this$visitConstructorCall_u24lambda_u241.getEndOffset(), $this$visitConstructorCall_u24lambda_u241.getType(), throwableLowering.newThrowableFunction, 0, null, null, 96, null);
            boolean bl2 = false;
            it.getArguments().set(0, messageArg);
            it.getArguments().set(1, causeArg);
            return irCallImpl;
        }

        @Override
        @NotNull
        public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull IrDeclarationParent data) {
            IrExpression irExpression;
            IrCallImpl irCallImpl;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(data, "data");
            expression2.transformChildren(this, data);
            if (!ThrowableLowering.this.throwableConstructors.contains(expression2.getSymbol())) {
                return (IrExpression)expression2;
            }
            ThrowableArguments throwableArguments = ThrowableLowering.this.extractThrowableArguments((IrFunctionAccessExpression)expression2);
            IrExpression messageArg = throwableArguments.component1();
            IrExpression causeArg = throwableArguments.component2();
            IrClass klass = (IrClass)data;
            int n2 = expression2.getStartOffset();
            int n3 = expression2.getEndOffset();
            IrValueParameter irValueParameter = klass.getThisReceiver();
            Intrinsics.checkNotNull(irValueParameter);
            IrGetValueImpl thisReceiver = BuildersKt.IrGetValueImpl$default(n2, n3, irValueParameter.getSymbol(), null, 8, null);
            IrFunctionAccessExpression[] irFunctionAccessExpressionArray = expression2;
            ThrowableLowering throwableLowering = ThrowableLowering.this;
            IrFunctionAccessExpression[] $this$visitDelegatingConstructorCall_u24lambda_u243 = irFunctionAccessExpressionArray;
            boolean bl = false;
            IrCallImpl $this$visitDelegatingConstructorCall_u24lambda_u243_u24lambda_u242 = irCallImpl = BuildersKt.IrCallImpl$default($this$visitDelegatingConstructorCall_u24lambda_u243.getStartOffset(), $this$visitDelegatingConstructorCall_u24lambda_u243.getEndOffset(), $this$visitDelegatingConstructorCall_u24lambda_u243.getType(), throwableLowering.getExtendThrowableFunction(), 0, null, null, 96, null);
            boolean bl2 = false;
            $this$visitDelegatingConstructorCall_u24lambda_u243_u24lambda_u242.getArguments().set(0, thisReceiver);
            $this$visitDelegatingConstructorCall_u24lambda_u243_u24lambda_u242.getArguments().set(1, messageArg);
            $this$visitDelegatingConstructorCall_u24lambda_u243_u24lambda_u242.getArguments().set(2, causeArg);
            IrCallImpl expressionReplacement = irCallImpl;
            if (!ThrowableLowering.this.getContext().getEs6mode()) {
                irExpression = expressionReplacement;
            } else {
                irFunctionAccessExpressionArray = new IrFunctionAccessExpression[]{BuildersKt.IrDelegatingConstructorCallImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), ThrowableLowering.this.getContext().getIrBuiltIns().getAnyType(), this.anyConstructor, 0, null, 32, null), expressionReplacement};
                irExpression = JsIrBuilder.INSTANCE.buildComposite(ThrowableLowering.this.getContext().getIrBuiltIns().getUnitType(), CollectionsKt.listOf(irFunctionAccessExpressionArray));
            }
            return irExpression;
        }
    }
}

