/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/PrimitiveCompanionLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getActualPrimitiveCompanion", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irClass", "getActualPrimitiveCompanionPropertyAccessor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "function", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nPrimitiveCompanionLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveCompanionLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PrimitiveCompanionLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1#2:87\n808#3,11:88\n626#3,12:99\n*S KotlinDebug\n*F\n+ 1 PrimitiveCompanionLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/PrimitiveCompanionLowering\n*L\n58#1:88,11\n59#1:99,12\n*E\n"})
public final class PrimitiveCompanionLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    public PrimitiveCompanionLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    private final IrClass getActualPrimitiveCompanion(IrClass irClass) {
        if (!irClass.isCompanion()) {
            return null;
        }
        IrDeclarationParent irDeclarationParent = irClass.getParent();
        Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass parent2 = (IrClass)irDeclarationParent;
        if (!IrTypePredicatesKt.isPrimitiveType$default(IrUtilsKt.getDefaultType(parent2), false, 1, null) && !IrTypePredicatesKt.isString(IrUtilsKt.getDefaultType(parent2))) {
            return null;
        }
        IrClassSymbol irClassSymbol = this.context.getPrimitiveCompanionObjects().get(parent2.getName());
        return irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction getActualPrimitiveCompanionPropertyAccessor(IrSimpleFunction function2) {
        void $this$single$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Object object = function2.getCorrespondingPropertySymbol();
        if (object == null || (object = (IrProperty)object.getOwner()) == null) {
            return null;
        }
        Object property2 = object;
        Object object2 = ((IrDeclarationBase)property2).getParent();
        IrClass irClass = object2 instanceof IrClass ? (IrClass)object2 : null;
        if (irClass == null) {
            return null;
        }
        IrClass companion = irClass;
        IrClass irClass2 = this.getActualPrimitiveCompanion(companion);
        if (irClass2 == null) {
            return null;
        }
        IrClass actualCompanion = irClass2;
        object2 = IrUtilsKt.getProperties(actualCompanion).iterator();
        while (object2.hasNext()) {
            IrSimpleFunction it;
            IrProperty p2 = (IrProperty)object2.next();
            if (p2.getGetter() != null) {
                boolean bl = false;
                if (Intrinsics.areEqual(it.getName(), function2.getName())) {
                    return it;
                }
            }
            if (p2.getSetter() == null) continue;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName(), function2.getName())) continue;
            return it;
        }
        object2 = actualCompanion.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        void var7_13 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName(), function2.getName())) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return single$iv;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this){
            final /* synthetic */ PrimitiveCompanionLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrExpression visitGetObjectValue(IrGetObjectValue expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrClass irClass = (IrClass)expression2.getSymbol().getOwner();
                IrClass irClass2 = PrimitiveCompanionLowering.access$getActualPrimitiveCompanion(this.this$0, irClass);
                if (irClass2 == null) {
                    return expression2;
                }
                IrClass actualCompanion = irClass2;
                return BuildersKt.IrGetObjectValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), IrUtilsKt.getDefaultType(actualCompanion), actualCompanion.getSymbol());
            }

            public IrExpression visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                IrExpression irExpression = super.visitCall(expression2);
                Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                IrCall newCall = (IrCall)irExpression;
                IrSimpleFunction irSimpleFunction = PrimitiveCompanionLowering.access$getActualPrimitiveCompanionPropertyAccessor(this.this$0, (IrSimpleFunction)expression2.getSymbol().getOwner());
                if (irSimpleFunction == null) {
                    return newCall;
                }
                IrSimpleFunction actualFunction = irSimpleFunction;
                return IrUtilsKt.irCall$default((IrFunctionAccessExpression)newCall, actualFunction, false, false, null, null, 60, null);
            }
        });
    }

    public static final /* synthetic */ IrClass access$getActualPrimitiveCompanion(PrimitiveCompanionLowering $this, IrClass irClass) {
        return $this.getActualPrimitiveCompanion(irClass);
    }

    public static final /* synthetic */ IrSimpleFunction access$getActualPrimitiveCompanionPropertyAccessor(PrimitiveCompanionLowering $this, IrSimpleFunction function2) {
        return $this.getActualPrimitiveCompanionPropertyAccessor(function2);
    }
}

