/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ir.SharedVariablesManager;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/JsSharedVariablesManager;", "Lorg/jetbrains/kotlin/backend/common/ir/SharedVariablesManager;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "dynamicType", "Lorg/jetbrains/kotlin/ir/types/IrDynamicType;", "intrinsics", "Lorg/jetbrains/kotlin/ir/backend/js/JsIntrinsics;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/types/IrDynamicType;Lorg/jetbrains/kotlin/ir/backend/js/JsIntrinsics;)V", "createBox", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "readBox", "writeBox", "declareSharedVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "originalDeclaration", "defineSharedValue", "sharedVariableDeclaration", "getSharedValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "sharedVariableSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "originalGet", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "setSharedValue", "originalSet", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "backend.js"})
public final class JsSharedVariablesManager
implements SharedVariablesManager {
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final IrDynamicType dynamicType;
    @NotNull
    private final IrSimpleFunctionSymbol createBox;
    @NotNull
    private final IrSimpleFunctionSymbol readBox;
    @NotNull
    private final IrSimpleFunctionSymbol writeBox;

    public JsSharedVariablesManager(@NotNull IrBuiltIns builtIns, @NotNull IrDynamicType dynamicType, @NotNull JsIntrinsics intrinsics) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(dynamicType, "dynamicType");
        Intrinsics.checkNotNullParameter(intrinsics, "intrinsics");
        this.builtIns = builtIns;
        this.dynamicType = dynamicType;
        this.createBox = intrinsics.getCreateSharedBox();
        this.readBox = intrinsics.getReadSharedBox();
        this.writeBox = intrinsics.getWriteSharedBox();
    }

    @Override
    @NotNull
    public IrVariable declareSharedVariable(@NotNull IrVariable originalDeclaration) {
        Intrinsics.checkNotNullParameter(originalDeclaration, "originalDeclaration");
        IrType valueType = originalDeclaration.getType();
        IrExpression irExpression = originalDeclaration.getInitializer();
        if (irExpression == null) {
            irExpression = IrConstImpl.Companion.constNull(originalDeclaration.getStartOffset(), originalDeclaration.getEndOffset(), valueType);
        }
        IrExpression initializer = irExpression;
        IrElementBase irElementBase = BuildersKt.IrCallImpl$default(initializer.getStartOffset(), initializer.getEndOffset(), this.dynamicType, this.createBox, 1, null, null, 96, null);
        IrCallImpl $this$declareSharedVariable_u24lambda_u240 = irElementBase;
        boolean bl = false;
        $this$declareSharedVariable_u24lambda_u240.getTypeArguments().set(0, valueType);
        $this$declareSharedVariable_u24lambda_u240.getArguments().set(0, initializer);
        IrCallImpl irCall = irElementBase;
        IrElementBase it = irElementBase = DeclarationBuildersKt.buildVariable$default(originalDeclaration.getParent(), originalDeclaration.getStartOffset(), originalDeclaration.getEndOffset(), originalDeclaration.getOrigin(), originalDeclaration.getName(), this.dynamicType, false, false, false, 448, null);
        boolean bl2 = false;
        ((IrVariable)it).setInitializer(irCall);
        return irElementBase;
    }

    @Override
    @NotNull
    public IrVariable defineSharedValue(@NotNull IrVariable originalDeclaration, @NotNull IrVariable sharedVariableDeclaration) {
        Intrinsics.checkNotNullParameter(originalDeclaration, "originalDeclaration");
        Intrinsics.checkNotNullParameter(sharedVariableDeclaration, "sharedVariableDeclaration");
        return sharedVariableDeclaration;
    }

    @Override
    @NotNull
    public IrExpression getSharedValue(@NotNull IrValueSymbol sharedVariableSymbol, @NotNull IrGetValue originalGet) {
        IrCallImpl irCallImpl;
        Intrinsics.checkNotNullParameter(sharedVariableSymbol, "sharedVariableSymbol");
        Intrinsics.checkNotNullParameter(originalGet, "originalGet");
        IrCallImpl $this$getSharedValue_u24lambda_u242 = irCallImpl = BuildersKt.IrCallImpl$default(originalGet.getStartOffset(), originalGet.getEndOffset(), originalGet.getType(), this.readBox, 1, originalGet.getOrigin(), null, 64, null);
        boolean bl = false;
        $this$getSharedValue_u24lambda_u242.getTypeArguments().set(0, originalGet.getType());
        $this$getSharedValue_u24lambda_u242.getArguments().set(0, BuildersKt.IrGetValueImpl(originalGet.getStartOffset(), originalGet.getEndOffset(), this.dynamicType, sharedVariableSymbol, originalGet.getOrigin()));
        return irCallImpl;
    }

    @Override
    @NotNull
    public IrExpression setSharedValue(@NotNull IrValueSymbol sharedVariableSymbol, @NotNull IrSetValue originalSet) {
        IrCallImpl irCallImpl;
        Intrinsics.checkNotNullParameter(sharedVariableSymbol, "sharedVariableSymbol");
        Intrinsics.checkNotNullParameter(originalSet, "originalSet");
        IrCallImpl $this$setSharedValue_u24lambda_u243 = irCallImpl = BuildersKt.IrCallImpl$default(originalSet.getStartOffset(), originalSet.getEndOffset(), this.builtIns.getUnitType(), this.writeBox, 1, originalSet.getOrigin(), null, 64, null);
        boolean bl = false;
        $this$setSharedValue_u24lambda_u243.getTypeArguments().set(0, originalSet.getValue().getType());
        $this$setSharedValue_u24lambda_u243.getArguments().set(0, BuildersKt.IrGetValueImpl(originalSet.getStartOffset(), originalSet.getEndOffset(), this.dynamicType, sharedVariableSymbol, originalSet.getOrigin()));
        $this$setSharedValue_u24lambda_u243.getArguments().set(1, originalSet.getValue());
        return irCallImpl;
    }
}

