/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.SourcesUtilsKt;
import org.jetbrains.kotlin.build.report.BuildReporter;
import org.jetbrains.kotlin.build.report.DoNothingICReporter;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.metrics.DoNothingBuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.CompilerRunnerUtils;
import org.jetbrains.kotlin.incremental.IncrementalCompilationFeatures;
import org.jetbrains.kotlin.incremental.IncrementalCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalFirJvmCompilerRunner;
import org.jetbrains.kotlin.incremental.IncrementalJvmCompilerRunner;
import org.jetbrains.kotlin.incremental.multiproject.EmptyModulesApiHistory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u000f*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000f\u001a8\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u001a7\u0010\u001d\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001e2\u0006\u0010\u0018\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001e0\"H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#\"(\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\"4\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\u00032\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006$"}, d2={"value", "Ljava/io/File;", "destinationAsFile", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "getDestinationAsFile", "(Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;)Ljava/io/File;", "setDestinationAsFile", "(Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;Ljava/io/File;)V", "", "classpathAsList", "getClasspathAsList", "(Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;)Ljava/util/List;", "setClasspathAsList", "(Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;Ljava/util/List;)V", "isK1ForcedByKapt", "", "(Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;)Z", "disablePreciseJavaTrackingIfK2", "usePreciseJavaTrackingByDefault", "makeJvmIncrementally", "", "cachesDir", "sourceRoots", "", "args", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "reporter", "Lorg/jetbrains/kotlin/build/report/ICReporter;", "withIncrementalCompilation", "R", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "enabled", "fn", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "incremental-compilation-impl"})
@JvmName(name="CompilerRunnerUtils")
@SourceDebugExtension(value={"SMAP\nCompilerRunnerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerRunnerUtils.kt\norg/jetbrains/kotlin/incremental/CompilerRunnerUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,123:1\n109#1,12:138\n1563#2:124\n1634#2,3:125\n1563#2:130\n1634#2,3:131\n12637#3,2:128\n37#4:134\n36#4,3:135\n*S KotlinDebug\n*F\n+ 1 CompilerRunnerUtils.kt\norg/jetbrains/kotlin/incremental/CompilerRunnerUtils\n*L\n71#1:138,12\n30#1:124\n30#1:125,3\n68#1:130\n68#1:131,3\n39#1:128,2\n68#1:134\n68#1:135,3\n*E\n"})
public final class CompilerRunnerUtils {
    @NotNull
    public static final File getDestinationAsFile(@NotNull K2JVMCompilerArguments $this$destinationAsFile) {
        Intrinsics.checkNotNullParameter($this$destinationAsFile, "<this>");
        return new File($this$destinationAsFile.getDestination());
    }

    public static final void setDestinationAsFile(@NotNull K2JVMCompilerArguments $this$destinationAsFile, @NotNull File value2) {
        Intrinsics.checkNotNullParameter($this$destinationAsFile, "<this>");
        Intrinsics.checkNotNullParameter(value2, "value");
        $this$destinationAsFile.setDestination(value2.getAbsolutePath());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> getClasspathAsList(@NotNull K2JVMCompilerArguments $this$classpathAsList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$classpathAsList, "<this>");
        String string2 = $this$classpathAsList.getClasspath();
        if (string2 == null) {
            string2 = "";
        }
        String[] stringArray = new String[]{File.pathSeparator};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)p0));
        }
        return (List)destination$iv$iv;
    }

    public static final void setClasspathAsList(@NotNull K2JVMCompilerArguments $this$classpathAsList, @NotNull List<? extends File> value2) {
        Intrinsics.checkNotNullParameter($this$classpathAsList, "<this>");
        Intrinsics.checkNotNullParameter(value2, "value");
        Iterable iterable = value2;
        String string2 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue(string2, "pathSeparator");
        $this$classpathAsList.setClasspath(CollectionsKt.joinToString$default(iterable, string2, null, null, 0, null, CompilerRunnerUtils::_set_classpathAsList_$lambda$0, 30, null));
    }

    public static final boolean isK1ForcedByKapt(@NotNull K2JVMCompilerArguments $this$isK1ForcedByKapt) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isK1ForcedByKapt, "<this>");
        String string2 = $this$isK1ForcedByKapt.getLanguageVersion();
        boolean isK2 = !(string2 != null ? !StringsKt.startsWith$default((CharSequence)string2, '2', false, 2, null) : false);
        String[] stringArray = $this$isK1ForcedByKapt.getPluginOptions();
        if (stringArray != null) {
            boolean bl2;
            block3: {
                String[] $this$any$iv = stringArray;
                boolean $i$f$any = false;
                int n2 = $this$any$iv.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String element$iv;
                    String it = element$iv = $this$any$iv[i2];
                    boolean bl3 = false;
                    if (!StringsKt.startsWith$default(it, "plugin:org.jetbrains.kotlin.kapt3", false, 2, null)) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        boolean isKaptUsed = bl;
        return isK2 && isKaptUsed && Intrinsics.areEqual($this$isK1ForcedByKapt.getUseK2Kapt(), false);
    }

    public static final boolean disablePreciseJavaTrackingIfK2(@NotNull K2JVMCompilerArguments $this$disablePreciseJavaTrackingIfK2, boolean usePreciseJavaTrackingByDefault) {
        LanguageVersion languageVersion;
        Intrinsics.checkNotNullParameter($this$disablePreciseJavaTrackingIfK2, "<this>");
        if (CompilerRunnerUtils.isK1ForcedByKapt($this$disablePreciseJavaTrackingIfK2)) {
            languageVersion = LanguageVersion.KOTLIN_1_9;
        } else {
            languageVersion = LanguageVersion.Companion.fromVersionString($this$disablePreciseJavaTrackingIfK2.getLanguageVersion());
            if (languageVersion == null) {
                languageVersion = LanguageVersion.LATEST_STABLE;
            }
        }
        LanguageVersion languageVersion2 = languageVersion;
        return !languageVersion2.getUsesK2() && usePreciseJavaTrackingByDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void makeJvmIncrementally(@NotNull File cachesDir, @NotNull Iterable<? extends File> sourceRoots, @NotNull K2JVMCompilerArguments args, @NotNull MessageCollector messageCollector, @NotNull ICReporter reporter) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter(cachesDir, "cachesDir");
        Intrinsics.checkNotNullParameter(sourceRoots, "sourceRoots");
        Intrinsics.checkNotNullParameter(args, "args");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Set<String> kotlinExtensions = SourcesUtilsKt.getDEFAULT_KOTLIN_SOURCE_FILES_EXTENSIONS();
        Set<String> allExtensions = SetsKt.plus(kotlinExtensions, "java");
        Sequence rootsWalk = SequencesKt.flatMap(CollectionsKt.asSequence(sourceRoots), CompilerRunnerUtils::makeJvmIncrementally$lambda$2);
        Sequence files2 = SequencesKt.filter(rootsWalk, makeJvmIncrementally.files.1.INSTANCE);
        List<File> sourceFiles = SequencesKt.toList(SequencesKt.filter(files2, arg_0 -> CompilerRunnerUtils.makeJvmIncrementally$lambda$3(allExtensions, arg_0)));
        File buildHistoryFile = new File(cachesDir, "build-history.bin");
        Iterable<? extends File> iterable = sourceRoots;
        K2JVMCompilerArguments k2JVMCompilerArguments = args;
        boolean $i$f$map = false;
        void var13_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAbsolutePath());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        k2JVMCompilerArguments.setJavaSourceRoots(thisCollection$iv.toArray(new String[0]));
        BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildReporter = new BuildReporter<GradleBuildTime, GradleBuildPerformanceMetric>(reporter, DoNothingBuildMetricsReporter.INSTANCE);
        boolean enabled$iv = true;
        boolean $i$f$withIncrementalCompilation = false;
        boolean isEnabledBackup$iv = IncrementalCompilation.isEnabledForJvm();
        IncrementalCompilation.setIsEnabledForJvm(enabled$iv);
        try {
            if (((CommonCompilerArguments)args).getIncrementalCompilation() == null) {
                ((CommonCompilerArguments)args).setIncrementalCompilation(enabled$iv);
            }
            boolean bl = false;
            LanguageVersion languageVersion = LanguageVersion.Companion.fromVersionString(args.getLanguageVersion());
            if (languageVersion == null) {
                languageVersion = LanguageVersion.LATEST_STABLE;
            }
            LanguageVersion languageVersion2 = languageVersion;
            boolean useK2 = languageVersion2.getUsesK2();
            boolean verifiedPreciseJavaTracking = CompilerRunnerUtils.disablePreciseJavaTrackingIfK2(args, true);
            IncrementalJvmCompilerRunner compiler = useK2 && args.getUseFirIC() && args.getUseFirLT() ? (IncrementalJvmCompilerRunner)new IncrementalFirJvmCompilerRunner(cachesDir, buildReporter, buildHistoryFile, null, EmptyModulesApiHistory.INSTANCE, ClasspathChanges.ClasspathSnapshotDisabled.INSTANCE, kotlinExtensions, new IncrementalCompilationFeatures(verifiedPreciseJavaTracking, false, false, false, false, false, 62, null)) : new IncrementalJvmCompilerRunner(cachesDir, buildReporter, buildHistoryFile, null, EmptyModulesApiHistory.INSTANCE, ClasspathChanges.ClasspathSnapshotDisabled.INSTANCE, kotlinExtensions, new IncrementalCompilationFeatures(verifiedPreciseJavaTracking, false, false, false, false, false, 62, null));
            ExitCode exitCode = IncrementalCompilerRunner.compile$default(compiler, sourceFiles, args, messageCollector, ChangedFiles.DeterminableFiles.ToBeComputed.INSTANCE, null, 16, null);
        }
        finally {
            IncrementalCompilation.setIsEnabledForJvm(isEnabledBackup$iv);
        }
    }

    public static /* synthetic */ void makeJvmIncrementally$default(File file2, Iterable iterable, K2JVMCompilerArguments k2JVMCompilerArguments, MessageCollector messageCollector, ICReporter iCReporter, int n2, Object object) {
        if ((n2 & 8) != 0) {
            messageCollector = MessageCollector.Companion.getNONE();
        }
        if ((n2 & 0x10) != 0) {
            iCReporter = DoNothingICReporter.INSTANCE;
        }
        CompilerRunnerUtils.makeJvmIncrementally(file2, iterable, k2JVMCompilerArguments, messageCollector, iCReporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <R> R withIncrementalCompilation(@NotNull CommonCompilerArguments args, boolean enabled, @NotNull Function0<? extends R> fn) {
        Intrinsics.checkNotNullParameter(args, "args");
        Intrinsics.checkNotNullParameter(fn, "fn");
        boolean $i$f$withIncrementalCompilation = false;
        boolean isEnabledBackup = IncrementalCompilation.isEnabledForJvm();
        IncrementalCompilation.setIsEnabledForJvm(enabled);
        try {
            if (args.getIncrementalCompilation() == null) {
                args.setIncrementalCompilation(enabled);
            }
            R r2 = fn.invoke();
            return r2;
        }
        finally {
            InlineMarker.finallyStart(1);
            IncrementalCompilation.setIsEnabledForJvm(isEnabledBackup);
            InlineMarker.finallyEnd(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ Object withIncrementalCompilation$default(CommonCompilerArguments args, boolean enabled, Function0 fn, int n2, Object object) {
        if ((n2 & 2) != 0) {
            enabled = true;
        }
        Intrinsics.checkNotNullParameter(args, "args");
        Intrinsics.checkNotNullParameter(fn, "fn");
        boolean $i$f$withIncrementalCompilation = false;
        boolean isEnabledBackup = IncrementalCompilation.isEnabledForJvm();
        IncrementalCompilation.setIsEnabledForJvm(enabled);
        try {
            if (args.getIncrementalCompilation() == null) {
                args.setIncrementalCompilation(enabled);
            }
            Object r2 = fn.invoke();
            return r2;
        }
        finally {
            InlineMarker.finallyStart(1);
            IncrementalCompilation.setIsEnabledForJvm(isEnabledBackup);
            InlineMarker.finallyEnd(1);
        }
    }

    private static final CharSequence _set_classpathAsList_$lambda$0(File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string2 = it.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string2, "getAbsolutePath(...)");
        return string2;
    }

    private static final Sequence makeJvmIncrementally$lambda$2(File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return FilesKt.walk$default(it, null, 1, null);
    }

    private static final boolean makeJvmIncrementally$lambda$3(Set $allExtensions, File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string2 = FilesKt.getExtension(it).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        return $allExtensions.contains(string2);
    }
}

