/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\b\u001a\u00020\u0002*\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u001a\u0012\u0010\b\u001a\u00020\n*\u00020\n2\u0006\u0010\t\u001a\u00020\u0001\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0015\u0010\u000b\u001a\u00020\f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "getType", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isStarProjection", "", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)Z", "replaceType", "newType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinTypeProjection;", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "getVariance", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)Lorg/jetbrains/kotlin/types/Variance;", "cones"})
@SourceDebugExtension(value={"SMAP\nConeTypeProjection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeTypeProjection.kt\norg/jetbrains/kotlin/fir/types/ConeTypeProjectionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class ConeTypeProjectionKt {
    @Nullable
    public static final ConeKotlinType getType(@NotNull ConeTypeProjection $this$type) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$type, "<this>");
        ConeTypeProjection coneTypeProjection = $this$type;
        if (Intrinsics.areEqual(coneTypeProjection, ConeStarProjection.INSTANCE)) {
            coneKotlinType = null;
        } else if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
            coneKotlinType = ((ConeKotlinTypeProjection)$this$type).getType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    public static final boolean isStarProjection(@NotNull ConeTypeProjection $this$isStarProjection) {
        Intrinsics.checkNotNullParameter($this$isStarProjection, "<this>");
        return Intrinsics.areEqual($this$isStarProjection, ConeStarProjection.INSTANCE);
    }

    @NotNull
    public static final ConeTypeProjection replaceType(@NotNull ConeTypeProjection $this$replaceType, @Nullable ConeKotlinType newType) {
        ConeTypeProjection coneTypeProjection;
        Intrinsics.checkNotNullParameter($this$replaceType, "<this>");
        ConeTypeProjection coneTypeProjection2 = $this$replaceType;
        if (coneTypeProjection2 instanceof ConeStarProjection) {
            coneTypeProjection = $this$replaceType;
        } else if (coneTypeProjection2 instanceof ConeKotlinTypeProjection) {
            if (newType == null) {
                boolean bl = false;
                String string2 = "Type for non star projection should be not null";
                throw new IllegalArgumentException(string2.toString());
            }
            coneTypeProjection = ConeTypeProjectionKt.replaceType((ConeKotlinTypeProjection)$this$replaceType, newType);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneTypeProjection;
    }

    @NotNull
    public static final ConeKotlinTypeProjection replaceType(@NotNull ConeKotlinTypeProjection $this$replaceType, @NotNull ConeKotlinType newType) {
        ConeKotlinTypeProjection coneKotlinTypeProjection;
        Intrinsics.checkNotNullParameter($this$replaceType, "<this>");
        Intrinsics.checkNotNullParameter(newType, "newType");
        ConeKotlinTypeProjection coneKotlinTypeProjection2 = $this$replaceType;
        if (coneKotlinTypeProjection2 instanceof ConeKotlinType) {
            coneKotlinTypeProjection = newType;
        } else if (coneKotlinTypeProjection2 instanceof ConeKotlinTypeProjectionIn) {
            coneKotlinTypeProjection = new ConeKotlinTypeProjectionIn(newType);
        } else if (coneKotlinTypeProjection2 instanceof ConeKotlinTypeProjectionOut) {
            coneKotlinTypeProjection = new ConeKotlinTypeProjectionOut(newType);
        } else if (coneKotlinTypeProjection2 instanceof ConeKotlinTypeConflictingProjection) {
            coneKotlinTypeProjection = new ConeKotlinTypeConflictingProjection(newType);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinTypeProjection;
    }

    @NotNull
    public static final Variance getVariance(@NotNull ConeTypeProjection $this$variance) {
        Variance variance;
        Intrinsics.checkNotNullParameter($this$variance, "<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$variance.getKind().ordinal()]) {
            case 1: {
                variance = Variance.OUT_VARIANCE;
                break;
            }
            case 2: {
                variance = Variance.IN_VARIANCE;
                break;
            }
            case 3: {
                variance = Variance.OUT_VARIANCE;
                break;
            }
            case 4: {
                variance = Variance.INVARIANT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return variance;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProjectionKind.values().length];
            try {
                nArray[ProjectionKind.STAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.OUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectionKind.INVARIANT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

