/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.deserialization;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltInsSignatures;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.builder.FirRegularClassBuilder;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirDeserializationExtension;
import org.jetbrains.kotlin.fir.java.deserialization.FirJvmConstDeserializer;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/java/deserialization/FirJvmDeserializationExtension;", "Lorg/jetbrains/kotlin/fir/deserialization/FirDeserializationExtension;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "createConstDeserializer", "Lorg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer;", "containerSource", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "serializerExtensionProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "configureDeserializedClass", "", "Lorg/jetbrains/kotlin/fir/declarations/builder/FirRegularClassBuilder;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "addSerializableIfNeeded", "loadModuleName", "", "classProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "Companion", "java"})
@SourceDebugExtension(value={"SMAP\nFirJvmDeserializationExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmDeserializationExtension.kt\norg/jetbrains/kotlin/fir/java/deserialization/FirJvmDeserializationExtension\n+ 2 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n49#2:61\n1#3:62\n*S KotlinDebug\n*F\n+ 1 FirJvmDeserializationExtension.kt\norg/jetbrains/kotlin/fir/java/deserialization/FirJvmDeserializationExtension\n*L\n44#1:61\n*E\n"})
public final class FirJvmDeserializationExtension
extends FirDeserializationExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ClassId JAVA_IO_SERIALIZABLE = ClassId.Companion.topLevel(new FqName("java.io.Serializable"));

    public FirJvmDeserializationExtension(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        super(session2);
    }

    @Override
    @Nullable
    public FirConstDeserializer createConstDeserializer(@Nullable DeserializedContainerSource containerSource, @NotNull FirSession session2, @NotNull SerializerExtensionProtocol serializerExtensionProtocol) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(serializerExtensionProtocol, "serializerExtensionProtocol");
        return containerSource instanceof KotlinJvmBinarySourceElement ? (FirConstDeserializer)new FirJvmConstDeserializer(((KotlinJvmBinarySourceElement)containerSource).getBinaryClass(), serializerExtensionProtocol) : null;
    }

    @Override
    public void configureDeserializedClass(@NotNull FirRegularClassBuilder $this$configureDeserializedClass, @NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter($this$configureDeserializedClass, "<this>");
        Intrinsics.checkNotNullParameter(classId, "classId");
        this.addSerializableIfNeeded($this$configureDeserializedClass, classId);
    }

    private final void addSerializableIfNeeded(FirRegularClassBuilder $this$addSerializableIfNeeded, ClassId classId) {
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
        if (!JvmBuiltInsSignatures.INSTANCE.isSerializableInJava(classId.asSingleFqName().toUnsafe())) {
            return;
        }
        Collection collection = $this$addSerializableIfNeeded.getSuperTypeRefs();
        boolean $i$f$buildResolvedTypeRef = false;
        FirResolvedTypeRefBuilder $this$addSerializableIfNeeded_u24lambda_u240 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        boolean bl = false;
        $this$addSerializableIfNeeded_u24lambda_u240.setConeType(new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(JAVA_IO_SERIALIZABLE), ConeTypeProjection.Companion.getEMPTY_ARRAY(), false, null, 8, null));
        FirResolvedTypeRef firResolvedTypeRef = firResolvedTypeRefBuilder.build();
        collection.add(firResolvedTypeRef);
    }

    @Override
    @Nullable
    public String loadModuleName(@NotNull ProtoBuf.Class classProto, @NotNull NameResolver nameResolver) {
        String string2;
        Intrinsics.checkNotNullParameter(classProto, "classProto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        GeneratedMessageLite.ExtendableMessage extendableMessage = classProto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Class, Integer> generatedExtension = JvmProtoBuf.classModuleName;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, "classModuleName");
        Integer n2 = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        if (n2 != null) {
            int p0 = ((Number)n2).intValue();
            boolean bl = false;
            string2 = nameResolver.getString(p0);
        } else {
            string2 = null;
        }
        return string2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/java/deserialization/FirJvmDeserializationExtension$Companion;", "", "<init>", "()V", "JAVA_IO_SERIALIZABLE", "Lorg/jetbrains/kotlin/name/ClassId;", "java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

