/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.metadata.BuiltinsSerializer;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.FirMetadataSource;
import org.jetbrains.kotlin.fir.backend.jvm.FirBuiltInsSerializer;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.comparators.FirMemberDeclarationComparator;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirCloneableSymbolProvider;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.serialization.FirAdditionalMetadataProvider;
import org.jetbrains.kotlin.fir.serialization.FirElementSerializer;
import org.jetbrains.kotlin.fir.serialization.FirSerializerExtensionBase;
import org.jetbrains.kotlin.fir.serialization.TypeApproximatorForMetadataSerializer;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirBuiltInsSerializer;", "Lorg/jetbrains/kotlin/backend/jvm/metadata/BuiltinsSerializer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "serialize", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/FqName;", "", "filesMetadata", "Lorg/jetbrains/kotlin/ir/declarations/MetadataSource$File;", "serializeEmptyPackage", "fqName", "PackageSerializer", "FirBuiltInsSerializerExtension", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nFirBuiltinsSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirBuiltinsSerializer.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirBuiltInsSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,159:1\n1563#2:160\n1634#2,3:161\n384#3,7:164\n384#3,7:171\n126#4:178\n153#4,3:179\n*S KotlinDebug\n*F\n+ 1 FirBuiltinsSerializer.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirBuiltInsSerializer\n*L\n47#1:160\n47#1:161,3\n49#1:164,7\n60#1:171,7\n64#1:178\n64#1:179,3\n*E\n"})
public final class FirBuiltInsSerializer
implements BuiltinsSerializer {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;

    public FirBuiltInsSerializer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        this.session = session2;
        this.scopeSession = scopeSession;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<FqName, byte[]>> serialize(@NotNull List<? extends MetadataSource.File> filesMetadata) {
        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"org/jetbrains/kotlin/fir/backend/jvm/FirBuiltInsSerializer$serialize$PackageContent", "", "<init>", "()V", "classes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "getClasses", "()Ljava/util/List;", "members", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "getMembers", "jvm-backend"})
        public final class PackageContent {
            private final List<FirRegularClass> classes;
            private final List<FirMemberDeclaration> members;

            public PackageContent() {
                this.classes = new ArrayList<E>();
                this.members = new ArrayList<E>();
            }

            public final List<FirRegularClass> getClasses() {
                return this.classes;
            }

            public final List<FirMemberDeclaration> getMembers() {
                return this.members;
            }
        }
        void $this$mapTo$iv$iv;
        Object object;
        Collection $this$getOrPut$iv;
        Object answer$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(filesMetadata, "filesMetadata");
        Map contentPerPackage = new LinkedHashMap();
        Iterable $this$map$iv = filesMetadata;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            MetadataSource.File file2 = (MetadataSource.File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.backend.FirMetadataSource.File");
            collection.add(((FirMetadataSource.File)it).getFir());
        }
        for (FirFile firFile : (List)destination$iv$iv) {
            Object object2;
            FqName packageFqName = UtilsKt.getPackageFqName(firFile);
            Map $this$getOrPut$iv2 = contentPerPackage;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv2.get(packageFqName);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new PackageContent();
                $this$getOrPut$iv2.put(packageFqName, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            PackageContent content = (PackageContent)object2;
            for (FirDeclaration declaration : firFile.getDeclarations()) {
                value$iv = declaration;
                if (value$iv instanceof FirCallableDeclaration || value$iv instanceof FirTypeAlias) {
                    ((Collection)content.getMembers()).add(declaration);
                    continue;
                }
                if (value$iv instanceof FirRegularClass) {
                    ((Collection)content.getClasses()).add(declaration);
                    continue;
                }
                throw new IllegalStateException(("Unexpected declaration: " + UtilsKt.render(declaration)).toString());
            }
        }
        Map map = contentPerPackage;
        Object key$iv = StandardNames.BUILT_INS_PACKAGE_FQ_NAME;
        boolean $i$f$getOrPut22 = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            PackageContent answer$iv2 = new PackageContent();
            $this$getOrPut$iv.put(key$iv, answer$iv2);
            object = answer$iv2;
        } else {
            object = value$iv;
        }
        $this$getOrPut$iv = ((PackageContent)object).getClasses();
        FirClassLikeSymbol<?> firClassLikeSymbol = new FirCloneableSymbolProvider(this.session, FirModuleDataKt.getModuleData(this.session), FirKotlinScopeProviderKt.getKotlinScopeProvider(this.session)).getClassLikeSymbolByClassId(StandardClassIds.INSTANCE.getCloneable());
        Intrinsics.checkNotNull(firClassLikeSymbol);
        key$iv = firClassLikeSymbol.getFir();
        Intrinsics.checkNotNull(key$iv, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
        key$iv = (FirRegularClass)key$iv;
        $this$getOrPut$iv.add(key$iv);
        Map $this$map$iv2 = contentPerPackage;
        boolean $i$f$map2 = false;
        Map $i$f$getOrPut22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            void packageWithContent;
            answer$iv = item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            FqName packageFqName = (FqName)packageWithContent.getKey();
            PackageContent content = (PackageContent)packageWithContent.getValue();
            PackageSerializer serializer = new PackageSerializer(packageFqName, content.getClasses(), content.getMembers(), this.session, this.scopeSession);
            collection.add(new Pair<FqName, byte[]>(packageFqName, serializer.serialize()));
        }
        return CollectionsKt.toList((List)destination$iv$iv2);
    }

    @Override
    @NotNull
    public byte[] serializeEmptyPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        return new PackageSerializer(fqName, CollectionsKt.emptyList(), CollectionsKt.emptyList(), this.session, this.scopeSession).serialize();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirBuiltInsSerializer$FirBuiltInsSerializerExtension;", "Lorg/jetbrains/kotlin/fir/serialization/FirSerializerExtensionBase;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "constValueProvider", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "getConstValueProvider", "()Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "additionalMetadataProvider", "Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;", "getAdditionalMetadataProvider", "()Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;", "shouldUseTypeTable", "", "jvm-backend"})
    private static final class FirBuiltInsSerializerExtension
    extends FirSerializerExtensionBase {
        @NotNull
        private final FirSession session;
        @NotNull
        private final ScopeSession scopeSession;

        public FirBuiltInsSerializerExtension(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
            Intrinsics.checkNotNullParameter(session2, "session");
            Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
            super(BuiltInSerializerProtocol.INSTANCE);
            this.session = session2;
            this.scopeSession = scopeSession;
        }

        @Override
        @NotNull
        public FirSession getSession() {
            return this.session;
        }

        @Override
        @NotNull
        public ScopeSession getScopeSession() {
            return this.scopeSession;
        }

        @Override
        @NotNull
        public BinaryVersion getMetadataVersion() {
            return BuiltInsBinaryVersion.INSTANCE;
        }

        @Override
        @Nullable
        public ConstValueProvider getConstValueProvider() {
            return null;
        }

        @Override
        @Nullable
        public FirAdditionalMetadataProvider getAdditionalMetadataProvider() {
            return null;
        }

        @Override
        public boolean shouldUseTypeTable() {
            return true;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010#\u001a\u00020$J\u001e\u0010%\u001a\u00020&2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010'\u001a\u00020\"H\u0002J\b\u0010(\u001a\u00020&H\u0002J\b\u0010)\u001a\u00020&H\u0002J\b\u0010*\u001a\u00020$H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirBuiltInsSerializer$PackageSerializer;", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "classes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "members", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/backend/jvm/FirBuiltInsSerializer;Lorg/jetbrains/kotlin/name/FqName;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getClasses", "()Ljava/util/List;", "getMembers", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment$Builder;", "kotlin.jvm.PlatformType", "extension", "Lorg/jetbrains/kotlin/fir/backend/jvm/FirBuiltInsSerializer$FirBuiltInsSerializerExtension;", "typeApproximator", "Lorg/jetbrains/kotlin/fir/serialization/TypeApproximatorForMetadataSerializer;", "getTypeApproximator", "()Lorg/jetbrains/kotlin/fir/serialization/TypeApproximatorForMetadataSerializer;", "rootSerializer", "Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "serialize", "", "serializeClasses", "", "parentSerializer", "serializeMembers", "serializeStringTable", "serializeToByteArray", "jvm-backend"})
    @SourceDebugExtension(value={"SMAP\nFirBuiltinsSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirBuiltinsSerializer.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirBuiltInsSerializer$PackageSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,159:1\n1563#2:160\n1634#2,3:161\n13493#3,2:164\n*S KotlinDebug\n*F\n+ 1 FirBuiltinsSerializer.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirBuiltInsSerializer$PackageSerializer\n*L\n100#1:160\n100#1:161,3\n136#1:164,2\n*E\n"})
    private final class PackageSerializer {
        @NotNull
        private final FqName packageFqName;
        @NotNull
        private final List<FirRegularClass> classes;
        @NotNull
        private final List<FirMemberDeclaration> members;
        @NotNull
        private final FirSession session;
        @NotNull
        private final ScopeSession scopeSession;
        private final ProtoBuf.PackageFragment.Builder proto;
        @NotNull
        private final FirBuiltInsSerializerExtension extension;
        @NotNull
        private final TypeApproximatorForMetadataSerializer typeApproximator;
        @NotNull
        private final FirElementSerializer rootSerializer;

        public PackageSerializer(@NotNull FqName packageFqName, @NotNull List<? extends FirRegularClass> classes, @NotNull List<? extends FirMemberDeclaration> members, @NotNull FirSession session2, ScopeSession scopeSession) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            Intrinsics.checkNotNullParameter(classes, "classes");
            Intrinsics.checkNotNullParameter(members, "members");
            Intrinsics.checkNotNullParameter(session2, "session");
            Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
            this.packageFqName = packageFqName;
            this.classes = classes;
            this.members = members;
            this.session = session2;
            this.scopeSession = scopeSession;
            this.proto = ProtoBuf.PackageFragment.newBuilder();
            this.extension = new FirBuiltInsSerializerExtension(this.session, this.scopeSession);
            this.typeApproximator = new TypeApproximatorForMetadataSerializer(this.session);
            this.rootSerializer = FirElementSerializer.Companion.createTopLevel$default(FirElementSerializer.Companion, this.session, this.scopeSession, this.extension, this.typeApproximator, FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session), false, 32, null);
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public final List<FirRegularClass> getClasses() {
            return this.classes;
        }

        @NotNull
        public final List<FirMemberDeclaration> getMembers() {
            return this.members;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @NotNull
        public final ScopeSession getScopeSession() {
            return this.scopeSession;
        }

        @NotNull
        public final TypeApproximatorForMetadataSerializer getTypeApproximator() {
            return this.typeApproximator;
        }

        @NotNull
        public final byte[] serialize() {
            this.serializeClasses(this.classes, this.rootSerializer);
            this.serializeMembers();
            this.serializeStringTable();
            return this.serializeToByteArray();
        }

        /*
         * WARNING - void declaration
         */
        private final void serializeClasses(List<? extends FirRegularClass> classes, FirElementSerializer parentSerializer) {
            for (FirRegularClass klass : CollectionsKt.sortedWith((Iterable)classes, FirMemberDeclarationComparator.INSTANCE)) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = parentSerializer.computeNestedClassifiersForClass(klass.getSymbol());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirClassifierSymbol firClassifierSymbol = (FirClassifierSymbol)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Object e2 = it.getFir();
                    Intrinsics.checkNotNull(e2, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
                    collection.add((FirRegularClass)e2);
                }
                List nestedClasses = (List)destination$iv$iv;
                if (!((Collection)nestedClasses).isEmpty()) {
                    FirElementSerializer nestedSerializer = FirElementSerializer.Companion.create$default(FirElementSerializer.Companion, this.session, this.scopeSession, klass, this.extension, parentSerializer, this.typeApproximator, FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session), false, 128, null);
                    this.serializeClasses(nestedClasses, nestedSerializer);
                }
                FirFile file2 = FirProviderKt.getFirProvider(this.session).getFirClassifierContainerFile(klass.getSymbol());
                ProtoBuf.Class.Builder classProto = parentSerializer.classProto(klass, file2);
                this.proto.addClass_(classProto.build());
            }
        }

        private final void serializeMembers() {
            ProtoBuf.Package.Builder packagePartProto2 = this.rootSerializer.packagePartProto(this.packageFqName, CollectionsKt.sortedWith((Iterable)this.members, FirMemberDeclarationComparator.INSTANCE), null);
            this.proto.setPackage(packagePartProto2.build());
        }

        private final void serializeStringTable() {
            Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = this.extension.getStringTable().buildProto();
            ProtoBuf.StringTable strings2 = pair.component1();
            ProtoBuf.QualifiedNameTable qualifiedNames = pair.component2();
            this.proto.setStrings(strings2);
            this.proto.setQualifiedNames(qualifiedNames);
        }

        private final byte[] serializeToByteArray() {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream $this$serializeToByteArray_u24lambda_u242 = new DataOutputStream(stream);
            boolean bl = false;
            int[] version2 = this.extension.getMetadataVersion().toArray();
            $this$serializeToByteArray_u24lambda_u242.writeInt(version2.length);
            int[] $this$forEach$iv = version2;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int element$iv;
                int it = element$iv = $this$forEach$iv[i2];
                boolean bl2 = false;
                $this$serializeToByteArray_u24lambda_u242.writeInt(it);
            }
            this.proto.build().writeTo(stream);
            byte[] byArray = stream.toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
            return byArray;
        }
    }
}

