/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakePsiSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRefWithNullability;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclarationModifierList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtModifierListElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirSuspendModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "<init>", "()V", "suspendTokenElementSet", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSuspendModifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuspendModifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirSuspendModifierChecker\n+ 2 FirSourceUtils.kt\norg/jetbrains/kotlin/fir/analysis/FirSourceUtilsKt\n+ 3 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n42#2,7:66\n64#2:73\n96#2,6:74\n66#2:80\n102#2:81\n49#2:82\n50#2:88\n105#2,5:89\n67#2:94\n110#2,2:97\n113#2:100\n69#2:101\n51#2,2:102\n80#2:104\n96#2,6:105\n82#2:111\n102#2:112\n53#2:120\n105#2,5:121\n83#2:126\n110#2,4:127\n85#2:131\n54#2:132\n846#3,5:83\n852#3,7:113\n234#4:95\n1869#5:96\n1870#5:99\n*S KotlinDebug\n*F\n+ 1 FirSuspendModifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirSuspendModifierChecker\n*L\n30#1:66,7\n30#1:73\n30#1:74,6\n30#1:80\n30#1:81\n30#1:82\n30#1:88\n30#1:89,5\n30#1:94\n30#1:97,2\n30#1:100\n30#1:101\n30#1:102,2\n30#1:104\n30#1:105,6\n30#1:111\n30#1:112\n30#1:120\n30#1:121,5\n30#1:126\n30#1:127,4\n30#1:131\n30#1:132\n30#1:83,5\n30#1:113,7\n30#1:95\n30#1:96\n30#1:99\n*E\n"})
public final class FirSuspendModifierChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final FirSuspendModifierChecker INSTANCE = new FirSuspendModifierChecker();
    @NotNull
    private static final Set<KtModifierKeywordToken> suspendTokenElementSet = SetsKt.setOf(KtTokens.SUSPEND_KEYWORD);

    private FirSuspendModifierChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(typeRef instanceof FirTypeRefWithNullability)) {
            return;
        }
        List suspendModifierSources = new ArrayList();
        KtSourceElement ktSourceElement = ((FirTypeRefWithNullability)typeRef).getSource();
        if (ktSourceElement != null) {
            KtModifierListElementType<KtDeclarationModifierList> ktModifierListElementType = KtStubElementTypes.MODIFIER_LIST;
            Intrinsics.checkNotNullExpressionValue(ktModifierListElementType, "MODIFIER_LIST");
            if ((ktSourceElement = FirSourceUtilsKt.getChild$default(ktSourceElement, ktModifierListElementType, 0, 1, false, 10, null)) != null) {
                void types$iv;
                void $this$forEachChildOfType_u24default$iv;
                KtSourceElement ktSourceElement2 = ktSourceElement;
                Set<KtModifierKeywordToken> set = suspendTokenElementSet;
                int depth$iv = 1;
                boolean reverse$iv = false;
                boolean $i$f$forEachChildOfType = false;
                void var10_10 = $this$forEachChildOfType_u24default$iv;
                if (var10_10 instanceof KtPsiSourceElement) {
                    PsiElement $this$forEachChildOfType$iv$iv = ((KtPsiSourceElement)$this$forEachChildOfType_u24default$iv).getPsi();
                    boolean $i$f$forEachChildOfType2 = false;
                    boolean $i$f$forEachChildOfType3 = false;
                    Object object = new Pair[]{TuplesKt.to($this$forEachChildOfType$iv$iv, 0)};
                    List<Pair> stack$iv$iv$iv = CollectionsKt.mutableListOf(object);
                    while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                        void $this$forEach$iv$iv$iv$iv;
                        Iterable $this$butIf$iv$iv$iv$iv;
                        PsiElement it$iv$iv;
                        object = AddToStdlibKt.popLast(stack$iv$iv$iv);
                        Object element$iv$iv$iv = ((Pair)object).component1();
                        int currentDepth$iv$iv$iv = ((Number)((Pair)object).component2()).intValue();
                        if (currentDepth$iv$iv$iv != 0) {
                            PsiElement psiElement = (PsiElement)element$iv$iv$iv;
                            void var19_27 = types$iv;
                            boolean bl = false;
                            IElementType iElementType = it$iv$iv.getNode().getElementType();
                            Intrinsics.checkNotNullExpressionValue(iElementType, "getElementType(...)");
                            if (var19_27.contains(iElementType)) {
                                KtPsiSourceElement ktPsiSourceElement;
                                PsiElement it$iv = (PsiElement)element$iv$iv$iv;
                                boolean bl2 = false;
                                PsiElement $this$toKtPsiSourceElement_u24default$iv$iv = it$iv;
                                KtSourceElementKind kind$iv$iv = KtRealSourceElementKind.INSTANCE;
                                boolean $i$f$toKtPsiSourceElement = false;
                                KtSourceElementKind ktSourceElementKind = kind$iv$iv;
                                if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                                    ktPsiSourceElement = new KtRealPsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv);
                                } else if (ktSourceElementKind instanceof KtFakeSourceElementKind) {
                                    ktPsiSourceElement = new KtFakePsiSourceElement($this$toKtPsiSourceElement_u24default$iv$iv, (KtFakeSourceElementKind)kind$iv$iv);
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                KtSourceElement it = ktPsiSourceElement;
                                boolean bl3 = false;
                                ((Collection)suspendModifierSources).add(it);
                            }
                        }
                        if (currentDepth$iv$iv$iv == depth$iv) continue;
                        it$iv$iv = (PsiElement)element$iv$iv$iv;
                        boolean bl = false;
                        List list = SequencesKt.toList(PsiUtilsKt.getAllChildren(it$iv$iv));
                        boolean condition$iv$iv$iv$iv = true;
                        boolean $i$f$butIf22 = false;
                        void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                        boolean bl4 = false;
                        $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed(it$iv$iv$iv);
                        boolean $i$f$forEach = false;
                        Iterator $i$f$butIf22 = $this$forEach$iv$iv$iv$iv.iterator();
                        while ($i$f$butIf22.hasNext()) {
                            Object element$iv$iv$iv$iv;
                            Object child$iv$iv$iv = element$iv$iv$iv$iv = $i$f$butIf22.next();
                            boolean bl5 = false;
                            ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, currentDepth$iv$iv$iv + 1));
                        }
                    }
                } else if (var10_10 instanceof KtLightSourceElement) {
                    LighterASTNode $this$forEachChildOfType$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getLighterASTNode();
                    FlyweightCapableTreeStructure<LighterASTNode> treeStructure$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
                    boolean $i$f$forEachChildOfType4 = false;
                    boolean $i$f$forEachChildOfType5 = false;
                    Object object = new Pair[]{TuplesKt.to($this$forEachChildOfType$iv$iv, 0)};
                    List<Pair> stack$iv$iv$iv = CollectionsKt.mutableListOf(object);
                    while (!((Collection)stack$iv$iv$iv).isEmpty()) {
                        void $this$forEach$iv$iv$iv$iv;
                        Iterable $this$butIf$iv$iv$iv$iv;
                        LighterASTNode it$iv$iv;
                        object = AddToStdlibKt.popLast(stack$iv$iv$iv);
                        Object element$iv$iv$iv = ((Pair)object).component1();
                        int currentDepth$iv$iv$iv = ((Number)((Pair)object).component2()).intValue();
                        if (currentDepth$iv$iv$iv != 0) {
                            LighterASTNode lighterASTNode = (LighterASTNode)element$iv$iv$iv;
                            void var20_30 = types$iv;
                            boolean bl = false;
                            IElementType iElementType = it$iv$iv.getTokenType();
                            Intrinsics.checkNotNullExpressionValue(iElementType, "getTokenType(...)");
                            if (var20_30.contains(iElementType)) {
                                void $this$toKtLightSourceElement_u24default$iv$iv;
                                LighterASTNode it$iv = (LighterASTNode)element$iv$iv$iv;
                                boolean bl6 = false;
                                LighterASTNode kind$iv$iv = it$iv;
                                FlyweightCapableTreeStructure<LighterASTNode> tree$iv$iv = ((KtLightSourceElement)$this$forEachChildOfType_u24default$iv).getTreeStructure();
                                KtSourceElementKind kind$iv$iv2 = KtRealSourceElementKind.INSTANCE;
                                int startOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getStartOffset();
                                int endOffset$iv$iv = $this$toKtLightSourceElement_u24default$iv$iv.getEndOffset();
                                boolean $i$f$toKtLightSourceElement = false;
                                KtSourceElement it = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv$iv, startOffset$iv$iv, endOffset$iv$iv, tree$iv$iv, kind$iv$iv2);
                                boolean bl7 = false;
                                ((Collection)suspendModifierSources).add(it);
                            }
                        }
                        if (currentDepth$iv$iv$iv == depth$iv) continue;
                        it$iv$iv = (LighterASTNode)element$iv$iv$iv;
                        boolean bl = false;
                        List<LighterASTNode> element$iv$iv$iv$iv = LightTreeUtilsKt.getChildren(it$iv$iv, treeStructure$iv$iv);
                        boolean condition$iv$iv$iv$iv = true;
                        boolean $i$f$butIf = false;
                        void it$iv$iv$iv = $this$butIf$iv$iv$iv$iv;
                        boolean bl8 = false;
                        $this$butIf$iv$iv$iv$iv = CollectionsKt.asReversed(it$iv$iv$iv);
                        boolean $i$f$forEach = false;
                        Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object element$iv$iv$iv$iv2;
                            Object child$iv$iv$iv = element$iv$iv$iv$iv2 = iterator2.next();
                            boolean bl9 = false;
                            ((Collection)stack$iv$iv$iv).add(TuplesKt.to(child$iv$iv$iv, currentDepth$iv$iv$iv + 1));
                        }
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (suspendModifierSources.isEmpty()) {
            return;
        }
        if (!(typeRef instanceof FirFunctionTypeRef) || ((FirFunctionTypeRef)typeRef).isMarkedNullable()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)CollectionsKt.first(suspendModifierSources), FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)KtTokens.SUSPEND_KEYWORD, (Object)"non-functional type", (DiagnosticContext)context2, null, 32, null);
        } else if (suspendModifierSources.size() > 1) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)CollectionsKt.first(suspendModifierSources), FirErrors.INSTANCE.getREPEATED_MODIFIER(), (Object)KtTokens.SUSPEND_KEYWORD, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

